/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.async;

import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.TriConsumer;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.xpack.core.async.AsyncExecutionId;
import org.elasticsearch.xpack.core.async.AsyncResponse;
import org.elasticsearch.xpack.core.async.AsyncTask;
import org.elasticsearch.xpack.core.async.AsyncTaskIndexService;
import org.elasticsearch.xpack.core.async.GetAsyncResultRequest;

public class AsyncResultsService<Task extends AsyncTask, Response extends AsyncResponse<Response>> {
    private final Logger logger = LogManager.getLogger(AsyncResultsService.class);
    private final Class<? extends Task> asyncTaskClass;
    private final TaskManager taskManager;
    private final ClusterService clusterService;
    private final AsyncTaskIndexService<Response> store;
    private final boolean updateInitialResultsInStore;
    private final TriConsumer<Task, ActionListener<Response>, TimeValue> addCompletionListener;

    public AsyncResultsService(AsyncTaskIndexService<Response> store, boolean updateInitialResultsInStore, Class<? extends Task> asyncTaskClass, TriConsumer<Task, ActionListener<Response>, TimeValue> addCompletionListener, TaskManager taskManager, ClusterService clusterService) {
        this.updateInitialResultsInStore = updateInitialResultsInStore;
        this.asyncTaskClass = asyncTaskClass;
        this.addCompletionListener = addCompletionListener;
        this.taskManager = taskManager;
        this.clusterService = clusterService;
        this.store = store;
    }

    public DiscoveryNode getNode(String id) {
        AsyncExecutionId searchId = AsyncExecutionId.decode(id);
        return this.clusterService.state().nodes().get(searchId.getTaskId().getNodeId());
    }

    public boolean isLocalNode(DiscoveryNode node) {
        return Objects.requireNonNull(node).equals((Object)this.clusterService.localNode());
    }

    public void retrieveResult(GetAsyncResultRequest request, ActionListener<Response> listener) {
        try {
            long nowInMillis = System.currentTimeMillis();
            AsyncExecutionId searchId = AsyncExecutionId.decode(request.getId());
            long expirationTime = request.getKeepAlive() != null && request.getKeepAlive().getMillis() > 0L ? nowInMillis + request.getKeepAlive().getMillis() : -1L;
            if (this.updateInitialResultsInStore & expirationTime > 0L) {
                this.store.updateExpirationTime(searchId.getDocId(), expirationTime, (ActionListener<UpdateResponse>)ActionListener.wrap(p -> this.getSearchResponseFromTask(searchId, request, nowInMillis, expirationTime, listener), exc -> {
                    RestStatus status = ExceptionsHelper.status((Throwable)ExceptionsHelper.unwrapCause((Throwable)exc));
                    if (status != RestStatus.NOT_FOUND) {
                        this.logger.error(() -> new ParameterizedMessage("failed to update expiration time for async-search [{}]", (Object)searchId.getEncoded()), (Throwable)exc);
                    }
                    listener.onFailure((Exception)new ResourceNotFoundException(searchId.getEncoded(), new Object[0]));
                }));
            } else {
                this.getSearchResponseFromTask(searchId, request, nowInMillis, expirationTime, listener);
            }
        }
        catch (Exception exc2) {
            listener.onFailure(exc2);
        }
    }

    private void getSearchResponseFromTask(AsyncExecutionId searchId, final GetAsyncResultRequest request, final long nowInMillis, long expirationTimeMillis, final ActionListener<Response> listener) {
        try {
            Task task = this.store.getTask(this.taskManager, searchId, this.asyncTaskClass);
            if (task == null) {
                this.getSearchResponseFromIndex(searchId, request, nowInMillis, listener);
                return;
            }
            if (task.isCancelled()) {
                listener.onFailure((Exception)new ResourceNotFoundException(searchId.getEncoded(), new Object[0]));
                return;
            }
            if (expirationTimeMillis != -1L) {
                task.setExpirationTime(expirationTimeMillis);
            }
            this.addCompletionListener.apply(task, (Object)new ActionListener<Response>(){

                public void onResponse(Response response) {
                    AsyncResultsService.this.sendFinalResponse(request, response, nowInMillis, listener);
                }

                public void onFailure(Exception exc) {
                    listener.onFailure(exc);
                }
            }, (Object)request.getWaitForCompletionTimeout());
        }
        catch (Exception exc) {
            listener.onFailure(exc);
        }
    }

    private void getSearchResponseFromIndex(AsyncExecutionId searchId, final GetAsyncResultRequest request, final long nowInMillis, final ActionListener<Response> listener) {
        this.store.getResponse(searchId, true, new ActionListener<Response>(){

            public void onResponse(Response response) {
                AsyncResultsService.this.sendFinalResponse(request, response, nowInMillis, listener);
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    private void sendFinalResponse(GetAsyncResultRequest request, Response response, long nowInMillis, ActionListener<Response> listener) {
        if (response.getExpirationTime() < nowInMillis) {
            listener.onFailure((Exception)new ResourceNotFoundException(request.getId(), new Object[0]));
            return;
        }
        listener.onResponse(response);
    }
}

