/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ilm.AsyncActionBranchingStep;
import org.elasticsearch.xpack.core.ilm.BranchingStep;
import org.elasticsearch.xpack.core.ilm.CheckNotDataStreamWriteIndexStep;
import org.elasticsearch.xpack.core.ilm.CleanupSnapshotStep;
import org.elasticsearch.xpack.core.ilm.CopyExecutionStateStep;
import org.elasticsearch.xpack.core.ilm.CopySettingsStep;
import org.elasticsearch.xpack.core.ilm.CreateSnapshotStep;
import org.elasticsearch.xpack.core.ilm.DeleteStep;
import org.elasticsearch.xpack.core.ilm.GenerateSnapshotNameStep;
import org.elasticsearch.xpack.core.ilm.LifecycleAction;
import org.elasticsearch.xpack.core.ilm.MountSnapshotStep;
import org.elasticsearch.xpack.core.ilm.ReplaceDataStreamBackingIndexStep;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.ilm.SwapAliasesAndDeleteSourceIndexStep;
import org.elasticsearch.xpack.core.ilm.WaitForIndexColorStep;
import org.elasticsearch.xpack.core.ilm.WaitForNoFollowersStep;

public class SearchableSnapshotAction
implements LifecycleAction {
    public static final String NAME = "searchable_snapshot";
    public static final ParseField SNAPSHOT_REPOSITORY = new ParseField("snapshot_repository", new String[0]);
    public static final String CONDITIONAL_DATASTREAM_CHECK_KEY = "branch-on-datastream-check";
    public static final String RESTORED_INDEX_PREFIX = "restored-";
    private static final ConstructingObjectParser<SearchableSnapshotAction, Void> PARSER = new ConstructingObjectParser("searchable_snapshot", a -> new SearchableSnapshotAction((String)a[0]));
    private final String snapshotRepository;

    public static SearchableSnapshotAction parse(XContentParser parser) {
        return (SearchableSnapshotAction)PARSER.apply(parser, null);
    }

    public SearchableSnapshotAction(String snapshotRepository) {
        if (!Strings.hasText((String)snapshotRepository)) {
            throw new IllegalArgumentException("the snapshot repository must be specified");
        }
        this.snapshotRepository = snapshotRepository;
    }

    public SearchableSnapshotAction(StreamInput in) throws IOException {
        this(in.readString());
    }

    @Override
    public List<Step> toSteps(Client client, String phase, Step.StepKey nextStepKey) {
        Step.StepKey checkNoWriteIndex = new Step.StepKey(phase, NAME, "check-not-write-index");
        Step.StepKey waitForNoFollowerStepKey = new Step.StepKey(phase, NAME, "wait-for-shard-history-leases");
        Step.StepKey generateSnapshotNameKey = new Step.StepKey(phase, NAME, "generate-snapshot-name");
        Step.StepKey cleanSnapshotKey = new Step.StepKey(phase, NAME, "cleanup-snapshot");
        Step.StepKey createSnapshotKey = new Step.StepKey(phase, NAME, "create-snapshot");
        Step.StepKey mountSnapshotKey = new Step.StepKey(phase, NAME, "mount-snapshot");
        Step.StepKey waitForGreenRestoredIndexKey = new Step.StepKey(phase, NAME, "wait-for-index-color");
        Step.StepKey copyMetadataKey = new Step.StepKey(phase, NAME, "copy-execution-state");
        Step.StepKey dataStreamCheckBranchingKey = new Step.StepKey(phase, NAME, CONDITIONAL_DATASTREAM_CHECK_KEY);
        Step.StepKey copyLifecyclePolicySettingKey = new Step.StepKey(phase, NAME, "copy-settings");
        Step.StepKey swapAliasesKey = new Step.StepKey(phase, NAME, "swap-aliases");
        Step.StepKey replaceDataStreamIndexKey = new Step.StepKey(phase, NAME, "replace-datastream-backing-index");
        Step.StepKey deleteIndexKey = new Step.StepKey(phase, NAME, "delete");
        CheckNotDataStreamWriteIndexStep checkNoWriteIndexStep = new CheckNotDataStreamWriteIndexStep(checkNoWriteIndex, waitForNoFollowerStepKey);
        WaitForNoFollowersStep waitForNoFollowersStep = new WaitForNoFollowersStep(waitForNoFollowerStepKey, generateSnapshotNameKey, client);
        GenerateSnapshotNameStep generateSnapshotNameStep = new GenerateSnapshotNameStep(generateSnapshotNameKey, cleanSnapshotKey, this.snapshotRepository);
        CleanupSnapshotStep cleanupSnapshotStep = new CleanupSnapshotStep(cleanSnapshotKey, createSnapshotKey, client);
        AsyncActionBranchingStep createSnapshotBranchingStep = new AsyncActionBranchingStep(new CreateSnapshotStep(createSnapshotKey, mountSnapshotKey, client), cleanSnapshotKey, client);
        MountSnapshotStep mountSnapshotStep = new MountSnapshotStep(mountSnapshotKey, waitForGreenRestoredIndexKey, client, RESTORED_INDEX_PREFIX);
        WaitForIndexColorStep waitForGreenIndexHealthStep = new WaitForIndexColorStep(waitForGreenRestoredIndexKey, copyMetadataKey, ClusterHealthStatus.GREEN, RESTORED_INDEX_PREFIX);
        CopyExecutionStateStep copyMetadataStep = new CopyExecutionStateStep(copyMetadataKey, copyLifecyclePolicySettingKey, RESTORED_INDEX_PREFIX, nextStepKey != null ? nextStepKey.getName() : "null");
        CopySettingsStep copySettingsStep = new CopySettingsStep(copyLifecyclePolicySettingKey, dataStreamCheckBranchingKey, RESTORED_INDEX_PREFIX, "index.lifecycle.name");
        BranchingStep isDataStreamBranchingStep = new BranchingStep(dataStreamCheckBranchingKey, swapAliasesKey, replaceDataStreamIndexKey, (index, clusterState) -> {
            IndexAbstraction indexAbstraction = (IndexAbstraction)clusterState.metadata().getIndicesLookup().get(index.getName());
            assert (indexAbstraction != null) : "invalid cluster metadata. index [" + index.getName() + "] was not found";
            return indexAbstraction.getParentDataStream() != null;
        });
        ReplaceDataStreamBackingIndexStep replaceDataStreamBackingIndex = new ReplaceDataStreamBackingIndexStep(replaceDataStreamIndexKey, deleteIndexKey, RESTORED_INDEX_PREFIX);
        DeleteStep deleteSourceIndexStep = new DeleteStep(deleteIndexKey, null, client);
        SwapAliasesAndDeleteSourceIndexStep swapAliasesAndDeleteSourceIndexStep = new SwapAliasesAndDeleteSourceIndexStep(swapAliasesKey, null, client, RESTORED_INDEX_PREFIX);
        return Arrays.asList(checkNoWriteIndexStep, waitForNoFollowersStep, generateSnapshotNameStep, cleanupSnapshotStep, createSnapshotBranchingStep, mountSnapshotStep, waitForGreenIndexHealthStep, copyMetadataStep, copySettingsStep, isDataStreamBranchingStep, replaceDataStreamBackingIndex, deleteSourceIndexStep, swapAliasesAndDeleteSourceIndexStep);
    }

    @Override
    public boolean isSafeAction() {
        return true;
    }

    public String getWriteableName() {
        return NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.snapshotRepository);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(SNAPSHOT_REPOSITORY.getPreferredName(), this.snapshotRepository);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchableSnapshotAction that = (SearchableSnapshotAction)o;
        return Objects.equals(this.snapshotRepository, that.snapshotRepository);
    }

    public int hashCode() {
        return Objects.hash(this.snapshotRepository);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), SNAPSHOT_REPOSITORY);
    }
}

