/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.ilm.ClusterStateWaitStep;
import org.elasticsearch.xpack.core.ilm.LifecycleExecutionState;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleMetadata;
import org.elasticsearch.xpack.core.slm.SnapshotLifecyclePolicyMetadata;

public class WaitForSnapshotStep
extends ClusterStateWaitStep {
    static final String NAME = "wait-for-snapshot";
    private static final String MESSAGE_FIELD = "message";
    private static final String POLICY_NOT_EXECUTED_MESSAGE = "waiting for policy '%s' to be executed since %s";
    private static final String POLICY_NOT_FOUND_MESSAGE = "configured policy '%s' not found";
    private static final String NO_INDEX_METADATA_MESSAGE = "no index metadata found for index '%s'";
    private static final String NO_PHASE_TIME_MESSAGE = "no information about ILM phase start in index metadata for index '%s'";
    private final String policy;

    WaitForSnapshotStep(Step.StepKey key, Step.StepKey nextStepKey, String policy) {
        super(key, nextStepKey);
        this.policy = policy;
    }

    @Override
    public ClusterStateWaitStep.Result isConditionMet(Index index, ClusterState clusterState) {
        IndexMetadata indexMetadata = clusterState.metadata().index(index);
        if (indexMetadata == null) {
            throw this.error(NO_INDEX_METADATA_MESSAGE, index.getName());
        }
        Long phaseTime = LifecycleExecutionState.fromIndexMetadata(indexMetadata).getPhaseTime();
        if (phaseTime == null) {
            throw this.error(NO_PHASE_TIME_MESSAGE, index.getName());
        }
        SnapshotLifecycleMetadata snapMeta = (SnapshotLifecycleMetadata)clusterState.metadata().custom("snapshot_lifecycle");
        if (snapMeta == null || !snapMeta.getSnapshotConfigurations().containsKey(this.policy)) {
            throw this.error(POLICY_NOT_FOUND_MESSAGE, this.policy);
        }
        SnapshotLifecyclePolicyMetadata snapPolicyMeta = snapMeta.getSnapshotConfigurations().get(this.policy);
        if (snapPolicyMeta.getLastSuccess() == null || snapPolicyMeta.getLastSuccess().getTimestamp() < phaseTime) {
            return new ClusterStateWaitStep.Result(false, this.notExecutedMessage(phaseTime));
        }
        return new ClusterStateWaitStep.Result(true, null);
    }

    public String getPolicy() {
        return this.policy;
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    private ToXContentObject notExecutedMessage(long time) {
        return (builder, params) -> {
            builder.startObject();
            builder.field(MESSAGE_FIELD, String.format(Locale.ROOT, POLICY_NOT_EXECUTED_MESSAGE, this.policy, new Date(time)));
            builder.endObject();
            return builder;
        };
    }

    private IllegalStateException error(String message, Object ... args) {
        return new IllegalStateException(String.format(Locale.ROOT, message, args));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WaitForSnapshotStep that = (WaitForSnapshotStep)o;
        return this.policy.equals(that.policy);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.policy);
    }
}

