/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xpack.core.ml.MachineLearningField;
import org.elasticsearch.xpack.core.ml.action.OpenJobAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;

public class CloseJobAction
extends ActionType<Response> {
    public static final CloseJobAction INSTANCE = new CloseJobAction();
    public static final String NAME = "cluster:admin/xpack/ml/job/close";

    private CloseJobAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends BaseTasksResponse
    implements Writeable,
    ToXContentObject {
        private final boolean closed;

        public Response(boolean closed) {
            super(null, null);
            this.closed = closed;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.closed = in.readBoolean();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.closed);
        }

        public boolean isClosed() {
            return this.closed;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("closed", this.closed);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return this.closed == response.closed;
        }

        public int hashCode() {
            return Objects.hash(this.closed);
        }
    }

    static class RequestBuilder
    extends ActionRequestBuilder<Request, Response> {
        RequestBuilder(ElasticsearchClient client, CloseJobAction action) {
            super(client, (ActionType)action, (ActionRequest)new Request());
        }
    }

    public static class Request
    extends BaseTasksRequest<Request>
    implements ToXContentObject {
        public static final ParseField TIMEOUT = new ParseField("timeout", new String[0]);
        public static final ParseField FORCE = new ParseField("force", new String[0]);
        public static final ParseField ALLOW_NO_JOBS = new ParseField("allow_no_jobs", new String[0]);
        public static final ObjectParser<Request, Void> PARSER = new ObjectParser("cluster:admin/xpack/ml/job/close", Request::new);
        private String jobId;
        private boolean force = false;
        private boolean allowNoJobs = true;
        private TimeValue timeout = MachineLearningField.STATE_PERSIST_RESTORE_TIMEOUT;
        private String[] openJobIds;
        private boolean local;

        public static Request parseRequest(String jobId, XContentParser parser) {
            Request request = (Request)((Object)PARSER.apply(parser, null));
            if (jobId != null) {
                request.setJobId(jobId);
            }
            return request;
        }

        public Request() {
            this.openJobIds = new String[0];
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.jobId = in.readString();
            this.timeout = in.readTimeValue();
            this.force = in.readBoolean();
            this.openJobIds = in.readStringArray();
            this.local = in.readBoolean();
            if (in.getVersion().onOrAfter(Version.V_6_1_0)) {
                this.allowNoJobs = in.readBoolean();
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.jobId);
            out.writeTimeValue(this.timeout);
            out.writeBoolean(this.force);
            out.writeStringArray(this.openJobIds);
            out.writeBoolean(this.local);
            if (out.getVersion().onOrAfter(Version.V_6_1_0)) {
                out.writeBoolean(this.allowNoJobs);
            }
        }

        public Request(String jobId) {
            this();
            this.jobId = jobId;
        }

        public String getJobId() {
            return this.jobId;
        }

        public void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public TimeValue getCloseTimeout() {
            return this.timeout;
        }

        public void setCloseTimeout(TimeValue timeout) {
            this.timeout = timeout;
        }

        public boolean isForce() {
            return this.force;
        }

        public void setForce(boolean force) {
            this.force = force;
        }

        public boolean allowNoJobs() {
            return this.allowNoJobs;
        }

        public void setAllowNoJobs(boolean allowNoJobs) {
            this.allowNoJobs = allowNoJobs;
        }

        public boolean isLocal() {
            return this.local;
        }

        public void setLocal(boolean local) {
            this.local = local;
        }

        public String[] getOpenJobIds() {
            return this.openJobIds;
        }

        public void setOpenJobIds(String[] openJobIds) {
            this.openJobIds = openJobIds;
        }

        public boolean match(Task task) {
            for (String id : this.openJobIds) {
                if (!OpenJobAction.JobTaskMatcher.match(task, id)) continue;
                return true;
            }
            return false;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Job.ID.getPreferredName(), this.jobId);
            builder.field(TIMEOUT.getPreferredName(), this.timeout.getStringRep());
            builder.field(FORCE.getPreferredName(), this.force);
            builder.field(ALLOW_NO_JOBS.getPreferredName(), this.allowNoJobs);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.jobId, this.timeout, this.force, this.allowNoJobs);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.jobId, other.jobId) && Objects.equals(this.timeout, other.timeout) && Objects.equals(this.force, other.force) && Objects.equals(this.allowNoJobs, other.allowNoJobs);
        }

        static {
            PARSER.declareString(Request::setJobId, Job.ID);
            PARSER.declareString((request, val) -> request.setCloseTimeout(TimeValue.parseTimeValue((String)val, (String)TIMEOUT.getPreferredName())), TIMEOUT);
            PARSER.declareBoolean(Request::setForce, FORCE);
            PARSER.declareBoolean(Request::setAllowNoJobs, ALLOW_NO_JOBS);
        }
    }
}

