/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xpack.core.action.AbstractGetResourcesRequest;
import org.elasticsearch.xpack.core.action.AbstractGetResourcesResponse;
import org.elasticsearch.xpack.core.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;

public class GetTrainedModelsAction
extends ActionType<Response> {
    public static final GetTrainedModelsAction INSTANCE = new GetTrainedModelsAction();
    public static final String NAME = "cluster:monitor/xpack/ml/inference/get";

    private GetTrainedModelsAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends AbstractGetResourcesResponse<TrainedModelConfig> {
        public static final ParseField RESULTS_FIELD = new ParseField("trained_model_configs", new String[0]);

        public Response(StreamInput in) throws IOException {
            super(in);
        }

        public Response(QueryPage<TrainedModelConfig> trainedModels) {
            super(trainedModels);
        }

        @Override
        protected Writeable.Reader<TrainedModelConfig> getReader() {
            return TrainedModelConfig::new;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private long totalCount;
            private List<TrainedModelConfig> configs = Collections.emptyList();

            private Builder() {
            }

            public Builder setTotalCount(long totalCount) {
                this.totalCount = totalCount;
                return this;
            }

            public Builder setModels(List<TrainedModelConfig> configs) {
                this.configs = configs;
                return this;
            }

            public Response build() {
                return new Response(new QueryPage<TrainedModelConfig>(this.configs, this.totalCount, RESULTS_FIELD));
            }
        }
    }

    public static class Request
    extends AbstractGetResourcesRequest {
        public static final ParseField INCLUDE_MODEL_DEFINITION = new ParseField("include_model_definition", new String[0]);
        public static final ParseField ALLOW_NO_MATCH = new ParseField("allow_no_match", new String[0]);
        public static final ParseField TAGS = new ParseField("tags", new String[0]);
        private final boolean includeModelDefinition;
        private final List<String> tags;

        public Request(String id, boolean includeModelDefinition, List<String> tags) {
            this.setResourceId(id);
            this.setAllowNoResources(true);
            this.includeModelDefinition = includeModelDefinition;
            this.tags = tags == null ? Collections.emptyList() : tags;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.includeModelDefinition = in.readBoolean();
            this.tags = in.getVersion().onOrAfter(Version.V_7_7_0) ? in.readStringList() : Collections.emptyList();
        }

        @Override
        public String getResourceIdField() {
            return TrainedModelConfig.MODEL_ID.getPreferredName();
        }

        public boolean isIncludeModelDefinition() {
            return this.includeModelDefinition;
        }

        public List<String> getTags() {
            return this.tags;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.includeModelDefinition);
            if (out.getVersion().onOrAfter(Version.V_7_7_0)) {
                out.writeStringCollection(this.tags);
            }
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.includeModelDefinition, this.tags);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return super.equals(obj) && this.includeModelDefinition == other.includeModelDefinition && Objects.equals(this.tags, other.tags);
        }
    }
}

