/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;

public class PutTrainedModelAction
extends ActionType<Response> {
    public static final PutTrainedModelAction INSTANCE = new PutTrainedModelAction();
    public static final String NAME = "cluster:admin/xpack/ml/inference/put";

    private PutTrainedModelAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final TrainedModelConfig trainedModelConfig;

        public Response(TrainedModelConfig trainedModelConfig) {
            this.trainedModelConfig = trainedModelConfig;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.trainedModelConfig = new TrainedModelConfig(in);
        }

        public TrainedModelConfig getResponse() {
            return this.trainedModelConfig;
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.trainedModelConfig.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return this.trainedModelConfig.toXContent(builder, params);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return Objects.equals(this.trainedModelConfig, response.trainedModelConfig);
        }

        public int hashCode() {
            return Objects.hash(this.trainedModelConfig);
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private final TrainedModelConfig config;

        public static Request parseRequest(String modelId, XContentParser parser) {
            TrainedModelConfig.Builder builder = (TrainedModelConfig.Builder)TrainedModelConfig.STRICT_PARSER.apply(parser, null);
            if (builder.getModelId() == null) {
                builder.setModelId(modelId).build();
            } else if (!Strings.isNullOrEmpty((String)modelId) && !modelId.equals(builder.getModelId())) {
                throw new IllegalArgumentException(Messages.getMessage("Inconsistent {0}; ''{1}'' specified in the body differs from ''{2}'' specified as a URL argument", TrainedModelConfig.MODEL_ID.getPreferredName(), builder.getModelId(), modelId));
            }
            return new Request(builder.validate(true).build());
        }

        public Request(TrainedModelConfig config) {
            this.config = config;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.config = new TrainedModelConfig(in);
        }

        public TrainedModelConfig getTrainedModelConfig() {
            return this.config;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.config.writeTo(out);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.config, request.config);
        }

        public int hashCode() {
            return Objects.hash(this.config);
        }

        public final String toString() {
            return Strings.toString((ToXContent)this.config);
        }
    }
}

