/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.datafeed;

import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.persistent.PersistentTaskState;

public enum DatafeedState implements PersistentTaskState
{
    STARTED,
    STOPPED,
    STARTING,
    STOPPING;

    public static final String NAME = "xpack/ml/datafeed";
    private static final ConstructingObjectParser<DatafeedState, Void> PARSER;

    public static DatafeedState fromString(String name) {
        return DatafeedState.valueOf(name.trim().toUpperCase(Locale.ROOT));
    }

    public static DatafeedState fromStream(StreamInput in) throws IOException {
        return (DatafeedState)in.readEnum(DatafeedState.class);
    }

    public String getWriteableName() {
        return NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        DatafeedState state = this;
        out.writeEnum((Enum)state);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("state", this.name().toLowerCase(Locale.ROOT));
        builder.endObject();
        return builder;
    }

    public boolean isFragment() {
        return false;
    }

    public static DatafeedState fromXContent(XContentParser parser) throws IOException {
        return (DatafeedState)((Object)PARSER.parse(parser, null));
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    static {
        PARSER = new ConstructingObjectParser(NAME, args -> DatafeedState.fromString((String)args[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("state", new String[0]));
    }
}

