/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.analyses;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.AbstractObjectParser;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class BoostedTreeParams
implements ToXContentFragment,
Writeable {
    static final String NAME = "boosted_tree_params";
    public static final ParseField LAMBDA = new ParseField("lambda", new String[0]);
    public static final ParseField GAMMA = new ParseField("gamma", new String[0]);
    public static final ParseField ETA = new ParseField("eta", new String[0]);
    public static final ParseField MAX_TREES = new ParseField("max_trees", new String[]{"maximum_number_trees"});
    public static final ParseField FEATURE_BAG_FRACTION = new ParseField("feature_bag_fraction", new String[0]);
    public static final ParseField NUM_TOP_FEATURE_IMPORTANCE_VALUES = new ParseField("num_top_feature_importance_values", new String[0]);
    private final Double lambda;
    private final Double gamma;
    private final Double eta;
    private final Integer maxTrees;
    private final Double featureBagFraction;
    private final Integer numTopFeatureImportanceValues;

    static void declareFields(AbstractObjectParser<?, Void> parser) {
        parser.declareDouble(ConstructingObjectParser.optionalConstructorArg(), LAMBDA);
        parser.declareDouble(ConstructingObjectParser.optionalConstructorArg(), GAMMA);
        parser.declareDouble(ConstructingObjectParser.optionalConstructorArg(), ETA);
        parser.declareInt(ConstructingObjectParser.optionalConstructorArg(), MAX_TREES);
        parser.declareDouble(ConstructingObjectParser.optionalConstructorArg(), FEATURE_BAG_FRACTION);
        parser.declareInt(ConstructingObjectParser.optionalConstructorArg(), NUM_TOP_FEATURE_IMPORTANCE_VALUES);
    }

    public BoostedTreeParams(@Nullable Double lambda, @Nullable Double gamma, @Nullable Double eta, @Nullable Integer maxTrees, @Nullable Double featureBagFraction, @Nullable Integer numTopFeatureImportanceValues) {
        if (lambda != null && lambda < 0.0) {
            throw ExceptionsHelper.badRequestException("[{}] must be a non-negative double", LAMBDA.getPreferredName());
        }
        if (gamma != null && gamma < 0.0) {
            throw ExceptionsHelper.badRequestException("[{}] must be a non-negative double", GAMMA.getPreferredName());
        }
        if (eta != null && (eta < 0.001 || eta > 1.0)) {
            throw ExceptionsHelper.badRequestException("[{}] must be a double in [0.001, 1]", ETA.getPreferredName());
        }
        if (maxTrees != null && (maxTrees <= 0 || maxTrees > 2000)) {
            throw ExceptionsHelper.badRequestException("[{}] must be an integer in [1, 2000]", MAX_TREES.getPreferredName());
        }
        if (featureBagFraction != null && (featureBagFraction <= 0.0 || featureBagFraction > 1.0)) {
            throw ExceptionsHelper.badRequestException("[{}] must be a double in (0, 1]", FEATURE_BAG_FRACTION.getPreferredName());
        }
        if (numTopFeatureImportanceValues != null && numTopFeatureImportanceValues < 0) {
            throw ExceptionsHelper.badRequestException("[{}] must be a non-negative integer", NUM_TOP_FEATURE_IMPORTANCE_VALUES.getPreferredName());
        }
        this.lambda = lambda;
        this.gamma = gamma;
        this.eta = eta;
        this.maxTrees = maxTrees;
        this.featureBagFraction = featureBagFraction;
        this.numTopFeatureImportanceValues = numTopFeatureImportanceValues;
    }

    BoostedTreeParams(StreamInput in) throws IOException {
        this.lambda = in.readOptionalDouble();
        this.gamma = in.readOptionalDouble();
        this.eta = in.readOptionalDouble();
        this.maxTrees = in.readOptionalVInt();
        this.featureBagFraction = in.readOptionalDouble();
        this.numTopFeatureImportanceValues = in.getVersion().onOrAfter(Version.V_7_6_0) ? in.readOptionalInt() : null;
    }

    public Double getLambda() {
        return this.lambda;
    }

    public Double getGamma() {
        return this.gamma;
    }

    public Double getEta() {
        return this.eta;
    }

    public Integer getMaxTrees() {
        return this.maxTrees;
    }

    public Double getFeatureBagFraction() {
        return this.featureBagFraction;
    }

    public Integer getNumTopFeatureImportanceValues() {
        return this.numTopFeatureImportanceValues;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalDouble(this.lambda);
        out.writeOptionalDouble(this.gamma);
        out.writeOptionalDouble(this.eta);
        out.writeOptionalVInt(this.maxTrees);
        out.writeOptionalDouble(this.featureBagFraction);
        if (out.getVersion().onOrAfter(Version.V_7_6_0)) {
            out.writeOptionalInt(this.numTopFeatureImportanceValues);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.lambda != null) {
            builder.field(LAMBDA.getPreferredName(), this.lambda);
        }
        if (this.gamma != null) {
            builder.field(GAMMA.getPreferredName(), this.gamma);
        }
        if (this.eta != null) {
            builder.field(ETA.getPreferredName(), this.eta);
        }
        if (this.maxTrees != null) {
            builder.field(MAX_TREES.getPreferredName(), this.maxTrees);
        }
        if (this.featureBagFraction != null) {
            builder.field(FEATURE_BAG_FRACTION.getPreferredName(), this.featureBagFraction);
        }
        if (this.numTopFeatureImportanceValues != null) {
            builder.field(NUM_TOP_FEATURE_IMPORTANCE_VALUES.getPreferredName(), this.numTopFeatureImportanceValues);
        }
        return builder;
    }

    Map<String, Object> getParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.lambda != null) {
            params.put(LAMBDA.getPreferredName(), this.lambda);
        }
        if (this.gamma != null) {
            params.put(GAMMA.getPreferredName(), this.gamma);
        }
        if (this.eta != null) {
            params.put(ETA.getPreferredName(), this.eta);
        }
        if (this.maxTrees != null) {
            params.put(MAX_TREES.getPreferredName(), this.maxTrees);
        }
        if (this.featureBagFraction != null) {
            params.put(FEATURE_BAG_FRACTION.getPreferredName(), this.featureBagFraction);
        }
        if (this.numTopFeatureImportanceValues != null) {
            params.put(NUM_TOP_FEATURE_IMPORTANCE_VALUES.getPreferredName(), this.numTopFeatureImportanceValues);
        }
        return params;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoostedTreeParams that = (BoostedTreeParams)o;
        return Objects.equals(this.lambda, that.lambda) && Objects.equals(this.gamma, that.gamma) && Objects.equals(this.eta, that.eta) && Objects.equals(this.maxTrees, that.maxTrees) && Objects.equals(this.featureBagFraction, that.featureBagFraction) && Objects.equals(this.numTopFeatureImportanceValues, that.numTopFeatureImportanceValues);
    }

    public int hashCode() {
        return Objects.hash(this.lambda, this.gamma, this.eta, this.maxTrees, this.featureBagFraction, this.numTopFeatureImportanceValues);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Double lambda;
        private Double gamma;
        private Double eta;
        private Integer maxTrees;
        private Double featureBagFraction;
        private Integer numTopFeatureImportanceValues;

        private Builder() {
        }

        Builder(BoostedTreeParams params) {
            this.lambda = params.lambda;
            this.gamma = params.gamma;
            this.eta = params.eta;
            this.maxTrees = params.maxTrees;
            this.featureBagFraction = params.featureBagFraction;
            this.numTopFeatureImportanceValues = params.numTopFeatureImportanceValues;
        }

        public Builder setLambda(Double lambda) {
            this.lambda = lambda;
            return this;
        }

        public Builder setGamma(Double gamma) {
            this.gamma = gamma;
            return this;
        }

        public Builder setEta(Double eta) {
            this.eta = eta;
            return this;
        }

        public Builder setMaxTrees(Integer maxTrees) {
            this.maxTrees = maxTrees;
            return this;
        }

        public Builder setFeatureBagFraction(Double featureBagFraction) {
            this.featureBagFraction = featureBagFraction;
            return this;
        }

        public Builder setNumTopFeatureImportanceValues(Integer numTopFeatureImportanceValues) {
            this.numTopFeatureImportanceValues = numTopFeatureImportanceValues;
            return this;
        }

        public BoostedTreeParams build() {
            return new BoostedTreeParams(this.lambda, this.gamma, this.eta, this.maxTrees, this.featureBagFraction, this.numTopFeatureImportanceValues);
        }
    }
}

