/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.analyses;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.index.mapper.NumberFieldMapper;

public final class Types {
    private static final Set<String> CATEGORICAL_TYPES = Collections.unmodifiableSet(Stream.of("text", "keyword", "ip").collect(Collectors.toSet()));
    private static final Set<String> NUMERICAL_TYPES = Collections.unmodifiableSet(Stream.concat(Stream.of(NumberFieldMapper.NumberType.values()).map(NumberFieldMapper.NumberType::typeName), Stream.of("scaled_float")).collect(Collectors.toSet()));
    private static final Set<String> DISCRETE_NUMERICAL_TYPES = Collections.unmodifiableSet(Stream.of(NumberFieldMapper.NumberType.BYTE, NumberFieldMapper.NumberType.SHORT, NumberFieldMapper.NumberType.INTEGER, NumberFieldMapper.NumberType.LONG).map(NumberFieldMapper.NumberType::typeName).collect(Collectors.toSet()));
    private static final Set<String> BOOL_TYPES = Collections.singleton("boolean");

    private Types() {
    }

    public static Set<String> categorical() {
        return CATEGORICAL_TYPES;
    }

    public static Set<String> numerical() {
        return NUMERICAL_TYPES;
    }

    public static Set<String> discreteNumerical() {
        return DISCRETE_NUMERICAL_TYPES;
    }

    public static Set<String> bool() {
        return BOOL_TYPES;
    }
}

