/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ContextParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.PipelineAggregatorBuilders;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.filter.Filters;
import org.elasticsearch.search.aggregations.bucket.filter.FiltersAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregation;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationMetric;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationMetricResult;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationParameters;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.MlEvaluationNamedXContentProvider;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification.Classification;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification.PainlessScripts;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class Precision
implements EvaluationMetric {
    public static final ParseField NAME = new ParseField("precision", new String[0]);
    private static final String AGG_NAME_PREFIX = "classification_precision_";
    static final String ACTUAL_CLASSES_NAMES_AGG_NAME = "classification_precision_by_actual_class";
    static final String BY_PREDICTED_CLASS_AGG_NAME = "classification_precision_by_predicted_class";
    static final String PER_PREDICTED_CLASS_PRECISION_AGG_NAME = "classification_precision_per_predicted_class_precision";
    static final String AVG_PRECISION_AGG_NAME = "classification_precision_avg_precision";
    private static final ObjectParser<Precision, Void> PARSER = new ObjectParser(NAME.getPreferredName(), true, Precision::new);
    private static final int MAX_CLASSES_CARDINALITY = 1000;
    private final SetOnce<String> actualField = new SetOnce();
    private final SetOnce<List<String>> topActualClassNames = new SetOnce();
    private final SetOnce<Result> result = new SetOnce();

    public static Precision fromXContent(XContentParser parser) {
        return (Precision)PARSER.apply(parser, null);
    }

    public Precision() {
    }

    public Precision(StreamInput in) throws IOException {
    }

    public String getWriteableName() {
        return MlEvaluationNamedXContentProvider.registeredMetricName(Classification.NAME, NAME);
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    @Override
    public final Tuple<List<AggregationBuilder>, List<PipelineAggregationBuilder>> aggs(EvaluationParameters parameters, String actualField, String predictedField) {
        this.actualField.trySet((Object)actualField);
        if (this.topActualClassNames.get() == null) {
            return Tuple.tuple(Arrays.asList(((TermsAggregationBuilder)AggregationBuilders.terms((String)ACTUAL_CLASSES_NAMES_AGG_NAME).field(actualField)).order(Arrays.asList(BucketOrder.count((boolean)false), BucketOrder.key((boolean)true))).size(1000)), Collections.emptyList());
        }
        if (this.result.get() == null) {
            FiltersAggregator.KeyedFilter[] keyedFiltersPredicted = (FiltersAggregator.KeyedFilter[])((List)this.topActualClassNames.get()).stream().map(className -> new FiltersAggregator.KeyedFilter(className, (QueryBuilder)QueryBuilders.matchQuery((String)predictedField, (Object)className).lenient(true))).toArray(FiltersAggregator.KeyedFilter[]::new);
            Script script = PainlessScripts.buildIsEqualScript(actualField, predictedField);
            return Tuple.tuple(Arrays.asList(AggregationBuilders.filters((String)BY_PREDICTED_CLASS_AGG_NAME, (FiltersAggregator.KeyedFilter[])keyedFiltersPredicted).subAggregation((AggregationBuilder)AggregationBuilders.avg((String)PER_PREDICTED_CLASS_PRECISION_AGG_NAME).script(script))), Arrays.asList(PipelineAggregatorBuilders.avgBucket((String)AVG_PRECISION_AGG_NAME, (String)"classification_precision_by_predicted_class>classification_precision_per_predicted_class_precision")));
        }
        return Tuple.tuple(Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public void process(Aggregations aggs) {
        if (this.topActualClassNames.get() == null && aggs.get(ACTUAL_CLASSES_NAMES_AGG_NAME) instanceof Terms) {
            Terms topActualClassesAgg = (Terms)aggs.get(ACTUAL_CLASSES_NAMES_AGG_NAME);
            if (topActualClassesAgg.getSumOfOtherDocCounts() > 0L) {
                throw ExceptionsHelper.badRequestException("Cannot calculate average precision. Cardinality of field [{}] is too high", this.actualField.get());
            }
            this.topActualClassNames.set(topActualClassesAgg.getBuckets().stream().map(MultiBucketsAggregation.Bucket::getKeyAsString).sorted().collect(Collectors.toList()));
        }
        if (this.result.get() == null && aggs.get(BY_PREDICTED_CLASS_AGG_NAME) instanceof Filters && aggs.get(AVG_PRECISION_AGG_NAME) instanceof NumericMetricsAggregation.SingleValue) {
            Filters byPredictedClassAgg = (Filters)aggs.get(BY_PREDICTED_CLASS_AGG_NAME);
            NumericMetricsAggregation.SingleValue avgPrecisionAgg = (NumericMetricsAggregation.SingleValue)aggs.get(AVG_PRECISION_AGG_NAME);
            ArrayList<PerClassResult> classes = new ArrayList<PerClassResult>(byPredictedClassAgg.getBuckets().size());
            for (Filters.Bucket bucket : byPredictedClassAgg.getBuckets()) {
                String className = bucket.getKeyAsString();
                NumericMetricsAggregation.SingleValue precisionAgg = (NumericMetricsAggregation.SingleValue)bucket.getAggregations().get(PER_PREDICTED_CLASS_PRECISION_AGG_NAME);
                double precision = precisionAgg.value();
                if (!Double.isFinite(precision)) continue;
                classes.add(new PerClassResult(className, precision));
            }
            this.result.set((Object)new Result(classes, avgPrecisionAgg.value()));
        }
    }

    public Optional<Result> getResult() {
        return Optional.ofNullable((Result)this.result.get());
    }

    public void writeTo(StreamOutput out) throws IOException {
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return Objects.hashCode(NAME.getPreferredName());
    }

    public static class PerClassResult
    implements ToXContentObject,
    Writeable {
        private static final ParseField CLASS_NAME = new ParseField("class_name", new String[0]);
        private static final ParseField PRECISION = new ParseField("precision", new String[0]);
        private static final ConstructingObjectParser<PerClassResult, Void> PARSER = new ConstructingObjectParser("precision_per_class_result", true, a -> new PerClassResult((String)a[0], (Double)a[1]));
        private final String className;
        private final double precision;

        public PerClassResult(String className, double precision) {
            this.className = ExceptionsHelper.requireNonNull(className, CLASS_NAME);
            this.precision = precision;
        }

        public PerClassResult(StreamInput in) throws IOException {
            this.className = in.readString();
            this.precision = in.readDouble();
        }

        public String getClassName() {
            return this.className;
        }

        public double getPrecision() {
            return this.precision;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.className);
            out.writeDouble(this.precision);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(CLASS_NAME.getPreferredName(), this.className);
            builder.field(PRECISION.getPreferredName(), this.precision);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PerClassResult that = (PerClassResult)o;
            return Objects.equals(this.className, that.className) && this.precision == that.precision;
        }

        public int hashCode() {
            return Objects.hash(this.className, this.precision);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), CLASS_NAME);
            PARSER.declareDouble(ConstructingObjectParser.constructorArg(), PRECISION);
        }
    }

    public static class Result
    implements EvaluationMetricResult {
        private static final ParseField CLASSES = new ParseField("classes", new String[0]);
        private static final ParseField AVG_PRECISION = new ParseField("avg_precision", new String[0]);
        private static final ConstructingObjectParser<Result, Void> PARSER = new ConstructingObjectParser("precision_result", true, a -> new Result((List)a[0], (Double)a[1]));
        private final List<PerClassResult> classes;
        private final double avgPrecision;

        public static Result fromXContent(XContentParser parser) {
            return (Result)PARSER.apply(parser, null);
        }

        public Result(List<PerClassResult> classes, double avgPrecision) {
            this.classes = Collections.unmodifiableList(ExceptionsHelper.requireNonNull(classes, CLASSES));
            this.avgPrecision = avgPrecision;
        }

        public Result(StreamInput in) throws IOException {
            this.classes = Collections.unmodifiableList(in.readList(PerClassResult::new));
            this.avgPrecision = in.readDouble();
        }

        public String getWriteableName() {
            return MlEvaluationNamedXContentProvider.registeredMetricName(Classification.NAME, NAME);
        }

        @Override
        public String getMetricName() {
            return NAME.getPreferredName();
        }

        public List<PerClassResult> getClasses() {
            return this.classes;
        }

        public double getAvgPrecision() {
            return this.avgPrecision;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeList(this.classes);
            out.writeDouble(this.avgPrecision);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(CLASSES.getPreferredName(), this.classes);
            builder.field(AVG_PRECISION.getPreferredName(), this.avgPrecision);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Result that = (Result)o;
            return Objects.equals(this.classes, that.classes) && this.avgPrecision == that.avgPrecision;
        }

        public int hashCode() {
            return Objects.hash(this.classes, this.avgPrecision);
        }

        static {
            PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (ContextParser)PerClassResult.PARSER, CLASSES);
            PARSER.declareDouble(ConstructingObjectParser.constructorArg(), AVG_PRECISION);
        }
    }
}

