/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.results;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.xpack.core.ml.inference.results.FeatureImportance;
import org.elasticsearch.xpack.core.ml.inference.results.SingleValueInferenceResults;
import org.elasticsearch.xpack.core.ml.inference.results.TopClassEntry;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.ClassificationConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.PredictionFieldType;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class ClassificationInferenceResults
extends SingleValueInferenceResults {
    public static final String NAME = "classification";
    public static final String PREDICTION_PROBABILITY = "prediction_probability";
    public static final String PREDICTION_SCORE = "prediction_score";
    private final String topNumClassesField;
    private final String resultsField;
    private final String classificationLabel;
    private final Double predictionProbability;
    private final Double predictionScore;
    private final List<TopClassEntry> topClasses;
    private final PredictionFieldType predictionFieldType;

    public ClassificationInferenceResults(double value, String classificationLabel, List<TopClassEntry> topClasses, List<FeatureImportance> featureImportance, InferenceConfig config, Double predictionProbability, Double predictionScore) {
        this(value, classificationLabel, topClasses, featureImportance, (ClassificationConfig)config, predictionProbability, predictionScore);
    }

    private ClassificationInferenceResults(double value, String classificationLabel, List<TopClassEntry> topClasses, List<FeatureImportance> featureImportance, ClassificationConfig classificationConfig, Double predictionProbability, Double predictionScore) {
        super(value, SingleValueInferenceResults.takeTopFeatureImportances(featureImportance, classificationConfig.getNumTopFeatureImportanceValues()));
        this.classificationLabel = classificationLabel;
        this.topClasses = topClasses == null ? Collections.emptyList() : Collections.unmodifiableList(topClasses);
        this.topNumClassesField = classificationConfig.getTopClassesResultsField();
        this.resultsField = classificationConfig.getResultsField();
        this.predictionFieldType = classificationConfig.getPredictionFieldType();
        this.predictionProbability = predictionProbability;
        this.predictionScore = predictionScore;
    }

    public ClassificationInferenceResults(StreamInput in) throws IOException {
        super(in);
        this.classificationLabel = in.readOptionalString();
        this.topClasses = Collections.unmodifiableList(in.readList(TopClassEntry::new));
        this.topNumClassesField = in.readString();
        this.resultsField = in.readString();
        this.predictionFieldType = in.getVersion().onOrAfter(Version.V_7_8_0) ? (PredictionFieldType)in.readEnum(PredictionFieldType.class) : PredictionFieldType.STRING;
        if (in.getVersion().onOrAfter(Version.V_7_9_0)) {
            this.predictionProbability = in.readOptionalDouble();
            this.predictionScore = in.readOptionalDouble();
        } else {
            this.predictionProbability = this.topClasses.size() > 0 ? Double.valueOf(this.topClasses.get(0).getProbability()) : null;
            this.predictionScore = this.topClasses.size() > 0 ? Double.valueOf(this.topClasses.get(0).getScore()) : null;
        }
    }

    public String getClassificationLabel() {
        return this.classificationLabel;
    }

    public List<TopClassEntry> getTopClasses() {
        return this.topClasses;
    }

    public PredictionFieldType getPredictionFieldType() {
        return this.predictionFieldType;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.classificationLabel);
        out.writeCollection(this.topClasses);
        out.writeString(this.topNumClassesField);
        out.writeString(this.resultsField);
        if (out.getVersion().onOrAfter(Version.V_7_8_0)) {
            out.writeEnum((Enum)this.predictionFieldType);
        }
        if (out.getVersion().onOrAfter(Version.V_7_9_0)) {
            out.writeOptionalDouble(this.predictionProbability);
            out.writeOptionalDouble(this.predictionScore);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ClassificationInferenceResults that = (ClassificationInferenceResults)object;
        return Objects.equals(this.value(), that.value()) && Objects.equals(this.classificationLabel, that.classificationLabel) && Objects.equals(this.resultsField, that.resultsField) && Objects.equals(this.topNumClassesField, that.topNumClassesField) && Objects.equals(this.topClasses, that.topClasses) && Objects.equals((Object)this.predictionFieldType, (Object)that.predictionFieldType) && Objects.equals(this.predictionProbability, that.predictionProbability) && Objects.equals(this.predictionScore, that.predictionScore) && Objects.equals(this.getFeatureImportance(), that.getFeatureImportance());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value(), this.classificationLabel, this.topClasses, this.resultsField, this.topNumClassesField, this.predictionProbability, this.predictionScore, this.getFeatureImportance(), this.predictionFieldType});
    }

    @Override
    public String valueAsString() {
        return this.classificationLabel == null ? super.valueAsString() : this.classificationLabel;
    }

    @Override
    public Object predictedValue() {
        return this.predictionFieldType.transformPredictedValue(this.value(), this.valueAsString());
    }

    @Override
    public void writeResult(IngestDocument document, String parentResultField) {
        ExceptionsHelper.requireNonNull(document, "document");
        ExceptionsHelper.requireNonNull(parentResultField, "parentResultField");
        document.setFieldValue(parentResultField, this.asMap());
    }

    public Double getPredictionProbability() {
        return this.predictionProbability;
    }

    public Double getPredictionScore() {
        return this.predictionScore;
    }

    @Override
    public Map<String, Object> asMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(this.resultsField, this.predictionFieldType.transformPredictedValue(this.value(), this.valueAsString()));
        if (!this.topClasses.isEmpty()) {
            map.put(this.topNumClassesField, this.topClasses.stream().map(TopClassEntry::asValueMap).collect(Collectors.toList()));
        }
        if (this.predictionProbability != null) {
            map.put(PREDICTION_PROBABILITY, this.predictionProbability);
        }
        if (this.predictionScore != null) {
            map.put(PREDICTION_SCORE, this.predictionScore);
        }
        if (!this.getFeatureImportance().isEmpty()) {
            map.put("feature_importance", this.getFeatureImportance().stream().map(FeatureImportance::toMap).collect(Collectors.toList()));
        }
        return map;
    }

    public String getWriteableName() {
        return NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(this.resultsField, this.predictionFieldType.transformPredictedValue(this.value(), this.valueAsString()));
        if (this.topClasses.size() > 0) {
            builder.field(this.topNumClassesField, this.topClasses);
        }
        if (this.predictionProbability != null) {
            builder.field(PREDICTION_PROBABILITY, this.predictionProbability);
        }
        if (this.predictionScore != null) {
            builder.field(PREDICTION_SCORE, this.predictionScore);
        }
        if (this.getFeatureImportance().size() > 0) {
            builder.field("feature_importance", this.getFeatureImportance());
        }
        return builder;
    }
}

