/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public enum PredictionFieldType implements Writeable
{
    STRING,
    NUMBER,
    BOOLEAN;

    private static final double EPS = 1.0E-9;

    public static PredictionFieldType fromString(String name) {
        return PredictionFieldType.valueOf(name.trim().toUpperCase(Locale.ROOT));
    }

    public static PredictionFieldType fromStream(StreamInput in) throws IOException {
        return (PredictionFieldType)in.readEnum(PredictionFieldType.class);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this);
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public Object transformPredictedValue(Double value, String stringRep) {
        if (value == null) {
            return null;
        }
        switch (this) {
            case STRING: {
                return stringRep == null ? value.toString() : stringRep;
            }
            case BOOLEAN: {
                if (!(PredictionFieldType.areClose(value, 1.0) || PredictionFieldType.areClose(value, 0.0))) {
                    throw new IllegalArgumentException("Cannot transform numbers other than 0.0 or 1.0 to boolean. Provided number [" + value + "]");
                }
                return PredictionFieldType.areClose(value, 1.0);
            }
            case NUMBER: {
                if (Strings.isNullOrEmpty((String)stringRep)) {
                    return value;
                }
                if (stringRep.charAt(0) == '-' || Character.isDigit(stringRep.charAt(0))) {
                    try {
                        return Long.parseLong(stringRep);
                    }
                    catch (NumberFormatException nfe) {
                        return value;
                    }
                }
                return value;
            }
        }
        return value;
    }

    private static boolean areClose(double value1, double value2) {
        return Math.abs(value1 - value2) < 1.0E-9;
    }
}

