/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.rollup.job;

import java.io.IOException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.indexing.IndexerJobStats;

public class RollupIndexerJobStats
extends IndexerJobStats {
    private static ParseField NUM_PAGES = new ParseField("pages_processed", new String[0]);
    private static ParseField NUM_INPUT_DOCUMENTS = new ParseField("documents_processed", new String[0]);
    private static ParseField NUM_OUTPUT_DOCUMENTS = new ParseField("rollups_indexed", new String[0]);
    private static ParseField NUM_INVOCATIONS = new ParseField("trigger_count", new String[0]);
    private static ParseField INDEX_TIME_IN_MS = new ParseField("index_time_in_ms", new String[0]);
    private static ParseField SEARCH_TIME_IN_MS = new ParseField("search_time_in_ms", new String[0]);
    private static ParseField PROCESSING_TIME_IN_MS = new ParseField("processing_time_in_ms", new String[0]);
    private static ParseField INDEX_TOTAL = new ParseField("index_total", new String[0]);
    private static ParseField SEARCH_TOTAL = new ParseField("search_total", new String[0]);
    private static ParseField PROCESSING_TOTAL = new ParseField("processing_total", new String[0]);
    private static ParseField SEARCH_FAILURES = new ParseField("search_failures", new String[0]);
    private static ParseField INDEX_FAILURES = new ParseField("index_failures", new String[0]);
    public static final ConstructingObjectParser<RollupIndexerJobStats, Void> PARSER = new ConstructingObjectParser(NAME.getPreferredName(), args -> new RollupIndexerJobStats((Long)args[0], (Long)args[1], (Long)args[2], (Long)args[3], (Long)args[4], (Long)args[5], (Long)args[6], (Long)args[7], (Long)args[8], (Long)args[9], (Long)args[10], (Long)args[11]));

    public RollupIndexerJobStats() {
    }

    public RollupIndexerJobStats(long numPages, long numInputDocuments, long numOuputDocuments, long numInvocations, long indexTime, long searchTime, long processingTime, long indexTotal, long searchTotal, long processingTotal, long indexFailures, long searchFailures) {
        super(numPages, numInputDocuments, numOuputDocuments, numInvocations, indexTime, searchTime, processingTime, indexTotal, searchTotal, processingTotal, indexFailures, searchFailures);
    }

    public RollupIndexerJobStats(StreamInput in) throws IOException {
        super(in);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NUM_PAGES.getPreferredName(), this.numPages);
        builder.field(NUM_INPUT_DOCUMENTS.getPreferredName(), this.numInputDocuments);
        builder.field(NUM_OUTPUT_DOCUMENTS.getPreferredName(), this.numOuputDocuments);
        builder.field(NUM_INVOCATIONS.getPreferredName(), this.numInvocations);
        builder.field(INDEX_TIME_IN_MS.getPreferredName(), this.indexTime);
        builder.field(INDEX_TOTAL.getPreferredName(), this.indexTotal);
        builder.field(INDEX_FAILURES.getPreferredName(), this.indexFailures);
        builder.field(SEARCH_TIME_IN_MS.getPreferredName(), this.searchTime);
        builder.field(SEARCH_TOTAL.getPreferredName(), this.searchTotal);
        builder.field(SEARCH_FAILURES.getPreferredName(), this.searchFailures);
        builder.field(PROCESSING_TIME_IN_MS.getPreferredName(), this.processingTime);
        builder.field(PROCESSING_TOTAL.getPreferredName(), this.processingTotal);
        builder.endObject();
        return builder;
    }

    public static RollupIndexerJobStats fromXContent(XContentParser parser) {
        try {
            return (RollupIndexerJobStats)PARSER.parse(parser, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), NUM_PAGES);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), NUM_INPUT_DOCUMENTS);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), NUM_OUTPUT_DOCUMENTS);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), NUM_INVOCATIONS);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), INDEX_TIME_IN_MS);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), SEARCH_TIME_IN_MS);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), PROCESSING_TIME_IN_MS);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), INDEX_TOTAL);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), SEARCH_TOTAL);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), PROCESSING_TOTAL);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), INDEX_FAILURES);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), SEARCH_FAILURES);
    }
}

