/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.oidc;

import java.io.IOException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class OpenIdConnectPrepareAuthenticationResponse
extends ActionResponse
implements ToXContentObject {
    private String authenticationRequestUrl;
    private String state;
    private String nonce;

    public OpenIdConnectPrepareAuthenticationResponse(String authorizationEndpointUrl, String state, String nonce) {
        this.authenticationRequestUrl = authorizationEndpointUrl;
        this.state = state;
        this.nonce = nonce;
    }

    public OpenIdConnectPrepareAuthenticationResponse(StreamInput in) throws IOException {
        super(in);
        this.authenticationRequestUrl = in.readString();
        this.state = in.readString();
        this.nonce = in.readString();
    }

    public String getAuthenticationRequestUrl() {
        return this.authenticationRequestUrl;
    }

    public String getState() {
        return this.state;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.authenticationRequestUrl);
        out.writeString(this.state);
        out.writeString(this.nonce);
    }

    public String toString() {
        return "{authenticationRequestUrl=" + this.authenticationRequestUrl + ", state=" + this.state + ", nonce=" + this.nonce + "}";
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("redirect", this.authenticationRequestUrl);
        builder.field("state", this.state);
        builder.field("nonce", this.nonce);
        builder.endObject();
        return builder;
    }
}

