/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.ExpressionModel;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.ExpressionParser;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.RoleMapperExpression;
import org.elasticsearch.xpack.core.security.support.Automatons;

public final class FieldExpression
implements RoleMapperExpression {
    public static final String NAME = "field";
    private final String field;
    private final List<FieldValue> values;

    public FieldExpression(String field, List<FieldValue> values) {
        if (field == null || field.isEmpty()) {
            throw new IllegalArgumentException("null or empty field name (" + field + ")");
        }
        if (values == null || values.isEmpty()) {
            throw new IllegalArgumentException("null or empty values (" + values + ")");
        }
        this.field = field;
        this.values = values;
    }

    public FieldExpression(StreamInput in) throws IOException {
        this(in.readString(), in.readList(FieldValue::readFrom));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.field);
        out.writeList(this.values);
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public boolean match(ExpressionModel model) {
        return model.test(this.field, this.values);
    }

    public String getField() {
        return this.field;
    }

    public List<FieldValue> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldExpression that = (FieldExpression)o;
        return this.field.equals(that.field) && this.values.equals(that.values);
    }

    public int hashCode() {
        int result = this.field.hashCode();
        result = 31 * result + this.values.hashCode();
        return result;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(ExpressionParser.Fields.FIELD.getPreferredName());
        if (this.values.size() == 1) {
            builder.field(this.field);
            this.values.get(0).toXContent(builder, params);
        } else {
            builder.startArray(this.field);
            for (FieldValue fp : this.values) {
                fp.toXContent(builder, params);
            }
            builder.endArray();
        }
        builder.endObject();
        return builder.endObject();
    }

    public static class FieldValue
    implements ToXContent,
    Writeable {
        private final Object value;
        @Nullable
        private final CharacterRunAutomaton automaton;

        public FieldValue(Object value) {
            this.value = value;
            this.automaton = FieldValue.buildAutomaton(value);
        }

        private static CharacterRunAutomaton buildAutomaton(Object value) {
            String str;
            if (value instanceof String && (Regex.isSimpleMatchPattern((String)(str = (String)value)) || Automatons.isLuceneRegex(str))) {
                return new CharacterRunAutomaton(Automatons.patterns(str));
            }
            return null;
        }

        public Object getValue() {
            return this.value;
        }

        public CharacterRunAutomaton getAutomaton() {
            return this.automaton;
        }

        public static FieldValue readFrom(StreamInput in) throws IOException {
            return new FieldValue(in.readGenericValue());
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeGenericValue(this.value);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.value(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldValue that = (FieldValue)o;
            return Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }
}

