/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.permission;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.TooComplexToDeterminizeException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.core.security.authz.permission.DocumentPermissions;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissions;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissionsCache;
import org.elasticsearch.xpack.core.security.authz.permission.ResourcePrivilegesMap;
import org.elasticsearch.xpack.core.security.authz.privilege.IndexPrivilege;
import org.elasticsearch.xpack.core.security.index.RestrictedIndicesNames;
import org.elasticsearch.xpack.core.security.support.Automatons;

public final class IndicesPermission {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(IndicesPermission.class));
    public static final IndicesPermission NONE = new IndicesPermission(new Group[0]);
    private static final Set<String> PRIVILEGE_NAME_SET_BWC_ALLOW_MAPPING_UPDATE = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("create", "create_doc", "index", "write")));
    private final Map<String, Predicate<IndexAbstraction>> allowedIndicesMatchersForAction = new ConcurrentHashMap<String, Predicate<IndexAbstraction>>();
    private final Group[] groups;

    public IndicesPermission(Group ... groups) {
        this.groups = groups;
    }

    private static Predicate<String> indexMatcher(Collection<String> ordinaryIndices, Collection<String> restrictedIndices) {
        Predicate<String> namePredicate;
        if (ordinaryIndices.isEmpty()) {
            namePredicate = IndicesPermission.indexMatcher(restrictedIndices);
        } else {
            namePredicate = IndicesPermission.indexMatcher(ordinaryIndices).and(index -> false == RestrictedIndicesNames.isRestricted(index));
            if (!restrictedIndices.isEmpty()) {
                namePredicate = IndicesPermission.indexMatcher(restrictedIndices).or(namePredicate);
            }
        }
        return namePredicate;
    }

    public static Predicate<String> indexMatcher(Collection<String> indices) {
        HashSet<String> exactMatch = new HashSet<String>();
        ArrayList<String> nonExactMatch = new ArrayList<String>();
        for (String indexPattern : indices) {
            if (indexPattern.startsWith("/") || indexPattern.contains("*") || indexPattern.contains("?")) {
                nonExactMatch.add(indexPattern);
                continue;
            }
            exactMatch.add(indexPattern);
        }
        if (exactMatch.isEmpty() && nonExactMatch.isEmpty()) {
            return s -> false;
        }
        if (exactMatch.isEmpty()) {
            return IndicesPermission.buildAutomataPredicate(nonExactMatch);
        }
        if (nonExactMatch.isEmpty()) {
            return IndicesPermission.buildExactMatchPredicate(exactMatch);
        }
        return IndicesPermission.buildExactMatchPredicate(exactMatch).or(IndicesPermission.buildAutomataPredicate(nonExactMatch));
    }

    private static Predicate<String> buildExactMatchPredicate(Set<String> indices) {
        if (indices.size() == 1) {
            String singleValue = indices.iterator().next();
            return singleValue::equals;
        }
        return indices::contains;
    }

    private static Predicate<String> buildAutomataPredicate(List<String> indices) {
        try {
            return Automatons.predicate(indices);
        }
        catch (TooComplexToDeterminizeException e) {
            LogManager.getLogger(IndicesPermission.class).debug("Index pattern automaton [{}] is too complex", indices);
            String description = Strings.collectionToCommaDelimitedString(indices);
            if (description.length() > 80) {
                description = Strings.cleanTruncate((String)description, (int)80) + "...";
            }
            throw new ElasticsearchSecurityException("The set of permitted index patterns [{}] is too complex to evaluate", (Exception)((Object)e), new Object[]{description});
        }
    }

    public Group[] groups() {
        return this.groups;
    }

    public Predicate<IndexAbstraction> allowedIndicesMatcher(String action) {
        return this.allowedIndicesMatchersForAction.computeIfAbsent(action, a -> Group.buildIndexMatcherPredicateForAction(a, this.groups));
    }

    public boolean check(String action) {
        boolean isMappingUpdateAction = IndicesPermission.isMappingUpdateAction(action);
        for (Group group : this.groups) {
            if (!group.checkAction(action) && (!isMappingUpdateAction || !IndicesPermission.containsPrivilegeThatGrantsMappingUpdatesForBwc(group))) continue;
            return true;
        }
        return false;
    }

    public ResourcePrivilegesMap checkResourcePrivileges(Set<String> checkForIndexPatterns, boolean allowRestrictedIndices, Set<String> checkForPrivileges) {
        ResourcePrivilegesMap.Builder resourcePrivilegesMapBuilder = ResourcePrivilegesMap.builder();
        HashMap<Group, Automaton> predicateCache = new HashMap<Group, Automaton>();
        for (String forIndexPattern : checkForIndexPatterns) {
            Automaton checkIndexAutomaton = Automatons.patterns(forIndexPattern);
            if (!allowRestrictedIndices && !this.isConcreteRestrictedIndex(forIndexPattern)) {
                checkIndexAutomaton = Automatons.minusAndMinimize(checkIndexAutomaton, RestrictedIndicesNames.NAMES_AUTOMATON);
            }
            if (!Operations.isEmpty((Automaton)checkIndexAutomaton)) {
                Automaton allowedIndexPrivilegesAutomaton = null;
                for (Group group : this.groups) {
                    Automaton groupIndexAutomaton = predicateCache.computeIfAbsent(group, g -> Group.buildIndexMatcherAutomaton(g.allowRestrictedIndices(), g.indices()));
                    if (!Operations.subsetOf((Automaton)checkIndexAutomaton, (Automaton)groupIndexAutomaton)) continue;
                    allowedIndexPrivilegesAutomaton = allowedIndexPrivilegesAutomaton != null ? Automatons.unionAndMinimize(Arrays.asList(allowedIndexPrivilegesAutomaton, group.privilege().getAutomaton())) : group.privilege().getAutomaton();
                }
                for (String privilege : checkForPrivileges) {
                    IndexPrivilege indexPrivilege = IndexPrivilege.get(Collections.singleton(privilege));
                    if (allowedIndexPrivilegesAutomaton != null && Operations.subsetOf((Automaton)indexPrivilege.getAutomaton(), (Automaton)allowedIndexPrivilegesAutomaton)) {
                        resourcePrivilegesMapBuilder.addResourcePrivilege(forIndexPattern, privilege, Boolean.TRUE);
                        continue;
                    }
                    resourcePrivilegesMapBuilder.addResourcePrivilege(forIndexPattern, privilege, Boolean.FALSE);
                }
                continue;
            }
            for (String privilege : checkForPrivileges) {
                resourcePrivilegesMapBuilder.addResourcePrivilege(forIndexPattern, privilege, Boolean.FALSE);
            }
        }
        return resourcePrivilegesMapBuilder.build();
    }

    public Automaton allowedActionsMatcher(String index) {
        ArrayList<Automaton> automatonList = new ArrayList<Automaton>();
        for (Group group : this.groups) {
            if (!group.indexNameMatcher.test(index)) continue;
            automatonList.add(group.privilege.getAutomaton());
        }
        return automatonList.isEmpty() ? Automatons.EMPTY : Automatons.unionAndMinimize(automatonList);
    }

    public Map<String, IndicesAccessControl.IndexAccessControl> authorize(String action, Set<String> requestedIndicesOrAliases, Map<String, IndexAbstraction> lookup, FieldPermissionsCache fieldPermissionsCache) {
        HashMap<String, Set> fieldPermissionsByIndex = new HashMap<String, Set>();
        HashMap<String, DocumentLevelPermissions> roleQueriesByIndex = new HashMap<String, DocumentLevelPermissions>();
        HashMap<String, Boolean> grantedBuilder = new HashMap<String, Boolean>();
        boolean isMappingUpdateAction = IndicesPermission.isMappingUpdateAction(action);
        for (String indexOrAlias : requestedIndicesOrAliases) {
            boolean isDataStream;
            boolean isBackingIndex;
            HashSet<String> concreteIndices = new HashSet<String>();
            IndexAbstraction indexAbstraction = lookup.get(indexOrAlias);
            if (indexAbstraction != null) {
                for (IndexMetadata indexMetadata : indexAbstraction.getIndices()) {
                    concreteIndices.add(indexMetadata.getIndex().getName());
                }
                isBackingIndex = indexAbstraction.getType() == IndexAbstraction.Type.CONCRETE_INDEX && indexAbstraction.getParentDataStream() != null;
                isDataStream = indexAbstraction.getType() == IndexAbstraction.Type.DATA_STREAM;
            } else {
                isDataStream = false;
                isBackingIndex = false;
            }
            boolean granted = false;
            boolean bwcGrantMappingUpdate = false;
            ArrayList<Runnable> bwcDeprecationLogActions = new ArrayList<Runnable>();
            for (Group group : this.groups) {
                boolean indexCheck;
                boolean bl = indexCheck = group.checkIndex(indexOrAlias) || isBackingIndex && group.checkIndex(indexAbstraction.getParentDataStream().getName());
                if (!indexCheck) continue;
                boolean actionCheck = group.checkAction(action);
                granted = granted || actionCheck;
                boolean bwcMappingActionCheck = isMappingUpdateAction && false == isDataStream && false == isBackingIndex && IndicesPermission.containsPrivilegeThatGrantsMappingUpdatesForBwc(group);
                boolean bl2 = bwcGrantMappingUpdate = bwcGrantMappingUpdate || bwcMappingActionCheck;
                if (!actionCheck && !bwcMappingActionCheck) continue;
                for (String index : concreteIndices) {
                    Set fieldPermissions = fieldPermissionsByIndex.computeIfAbsent(index, k -> new HashSet());
                    fieldPermissionsByIndex.put(indexOrAlias, fieldPermissions);
                    fieldPermissions.add(group.getFieldPermissions());
                    DocumentLevelPermissions permissions = roleQueriesByIndex.computeIfAbsent(index, k -> new DocumentLevelPermissions());
                    roleQueriesByIndex.putIfAbsent(indexOrAlias, permissions);
                    if (group.hasQuery()) {
                        permissions.addAll(group.getQuery());
                        continue;
                    }
                    permissions.setAllowAll(true);
                }
                if (actionCheck) continue;
                for (String privilegeName : group.privilege.name()) {
                    if (!PRIVILEGE_NAME_SET_BWC_ALLOW_MAPPING_UPDATE.contains(privilegeName)) continue;
                    bwcDeprecationLogActions.add(() -> deprecationLogger.deprecatedAndMaybeLog("[" + indexOrAlias + "] mapping update for ingest privilege [" + privilegeName + "]", "the index privilege [" + privilegeName + "] allowed the update mapping action [" + action + "] on index [" + indexOrAlias + "], this privilege will not permit mapping updates in the next major release - users who require access to update mappings must be granted explicit privileges", new Object[0]));
                }
            }
            if (!granted && bwcGrantMappingUpdate) {
                granted = true;
                bwcDeprecationLogActions.forEach(deprecationLogAction -> deprecationLogAction.run());
            }
            if (concreteIndices.isEmpty()) {
                grantedBuilder.put(indexOrAlias, granted);
                continue;
            }
            grantedBuilder.put(indexOrAlias, granted);
            for (String concreteIndex : concreteIndices) {
                grantedBuilder.put(concreteIndex, granted);
            }
        }
        HashMap<String, IndicesAccessControl.IndexAccessControl> indexPermissions = new HashMap<String, IndicesAccessControl.IndexAccessControl>();
        for (Map.Entry entry : grantedBuilder.entrySet()) {
            String index = (String)entry.getKey();
            DocumentLevelPermissions permissions = (DocumentLevelPermissions)roleQueriesByIndex.get(index);
            Set<BytesReference> roleQueries = permissions != null && !permissions.isAllowAll() ? Collections.unmodifiableSet(permissions.queries) : null;
            Set indexFieldPermissions = (Set)fieldPermissionsByIndex.get(index);
            FieldPermissions fieldPermissions = indexFieldPermissions != null && !indexFieldPermissions.isEmpty() ? (indexFieldPermissions.size() == 1 ? (FieldPermissions)indexFieldPermissions.iterator().next() : fieldPermissionsCache.getFieldPermissions(indexFieldPermissions)) : FieldPermissions.DEFAULT;
            indexPermissions.put(index, new IndicesAccessControl.IndexAccessControl((Boolean)entry.getValue(), fieldPermissions, roleQueries != null ? DocumentPermissions.filteredBy(roleQueries) : DocumentPermissions.allowAll()));
        }
        return Collections.unmodifiableMap(indexPermissions);
    }

    private boolean isConcreteRestrictedIndex(String indexPattern) {
        if (Regex.isSimpleMatchPattern((String)indexPattern) || Automatons.isLuceneRegex(indexPattern)) {
            return false;
        }
        return RestrictedIndicesNames.isRestricted(indexPattern);
    }

    private static boolean isMappingUpdateAction(String action) {
        return action.equals("indices:admin/mapping/put") || action.equals("indices:admin/mapping/auto_put");
    }

    private static boolean containsPrivilegeThatGrantsMappingUpdatesForBwc(Group group) {
        return group.privilege().name().stream().anyMatch(PRIVILEGE_NAME_SET_BWC_ALLOW_MAPPING_UPDATE::contains);
    }

    public static class Group {
        private final IndexPrivilege privilege;
        private final Predicate<String> actionMatcher;
        private final String[] indices;
        private final Predicate<String> indexNameMatcher;
        private final FieldPermissions fieldPermissions;
        private final Set<BytesReference> query;
        private final boolean allowRestrictedIndices;

        public Group(IndexPrivilege privilege, FieldPermissions fieldPermissions, @Nullable Set<BytesReference> query, boolean allowRestrictedIndices, String ... indices) {
            assert (indices.length != 0);
            this.privilege = privilege;
            this.actionMatcher = privilege.predicate();
            this.indices = indices;
            this.indexNameMatcher = IndicesPermission.indexMatcher(Arrays.asList(indices));
            this.fieldPermissions = Objects.requireNonNull(fieldPermissions);
            this.query = query;
            this.allowRestrictedIndices = allowRestrictedIndices;
        }

        public IndexPrivilege privilege() {
            return this.privilege;
        }

        public String[] indices() {
            return this.indices;
        }

        @Nullable
        public Set<BytesReference> getQuery() {
            return this.query;
        }

        public FieldPermissions getFieldPermissions() {
            return this.fieldPermissions;
        }

        private boolean checkAction(String action) {
            return this.actionMatcher.test(action);
        }

        private boolean checkIndex(String index) {
            assert (index != null);
            return this.indexNameMatcher.test(index) && (this.allowRestrictedIndices || false == RestrictedIndicesNames.isRestricted(index));
        }

        boolean hasQuery() {
            return this.query != null;
        }

        public boolean allowRestrictedIndices() {
            return this.allowRestrictedIndices;
        }

        public static Automaton buildIndexMatcherAutomaton(boolean allowRestrictedIndices, String ... indices) {
            Automaton indicesAutomaton = Automatons.patterns(indices);
            if (allowRestrictedIndices) {
                return indicesAutomaton;
            }
            return Automatons.minusAndMinimize(indicesAutomaton, RestrictedIndicesNames.NAMES_AUTOMATON);
        }

        private static Predicate<IndexAbstraction> buildIndexMatcherPredicateForAction(String action, Group ... groups) {
            HashSet<String> ordinaryIndices = new HashSet<String>();
            HashSet<String> restrictedIndices = new HashSet<String>();
            HashSet<String> grantMappingUpdatesOnIndices = new HashSet<String>();
            HashSet<String> grantMappingUpdatesOnRestrictedIndices = new HashSet<String>();
            boolean isMappingUpdateAction = IndicesPermission.isMappingUpdateAction(action);
            for (Group group : groups) {
                if (group.actionMatcher.test(action)) {
                    if (group.allowRestrictedIndices) {
                        restrictedIndices.addAll(Arrays.asList(group.indices()));
                        continue;
                    }
                    ordinaryIndices.addAll(Arrays.asList(group.indices()));
                    continue;
                }
                if (!isMappingUpdateAction || !IndicesPermission.containsPrivilegeThatGrantsMappingUpdatesForBwc(group)) continue;
                if (group.allowRestrictedIndices) {
                    grantMappingUpdatesOnRestrictedIndices.addAll(Arrays.asList(group.indices()));
                    continue;
                }
                grantMappingUpdatesOnIndices.addAll(Arrays.asList(group.indices()));
            }
            Predicate namePredicate = IndicesPermission.indexMatcher(ordinaryIndices, restrictedIndices);
            Predicate bwcSpecialCaseNamePredicate = IndicesPermission.indexMatcher(grantMappingUpdatesOnIndices, grantMappingUpdatesOnRestrictedIndices);
            return indexAbstraction -> namePredicate.test(indexAbstraction.getName()) || indexAbstraction.getType() != IndexAbstraction.Type.DATA_STREAM && indexAbstraction.getParentDataStream() == null && bwcSpecialCaseNamePredicate.test(indexAbstraction.getName());
        }
    }

    private static class DocumentLevelPermissions {
        private Set<BytesReference> queries = null;
        private boolean allowAll = false;

        private DocumentLevelPermissions() {
        }

        private void addAll(Set<BytesReference> query) {
            if (!this.allowAll) {
                if (this.queries == null) {
                    this.queries = new HashSet<BytesReference>();
                }
                this.queries.addAll(query);
            }
        }

        private boolean isAllowAll() {
            return this.allowAll;
        }

        private void setAllowAll(boolean allowAll) {
            this.allowAll = allowAll;
        }
    }
}

