/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.client;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.core.security.action.CreateApiKeyAction;
import org.elasticsearch.xpack.core.security.action.CreateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.CreateApiKeyRequestBuilder;
import org.elasticsearch.xpack.core.security.action.CreateApiKeyResponse;
import org.elasticsearch.xpack.core.security.action.GetApiKeyAction;
import org.elasticsearch.xpack.core.security.action.GetApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.GetApiKeyResponse;
import org.elasticsearch.xpack.core.security.action.InvalidateApiKeyAction;
import org.elasticsearch.xpack.core.security.action.InvalidateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.InvalidateApiKeyResponse;
import org.elasticsearch.xpack.core.security.action.privilege.DeletePrivilegesAction;
import org.elasticsearch.xpack.core.security.action.privilege.DeletePrivilegesRequestBuilder;
import org.elasticsearch.xpack.core.security.action.privilege.GetPrivilegesAction;
import org.elasticsearch.xpack.core.security.action.privilege.GetPrivilegesRequestBuilder;
import org.elasticsearch.xpack.core.security.action.privilege.PutPrivilegesAction;
import org.elasticsearch.xpack.core.security.action.privilege.PutPrivilegesRequestBuilder;
import org.elasticsearch.xpack.core.security.action.realm.ClearRealmCacheAction;
import org.elasticsearch.xpack.core.security.action.realm.ClearRealmCacheRequest;
import org.elasticsearch.xpack.core.security.action.realm.ClearRealmCacheRequestBuilder;
import org.elasticsearch.xpack.core.security.action.realm.ClearRealmCacheResponse;
import org.elasticsearch.xpack.core.security.action.role.ClearRolesCacheAction;
import org.elasticsearch.xpack.core.security.action.role.ClearRolesCacheRequest;
import org.elasticsearch.xpack.core.security.action.role.ClearRolesCacheRequestBuilder;
import org.elasticsearch.xpack.core.security.action.role.ClearRolesCacheResponse;
import org.elasticsearch.xpack.core.security.action.role.DeleteRoleAction;
import org.elasticsearch.xpack.core.security.action.role.DeleteRoleRequest;
import org.elasticsearch.xpack.core.security.action.role.DeleteRoleRequestBuilder;
import org.elasticsearch.xpack.core.security.action.role.DeleteRoleResponse;
import org.elasticsearch.xpack.core.security.action.role.GetRolesAction;
import org.elasticsearch.xpack.core.security.action.role.GetRolesRequest;
import org.elasticsearch.xpack.core.security.action.role.GetRolesRequestBuilder;
import org.elasticsearch.xpack.core.security.action.role.GetRolesResponse;
import org.elasticsearch.xpack.core.security.action.role.PutRoleAction;
import org.elasticsearch.xpack.core.security.action.role.PutRoleRequest;
import org.elasticsearch.xpack.core.security.action.role.PutRoleRequestBuilder;
import org.elasticsearch.xpack.core.security.action.role.PutRoleResponse;
import org.elasticsearch.xpack.core.security.action.rolemapping.DeleteRoleMappingAction;
import org.elasticsearch.xpack.core.security.action.rolemapping.DeleteRoleMappingRequestBuilder;
import org.elasticsearch.xpack.core.security.action.rolemapping.GetRoleMappingsAction;
import org.elasticsearch.xpack.core.security.action.rolemapping.GetRoleMappingsRequest;
import org.elasticsearch.xpack.core.security.action.rolemapping.GetRoleMappingsRequestBuilder;
import org.elasticsearch.xpack.core.security.action.rolemapping.GetRoleMappingsResponse;
import org.elasticsearch.xpack.core.security.action.rolemapping.PutRoleMappingAction;
import org.elasticsearch.xpack.core.security.action.rolemapping.PutRoleMappingRequestBuilder;
import org.elasticsearch.xpack.core.security.action.saml.SamlAuthenticateAction;
import org.elasticsearch.xpack.core.security.action.saml.SamlAuthenticateRequest;
import org.elasticsearch.xpack.core.security.action.saml.SamlAuthenticateRequestBuilder;
import org.elasticsearch.xpack.core.security.action.saml.SamlAuthenticateResponse;
import org.elasticsearch.xpack.core.security.action.saml.SamlPrepareAuthenticationRequestBuilder;
import org.elasticsearch.xpack.core.security.action.token.CreateTokenAction;
import org.elasticsearch.xpack.core.security.action.token.CreateTokenRequest;
import org.elasticsearch.xpack.core.security.action.token.CreateTokenRequestBuilder;
import org.elasticsearch.xpack.core.security.action.token.CreateTokenResponse;
import org.elasticsearch.xpack.core.security.action.token.InvalidateTokenAction;
import org.elasticsearch.xpack.core.security.action.token.InvalidateTokenRequest;
import org.elasticsearch.xpack.core.security.action.token.InvalidateTokenRequestBuilder;
import org.elasticsearch.xpack.core.security.action.token.InvalidateTokenResponse;
import org.elasticsearch.xpack.core.security.action.token.RefreshTokenAction;
import org.elasticsearch.xpack.core.security.action.user.ChangePasswordAction;
import org.elasticsearch.xpack.core.security.action.user.ChangePasswordRequest;
import org.elasticsearch.xpack.core.security.action.user.ChangePasswordRequestBuilder;
import org.elasticsearch.xpack.core.security.action.user.ChangePasswordResponse;
import org.elasticsearch.xpack.core.security.action.user.DeleteUserAction;
import org.elasticsearch.xpack.core.security.action.user.DeleteUserRequest;
import org.elasticsearch.xpack.core.security.action.user.DeleteUserRequestBuilder;
import org.elasticsearch.xpack.core.security.action.user.DeleteUserResponse;
import org.elasticsearch.xpack.core.security.action.user.GetUserPrivilegesAction;
import org.elasticsearch.xpack.core.security.action.user.GetUserPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.user.GetUserPrivilegesRequestBuilder;
import org.elasticsearch.xpack.core.security.action.user.GetUserPrivilegesResponse;
import org.elasticsearch.xpack.core.security.action.user.GetUsersAction;
import org.elasticsearch.xpack.core.security.action.user.GetUsersRequest;
import org.elasticsearch.xpack.core.security.action.user.GetUsersRequestBuilder;
import org.elasticsearch.xpack.core.security.action.user.GetUsersResponse;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesAction;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesRequestBuilder;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesResponse;
import org.elasticsearch.xpack.core.security.action.user.PutUserAction;
import org.elasticsearch.xpack.core.security.action.user.PutUserRequest;
import org.elasticsearch.xpack.core.security.action.user.PutUserRequestBuilder;
import org.elasticsearch.xpack.core.security.action.user.PutUserResponse;
import org.elasticsearch.xpack.core.security.action.user.SetEnabledAction;
import org.elasticsearch.xpack.core.security.action.user.SetEnabledRequest;
import org.elasticsearch.xpack.core.security.action.user.SetEnabledRequestBuilder;
import org.elasticsearch.xpack.core.security.action.user.SetEnabledResponse;
import org.elasticsearch.xpack.core.security.authc.support.Hasher;

public class SecurityClient {
    private final ElasticsearchClient client;

    public SecurityClient(ElasticsearchClient client) {
        this.client = client;
    }

    public ClearRealmCacheRequestBuilder prepareClearRealmCache() {
        return new ClearRealmCacheRequestBuilder(this.client);
    }

    public void clearRealmCache(ClearRealmCacheRequest request, ActionListener<ClearRealmCacheResponse> listener) {
        this.client.execute((ActionType)ClearRealmCacheAction.INSTANCE, (ActionRequest)request, listener);
    }

    public ActionFuture<ClearRealmCacheResponse> clearRealmCache(ClearRealmCacheRequest request) {
        return this.client.execute((ActionType)ClearRealmCacheAction.INSTANCE, (ActionRequest)request);
    }

    public ClearRolesCacheRequestBuilder prepareClearRolesCache() {
        return new ClearRolesCacheRequestBuilder(this.client);
    }

    public void clearRolesCache(ClearRolesCacheRequest request, ActionListener<ClearRolesCacheResponse> listener) {
        this.client.execute((ActionType)ClearRolesCacheAction.INSTANCE, (ActionRequest)request, listener);
    }

    public ActionFuture<ClearRolesCacheResponse> clearRolesCache(ClearRolesCacheRequest request) {
        return this.client.execute((ActionType)ClearRolesCacheAction.INSTANCE, (ActionRequest)request);
    }

    public HasPrivilegesRequestBuilder prepareHasPrivileges(String username) {
        return new HasPrivilegesRequestBuilder(this.client).username(username);
    }

    public HasPrivilegesRequestBuilder prepareHasPrivileges(String username, BytesReference source, XContentType xContentType) throws IOException {
        return new HasPrivilegesRequestBuilder(this.client).source(username, source, xContentType);
    }

    public void hasPrivileges(HasPrivilegesRequest request, ActionListener<HasPrivilegesResponse> listener) {
        this.client.execute((ActionType)HasPrivilegesAction.INSTANCE, (ActionRequest)request, listener);
    }

    public GetUserPrivilegesRequestBuilder prepareGetUserPrivileges(String username) {
        return new GetUserPrivilegesRequestBuilder(this.client).username(username);
    }

    public void listUserPrivileges(GetUserPrivilegesRequest request, ActionListener<GetUserPrivilegesResponse> listener) {
        this.client.execute((ActionType)GetUserPrivilegesAction.INSTANCE, (ActionRequest)request, listener);
    }

    public GetUsersRequestBuilder prepareGetUsers(String ... usernames) {
        return new GetUsersRequestBuilder(this.client).usernames(usernames);
    }

    public void getUsers(GetUsersRequest request, ActionListener<GetUsersResponse> listener) {
        this.client.execute((ActionType)GetUsersAction.INSTANCE, (ActionRequest)request, listener);
    }

    public DeleteUserRequestBuilder prepareDeleteUser(String username) {
        return new DeleteUserRequestBuilder(this.client).username(username);
    }

    public void deleteUser(DeleteUserRequest request, ActionListener<DeleteUserResponse> listener) {
        this.client.execute((ActionType)DeleteUserAction.INSTANCE, (ActionRequest)request, listener);
    }

    public PutUserRequestBuilder preparePutUser(String username, BytesReference source, XContentType xContentType, Hasher hasher) throws IOException {
        return new PutUserRequestBuilder(this.client).source(username, source, xContentType, hasher);
    }

    public PutUserRequestBuilder preparePutUser(String username, char[] password, Hasher hasher, String ... roles) {
        return new PutUserRequestBuilder(this.client).username(username).password(password, hasher).roles(roles);
    }

    public PutUserRequestBuilder preparePutUser(String username, SecureString password, Hasher hasher, String ... roles) {
        return new PutUserRequestBuilder(this.client).username(username).password(password, hasher).roles(roles);
    }

    public void putUser(PutUserRequest request, ActionListener<PutUserResponse> listener) {
        this.client.execute((ActionType)PutUserAction.INSTANCE, (ActionRequest)request, listener);
    }

    public ChangePasswordRequestBuilder prepareChangePassword(String username, char[] password, Hasher hasher) {
        return new ChangePasswordRequestBuilder(this.client).username(username).password(password, hasher);
    }

    public ChangePasswordRequestBuilder prepareChangePassword(String username, BytesReference source, XContentType xContentType, Hasher hasher) throws IOException {
        return new ChangePasswordRequestBuilder(this.client).username(username).source(source, xContentType, hasher);
    }

    public void changePassword(ChangePasswordRequest request, ActionListener<ChangePasswordResponse> listener) {
        this.client.execute((ActionType)ChangePasswordAction.INSTANCE, (ActionRequest)request, listener);
    }

    public SetEnabledRequestBuilder prepareSetEnabled(String username, boolean enabled) {
        return new SetEnabledRequestBuilder(this.client).username(username).enabled(enabled);
    }

    public void setEnabled(SetEnabledRequest request, ActionListener<SetEnabledResponse> listener) {
        this.client.execute((ActionType)SetEnabledAction.INSTANCE, (ActionRequest)request, listener);
    }

    public GetRolesRequestBuilder prepareGetRoles(String ... names) {
        return new GetRolesRequestBuilder(this.client).names(names);
    }

    public void getRoles(GetRolesRequest request, ActionListener<GetRolesResponse> listener) {
        this.client.execute((ActionType)GetRolesAction.INSTANCE, (ActionRequest)request, listener);
    }

    public DeleteRoleRequestBuilder prepareDeleteRole(String name) {
        return new DeleteRoleRequestBuilder(this.client).name(name);
    }

    public void deleteRole(DeleteRoleRequest request, ActionListener<DeleteRoleResponse> listener) {
        this.client.execute((ActionType)DeleteRoleAction.INSTANCE, (ActionRequest)request, listener);
    }

    public PutRoleRequestBuilder preparePutRole(String name) {
        return new PutRoleRequestBuilder(this.client).name(name);
    }

    public PutRoleRequestBuilder preparePutRole(String name, BytesReference source, XContentType xContentType) throws IOException {
        return new PutRoleRequestBuilder(this.client).source(name, source, xContentType);
    }

    public void putRole(PutRoleRequest request, ActionListener<PutRoleResponse> listener) {
        this.client.execute((ActionType)PutRoleAction.INSTANCE, (ActionRequest)request, listener);
    }

    public GetRoleMappingsRequestBuilder prepareGetRoleMappings(String ... names) {
        return new GetRoleMappingsRequestBuilder(this.client, GetRoleMappingsAction.INSTANCE).names(names);
    }

    public void getRoleMappings(GetRoleMappingsRequest request, ActionListener<GetRoleMappingsResponse> listener) {
        this.client.execute((ActionType)GetRoleMappingsAction.INSTANCE, (ActionRequest)request, listener);
    }

    public PutRoleMappingRequestBuilder preparePutRoleMapping(String name, BytesReference content, XContentType xContentType) throws IOException {
        return new PutRoleMappingRequestBuilder(this.client, PutRoleMappingAction.INSTANCE).source(name, content, xContentType);
    }

    public DeleteRoleMappingRequestBuilder prepareDeleteRoleMapping(String name) {
        return new DeleteRoleMappingRequestBuilder(this.client, DeleteRoleMappingAction.INSTANCE).name(name);
    }

    public GetPrivilegesRequestBuilder prepareGetPrivileges(String applicationName, String[] privileges) {
        return new GetPrivilegesRequestBuilder(this.client, GetPrivilegesAction.INSTANCE).application(applicationName).privileges(privileges);
    }

    public PutPrivilegesRequestBuilder preparePutPrivileges(BytesReference bytesReference, XContentType xContentType) throws IOException {
        return new PutPrivilegesRequestBuilder(this.client, PutPrivilegesAction.INSTANCE).source(bytesReference, xContentType);
    }

    public DeletePrivilegesRequestBuilder prepareDeletePrivileges(String applicationName, String[] privileges) {
        return new DeletePrivilegesRequestBuilder(this.client, DeletePrivilegesAction.INSTANCE).application(applicationName).privileges(privileges);
    }

    public CreateTokenRequestBuilder prepareCreateToken() {
        return new CreateTokenRequestBuilder(this.client, CreateTokenAction.INSTANCE);
    }

    public void createToken(CreateTokenRequest request, ActionListener<CreateTokenResponse> listener) {
        this.client.execute((ActionType)CreateTokenAction.INSTANCE, (ActionRequest)request, listener);
    }

    public InvalidateTokenRequestBuilder prepareInvalidateToken(String token) {
        return new InvalidateTokenRequestBuilder(this.client).setTokenString(token);
    }

    public InvalidateTokenRequestBuilder prepareInvalidateToken() {
        return new InvalidateTokenRequestBuilder(this.client);
    }

    public void invalidateToken(InvalidateTokenRequest request, ActionListener<InvalidateTokenResponse> listener) {
        this.client.execute((ActionType)InvalidateTokenAction.INSTANCE, (ActionRequest)request, listener);
    }

    public CreateApiKeyRequestBuilder prepareCreateApiKey() {
        return new CreateApiKeyRequestBuilder(this.client);
    }

    public CreateApiKeyRequestBuilder prepareCreateApiKey(BytesReference bytesReference, XContentType xContentType) throws IOException {
        return new CreateApiKeyRequestBuilder(this.client).source(bytesReference, xContentType);
    }

    public void createApiKey(CreateApiKeyRequest request, ActionListener<CreateApiKeyResponse> listener) {
        this.client.execute((ActionType)CreateApiKeyAction.INSTANCE, (ActionRequest)request, listener);
    }

    public void invalidateApiKey(InvalidateApiKeyRequest request, ActionListener<InvalidateApiKeyResponse> listener) {
        this.client.execute((ActionType)InvalidateApiKeyAction.INSTANCE, (ActionRequest)request, listener);
    }

    public void getApiKey(GetApiKeyRequest request, ActionListener<GetApiKeyResponse> listener) {
        this.client.execute((ActionType)GetApiKeyAction.INSTANCE, (ActionRequest)request, listener);
    }

    public SamlAuthenticateRequestBuilder prepareSamlAuthenticate(byte[] xmlContent, List<String> validIds) {
        SamlAuthenticateRequestBuilder builder = new SamlAuthenticateRequestBuilder(this.client);
        builder.saml(xmlContent);
        builder.validRequestIds(validIds);
        return builder;
    }

    public void samlAuthenticate(SamlAuthenticateRequest request, ActionListener<SamlAuthenticateResponse> listener) {
        this.client.execute((ActionType)SamlAuthenticateAction.INSTANCE, (ActionRequest)request, listener);
    }

    public SamlPrepareAuthenticationRequestBuilder prepareSamlPrepareAuthentication() {
        return new SamlPrepareAuthenticationRequestBuilder(this.client);
    }

    public CreateTokenRequestBuilder prepareRefreshToken(String refreshToken) {
        return new CreateTokenRequestBuilder(this.client, RefreshTokenAction.INSTANCE).setRefreshToken(refreshToken).setGrantType("refresh_token");
    }

    public void refreshToken(CreateTokenRequest request, ActionListener<CreateTokenResponse> listener) {
        this.client.execute((ActionType)RefreshTokenAction.INSTANCE, (ActionRequest)request, listener);
    }
}

