/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api.systemhooks;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.HookManager;
import org.gitlab4j.api.systemhooks.GroupMemberSystemHookEvent;
import org.gitlab4j.api.systemhooks.GroupSystemHookEvent;
import org.gitlab4j.api.systemhooks.KeySystemHookEvent;
import org.gitlab4j.api.systemhooks.MergeRequestSystemHookEvent;
import org.gitlab4j.api.systemhooks.ProjectSystemHookEvent;
import org.gitlab4j.api.systemhooks.PushSystemHookEvent;
import org.gitlab4j.api.systemhooks.RepositorySystemHookEvent;
import org.gitlab4j.api.systemhooks.SystemHookEvent;
import org.gitlab4j.api.systemhooks.SystemHookListener;
import org.gitlab4j.api.systemhooks.TagPushSystemHookEvent;
import org.gitlab4j.api.systemhooks.TeamMemberSystemHookEvent;
import org.gitlab4j.api.systemhooks.UserSystemHookEvent;
import org.gitlab4j.api.utils.HttpRequestUtils;
import org.gitlab4j.api.utils.JacksonJson;

public class SystemHookManager
implements HookManager {
    private static final Logger LOGGER = Logger.getLogger(SystemHookManager.class.getName());
    public static final String SYSTEM_HOOK_EVENT = "System Hook";
    private final JacksonJson jacksonJson = new JacksonJson();
    private final List<SystemHookListener> systemHookListeners = new CopyOnWriteArrayList<SystemHookListener>();
    private String secretToken;

    public SystemHookManager() {
    }

    public SystemHookManager(String secretToken) {
        this.secretToken = secretToken;
    }

    @Override
    public String getSecretToken() {
        return this.secretToken;
    }

    @Override
    public void setSecretToken(String secretToken) {
        this.secretToken = secretToken;
    }

    @Override
    public void handleEvent(HttpServletRequest request) throws GitLabApiException {
        this.handleRequest(request);
    }

    public SystemHookEvent handleRequest(HttpServletRequest request) throws GitLabApiException {
        SystemHookEvent event;
        JsonNode tree;
        String eventName = request.getHeader("X-Gitlab-Event");
        if (eventName == null || eventName.trim().isEmpty()) {
            String message = "X-Gitlab-Event header is missing!";
            LOGGER.warning(message);
            return null;
        }
        if (!this.isValidSecretToken(request)) {
            String message = "X-Gitlab-Token mismatch!";
            LOGGER.warning(message);
            throw new GitLabApiException(message);
        }
        LOGGER.info("handleEvent: X-Gitlab-Event=" + eventName);
        if (!SYSTEM_HOOK_EVENT.equals(eventName)) {
            String message = "Unsupported X-Gitlab-Event, event Name=" + eventName;
            LOGGER.warning(message);
            throw new GitLabApiException(message);
        }
        try {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(HttpRequestUtils.getShortRequestDump(SYSTEM_HOOK_EVENT, true, request));
                String postData = HttpRequestUtils.getPostDataAsString(request);
                LOGGER.fine("Raw POST data:\n" + postData);
                tree = this.jacksonJson.readTree(postData);
            } else {
                InputStreamReader reader = new InputStreamReader((InputStream)request.getInputStream());
                tree = this.jacksonJson.readTree(reader);
            }
        }
        catch (Exception e) {
            LOGGER.warning("Error reading JSON data, exception=" + e.getClass().getSimpleName() + ", error=" + e.getMessage());
            throw new GitLabApiException(e);
        }
        if (!tree.has("event_name") && tree.has("object_kind")) {
            String objectKind = tree.get("object_kind").asText();
            if ("merge_request".equals(objectKind)) {
                ObjectNode node = (ObjectNode)tree;
                node.put("event_name", "merge_request");
            } else {
                String message = "Unsupported object_kind for system hook event, object_kind=" + objectKind;
                LOGGER.warning(message);
                throw new GitLabApiException(message);
            }
        }
        try {
            StringBuffer requestUrl;
            event = this.jacksonJson.unmarshal(SystemHookEvent.class, tree);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(event.getEventName() + "\n" + this.jacksonJson.marshal(event) + "\n");
            }
            event.setRequestUrl((requestUrl = request.getRequestURL()) != null ? requestUrl.toString() : null);
            event.setRequestQueryString(request.getQueryString());
            String secretToken = request.getHeader("X-Gitlab-Token");
            event.setRequestSecretToken(secretToken);
        }
        catch (Exception e) {
            LOGGER.warning(String.format("Error processing JSON data, exception=%s, error=%s", e.getClass().getSimpleName(), e.getMessage()));
            throw new GitLabApiException(e);
        }
        try {
            this.fireEvent(event);
            return event;
        }
        catch (Exception e) {
            LOGGER.warning(String.format("Error processing event, exception=%s, error=%s", e.getClass().getSimpleName(), e.getMessage()));
            throw new GitLabApiException(e);
        }
    }

    public void handleEvent(SystemHookEvent event) throws GitLabApiException {
        if (event != null) {
            LOGGER.info("handleEvent:" + event.getClass().getSimpleName() + ", eventName=" + event.getEventName());
            this.fireEvent(event);
        } else {
            LOGGER.warning("handleEvent: provided event cannot be null!");
        }
    }

    public void addListener(SystemHookListener listener) {
        if (!this.systemHookListeners.contains(listener)) {
            this.systemHookListeners.add(listener);
        }
    }

    public void removeListener(SystemHookListener listener) {
        this.systemHookListeners.remove(listener);
    }

    public void fireEvent(SystemHookEvent event) throws GitLabApiException {
        if (event instanceof ProjectSystemHookEvent) {
            this.fireProjectEvent((ProjectSystemHookEvent)event);
        } else if (event instanceof TeamMemberSystemHookEvent) {
            this.fireTeamMemberEvent((TeamMemberSystemHookEvent)event);
        } else if (event instanceof UserSystemHookEvent) {
            this.fireUserEvent((UserSystemHookEvent)event);
        } else if (event instanceof KeySystemHookEvent) {
            this.fireKeyEvent((KeySystemHookEvent)event);
        } else if (event instanceof GroupSystemHookEvent) {
            this.fireGroupEvent((GroupSystemHookEvent)event);
        } else if (event instanceof GroupMemberSystemHookEvent) {
            this.fireGroupMemberEvent((GroupMemberSystemHookEvent)event);
        } else if (event instanceof PushSystemHookEvent) {
            this.firePushEvent((PushSystemHookEvent)event);
        } else if (event instanceof TagPushSystemHookEvent) {
            this.fireTagPushEvent((TagPushSystemHookEvent)event);
        } else if (event instanceof RepositorySystemHookEvent) {
            this.fireRepositoryEvent((RepositorySystemHookEvent)event);
        } else if (event instanceof MergeRequestSystemHookEvent) {
            this.fireMergeRequestEvent((MergeRequestSystemHookEvent)event);
        } else {
            String message = "Unsupported event, event_named=" + event.getEventName();
            LOGGER.warning(message);
            throw new GitLabApiException(message);
        }
    }

    protected void fireProjectEvent(ProjectSystemHookEvent event) {
        for (SystemHookListener listener : this.systemHookListeners) {
            listener.onProjectEvent(event);
        }
    }

    protected void fireTeamMemberEvent(TeamMemberSystemHookEvent event) {
        for (SystemHookListener listener : this.systemHookListeners) {
            listener.onTeamMemberEvent(event);
        }
    }

    protected void fireUserEvent(UserSystemHookEvent event) {
        for (SystemHookListener listener : this.systemHookListeners) {
            listener.onUserEvent(event);
        }
    }

    protected void fireKeyEvent(KeySystemHookEvent event) {
        for (SystemHookListener listener : this.systemHookListeners) {
            listener.onKeyEvent(event);
        }
    }

    protected void fireGroupEvent(GroupSystemHookEvent event) {
        for (SystemHookListener listener : this.systemHookListeners) {
            listener.onGroupEvent(event);
        }
    }

    protected void fireGroupMemberEvent(GroupMemberSystemHookEvent event) {
        for (SystemHookListener listener : this.systemHookListeners) {
            listener.onGroupMemberEvent(event);
        }
    }

    protected void firePushEvent(PushSystemHookEvent event) {
        for (SystemHookListener listener : this.systemHookListeners) {
            listener.onPushEvent(event);
        }
    }

    protected void fireTagPushEvent(TagPushSystemHookEvent event) {
        for (SystemHookListener listener : this.systemHookListeners) {
            listener.onTagPushEvent(event);
        }
    }

    protected void fireRepositoryEvent(RepositorySystemHookEvent event) {
        for (SystemHookListener listener : this.systemHookListeners) {
            listener.onRepositoryEvent(event);
        }
    }

    protected void fireMergeRequestEvent(MergeRequestSystemHookEvent event) {
        for (SystemHookListener listener : this.systemHookListeners) {
            listener.onMergeRequestEvent(event);
        }
    }
}

