/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.essentials.collections;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.greenrobot.essentials.collections.AbstractMultimap;

public class MultimapSet<K, V>
extends AbstractMultimap<K, V, Set<V>> {
    private final SetType setType;

    public static <K, V> MultimapSet<K, V> create() {
        return MultimapSet.create(SetType.REGULAR);
    }

    public static <K, V> MultimapSet<K, V> create(SetType setType) {
        return new MultimapSet(new HashMap(), setType);
    }

    protected MultimapSet(Map<K, Set<V>> map, SetType setType) {
        super(map);
        this.setType = setType;
    }

    @Override
    protected Set<V> createNewCollection() {
        switch (this.setType) {
            case REGULAR: {
                return new HashSet();
            }
            case THREAD_SAFE: {
                return new CopyOnWriteArraySet();
            }
        }
        throw new IllegalStateException("Unknown set type: " + (Object)((Object)this.setType));
    }

    public static enum SetType {
        REGULAR,
        THREAD_SAFE;

    }
}

