/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.greendao.gradle;

import groovy.lang.Closure;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.LogLevel;
import org.greenrobot.greendao.codemodifier.Greendao3Generator;
import org.greenrobot.greendao.codemodifier.SchemaOptions;
import org.greenrobot.greendao.gradle.DetectEntityCandidatesTask;
import org.greenrobot.greendao.gradle.Greendao3GradlePlugin;
import org.greenrobot.greendao.gradle.GreendaoOptions;
import org.greenrobot.greendao.gradle.SchemaOptionsExtension;
import org.greenrobot.greendao.gradle.SourceProvider;
import org.greenrobot.greendao.gradle.SourceProviderKt;
import org.greenrobot.greendao.gradle.UtilKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J.\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J8\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J\b\u0010\u001b\u001a\u00020\u0005H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lorg/greenrobot/greendao/gradle/Greendao3GradlePlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "name", "", "getName", "()Ljava/lang/String;", "packageName", "getPackageName", "apply", "", "project", "collectSchemaOptions", "", "Lorg/greenrobot/greendao/codemodifier/SchemaOptions;", "daoPackage", "genSrcDir", "Ljava/io/File;", "options", "Lorg/greenrobot/greendao/gradle/GreendaoOptions;", "createGreendaoTask", "Lorg/gradle/api/Task;", "candidatesFile", "targetGenDir", "encoding", "version", "getVersion", "greendao-gradle-plugin_main"})
public final class Greendao3GradlePlugin
implements Plugin<Project> {
    @NotNull
    private final String name = "greendao";
    @NotNull
    private final String packageName = "org/greenrobot/greendao";

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getPackageName() {
        return this.packageName;
    }

    public void apply(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        project.getLogger().debug(this.name + " plugin starting...");
        project.getExtensions().create(this.name, GreendaoOptions.class, new Object[]{project});
        project.afterEvaluate((Action)new Action<Project>(this, project){
            final /* synthetic */ Greendao3GradlePlugin this$0;
            final /* synthetic */ Project $project;

            public final void execute(Project it) {
                File file;
                boolean writeToBuildFolder;
                String version = Greendao3GradlePlugin.access$getVersion(this.this$0);
                this.$project.getLogger().debug(this.this$0.getName() + " plugin " + version + " preparing tasks...");
                File candidatesFile = this.$project.file((Object)("build/cache/" + this.this$0.getName() + "-candidates.list"));
                SourceProvider sourceProvider = SourceProviderKt.getSourceProvider(this.$project);
                String string = sourceProvider.getEncoding();
                if (string == null) {
                    string = "UTF-8";
                }
                String encoding = string;
                Map taskArgs = MapsKt.mapOf((Pair)TuplesKt.to((Object)"type", DetectEntityCandidatesTask.class));
                Task task = this.$project.task(taskArgs, this.this$0.getName() + "Prepare");
                if (task == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.greenrobot.greendao.gradle.DetectEntityCandidatesTask");
                }
                DetectEntityCandidatesTask prepareTask = (DetectEntityCandidatesTask)task;
                prepareTask.setSourceFiles((FileCollection)sourceProvider.sourceTree().matching((Closure)UtilKt.Closure(apply.1.INSTANCE)));
                prepareTask.setCandidatesListFile(candidatesFile);
                prepareTask.setVersion(version);
                prepareTask.setCharset(encoding);
                prepareTask.setGroup(this.this$0.getName());
                prepareTask.setDescription("Finds entity source files for " + this.this$0.getName());
                GreendaoOptions options = (GreendaoOptions)this.$project.getExtensions().getByType(GreendaoOptions.class);
                boolean bl = writeToBuildFolder = options.getTargetGenDir() == null;
                if (writeToBuildFolder) {
                    file = new File(this.$project.getBuildDir(), "generated/source/" + this.this$0.getName());
                } else {
                    file = options.getTargetGenDir();
                    if (file == null) {
                        Intrinsics.throwNpe();
                    }
                }
                File targetGenDir = file;
                File file2 = candidatesFile;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"candidatesFile");
                GreendaoOptions greendaoOptions = options;
                Intrinsics.checkExpressionValueIsNotNull((Object)greendaoOptions, (String)"options");
                Task greendaoTask = Greendao3GradlePlugin.access$createGreendaoTask(this.this$0, this.$project, file2, greendaoOptions, targetGenDir, encoding, version);
                greendaoTask.dependsOn(new Object[]{prepareTask});
                sourceProvider.addGeneratorTask(greendaoTask, targetGenDir, writeToBuildFolder);
            }
            {
                this.this$0 = greendao3GradlePlugin;
                this.$project = project;
            }
        });
    }

    private final Task createGreendaoTask(Project project, File candidatesFile, GreendaoOptions options, File targetGenDir, String encoding, String version) {
        Map<String, SchemaOptions> schemaOptions;
        Map<String, SchemaOptions> $receiver$iv;
        Task task;
        Task $receiver = task = project.task(this.name);
        $receiver.getLogging().captureStandardOutput(LogLevel.INFO);
        $receiver.getInputs().file((Object)candidatesFile);
        $receiver.getInputs().property("plugin-version", (Object)version);
        $receiver.getInputs().property("source-encoding", (Object)encoding);
        Map<String, SchemaOptions> map = $receiver$iv = (schemaOptions = this.collectSchemaOptions(options.getDaoPackage(), targetGenDir, options));
        Iterator<Map.Entry<String, SchemaOptions>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, SchemaOptions> element$iv;
            Map.Entry<String, SchemaOptions> e = element$iv = iterator.next();
            $receiver.getInputs().property("schema-" + e.getKey(), (Object)e.getValue().toString());
        }
        ConfigurableFileTree outputFileTree2 = project.fileTree((Object)targetGenDir, (Closure)UtilKt.Closure(createGreendaoTask.generateTask.1.outputFileTree.1.INSTANCE));
        $receiver.getOutputs().files(new Object[]{outputFileTree2});
        if (options.getGenerateTests()) {
            $receiver.getOutputs().dir((Object)options.getTargetGenDirTests());
        }
        $receiver.doLast((Action)new Action<Task>(schemaOptions, this, candidatesFile, version, encoding, options, targetGenDir, project){
            final /* synthetic */ Map $schemaOptions;
            final /* synthetic */ Greendao3GradlePlugin this$0;
            final /* synthetic */ File $candidatesFile$inlined;
            final /* synthetic */ String $version$inlined;
            final /* synthetic */ String $encoding$inlined;
            final /* synthetic */ GreendaoOptions $options$inlined;
            final /* synthetic */ File $targetGenDir$inlined;
            final /* synthetic */ Project $project$inlined;
            {
                this.$schemaOptions = map;
                this.this$0 = greendao3GradlePlugin;
                this.$candidatesFile$inlined = file;
                this.$version$inlined = string;
                this.$encoding$inlined = string2;
                this.$options$inlined = greendaoOptions;
                this.$targetGenDir$inlined = file2;
                this.$project$inlined = project;
            }

            public final void execute(Task it) {
                boolean bl = this.$candidatesFile$inlined.exists();
                if (!bl) {
                    String string = "Candidates file does not exist. Can't continue";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                Iterable candidatesFiles2 = SequencesKt.asIterable((Sequence)SequencesKt.map((Sequence)SequencesKt.drop((Sequence)CollectionsKt.asSequence((Iterable)FilesKt.readLines$default((File)this.$candidatesFile$inlined, null, (int)1, null)), (int)1), (Function1)createGreendaoTask.generateTask.1.candidatesFiles.1.INSTANCE));
                new Greendao3Generator(this.$options$inlined.getFormatting$greendao_gradle_plugin_main().getData$greendao_gradle_plugin_main(), this.$options$inlined.getSkipTestGeneration(), this.$encoding$inlined).run(candidatesFiles2, this.$schemaOptions);
            }
        });
        Task generateTask2 = task;
        generateTask2.setGroup(this.name);
        generateTask2.setDescription("Generates source files for " + this.name);
        Task task2 = generateTask2;
        Intrinsics.checkExpressionValueIsNotNull((Object)task2, (String)"generateTask");
        return task2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getVersion() {
        String string;
        InputStream stream;
        Properties properties = new Properties();
        InputStream inputStream = stream = this.getClass().getResourceAsStream("/" + this.packageName + "/gradle/version.properties");
        if (inputStream != null) {
            Closeable closeable = inputStream;
            boolean bl = false;
            try {
                InputStream it = (InputStream)closeable;
                try {
                    properties.load(it);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Exception exception) {
                bl = true;
                try {
                    Closeable closeable2 = closeable;
                    if (closeable2 != null) {
                        closeable2.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw (Throwable)exception;
            }
            finally {
                if (!bl) {
                    Closeable closeable3 = closeable;
                    if (closeable3 != null) {
                        closeable3.close();
                    }
                }
            }
        }
        if ((string = properties.getProperty("version")) == null) {
            string = "Unknown (bad build)";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, SchemaOptions> collectSchemaOptions(String daoPackage, File genSrcDir, GreendaoOptions options) {
        void $receiver$iv$iv;
        Object $receiver$iv;
        SchemaOptions defaultOptions = new SchemaOptions("default", options.getSchemaVersion(), daoPackage, genSrcDir, options.getGenerateTests() ? options.getTargetGenDirTests() : null);
        Map schemaOptions = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"default", (Object)defaultOptions)});
        Object object = $receiver$iv = options.getSchemas$greendao_gradle_plugin_main().getSchemasMap();
        Collection destination$iv$iv = new ArrayList($receiver$iv.size());
        Map map = $receiver$iv$iv;
        Pair pair = map.entrySet().iterator();
        while (pair.hasNext()) {
            File file;
            void schemaExt;
            void name;
            SchemaOptions schemaOptions2;
            void e;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = pair.next();
            Collection collection = destination$iv$iv;
            String string = e;
            void var14_14 = string;
            String string2 = (String)var14_14.getKey();
            var14_14 = string;
            SchemaOptionsExtension schemaOptionsExtension = (SchemaOptionsExtension)var14_14.getValue();
            string = null;
            SchemaOptions schemaOptions3 = schemaOptions2;
            SchemaOptions schemaOptions4 = schemaOptions2;
            void v3 = name;
            Integer n = schemaExt.getVersion();
            int n2 = n != null ? ((Number)n).intValue() : defaultOptions.getVersion();
            String string3 = schemaExt.getDaoPackage();
            if (string3 == null) {
                String string4 = defaultOptions.getDaoPackage();
                if (string4 != null) {
                    string = string4;
                    int n3 = n2;
                    void var18_18 = v3;
                    SchemaOptions schemaOptions5 = schemaOptions3;
                    SchemaOptions schemaOptions6 = schemaOptions4;
                    String it = string;
                    String string5 = it + "." + (String)name;
                    schemaOptions4 = schemaOptions6;
                    schemaOptions3 = schemaOptions5;
                    v3 = var18_18;
                    n2 = n3;
                    string3 = string5;
                } else {
                    string3 = null;
                }
            }
            File file2 = defaultOptions.getOutputDir();
            if (options.getGenerateTests()) {
                file = schemaExt.getTargetGenDirTests();
                if (file == null) {
                    file = defaultOptions.getTestsOutputDir();
                }
            } else {
                file = null;
            }
            schemaOptions3((String)v3, n2, string3, file2, file);
            SchemaOptions schemaOptions7 = schemaOptions4;
            collection.add(schemaOptions7);
        }
        $receiver$iv = (List)destination$iv$iv;
        object = $receiver$iv.iterator();
        while (object.hasNext()) {
            Object element$iv = object.next();
            map = schemaOptions;
            SchemaOptions it = (SchemaOptions)element$iv;
            pair = TuplesKt.to((Object)it.getName(), (Object)it);
            map.put(pair.getFirst(), pair.getSecond());
        }
        return schemaOptions;
    }

    @NotNull
    public static final /* synthetic */ String access$getVersion(Greendao3GradlePlugin $this) {
        return $this.getVersion();
    }

    @NotNull
    public static final /* synthetic */ Task access$createGreendaoTask(Greendao3GradlePlugin $this, @NotNull Project project, @NotNull File candidatesFile, @NotNull GreendaoOptions options, @NotNull File targetGenDir, @NotNull String encoding, @NotNull String version) {
        return $this.createGreendaoTask(project, candidatesFile, options, targetGenDir, encoding, version);
    }
}

