/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.core.commands.operations;

import java.util.ArrayList;
import java.util.List;
import org.greenrobot.eclipse.core.commands.ExecutionException;
import org.greenrobot.eclipse.core.commands.operations.IUndoContext;
import org.greenrobot.eclipse.core.commands.operations.IUndoableOperation;
import org.greenrobot.eclipse.core.runtime.Assert;
import org.greenrobot.eclipse.core.runtime.IAdaptable;
import org.greenrobot.eclipse.core.runtime.IProgressMonitor;
import org.greenrobot.eclipse.core.runtime.IStatus;

public abstract class AbstractOperation
implements IUndoableOperation {
    List<IUndoContext> contexts = new ArrayList<IUndoContext>();
    private String label = "";

    public AbstractOperation(String label) {
        Assert.isNotNull(label);
        this.label = label;
    }

    @Override
    public void addContext(IUndoContext context) {
        if (!this.contexts.contains(context)) {
            this.contexts.add(context);
        }
    }

    @Override
    public boolean canExecute() {
        return true;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void dispose() {
    }

    @Override
    public abstract IStatus execute(IProgressMonitor var1, IAdaptable var2) throws ExecutionException;

    @Override
    public final IUndoContext[] getContexts() {
        return this.contexts.toArray(new IUndoContext[this.contexts.size()]);
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String name) {
        this.label = name;
    }

    @Override
    public final boolean hasContext(IUndoContext context) {
        Assert.isNotNull(context);
        for (IUndoContext otherContext : this.contexts) {
            if (!context.matches(otherContext) && !otherContext.matches(context)) continue;
            return true;
        }
        return false;
    }

    @Override
    public abstract IStatus redo(IProgressMonitor var1, IAdaptable var2) throws ExecutionException;

    @Override
    public void removeContext(IUndoContext context) {
        this.contexts.remove(context);
    }

    @Override
    public abstract IStatus undo(IProgressMonitor var1, IAdaptable var2) throws ExecutionException;

    public String toString() {
        StringBuilder stringBuffer = new StringBuilder();
        stringBuffer.append(this.getLabel());
        stringBuffer.append("(");
        IUndoContext[] contexts = this.getContexts();
        int i = 0;
        while (i < contexts.length) {
            stringBuffer.append(contexts[i].toString());
            if (i != contexts.length - 1) {
                stringBuffer.append(',');
            }
            ++i;
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

