/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.core.expressions;

import org.greenrobot.eclipse.core.expressions.ElementHandler;
import org.greenrobot.eclipse.core.expressions.Expression;
import org.greenrobot.eclipse.core.internal.expressions.CompositeExpression;
import org.greenrobot.eclipse.core.internal.expressions.ExpressionMessages;
import org.greenrobot.eclipse.core.internal.expressions.ExpressionPlugin;
import org.greenrobot.eclipse.core.internal.expressions.Messages;
import org.greenrobot.eclipse.core.runtime.Assert;
import org.greenrobot.eclipse.core.runtime.CoreException;
import org.greenrobot.eclipse.core.runtime.IConfigurationElement;
import org.greenrobot.eclipse.core.runtime.IExtension;
import org.greenrobot.eclipse.core.runtime.Status;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class ExpressionConverter {
    private ElementHandler[] fHandlers;
    private static final ExpressionConverter INSTANCE = new ExpressionConverter(new ElementHandler[]{ElementHandler.getDefault()});

    public static ExpressionConverter getDefault() {
        return INSTANCE;
    }

    public ExpressionConverter(ElementHandler[] handlers) {
        Assert.isNotNull(handlers);
        this.fHandlers = handlers;
    }

    public Expression perform(IConfigurationElement root) throws CoreException {
        ElementHandler[] elementHandlerArray = this.fHandlers;
        int n = this.fHandlers.length;
        int n2 = 0;
        while (n2 < n) {
            ElementHandler handler = elementHandlerArray[n2];
            Expression result = handler.create(this, root);
            if (result != null) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public Expression perform(Element root) throws CoreException {
        ElementHandler[] elementHandlerArray = this.fHandlers;
        int n = this.fHandlers.length;
        int n2 = 0;
        while (n2 < n) {
            ElementHandler handler = elementHandlerArray[n2];
            Expression result = handler.create(this, root);
            if (result != null) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    void processChildren(IConfigurationElement element, CompositeExpression result) throws CoreException {
        IConfigurationElement[] children = element.getChildren();
        if (children != null) {
            IConfigurationElement[] iConfigurationElementArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configElement = iConfigurationElementArray[n2];
                Expression child = this.perform(configElement);
                if (child == null) {
                    throw new CoreException(new Status(4, ExpressionPlugin.getPluginId(), 4, Messages.format(ExpressionMessages.Expression_unknown_element, this.getDebugPath(configElement)), null));
                }
                result.add(child);
                ++n2;
            }
        }
    }

    private String getDebugPath(IConfigurationElement configurationElement) {
        StringBuilder buf = new StringBuilder();
        buf.append(configurationElement.getName());
        Object parent = configurationElement.getParent();
        while (parent != null) {
            Object parent2;
            if (parent instanceof IConfigurationElement) {
                buf.append(" > ");
                parent2 = (IConfigurationElement)parent;
                buf.append(parent2.getName());
                String id = parent2.getAttribute("id");
                if (id != null) {
                    buf.append(" (id=").append(id).append(')');
                }
                parent = parent2.getParent();
                continue;
            }
            if (parent instanceof IExtension) {
                parent2 = (IExtension)parent;
                buf.append(" : ");
                buf.append(parent2.getExtensionPointUniqueIdentifier());
                buf.append(" @ ");
                buf.append(parent2.getContributor().getName());
                parent = null;
                continue;
            }
            parent = null;
        }
        return buf.toString();
    }

    void processChildren(Element element, CompositeExpression result) throws CoreException {
        Node child = element.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                Expression exp = this.perform((Element)child);
                if (exp == null) {
                    throw new CoreException(new Status(4, ExpressionPlugin.getPluginId(), 4, Messages.format(ExpressionMessages.Expression_unknown_element, child.getNodeName()), null));
                }
                result.add(exp);
            }
            child = child.getNextSibling();
        }
    }
}

