/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.core.internal.content;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.ref.SoftReference;
import org.greenrobot.eclipse.core.internal.content.ContentType;
import org.greenrobot.eclipse.core.internal.content.ContentTypeCatalog;
import org.greenrobot.eclipse.core.internal.content.ContentTypeManager;
import org.greenrobot.eclipse.core.runtime.CoreException;
import org.greenrobot.eclipse.core.runtime.QualifiedName;
import org.greenrobot.eclipse.core.runtime.content.IContentDescription;
import org.greenrobot.eclipse.core.runtime.content.IContentType;
import org.greenrobot.eclipse.core.runtime.content.IContentTypeSettings;
import org.greenrobot.eclipse.core.runtime.preferences.IScopeContext;

public class ContentTypeHandler
implements IContentType {
    private int generation;
    String id;
    private SoftReference<ContentType> targetRef;

    ContentTypeHandler(ContentType target, int generation) {
        this.id = target.getId();
        this.targetRef = new SoftReference<ContentType>(target);
        this.generation = generation;
    }

    @Override
    public void addFileSpec(String fileSpec, int type) throws CoreException {
        ContentType target = this.getTarget();
        if (target != null) {
            target.addFileSpec(fileSpec, type);
        }
    }

    public boolean equals(Object another) {
        if (another instanceof ContentType) {
            return this.id.equals(((ContentType)another).id);
        }
        if (another instanceof ContentTypeHandler) {
            return this.id.equals(((ContentTypeHandler)another).id);
        }
        return false;
    }

    @Override
    public IContentType getBaseType() {
        ContentType target = this.getTarget();
        if (target == null) {
            return null;
        }
        ContentType baseType = (ContentType)target.getBaseType();
        return baseType != null ? new ContentTypeHandler(baseType, baseType.getCatalog().getGeneration()) : null;
    }

    @Override
    public String getDefaultCharset() {
        ContentType target = this.getTarget();
        return target != null ? target.getDefaultCharset() : null;
    }

    @Override
    public IContentDescription getDefaultDescription() {
        ContentType target = this.getTarget();
        return target != null ? target.getDefaultDescription() : new DummyContentDescription();
    }

    @Override
    public IContentDescription getDescriptionFor(InputStream contents, QualifiedName[] options) throws IOException {
        ContentType target = this.getTarget();
        return target != null ? target.getDescriptionFor(contents, options) : null;
    }

    @Override
    public IContentDescription getDescriptionFor(Reader contents, QualifiedName[] options) throws IOException {
        ContentType target = this.getTarget();
        return target != null ? target.getDescriptionFor(contents, options) : null;
    }

    @Override
    public String[] getFileSpecs(int type) {
        ContentType target = this.getTarget();
        return target != null ? target.getFileSpecs(type) : new String[]{};
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        ContentType target = this.getTarget();
        return target != null ? target.getName() : this.id;
    }

    @Override
    public IContentTypeSettings getSettings(IScopeContext context) throws CoreException {
        ContentType target = this.getTarget();
        if (target == null) {
            return null;
        }
        IContentTypeSettings settings = target.getSettings(context);
        return settings == target ? this : settings;
    }

    public ContentType getTarget() {
        ContentType target = this.targetRef.get();
        ContentTypeCatalog catalog = ContentTypeManager.getInstance().getCatalog();
        if (target == null || catalog.getGeneration() != this.generation) {
            target = catalog.getContentType(this.id);
            this.targetRef = new SoftReference<ContentType>(target);
            this.generation = catalog.getGeneration();
        }
        return target == null ? null : target.getAliasTarget(true);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public boolean isAssociatedWith(String fileName) {
        ContentType target = this.getTarget();
        return target != null ? target.isAssociatedWith(fileName) : false;
    }

    @Override
    public boolean isAssociatedWith(String fileName, IScopeContext context) {
        ContentType target = this.getTarget();
        return target != null ? target.isAssociatedWith(fileName, context) : false;
    }

    @Override
    public boolean isKindOf(IContentType another) {
        ContentType target;
        if (another instanceof ContentTypeHandler) {
            another = ((ContentTypeHandler)another).getTarget();
        }
        return (target = this.getTarget()) != null ? target.isKindOf(another) : false;
    }

    @Override
    public void removeFileSpec(String fileSpec, int type) throws CoreException {
        ContentType target = this.getTarget();
        if (target != null) {
            target.removeFileSpec(fileSpec, type);
        }
    }

    @Override
    public void setDefaultCharset(String userCharset) throws CoreException {
        ContentType target = this.getTarget();
        if (target != null) {
            target.setDefaultCharset(userCharset);
        }
    }

    public String toString() {
        return this.id;
    }

    @Override
    public boolean isUserDefined() {
        ContentType target = this.getTarget();
        if (target != null) {
            return target.isUserDefined();
        }
        return false;
    }

    private class DummyContentDescription
    implements IContentDescription {
        private DummyContentDescription() {
        }

        @Override
        public String getCharset() {
            return null;
        }

        @Override
        public IContentType getContentType() {
            return ContentTypeHandler.this;
        }

        @Override
        public Object getProperty(QualifiedName key) {
            return null;
        }

        @Override
        public boolean isRequested(QualifiedName key) {
            return false;
        }

        @Override
        public void setProperty(QualifiedName key, Object value) {
        }
    }
}

