/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.core.internal.expressions;

import java.util.HashMap;
import java.util.Map;
import org.greenrobot.eclipse.core.expressions.Expression;
import org.greenrobot.eclipse.core.expressions.ExpressionConverter;
import org.greenrobot.eclipse.core.internal.expressions.ExpressionMessages;
import org.greenrobot.eclipse.core.internal.expressions.ExpressionStatus;
import org.greenrobot.eclipse.core.internal.expressions.Messages;
import org.greenrobot.eclipse.core.runtime.CoreException;
import org.greenrobot.eclipse.core.runtime.IConfigurationElement;
import org.greenrobot.eclipse.core.runtime.IExtensionDelta;
import org.greenrobot.eclipse.core.runtime.IExtensionRegistry;
import org.greenrobot.eclipse.core.runtime.IRegistryChangeEvent;
import org.greenrobot.eclipse.core.runtime.IRegistryChangeListener;
import org.greenrobot.eclipse.core.runtime.InvalidRegistryObjectException;
import org.greenrobot.eclipse.core.runtime.Platform;

public class DefinitionRegistry
implements IRegistryChangeListener {
    private Map<String, Expression> cache = null;

    private Map<String, Expression> getCache() {
        if (this.cache == null) {
            this.cache = new HashMap<String, Expression>();
        }
        return this.cache;
    }

    public DefinitionRegistry() {
        Platform.getExtensionRegistry().addRegistryChangeListener(this, "org.greenrobot.eclipse.core.expressions");
    }

    public Expression getExpression(String id) throws CoreException {
        Expression cachedExpression = this.getCache().get(id);
        if (cachedExpression != null) {
            return cachedExpression;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] ces = registry.getConfigurationElementsFor("org.greenrobot.eclipse.core.expressions", "definitions");
        Expression foundExpression = null;
        IConfigurationElement[] iConfigurationElementArray = ces;
        int n = ces.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            String cid = ce.getAttribute("id");
            if (cid != null && cid.equals(id)) {
                try {
                    foundExpression = this.getExpression(id, ce);
                    break;
                }
                catch (InvalidRegistryObjectException invalidRegistryObjectException) {
                    throw new CoreException(new ExpressionStatus(52, Messages.format(ExpressionMessages.Missing_Expression, id)));
                }
            }
            ++n2;
        }
        if (foundExpression == null) {
            throw new CoreException(new ExpressionStatus(52, Messages.format(ExpressionMessages.Missing_Expression, id)));
        }
        return foundExpression;
    }

    private Expression getExpression(String id, IConfigurationElement element) throws InvalidRegistryObjectException, CoreException {
        Expression expr = ExpressionConverter.getDefault().perform(element.getChildren()[0]);
        if (expr != null) {
            this.getCache().put(id, expr);
        }
        return expr;
    }

    @Override
    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] extensionDeltas;
        IExtensionDelta[] iExtensionDeltaArray = extensionDeltas = event.getExtensionDeltas("org.greenrobot.eclipse.core.expressions", "definitions");
        int n = extensionDeltas.length;
        int n2 = 0;
        while (n2 < n) {
            IExtensionDelta extensionDelta = iExtensionDeltaArray[n2];
            if (extensionDelta.getKind() == 2) {
                IConfigurationElement[] ces;
                IConfigurationElement[] iConfigurationElementArray = ces = extensionDelta.getExtension().getConfigurationElements();
                int n3 = ces.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement ce = iConfigurationElementArray[n4];
                    String id = ce.getAttribute("id");
                    if (id != null) {
                        this.getCache().remove(id);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }
}

