/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.core.internal.registry.osgi;

import org.greenrobot.eclipse.core.internal.registry.osgi.OSGIUtils;
import org.greenrobot.eclipse.core.internal.registry.osgi.RegistryCommandProvider;
import org.greenrobot.eclipse.osgi.service.environment.EnvironmentInfo;
import org.greenrobot.eclipse.osgi.service.resolver.PlatformAdmin;
import org.greenrobot.osgi.framework.Bundle;
import org.greenrobot.osgi.framework.BundleContext;
import org.greenrobot.osgi.framework.ServiceReference;
import org.greenrobot.osgi.framework.ServiceRegistration;

public class EquinoxUtils {
    public static String[] getCommandLine(BundleContext context, ServiceReference<?> ref) {
        if (ref == null) {
            return null;
        }
        try {
            EnvironmentInfo environmentInfo = (EnvironmentInfo)context.getService(ref);
            String[] stringArray = environmentInfo == null ? null : environmentInfo.getNonFrameworkArgs();
            return stringArray;
        }
        finally {
            context.ungetService(ref);
        }
    }

    public static long getContainerTimestamp(BundleContext context, ServiceReference<?> ref) {
        if (ref == null) {
            return -1L;
        }
        try {
            PlatformAdmin admin = (PlatformAdmin)context.getService(ref);
            long l = admin == null ? -1L : admin.getState(false).getTimeStamp();
            return l;
        }
        finally {
            context.ungetService(ref);
        }
    }

    public static ServiceRegistration<?> registerCommandProvider(BundleContext context) {
        try {
            return context.registerService("org.greenrobot.eclipse.osgi.framework.console.CommandProvider", (Object)new RegistryCommandProvider(), null);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return null;
        }
    }

    public static boolean isActive(String bundleId) {
        Bundle bundle;
        block3: {
            try {
                bundle = OSGIUtils.getDefault().getBundle(bundleId);
                if (bundle != null) break block3;
                return false;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                return true;
            }
        }
        return bundle.getState() == 32;
    }
}

