/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.core.resources.mapping;

import java.util.ArrayList;
import org.greenrobot.eclipse.core.internal.resources.mapping.ModelProviderManager;
import org.greenrobot.eclipse.core.resources.IMarker;
import org.greenrobot.eclipse.core.resources.IProject;
import org.greenrobot.eclipse.core.resources.IResourceVisitor;
import org.greenrobot.eclipse.core.resources.mapping.ModelProvider;
import org.greenrobot.eclipse.core.resources.mapping.ResourceMappingContext;
import org.greenrobot.eclipse.core.resources.mapping.ResourceTraversal;
import org.greenrobot.eclipse.core.runtime.CoreException;
import org.greenrobot.eclipse.core.runtime.IProgressMonitor;
import org.greenrobot.eclipse.core.runtime.PlatformObject;

public abstract class ResourceMapping
extends PlatformObject {
    public void accept(ResourceMappingContext context, IResourceVisitor visitor, IProgressMonitor monitor) throws CoreException {
        ResourceTraversal[] traversals;
        ResourceTraversal[] resourceTraversalArray = traversals = this.getTraversals(context, monitor);
        int n = traversals.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceTraversal traversal = resourceTraversalArray[n2];
            traversal.accept(visitor);
            ++n2;
        }
    }

    public boolean contains(ResourceMapping mapping) {
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ResourceMapping) {
            ResourceMapping other = (ResourceMapping)obj;
            return other.getModelObject().equals(this.getModelObject());
        }
        return false;
    }

    public IMarker[] findMarkers(String type, boolean includeSubtypes, IProgressMonitor monitor) throws CoreException {
        ResourceTraversal[] traversals = this.getTraversals(ResourceMappingContext.LOCAL_CONTEXT, monitor);
        ArrayList<IMarker> result = new ArrayList<IMarker>();
        ResourceTraversal[] resourceTraversalArray = traversals;
        int n = traversals.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceTraversal traversal = resourceTraversalArray[n2];
            traversal.doFindMarkers(result, type, includeSubtypes);
            ++n2;
        }
        return result.toArray(new IMarker[result.size()]);
    }

    public abstract Object getModelObject();

    public final ModelProvider getModelProvider() {
        try {
            return ModelProviderManager.getDefault().getModelProvider(this.getModelProviderId());
        }
        catch (CoreException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public abstract String getModelProviderId();

    public abstract IProject[] getProjects();

    public abstract ResourceTraversal[] getTraversals(ResourceMappingContext var1, IProgressMonitor var2) throws CoreException;

    public int hashCode() {
        return this.getModelObject().hashCode();
    }
}

