/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import org.greenrobot.eclipse.jdt.core.dom.AST;
import org.greenrobot.eclipse.jdt.core.dom.ASTMatcher;
import org.greenrobot.eclipse.jdt.core.dom.ASTNode;
import org.greenrobot.eclipse.jdt.core.dom.ASTVisitor;
import org.greenrobot.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.greenrobot.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.greenrobot.eclipse.jdt.core.dom.Expression;
import org.greenrobot.eclipse.jdt.core.dom.SimpleName;
import org.greenrobot.eclipse.jdt.core.dom.Statement;

public class SwitchExpression
extends Expression {
    public static final ChildPropertyDescriptor EXPRESSION_PROPERTY = new ChildPropertyDescriptor(SwitchExpression.class, "expression", Expression.class, true, true);
    public static final ChildListPropertyDescriptor STATEMENTS_PROPERTY = new ChildListPropertyDescriptor(SwitchExpression.class, "statements", Statement.class, true);
    private static final List PROPERTY_DESCRIPTORS;
    private Expression expression = null;
    private ASTNode.NodeList statements = new ASTNode.NodeList(STATEMENTS_PROPERTY);

    static {
        ArrayList propertyList = new ArrayList(3);
        SwitchExpression.createPropertyList(SwitchExpression.class, propertyList);
        SwitchExpression.addProperty(EXPRESSION_PROPERTY, propertyList);
        SwitchExpression.addProperty(STATEMENTS_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS = SwitchExpression.reapPropertyList(propertyList);
    }

    public static List propertyDescriptors(int apiLevel) {
        return SwitchExpression.propertyDescriptors(apiLevel, false);
    }

    public static List propertyDescriptors(int apiLevel, boolean previewEnabled) {
        if (apiLevel == 13 && previewEnabled) {
            return PROPERTY_DESCRIPTORS;
        }
        return null;
    }

    SwitchExpression(AST ast) {
        super(ast);
        this.supportedOnlyIn13();
        this.unsupportedWithoutPreviewError();
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return SwitchExpression.propertyDescriptors(apiLevel);
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel, boolean previewEnabled) {
        return SwitchExpression.propertyDescriptors(apiLevel, previewEnabled);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == EXPRESSION_PROPERTY) {
            if (get) {
                return this.getExpression();
            }
            this.setExpression((Expression)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == STATEMENTS_PROPERTY) {
            return this.statements();
        }
        return super.internalGetChildListProperty(property);
    }

    @Override
    final int getNodeType0() {
        return 100;
    }

    @Override
    ASTNode clone0(AST target) {
        SwitchExpression result = new SwitchExpression(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setExpression((Expression)this.getExpression().clone(target));
        result.statements().addAll(ASTNode.copySubtrees(target, this.statements()));
        return result;
    }

    @Override
    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getExpression());
            this.acceptChildren(visitor, this.statements);
        }
        visitor.endVisit(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression getExpression() {
        if (this.expression == null) {
            SwitchExpression switchExpression = this;
            synchronized (switchExpression) {
                if (this.expression == null) {
                    this.preLazyInit();
                    this.expression = new SimpleName(this.ast);
                    this.postLazyInit(this.expression, EXPRESSION_PROPERTY);
                }
            }
        }
        return this.expression;
    }

    public void setExpression(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.expression;
        this.preReplaceChild(oldChild, expression, EXPRESSION_PROPERTY);
        this.expression = expression;
        this.postReplaceChild(oldChild, expression, EXPRESSION_PROPERTY);
    }

    public List statements() {
        return this.statements;
    }

    @Override
    int memSize() {
        return 52;
    }

    @Override
    int treeSize() {
        return this.memSize() + (this.expression == null ? 0 : this.getExpression().treeSize()) + this.statements.listSize();
    }
}

