/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.jdt.core.util;

import java.util.Comparator;
import org.greenrobot.eclipse.core.runtime.IProgressMonitor;
import org.greenrobot.eclipse.jdt.core.ICompilationUnit;
import org.greenrobot.eclipse.jdt.core.IJavaElement;
import org.greenrobot.eclipse.jdt.core.JavaModelException;
import org.greenrobot.eclipse.jdt.core.dom.CompilationUnit;
import org.greenrobot.eclipse.jdt.internal.core.SortElementsOperation;
import org.greenrobot.eclipse.text.edits.TextEdit;
import org.greenrobot.eclipse.text.edits.TextEditGroup;

public final class CompilationUnitSorter {
    public static final String RELATIVE_ORDER = "relativeOrder";

    private CompilationUnitSorter() {
    }

    private static void checkASTLevel(int level) {
        switch (level) {
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public static void sort(ICompilationUnit compilationUnit, int[] positions, Comparator comparator, int options, IProgressMonitor monitor) throws JavaModelException {
        CompilationUnitSorter.sort(2, compilationUnit, positions, comparator, options, monitor);
    }

    public static void sort(int level, ICompilationUnit compilationUnit, int[] positions, Comparator comparator, int options, IProgressMonitor monitor) throws JavaModelException {
        if (compilationUnit == null || comparator == null) {
            throw new IllegalArgumentException();
        }
        CompilationUnitSorter.checkASTLevel(level);
        IJavaElement[] compilationUnits = new ICompilationUnit[]{compilationUnit};
        SortElementsOperation operation = new SortElementsOperation(level, compilationUnits, positions, comparator);
        operation.runOperation(monitor);
    }

    public static TextEdit sort(CompilationUnit unit, Comparator comparator, int options, TextEditGroup group, IProgressMonitor monitor) throws JavaModelException {
        if (unit == null || comparator == null) {
            throw new IllegalArgumentException();
        }
        SortElementsOperation operation = new SortElementsOperation(unit.getAST().apiLevel(), new IJavaElement[]{unit.getJavaElement()}, null, comparator);
        return operation.calculateEdit(unit, group);
    }
}

