/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.jdt.internal.core;

import java.util.ArrayList;
import org.greenrobot.eclipse.core.runtime.IPath;
import org.greenrobot.eclipse.core.runtime.Path;
import org.greenrobot.eclipse.jdt.core.IClasspathAttribute;
import org.greenrobot.eclipse.jdt.core.IClasspathContainer;
import org.greenrobot.eclipse.jdt.core.IClasspathEntry;
import org.greenrobot.eclipse.jdt.core.IJavaProject;
import org.greenrobot.eclipse.jdt.core.JavaCore;
import org.greenrobot.eclipse.jdt.core.JavaModelException;
import org.greenrobot.eclipse.jdt.internal.compiler.env.IModule;
import org.greenrobot.eclipse.jdt.internal.compiler.env.IModulePathEntry;
import org.greenrobot.eclipse.jdt.internal.core.AbstractModule;
import org.greenrobot.eclipse.jdt.internal.core.ClasspathAttribute;
import org.greenrobot.eclipse.jdt.internal.core.ClasspathEntry;
import org.greenrobot.eclipse.jdt.internal.core.JavaModelManager;
import org.greenrobot.eclipse.jdt.internal.core.JavaProject;
import org.greenrobot.eclipse.jdt.internal.core.ModuleSourcePathManager;
import org.greenrobot.eclipse.jdt.internal.core.ProjectEntry;

public class ModulePathContainer
implements IClasspathContainer {
    private IJavaProject project;

    public ModulePathContainer(IJavaProject project) {
        this.project = project;
    }

    @Override
    public IClasspathEntry[] getClasspathEntries() {
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
        ModuleSourcePathManager manager = JavaModelManager.getModulePathManager();
        try {
            AbstractModule module = (AbstractModule)((JavaProject)this.project).getModuleDescription();
            if (module == null) {
                return new IClasspathEntry[0];
            }
            IModule.IModuleReference[] iModuleReferenceArray = module.getRequiredModules();
            int n = iModuleReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IModule.IModuleReference ref = iModuleReferenceArray[n2];
                IModulePathEntry entry = manager.getModuleRoot(new String(ref.name()));
                JavaProject refRoot = null;
                if (entry instanceof ProjectEntry) {
                    refRoot = ((ProjectEntry)entry).project;
                }
                if (refRoot != null) {
                    IPath path = refRoot.getPath();
                    ClasspathAttribute moduleAttribute = new ClasspathAttribute("module", "true");
                    entries.add(JavaCore.newProjectEntry(path, ClasspathEntry.NO_ACCESS_RULES, false, new IClasspathAttribute[]{moduleAttribute}, ref.isTransitive()));
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
        return entries.toArray(new IClasspathEntry[entries.size()]);
    }

    @Override
    public String getDescription() {
        return "Module path";
    }

    @Override
    public int getKind() {
        return 1;
    }

    @Override
    public IPath getPath() {
        return new Path("org.greenrobot.eclipse.jdt.MODULE_PATH");
    }
}

