/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.jdt.internal.core.dom.rewrite.imports;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.greenrobot.eclipse.jdt.internal.core.dom.rewrite.imports.ImportAdder;
import org.greenrobot.eclipse.jdt.internal.core.dom.rewrite.imports.ImportName;

final class ReorderingImportAdder
implements ImportAdder {
    private final Comparator<ImportName> importComparator;

    ReorderingImportAdder(Comparator<ImportName> importComparator) {
        this.importComparator = importComparator;
    }

    @Override
    public List<ImportName> addImports(Collection<ImportName> existingImports, Collection<ImportName> importsToAdd) {
        int setCapacity = 2 * (existingImports.size() + importsToAdd.size());
        HashSet<ImportName> uniqueImportsWithAdditions = new HashSet<ImportName>(setCapacity);
        uniqueImportsWithAdditions.addAll(existingImports);
        uniqueImportsWithAdditions.addAll(importsToAdd);
        ArrayList<ImportName> sortedImports = new ArrayList<ImportName>(uniqueImportsWithAdditions);
        Collections.sort(sortedImports, this.importComparator);
        return sortedImports;
    }
}

