/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.jdt.internal.core.nd.db;

import org.greenrobot.eclipse.jdt.internal.core.nd.db.Chunk;
import org.greenrobot.eclipse.jdt.internal.core.nd.db.Database;
import org.greenrobot.eclipse.jdt.internal.core.nd.db.IString;
import org.greenrobot.eclipse.jdt.internal.core.nd.db.IndexException;
import org.greenrobot.eclipse.jdt.internal.core.nd.db.Package;
import org.greenrobot.eclipse.jdt.internal.core.nd.util.CharArrayUtils;

public class ShortString
implements IString {
    private final Database db;
    private final long record;
    private int hash;
    private static final int LENGTH = 0;
    private static final int CHARS = 4;
    public static final int MAX_BYTE_LENGTH = Database.MAX_SINGLE_BLOCK_MALLOC_SIZE - 4;

    public ShortString(Database db, long offset) {
        this.db = db;
        this.record = offset;
    }

    public ShortString(Database db, char[] chars, boolean useBytes) throws IndexException {
        int n = chars.length;
        this.db = db;
        this.record = db.malloc(4 + (useBytes ? n : 2 * n), (short)4);
        Chunk chunk = db.getChunk(this.record);
        chunk.putInt(this.record + 0L, useBytes ? -n : n);
        long p = this.record + 4L;
        if (useBytes) {
            chunk.putCharsAsBytes(p, chars, 0, n);
        } else {
            chunk.putChars(p, chars, 0, n);
        }
    }

    @Override
    public long getRecord() {
        return this.record;
    }

    @Override
    public void delete() throws IndexException {
        this.db.free(this.record, (short)4);
    }

    @Override
    public char[] getChars() throws IndexException {
        Chunk chunk = this.db.getChunk(this.record);
        int l = chunk.getInt(this.record + 0L);
        int length = Math.abs(l);
        char[] chars = new char[length];
        if (l < 0) {
            chunk.getCharsFromBytes(this.record + 4L, chars, 0, length);
        } else {
            chunk.getChars(this.record + 4L, chars, 0, length);
        }
        return chars;
    }

    @Override
    public String getString() throws IndexException {
        return new String(this.getChars());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        try {
            if (obj instanceof ShortString) {
                int n2;
                ShortString string = (ShortString)obj;
                if (this.db == string.db && this.record == string.record) {
                    return true;
                }
                Chunk chunk1 = this.db.getChunk(this.record);
                Chunk chunk2 = string.db.getChunk(string.record);
                int n1 = chunk1.getInt(this.record);
                if (n1 == (n2 = chunk2.getInt(string.record))) return CharArrayUtils.equals(this.getChars(), string.getChars());
                return false;
            }
            if (obj instanceof char[]) {
                char[] chars = (char[])obj;
                if (this.length() == chars.length) return CharArrayUtils.equals(this.getChars(), chars);
                return false;
            }
            if (!(obj instanceof String)) return false;
            String string = (String)obj;
            if (this.length() == string.length()) return CharArrayUtils.equals(this.getChars(), string.toCharArray());
            return false;
        }
        catch (IndexException e) {
            Package.log(e);
        }
        return false;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            char[] chars = this.getChars();
            int len = chars.length;
            int i = 0;
            while (i < len) {
                h = 31 * h + chars[i];
                ++i;
            }
            this.hash = h;
        }
        return h;
    }

    public static int compare(char[] chars, char[] other, boolean caseSensitive) {
        int n = Math.min(chars.length, other.length);
        int i = 0;
        while (i < n) {
            int cmp = ShortString.compareChars(chars[i], other[i], caseSensitive);
            if (cmp != 0) {
                return cmp;
            }
            ++i;
        }
        return chars.length - other.length;
    }

    @Override
    public int compare(char[] other, boolean caseSensitive) throws IndexException {
        return ShortString.compare(this.getChars(), other, caseSensitive);
    }

    @Override
    public int compare(IString string, boolean caseSensitive) throws IndexException {
        return ShortString.compare(this.getChars(), string.getChars(), caseSensitive);
    }

    @Override
    public int compare(String other, boolean caseSensitive) throws IndexException {
        return ShortString.compare(this.getChars(), other.toCharArray(), caseSensitive);
    }

    @Override
    public int compareCompatibleWithIgnoreCase(IString string) throws IndexException {
        return this.compareCompatibleWithIgnoreCase(string.getChars());
    }

    @Override
    public int compareCompatibleWithIgnoreCase(char[] other) throws IndexException {
        return ShortString.compareCompatibleWithIgnoreCase(this.getChars(), other);
    }

    public static int compareCompatibleWithIgnoreCase(char[] chars, char[] other) {
        int n = Math.min(chars.length, other.length);
        int sensitiveCmp = 0;
        int i = 0;
        while (i < n) {
            char c1 = chars[i];
            char c2 = other[i];
            if (c1 != c2) {
                int cmp = ShortString.compareChars(c1, c2, false);
                if (cmp != 0) {
                    return cmp;
                }
                if (sensitiveCmp == 0) {
                    sensitiveCmp = c1 < c2 ? -1 : 1;
                }
            }
            ++i;
        }
        int cmp = chars.length - other.length;
        if (cmp != 0) {
            return cmp;
        }
        return sensitiveCmp;
    }

    @Override
    public int comparePrefix(char[] other, boolean caseSensitive) throws IndexException {
        return ShortString.comparePrefix(this.getChars(), other, caseSensitive);
    }

    public static int comparePrefix(char[] chars, char[] other, boolean caseSensitive) {
        int n = Math.min(chars.length, other.length);
        int i = 0;
        while (i < n) {
            int cmp = ShortString.compareChars(chars[i], other[i], caseSensitive);
            if (cmp != 0) {
                return cmp;
            }
            ++i;
        }
        if (chars.length < other.length) {
            return -1;
        }
        return 0;
    }

    public static int compareChars(char a, char b, boolean caseSensitive) {
        if (caseSensitive) {
            if (a < b) {
                return -1;
            }
            if (a > b) {
                return 1;
            }
        } else if (a != b) {
            a = a >= 'a' && a <= 'z' ? (char)(a - 32) : a;
            char c = b = b >= 'a' && b <= 'z' ? (char)(b - 32) : b;
            if (a < b) {
                return -1;
            }
            if (a > b) {
                return 1;
            }
        }
        return 0;
    }

    public String toString() {
        try {
            return this.getString();
        }
        catch (IndexException indexException) {
            return super.toString();
        }
    }

    @Override
    public int length() {
        return Math.abs(this.db.getInt(this.record + 0L));
    }
}

