/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.jdt.internal.core.util;

import org.greenrobot.eclipse.jdt.core.util.ClassFormatException;
import org.greenrobot.eclipse.jdt.core.util.IConstantPool;
import org.greenrobot.eclipse.jdt.core.util.IConstantPoolEntry;
import org.greenrobot.eclipse.jdt.core.util.IModuleMainClassAttribute;
import org.greenrobot.eclipse.jdt.internal.core.util.ClassFileAttribute;

public class ModuleMainClassAttribute
extends ClassFileAttribute
implements IModuleMainClassAttribute {
    private final int mainClassIndex;
    private final char[] mainClassName;

    public ModuleMainClassAttribute(byte[] classFileBytes, IConstantPool constantPool, int offset) throws ClassFormatException {
        super(classFileBytes, constantPool, offset);
        int readOffset = 6;
        this.mainClassIndex = this.u2At(classFileBytes, readOffset, offset);
        IConstantPoolEntry constantPoolEntry = constantPool.decodeEntry(this.mainClassIndex);
        if (constantPoolEntry.getKind() != 7) {
            throw new ClassFormatException(3);
        }
        this.mainClassName = constantPoolEntry.getClassInfoName();
    }

    @Override
    public int getMainClassIndex() {
        return this.mainClassIndex;
    }

    @Override
    public char[] getMainClassName() {
        return this.mainClassName;
    }
}

