/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.osgi.internal.framework;

import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.greenrobot.eclipse.osgi.internal.framework.EquinoxConfiguration;
import org.greenrobot.eclipse.osgi.internal.framework.EquinoxContainer;

public final class StorageSaver {
    private final EquinoxContainer container;
    private final long delay;
    private final ScheduledFuture<?> future;
    private final Thread hook;
    private final StorageSaverTask task;

    public StorageSaver(EquinoxContainer container) {
        this.container = container;
        this.task = new StorageSaverTask(container);
        this.delay = this.computeDelay();
        this.future = this.scheduleTask();
        this.hook = this.registerShutdownHook();
    }

    public void close() {
        this.unregisterShutdownHook();
        this.unscheduleTask();
    }

    public void save() {
        if (this.delay != 0L) {
            return;
        }
        this.task.run();
    }

    private Thread registerShutdownHook() {
        Thread thread = new Thread((Runnable)this.task, "Equinox Shutdown Hook");
        Runtime.getRuntime().addShutdownHook(thread);
        return thread;
    }

    private long computeDelay() {
        EquinoxConfiguration configuration = this.container.getConfiguration();
        String delayProp = configuration.getConfiguration("eclipse.stateSaveDelayInterval");
        return Long.parseLong(delayProp);
    }

    private ScheduledFuture<?> scheduleTask() {
        if (this.delay <= 0L) {
            return null;
        }
        ScheduledExecutorService executor = this.container.getScheduledExecutor();
        return executor.scheduleWithFixedDelay(this.task, this.delay, this.delay, TimeUnit.MILLISECONDS);
    }

    private void unregisterShutdownHook() {
        try {
            Runtime.getRuntime().removeShutdownHook(this.hook);
        }
        catch (IllegalStateException illegalStateException) {}
    }

    private void unscheduleTask() {
        if (this.future != null) {
            this.future.cancel(false);
        }
    }

    private static class StorageSaverTask
    implements Runnable {
        private final EquinoxContainer container;

        public StorageSaverTask(EquinoxContainer container) {
            this.container = container;
        }

        @Override
        public void run() {
            try {
                this.container.getStorage().save();
            }
            catch (IOException e) {
                this.container.getLogServices().log("org.greenrobot.eclipse.osgi", 4, "Error saving on update", e);
            }
        }
    }
}

