/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.osgi.internal.signedcontent;

import java.security.cert.Certificate;
import java.util.HashSet;
import java.util.Iterator;
import org.greenrobot.eclipse.osgi.internal.framework.EquinoxBundle;
import org.greenrobot.eclipse.osgi.internal.signedcontent.SignedBundleHook;
import org.greenrobot.eclipse.osgi.internal.signedcontent.SignedContentImpl;
import org.greenrobot.eclipse.osgi.internal.signedcontent.SignedStorageHook;
import org.greenrobot.eclipse.osgi.internal.signedcontent.SignerInfoImpl;
import org.greenrobot.eclipse.osgi.signedcontent.SignerInfo;
import org.greenrobot.eclipse.osgi.storage.BundleInfo;
import org.greenrobot.osgi.framework.Bundle;
import org.greenrobot.osgi.framework.BundleContext;

public class TrustEngineListener {
    private final BundleContext context;
    private final SignedBundleHook signedBundleHook;

    TrustEngineListener(BundleContext context, SignedBundleHook signedBundleHook) {
        this.context = context;
        this.signedBundleHook = signedBundleHook;
    }

    public void addedTrustAnchor(Certificate anchor) {
        Bundle[] bundles;
        Bundle[] bundleArray = bundles = this.context.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            SignedContentImpl signedContent = this.getSignedContent(bundle);
            if (signedContent != null && signedContent.isSigned()) {
                SignerInfo[] infos;
                SignerInfo[] signerInfoArray = infos = signedContent.getSignerInfos();
                int n3 = infos.length;
                int n4 = 0;
                while (n4 < n3) {
                    SignerInfo info = signerInfoArray[n4];
                    if (info.getTrustAnchor() == null) {
                        this.signedBundleHook.determineTrust(signedContent, 2);
                    } else {
                        SignerInfo tsa = signedContent.getTSASignerInfo(info);
                        if (tsa != null && tsa.getTrustAnchor() == null) {
                            this.signedBundleHook.determineTrust(signedContent, 2);
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public void removedTrustAnchor(Certificate anchor) {
        Bundle[] bundles = this.context.getBundles();
        HashSet<Bundle> usingAnchor = new HashSet<Bundle>();
        HashSet<SignerInfo> untrustedSigners = new HashSet<SignerInfo>();
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            SignedContentImpl signedContent = this.getSignedContent(bundle);
            if (signedContent != null && signedContent.isSigned()) {
                SignerInfo[] infos;
                SignerInfo[] signerInfoArray = infos = signedContent.getSignerInfos();
                int n3 = infos.length;
                int n4 = 0;
                while (n4 < n3) {
                    SignerInfo tsa;
                    SignerInfo info = signerInfoArray[n4];
                    if (anchor.equals(info.getTrustAnchor())) {
                        untrustedSigners.add(info);
                        usingAnchor.add(bundle);
                    }
                    if ((tsa = signedContent.getTSASignerInfo(info)) != null && anchor.equals(tsa.getTrustAnchor())) {
                        usingAnchor.add(bundle);
                        untrustedSigners.add(tsa);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        Iterator untrusted = untrustedSigners.iterator();
        while (untrusted.hasNext()) {
            ((SignerInfoImpl)untrusted.next()).setTrustAnchor(null);
        }
        for (Bundle bundle : usingAnchor) {
            SignedContentImpl signedContent = this.getSignedContent(bundle);
            this.signedBundleHook.determineTrust(signedContent, 2);
        }
    }

    private SignedContentImpl getSignedContent(Bundle bundle) {
        BundleInfo.Generation generation = (BundleInfo.Generation)((EquinoxBundle)bundle).getModule().getCurrentRevision().getRevisionInfo();
        SignedStorageHook.StorageHookImpl hook = (SignedStorageHook.StorageHookImpl)generation.getStorageHook(SignedStorageHook.class);
        return hook != null ? hook.signedContent : null;
    }
}

