/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.cte.CteMaterialization;
import org.hibernate.sql.ast.tree.expression.Any;
import org.hibernate.sql.ast.tree.expression.Every;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.from.QueryPartTableReference;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class SQLiteSqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    public SQLiteSqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    protected AbstractSqlAstTranslator.LockStrategy determineLockingStrategy(QuerySpec querySpec, AbstractSqlAstTranslator.ForUpdateClause forUpdateClause, Boolean followOnLocking) {
        return AbstractSqlAstTranslator.LockStrategy.NONE;
    }

    protected void renderForUpdateClause(QuerySpec querySpec, AbstractSqlAstTranslator.ForUpdateClause forUpdateClause) {
    }

    protected void renderMaterializationHint(CteMaterialization materialization) {
        if (this.getDialect().getVersion().isSameOrAfter(3, 3, 5)) {
            if (materialization == CteMaterialization.NOT_MATERIALIZED) {
                this.appendSql("not ");
            }
            this.appendSql("materialized ");
        }
    }

    public boolean supportsFilterClause() {
        return this.getDialect().getVersion().isSameOrAfter(3, 3);
    }

    protected boolean supportsQuantifiedPredicates() {
        return false;
    }

    protected boolean shouldEmulateFetchClause(QueryPart queryPart) {
        return this.getQueryPartForRowNumbering() != queryPart && !this.isRowsOnlyFetchClauseType(queryPart);
    }

    public void visitQueryGroup(QueryGroup queryGroup) {
        if (this.shouldEmulateFetchClause((QueryPart)queryGroup)) {
            this.emulateFetchOffsetWithWindowFunctions((QueryPart)queryGroup, true);
        } else {
            super.visitQueryGroup(queryGroup);
        }
    }

    public void visitQuerySpec(QuerySpec querySpec) {
        if (this.shouldEmulateFetchClause((QueryPart)querySpec)) {
            this.emulateFetchOffsetWithWindowFunctions((QueryPart)querySpec, true);
        } else {
            super.visitQuerySpec(querySpec);
        }
    }

    public void visitQueryPartTableReference(QueryPartTableReference tableReference) {
        this.emulateQueryPartTableReferenceColumnAliasing(tableReference);
    }

    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (!this.isRowNumberingCurrentQueryPart()) {
            this.renderLimitOffsetClause(queryPart);
        }
    }

    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        if (rhs instanceof Any) {
            this.emulateSubQueryRelationalRestrictionPredicate(null, false, ((Any)rhs).getSubquery(), lhs, (x$0, x$1, x$2) -> this.renderSelectSimpleComparison(x$0, x$1, x$2), operator);
        } else if (rhs instanceof Every) {
            this.emulateSubQueryRelationalRestrictionPredicate(null, true, ((Every)rhs).getSubquery(), lhs, (x$0, x$1, x$2) -> this.renderSelectSimpleComparison(x$0, x$1, x$2), operator.negated());
        } else {
            this.renderComparisonDistinctOperator(lhs, operator, rhs);
        }
    }

    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Summarization) {
            throw new UnsupportedOperationException("Summarization is not supported by DBMS!");
        }
        expression.accept((SqlAstWalker)this);
    }
}

