/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping;

import org.hibernate.Incubating;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.InDatabaseGeneratedValueResolver;
import org.hibernate.metamodel.mapping.InMemoryGeneratedValueResolver;
import org.hibernate.metamodel.mapping.internal.NoGeneratedValueResolver;
import org.hibernate.tuple.GenerationTiming;
import org.hibernate.tuple.ValueGeneration;

@Incubating
public interface GeneratedValueResolver {
    public static GeneratedValueResolver from(ValueGeneration valueGeneration, GenerationTiming requestedTiming, int dbSelectionPosition) {
        if (!1.$assertionsDisabled && requestedTiming == GenerationTiming.NEVER) {
            throw new AssertionError();
        }
        if (valueGeneration == null || valueGeneration.getGenerationTiming().includes(GenerationTiming.NEVER)) {
            return NoGeneratedValueResolver.INSTANCE;
        }
        if (requestedTiming == GenerationTiming.ALWAYS && valueGeneration.getGenerationTiming() == GenerationTiming.INSERT) {
            return NoGeneratedValueResolver.INSTANCE;
        }
        if (valueGeneration.getValueGenerator() == null) {
            return new InDatabaseGeneratedValueResolver(requestedTiming, dbSelectionPosition);
        }
        return new InMemoryGeneratedValueResolver(valueGeneration.getValueGenerator(), requestedTiming);
    }

    public GenerationTiming getGenerationTiming();

    public Object resolveGeneratedValue(Object[] var1, Object var2, SharedSessionContractImplementor var3);

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

