/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.hibernate.HibernateException;
import org.hibernate.query.internal.QueryParameterNamedImpl;
import org.hibernate.query.internal.QueryParameterPositionalImpl;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sqm.SqmTreeTransformationLogger;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.expression.JpaCriteriaParameter;
import org.hibernate.query.sqm.tree.expression.SqmJpaCriteriaParameterWrapper;
import org.hibernate.query.sqm.tree.expression.SqmNamedParameter;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.expression.SqmPositionalParameter;

public class DomainParameterXref {
    private final SqmStatement.ParameterResolutions parameterResolutions;
    private final Map<QueryParameterImplementor<?>, List<SqmParameter<?>>> sqmParamsByQueryParam;
    private final Map<SqmParameter<?>, QueryParameterImplementor<?>> queryParamBySqmParam;
    private Map<SqmParameter<?>, List<SqmParameter<?>>> expansions;

    public static DomainParameterXref from(SqmStatement<?> sqmStatement) {
        TreeMap<SqmParameter, QueryParameterImplementor> xrefMap = new TreeMap<SqmParameter, QueryParameterImplementor>((o1, o2) -> {
            if (o1 instanceof SqmNamedParameter) {
                SqmNamedParameter one = (SqmNamedParameter)o1;
                return o2 instanceof SqmNamedParameter ? one.getName().compareTo(((SqmNamedParameter)o2).getName()) : -1;
            }
            if (o1 instanceof SqmPositionalParameter) {
                SqmPositionalParameter one = (SqmPositionalParameter)o1;
                return o2 instanceof SqmPositionalParameter ? one.getPosition().compareTo(((SqmPositionalParameter)o2).getPosition()) : 1;
            }
            if (o1 instanceof SqmJpaCriteriaParameterWrapper && o2 instanceof SqmJpaCriteriaParameterWrapper) {
                return Integer.compare(o1.hashCode(), o2.hashCode());
            }
            throw new HibernateException("Unexpected SqmParameter type for comparison : " + o1 + " & " + o2);
        });
        SqmStatement.ParameterResolutions parameterResolutions = sqmStatement.resolveParameters();
        if (parameterResolutions.getSqmParameters().isEmpty()) {
            return DomainParameterXref.empty();
        }
        IdentityHashMap sqmParamsByQueryParam = new IdentityHashMap();
        int sqmParamCount = parameterResolutions.getSqmParameters().size();
        IdentityHashMap queryParamBySqmParam = new IdentityHashMap(sqmParamCount);
        for (SqmParameter<?> sqmParameter : parameterResolutions.getSqmParameters()) {
            if (sqmParameter instanceof JpaCriteriaParameter) {
                throw new UnsupportedOperationException("Unexpected JpaCriteriaParameter in SqmStatement#getSqmParameters.  Criteria parameters should be represented as SqmJpaCriteriaParameterWrapper references in this collection");
            }
            QueryParameterImplementor queryParameter = xrefMap.computeIfAbsent(sqmParameter, p -> {
                if (sqmParameter instanceof SqmJpaCriteriaParameterWrapper) {
                    return ((SqmJpaCriteriaParameterWrapper)sqmParameter).getJpaCriteriaParameter();
                }
                if (sqmParameter.getName() != null) {
                    return QueryParameterNamedImpl.fromSqm(sqmParameter);
                }
                if (sqmParameter.getPosition() != null) {
                    return QueryParameterPositionalImpl.fromSqm(sqmParameter);
                }
                throw new UnsupportedOperationException("Unexpected SqmParameter type : " + sqmParameter);
            });
            if (!sqmParameter.allowMultiValuedBinding() && queryParameter.allowsMultiValuedBinding()) {
                SqmTreeTransformationLogger.LOGGER.debugf("SqmParameter [%s] does not allow multi-valued binding, but mapped to existing QueryParameter [%s] that does - disallowing multi-valued binding", sqmParameter, (Object)queryParameter);
                queryParameter.disallowMultiValuedBinding();
            }
            sqmParamsByQueryParam.computeIfAbsent(queryParameter, qp -> new ArrayList()).add(sqmParameter);
            queryParamBySqmParam.put(sqmParameter, queryParameter);
        }
        return new DomainParameterXref(sqmParamsByQueryParam, queryParamBySqmParam, parameterResolutions);
    }

    public static DomainParameterXref empty() {
        return new DomainParameterXref(Collections.emptyMap(), Collections.emptyMap(), SqmStatement.ParameterResolutions.empty());
    }

    public DomainParameterXref(Map<QueryParameterImplementor<?>, List<SqmParameter<?>>> sqmParamsByQueryParam, Map<SqmParameter<?>, QueryParameterImplementor<?>> queryParamBySqmParam, SqmStatement.ParameterResolutions parameterResolutions) {
        this.sqmParamsByQueryParam = sqmParamsByQueryParam;
        this.queryParamBySqmParam = queryParamBySqmParam;
        this.parameterResolutions = parameterResolutions;
    }

    public DomainParameterXref copy() {
        return new DomainParameterXref(this.sqmParamsByQueryParam, new IdentityHashMap(this.queryParamBySqmParam), this.parameterResolutions);
    }

    public boolean hasParameters() {
        return this.sqmParamsByQueryParam != null && !this.sqmParamsByQueryParam.isEmpty();
    }

    public Map<QueryParameterImplementor<?>, List<SqmParameter<?>>> getQueryParameters() {
        return this.sqmParamsByQueryParam;
    }

    public int getQueryParameterCount() {
        return this.sqmParamsByQueryParam.size();
    }

    public int getSqmParameterCount() {
        return this.queryParamBySqmParam.size();
    }

    public int getNumberOfSqmParameters(QueryParameterImplementor<?> queryParameter) {
        List<SqmParameter<?>> sqmParameters = this.sqmParamsByQueryParam.get(queryParameter);
        if (sqmParameters == null) {
            return 0;
        }
        return sqmParameters.size();
    }

    public Map<QueryParameterImplementor<?>, List<SqmParameter<?>>> getSqmParamByQueryParam() {
        return this.sqmParamsByQueryParam;
    }

    public SqmStatement.ParameterResolutions getParameterResolutions() {
        return this.parameterResolutions;
    }

    public List<SqmParameter<?>> getSqmParameters(QueryParameterImplementor<?> queryParameter) {
        return this.sqmParamsByQueryParam.get(queryParameter);
    }

    public QueryParameterImplementor<?> getQueryParameter(SqmParameter<?> sqmParameter) {
        if (sqmParameter instanceof SqmJpaCriteriaParameterWrapper) {
            return ((SqmJpaCriteriaParameterWrapper)sqmParameter).getJpaCriteriaParameter();
        }
        if (sqmParameter instanceof QueryParameterImplementor) {
            return (QueryParameterImplementor)((Object)sqmParameter);
        }
        return this.queryParamBySqmParam.get(sqmParameter);
    }

    public void addExpansion(QueryParameterImplementor<?> domainParam, SqmParameter originalSqmParameter, SqmParameter expansion) {
        SqmTreeTransformationLogger.LOGGER.debugf("Adding domain-param xref expansion : %s", (Object)originalSqmParameter);
        this.queryParamBySqmParam.put(expansion, domainParam);
        if (this.expansions == null) {
            this.expansions = new IdentityHashMap();
        }
        this.expansions.computeIfAbsent(originalSqmParameter, p -> new ArrayList()).add(expansion);
    }

    public List<SqmParameter<?>> getExpansions(SqmParameter<?> sqmParameter) {
        if (this.expansions == null) {
            return Collections.emptyList();
        }
        List<SqmParameter<?>> sqmParameters = this.expansions.get(sqmParameter);
        return sqmParameters == null ? Collections.emptyList() : sqmParameters;
    }

    public void clearExpansions() {
        if (this.expansions == null) {
            return;
        }
        for (List<SqmParameter<?>> expansionList : this.expansions.values()) {
            for (SqmParameter<?> expansion : expansionList) {
                this.queryParamBySqmParam.remove(expansion);
            }
        }
        this.expansions.clear();
    }
}

