/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.cte;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SqlExpressible;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmJdbcExecutionContextAdapter;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.mutation.internal.MatchingIdSelectionHelper;
import org.hibernate.query.sqm.mutation.internal.MultiTableSqmMutationConverter;
import org.hibernate.query.sqm.mutation.internal.cte.CteMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.AbstractMutationHandler;
import org.hibernate.query.sqm.sql.BaseSqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmDeleteOrUpdateStatement;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.cte.SqmCteTable;
import org.hibernate.query.sqm.tree.domain.AbstractSqmFrom;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.expression.SqmStar;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.tree.cte.CteColumn;
import org.hibernate.sql.ast.tree.cte.CteContainer;
import org.hibernate.sql.ast.tree.cte.CteMaterialization;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.cte.CteTableGroup;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.UnionTableReference;
import org.hibernate.sql.ast.tree.predicate.InSubQueryPredicate;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcSelect;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.sql.results.spi.ListResultsConsumer;
import org.hibernate.type.spi.TypeConfiguration;

public abstract class AbstractCteMutationHandler
extends AbstractMutationHandler {
    public static final String CTE_TABLE_IDENTIFIER = "id";
    private final SqmCteTable cteTable;
    private final DomainParameterXref domainParameterXref;
    private final CteMutationStrategy strategy;

    public AbstractCteMutationHandler(SqmCteTable cteTable, SqmDeleteOrUpdateStatement<?> sqmStatement, DomainParameterXref domainParameterXref, CteMutationStrategy strategy, SessionFactoryImplementor sessionFactory) {
        super(sqmStatement, sessionFactory);
        this.cteTable = cteTable;
        this.domainParameterXref = domainParameterXref;
        this.strategy = strategy;
    }

    public SqmCteTable getCteTable() {
        return this.cteTable;
    }

    public DomainParameterXref getDomainParameterXref() {
        return this.domainParameterXref;
    }

    public CteMutationStrategy getStrategy() {
        return this.strategy;
    }

    @Override
    public int execute(DomainQueryExecutionContext executionContext) {
        SqmDeleteOrUpdateStatement<?> sqmMutationStatement = this.getSqmDeleteOrUpdateStatement();
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        EntityMappingType entityDescriptor = this.getEntityDescriptor();
        String explicitDmlTargetAlias = ((AbstractSqmFrom)((Object)sqmMutationStatement.getTarget())).getExplicitAlias() == null ? "dml_target" : ((AbstractSqmFrom)((Object)sqmMutationStatement.getTarget())).getExplicitAlias();
        MultiTableSqmMutationConverter sqmConverter = new MultiTableSqmMutationConverter(entityDescriptor, (SqmStatement<?>)sqmMutationStatement, (SqmRoot<?>)sqmMutationStatement.getTarget(), explicitDmlTargetAlias, this.domainParameterXref, executionContext.getQueryOptions(), executionContext.getSession().getLoadQueryInfluencers(), executionContext.getQueryParameterBindings(), factory);
        Map<SqmParameter<Object>, List<JdbcParameter>> parameterResolutions = this.domainParameterXref.getSqmParameterCount() == 0 ? Collections.emptyMap() : new IdentityHashMap();
        LinkedHashMap paramTypeResolutions = new LinkedHashMap();
        Predicate restriction = sqmConverter.visitWhereClause(sqmMutationStatement.getWhereClause(), columnReference -> {}, (sqmParam, mappingType, jdbcParameters) -> paramTypeResolutions.put(sqmParam, mappingType));
        sqmConverter.pruneTableGroupJoins();
        CteStatement idSelectCte = new CteStatement(BaseSqmToSqlAstConverter.createCteTable(this.getCteTable(), factory), MatchingIdSelectionHelper.generateMatchingIdSelectStatement(entityDescriptor, sqmMutationStatement, true, restriction, sqmConverter, executionContext, factory), CteMaterialization.MATERIALIZED);
        QuerySpec querySpec = new QuerySpec(true, 1);
        ArrayList domainResults = new ArrayList(1);
        SelectStatement statement = new SelectStatement(querySpec, domainResults);
        JdbcServices jdbcServices = factory.getJdbcServices();
        SqlAstTranslator<JdbcSelect> translator = jdbcServices.getJdbcEnvironment().getSqlAstTranslatorFactory().buildSelectTranslator(factory, statement);
        Expression count = this.createCountStar(factory, sqmConverter);
        domainResults.add(new BasicResult(0, null, ((SqlExpressible)((Object)count)).getJdbcMapping()));
        querySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(1, 0, count));
        querySpec.getFromClause().addRoot(new CteTableGroup(new NamedTableReference(idSelectCte.getCteTable().getTableExpression(), CTE_TABLE_IDENTIFIER, false, factory)));
        statement.addCteStatement(idSelectCte);
        this.addDmlCtes(statement, idSelectCte, sqmConverter, parameterResolutions, factory);
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings(executionContext.getQueryParameterBindings(), this.domainParameterXref, SqmUtil.generateJdbcParamsXref(this.domainParameterXref, sqmConverter), factory.getRuntimeMetamodels().getMappingMetamodel(), navigablePath -> sqmConverter.getMutatingTableGroup(), paramTypeResolutions::get, executionContext.getSession());
        LockOptions lockOptions = executionContext.getQueryOptions().getLockOptions();
        LockMode lockMode = lockOptions.getAliasSpecificLockMode(explicitDmlTargetAlias);
        lockOptions.setAliasSpecificLockMode(explicitDmlTargetAlias, LockMode.WRITE);
        JdbcSelect select = translator.translate(jdbcParameterBindings, executionContext.getQueryOptions());
        lockOptions.setAliasSpecificLockMode(explicitDmlTargetAlias, lockMode);
        executionContext.getSession().autoFlushIfRequired(select.getAffectedTableNames());
        List<Object> list = jdbcServices.getJdbcSelectExecutor().list(select, jdbcParameterBindings, SqmJdbcExecutionContextAdapter.omittingLockingAndPaging(executionContext), row -> row[0], ListResultsConsumer.UniqueSemantic.NONE);
        return ((Number)list.get(0)).intValue();
    }

    private Expression createCountStar(SessionFactoryImplementor factory, MultiTableSqmMutationConverter sqmConverter) {
        SqmStar arg = new SqmStar(factory.getNodeBuilder());
        TypeConfiguration typeConfiguration = factory.getJpaMetamodel().getTypeConfiguration();
        return factory.getQueryEngine().getSqmFunctionRegistry().findFunctionDescriptor("count").generateSqmExpression(arg, null, factory.getQueryEngine(), typeConfiguration).convertToSqlAst(sqmConverter);
    }

    protected Predicate createIdSubQueryPredicate(List<? extends Expression> lhsExpressions, CteStatement idSelectCte, SessionFactoryImplementor factory) {
        return this.createIdSubQueryPredicate(lhsExpressions, idSelectCte, null, factory);
    }

    protected Predicate createIdSubQueryPredicate(List<? extends Expression> lhsExpressions, CteStatement idSelectCte, ModelPart fkModelPart, SessionFactoryImplementor factory) {
        Junction predicate = new Junction(Junction.Nature.CONJUNCTION);
        QuerySpec subQuery = this.createIdSubQuery(idSelectCte, fkModelPart, factory);
        Expression lhs = lhsExpressions.size() == 1 ? lhsExpressions.get(0) : new SqlTuple(lhsExpressions, null);
        predicate.add(new InSubQueryPredicate(lhs, subQuery, false));
        return predicate;
    }

    protected QuerySpec createIdSubQuery(CteStatement idSelectCte, ModelPart fkModelPart, SessionFactoryImplementor factory) {
        NamedTableReference idSelectTableReference = new NamedTableReference(idSelectCte.getCteTable().getTableExpression(), CTE_TABLE_IDENTIFIER, false, factory);
        List<CteColumn> cteColumns = idSelectCte.getCteTable().getCteColumns();
        int size = cteColumns.size();
        QuerySpec subQuery = new QuerySpec(false, 1);
        subQuery.getFromClause().addRoot(new CteTableGroup(idSelectTableReference));
        SelectClause subQuerySelectClause = subQuery.getSelectClause();
        if (fkModelPart == null) {
            for (int i = 0; i < size; ++i) {
                CteColumn cteColumn = cteColumns.get(i);
                subQuerySelectClause.addSqlSelection(new SqlSelectionImpl(i + 1, i, new ColumnReference(idSelectTableReference, cteColumn.getColumnExpression(), cteColumn.getJdbcMapping(), factory)));
            }
        } else {
            fkModelPart.forEachSelectable((selectionIndex, selectableMapping) -> subQuerySelectClause.addSqlSelection(new SqlSelectionImpl(selectionIndex + 1, selectionIndex, new ColumnReference(idSelectTableReference, selectableMapping.getSelectionExpression(), selectableMapping.getJdbcMapping(), factory))));
        }
        return subQuery;
    }

    protected abstract void addDmlCtes(CteContainer var1, CteStatement var2, MultiTableSqmMutationConverter var3, Map<SqmParameter<?>, List<JdbcParameter>> var4, SessionFactoryImplementor var5);

    protected NamedTableReference resolveUnionTableReference(TableReference tableReference, String tableExpression) {
        if (tableReference instanceof UnionTableReference) {
            return new NamedTableReference(tableExpression, tableReference.getIdentificationVariable(), tableReference.isOptional(), this.getSessionFactory());
        }
        return (NamedTableReference)tableReference;
    }

    protected abstract String getCteTableName(String var1);
}

