/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.tree.from.AbstractTableGroup;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.from.VirtualTableGroup;

public class SyntheticVirtualTableGroup
extends AbstractTableGroup
implements VirtualTableGroup {
    private final TableGroup underlyingTableGroup;
    private final TableReference syntheticTableReference;

    public SyntheticVirtualTableGroup(NavigablePath navigablePath, ModelPartContainer modelPart, TableGroup underlyingTableGroup) {
        super(underlyingTableGroup.canUseInnerJoins(), navigablePath, modelPart, underlyingTableGroup.getSourceAlias(), null, null);
        this.underlyingTableGroup = underlyingTableGroup;
        this.syntheticTableReference = new NamedTableReference(navigablePath.getFullPath(), navigablePath.getLocalName(), false, null);
    }

    @Override
    public ModelPartContainer getExpressionType() {
        return this.getModelPart();
    }

    @Override
    public boolean isFetched() {
        return false;
    }

    @Override
    public String getSourceAlias() {
        return this.underlyingTableGroup.getSourceAlias();
    }

    @Override
    public boolean canUseInnerJoins() {
        return this.underlyingTableGroup.canUseInnerJoins();
    }

    @Override
    public void applyAffectedTableNames(Consumer<String> nameCollector) {
    }

    @Override
    public TableReference getPrimaryTableReference() {
        return this.syntheticTableReference;
    }

    @Override
    public List<TableReferenceJoin> getTableReferenceJoins() {
        return Collections.emptyList();
    }

    @Override
    public TableReference getTableReferenceInternal(NavigablePath navigablePath, String tableExpression, boolean allowFkOptimization, boolean resolve) {
        TableReference tableReference = this.underlyingTableGroup.getPrimaryTableReference().getTableReference(navigablePath, tableExpression, allowFkOptimization, resolve);
        if (tableReference != null) {
            return this.syntheticTableReference;
        }
        return null;
    }
}

