/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple;

import org.hibernate.PropertyValueException;
import org.hibernate.Session;
import org.hibernate.annotations.TenantId;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.tuple.AnnotationValueGeneration;
import org.hibernate.tuple.GenerationTiming;
import org.hibernate.tuple.ValueGenerator;

public class TenantIdGeneration
implements AnnotationValueGeneration<TenantId>,
ValueGenerator<Object> {
    private String entityName;
    private String propertyName;

    @Override
    public void initialize(TenantId annotation, Class<?> propertyType, String entityName, String propertyName) {
        this.entityName = entityName;
        this.propertyName = propertyName;
    }

    @Override
    public void initialize(TenantId annotation, Class<?> propertyType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public GenerationTiming getGenerationTiming() {
        return GenerationTiming.INSERT;
    }

    @Override
    public ValueGenerator<?> getValueGenerator() {
        return this;
    }

    @Override
    public Object generateValue(Session session, Object owner, Object currentValue) {
        String identifier = session.getTenantIdentifier();
        if (currentValue != null) {
            CurrentTenantIdentifierResolver resolver = ((SessionFactoryImplementor)session.getSessionFactory()).getCurrentTenantIdentifierResolver();
            if (resolver != null && resolver.isRoot(session.getTenantIdentifier())) {
                return currentValue;
            }
            if (!currentValue.equals(identifier)) {
                throw new PropertyValueException("assigned tenant id differs from current tenant id: " + currentValue + "!=" + identifier, this.entityName, this.propertyName);
            }
        }
        return identifier;
    }

    @Override
    public Object generateValue(Session session, Object owner) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean referenceColumnInSql() {
        return false;
    }

    @Override
    public String getDatabaseGeneratedReferencedColumnValue() {
        return null;
    }
}

