
package org.hibernate.boot.jaxb.hbm.spi;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for PolymorphismEnum.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="PolymorphismEnum">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}token">
 *     <enumeration value="explicit"/>
 *     <enumeration value="implicit"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "PolymorphismEnum", namespace = "http://www.hibernate.org/xsd/orm/hbm")
@XmlEnum
public enum JaxbHbmPolymorphismEnum {

    @XmlEnumValue("explicit")
    EXPLICIT("explicit"),
    @XmlEnumValue("implicit")
    IMPLICIT("implicit");
    private final String value;

    JaxbHbmPolymorphismEnum(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static JaxbHbmPolymorphismEnum fromValue(String v) {
        for (JaxbHbmPolymorphismEnum c: JaxbHbmPolymorphismEnum.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
