
package org.hibernate.boot.jaxb.mapping;

import java.io.Serializable;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 *                 See `@org.hibernate.annotations.TenantId`
 *             
 * 
 * <p>Java class for multi-tenancy complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="multi-tenancy">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <choice minOccurs="0">
 *           <element name="column" type="{http://www.hibernate.org/xsd/orm/mapping}column"/>
 *           <element name="formula" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         </choice>
 *       </sequence>
 *       <attribute name="shared" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       <attribute name="bind-as-param" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "multi-tenancy", namespace = "http://www.hibernate.org/xsd/orm/mapping", propOrder = {
    "column",
    "formula"
})
public class JaxbMultiTenancy
    implements Serializable
{

    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbColumn column;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected String formula;
    @XmlAttribute(name = "shared")
    protected Boolean shared;
    @XmlAttribute(name = "bind-as-param")
    protected Boolean bindAsParam;

    /**
     * Gets the value of the column property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbColumn }
     *     
     */
    public JaxbColumn getColumn() {
        return column;
    }

    /**
     * Sets the value of the column property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbColumn }
     *     
     */
    public void setColumn(JaxbColumn value) {
        this.column = value;
    }

    /**
     * Gets the value of the formula property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getFormula() {
        return formula;
    }

    /**
     * Sets the value of the formula property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setFormula(String value) {
        this.formula = value;
    }

    /**
     * Gets the value of the shared property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isShared() {
        if (shared == null) {
            return true;
        } else {
            return shared;
        }
    }

    /**
     * Sets the value of the shared property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setShared(Boolean value) {
        this.shared = value;
    }

    /**
     * Gets the value of the bindAsParam property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isBindAsParam() {
        if (bindAsParam == null) {
            return true;
        } else {
            return bindAsParam;
        }
    }

    /**
     * Sets the value of the bindAsParam property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setBindAsParam(Boolean value) {
        this.bindAsParam = value;
    }

}
