
package org.hibernate.boot.jaxb.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 *                 Specifies a filter definition.  After definition, a filter
 *                 can be applied to entity or collection by name.
 *             
 * 
 * <p>Java class for filter-def complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="filter-def">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="filter-param" maxOccurs="unbounded" minOccurs="0">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <attribute name="name" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *                 <attribute name="type" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *                 <attribute name="resolver" type="{http://www.w3.org/2001/XMLSchema}string" />
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *         <element name="condition" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *       </sequence>
 *       <attribute name="name" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "filter-def", namespace = "http://www.hibernate.org/xsd/orm/mapping", propOrder = {
    "filterParam",
    "condition"
})
public class JaxbFilterDef
    implements Serializable
{

    @XmlElement(name = "filter-param", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbFilterDef.JaxbFilterParam> filterParam;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected String condition;
    @XmlAttribute(name = "name", required = true)
    protected String name;

    /**
     * Gets the value of the filterParam property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the filterParam property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getFilterParam().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbFilterDef.JaxbFilterParam }
     * 
     * 
     * @return
     *     The value of the filterParam property.
     */
    public List<JaxbFilterDef.JaxbFilterParam> getFilterParam() {
        if (filterParam == null) {
            filterParam = new ArrayList<>();
        }
        return this.filterParam;
    }

    /**
     * Gets the value of the condition property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCondition() {
        return condition;
    }

    /**
     * Sets the value of the condition property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCondition(String value) {
        this.condition = value;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setName(String value) {
        this.name = value;
    }


    /**
     * 
     *                             Used to identify all bind parameters in the condition elemement
     *                         
     * 
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <attribute name="name" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
     *       <attribute name="type" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
     *       <attribute name="resolver" type="{http://www.w3.org/2001/XMLSchema}string" />
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "")
    public static class JaxbFilterParam
        implements Serializable
    {

        @XmlAttribute(name = "name", required = true)
        protected String name;
        @XmlAttribute(name = "type", required = true)
        protected String type;
        @XmlAttribute(name = "resolver")
        protected String resolver;

        /**
         * Gets the value of the name property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getName() {
            return name;
        }

        /**
         * Sets the value of the name property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setName(String value) {
            this.name = value;
        }

        /**
         * Gets the value of the type property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getType() {
            return type;
        }

        /**
         * Sets the value of the type property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setType(String value) {
            this.type = value;
        }

        /**
         * Gets the value of the resolver property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getResolver() {
            return resolver;
        }

        /**
         * Sets the value of the resolver property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setResolver(String value) {
            this.resolver = value;
        }

    }

}
