
/*
 * Hibernate, Relational Persistence for Idiomatic Java
 *
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later.
 * See the lgpl.txt file in the root directory or <http://www.gnu.org/licenses/lgpl-2.1.html>.
 */
package org.hibernate.grammars.hql;

import org.antlr.v4.runtime.atn.*;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.*;
import org.antlr.v4.runtime.misc.*;
import org.antlr.v4.runtime.tree.*;
import java.util.List;
import java.util.Iterator;
import java.util.ArrayList;

@SuppressWarnings({"all", "warnings", "unchecked", "unused", "cast", "CheckReturnValue"})
public class HqlParser extends Parser {
	static { RuntimeMetaData.checkVersion("4.13.0", RuntimeMetaData.VERSION); }

	protected static final DFA[] _decisionToDFA;
	protected static final PredictionContextCache _sharedContextCache =
		new PredictionContextCache();
	public static final int
		WS=1, COMMENT=2, INTEGER_LITERAL=3, LONG_LITERAL=4, FLOAT_LITERAL=5, DOUBLE_LITERAL=6, 
		BIG_INTEGER_LITERAL=7, BIG_DECIMAL_LITERAL=8, HEX_LITERAL=9, STRING_LITERAL=10, 
		JAVA_STRING_LITERAL=11, BINARY_LITERAL=12, TIMESTAMP_ESCAPE_START=13, 
		DATE_ESCAPE_START=14, TIME_ESCAPE_START=15, EQUAL=16, NOT_EQUAL=17, GREATER=18, 
		GREATER_EQUAL=19, LESS=20, LESS_EQUAL=21, COMMA=22, DOT=23, LEFT_PAREN=24, 
		RIGHT_PAREN=25, LEFT_BRACKET=26, RIGHT_BRACKET=27, LEFT_BRACE=28, RIGHT_BRACE=29, 
		PLUS=30, MINUS=31, ASTERISK=32, SLASH=33, PERCENT_OP=34, AMPERSAND=35, 
		SEMICOLON=36, COLON=37, PIPE=38, DOUBLE_PIPE=39, QUESTION_MARK=40, ARROW=41, 
		ID=42, VERSION=43, VERSIONED=44, NATURALID=45, FK=46, ALL=47, AND=48, 
		ANY=49, AS=50, ASC=51, AVG=52, BETWEEN=53, BOTH=54, BREADTH=55, BY=56, 
		CASE=57, CAST=58, COLLATE=59, COLUMN=60, CONFLICT=61, CONSTRAINT=62, COUNT=63, 
		CROSS=64, CUBE=65, CURRENT=66, CURRENT_DATE=67, CURRENT_INSTANT=68, CURRENT_TIME=69, 
		CURRENT_TIMESTAMP=70, CYCLE=71, DATE=72, DATETIME=73, DAY=74, DEFAULT=75, 
		DELETE=76, DEPTH=77, DESC=78, DISTINCT=79, DO=80, ELEMENT=81, ELEMENTS=82, 
		ELSE=83, EMPTY=84, END=85, ENTRY=86, EPOCH=87, ERROR=88, ESCAPE=89, EVERY=90, 
		EXCEPT=91, EXCLUDE=92, EXISTS=93, EXTRACT=94, FETCH=95, FILTER=96, FIRST=97, 
		FOLLOWING=98, FOR=99, FORMAT=100, FROM=101, FULL=102, FUNCTION=103, GROUP=104, 
		GROUPS=105, HAVING=106, HOUR=107, IGNORE=108, ILIKE=109, IN=110, INDEX=111, 
		INDICES=112, INNER=113, INSERT=114, INSTANT=115, INTERSECT=116, INTO=117, 
		IS=118, JOIN=119, KEY=120, KEYS=121, LAST=122, LATERAL=123, LEADING=124, 
		LEFT=125, LIKE=126, LIMIT=127, LIST=128, LISTAGG=129, LOCAL=130, LOCAL_DATE=131, 
		LOCAL_DATETIME=132, LOCAL_TIME=133, MAP=134, MATERIALIZED=135, MAX=136, 
		MAXELEMENT=137, MAXINDEX=138, MEMBER=139, MICROSECOND=140, MILLISECOND=141, 
		MIN=142, MINELEMENT=143, MININDEX=144, MINUTE=145, MONTH=146, NANOSECOND=147, 
		NEW=148, NEXT=149, NO=150, NOT=151, NOTHING=152, NULLS=153, OBJECT=154, 
		OF=155, OFFSET=156, OFFSET_DATETIME=157, ON=158, ONLY=159, OR=160, ORDER=161, 
		OTHERS=162, OUTER=163, OVER=164, OVERFLOW=165, OVERLAY=166, PAD=167, PARTITION=168, 
		PERCENT=169, PLACING=170, POSITION=171, PRECEDING=172, QUARTER=173, RANGE=174, 
		RESPECT=175, RIGHT=176, ROLLUP=177, ROW=178, ROWS=179, SEARCH=180, SECOND=181, 
		SELECT=182, SET=183, SIZE=184, SOME=185, SUBSTRING=186, SUM=187, THEN=188, 
		TIES=189, TIME=190, TIMESTAMP=191, TIMEZONE_HOUR=192, TIMEZONE_MINUTE=193, 
		TO=194, TRAILING=195, TREAT=196, TRIM=197, TRUNC=198, TRUNCATE=199, TYPE=200, 
		UNBOUNDED=201, UNION=202, UPDATE=203, USING=204, VALUE=205, VALUES=206, 
		WEEK=207, WHEN=208, WHERE=209, WITH=210, WITHIN=211, WITHOUT=212, YEAR=213, 
		ZONED=214, TRUE=215, FALSE=216, NULL=217, IDENTIFIER=218, QUOTED_IDENTIFIER=219;
	public static final int
		RULE_statement = 0, RULE_selectStatement = 1, RULE_subquery = 2, RULE_targetEntity = 3, 
		RULE_deleteStatement = 4, RULE_updateStatement = 5, RULE_setClause = 6, 
		RULE_assignment = 7, RULE_insertStatement = 8, RULE_targetFields = 9, 
		RULE_valuesList = 10, RULE_values = 11, RULE_conflictClause = 12, RULE_conflictTarget = 13, 
		RULE_conflictAction = 14, RULE_withClause = 15, RULE_cte = 16, RULE_cteAttributes = 17, 
		RULE_searchClause = 18, RULE_searchSpecifications = 19, RULE_searchSpecification = 20, 
		RULE_cycleClause = 21, RULE_queryExpression = 22, RULE_orderedQuery = 23, 
		RULE_setOperator = 24, RULE_queryOrder = 25, RULE_query = 26, RULE_fromClause = 27, 
		RULE_entityWithJoins = 28, RULE_fromRoot = 29, RULE_entityName = 30, RULE_variable = 31, 
		RULE_crossJoin = 32, RULE_jpaCollectionJoin = 33, RULE_join = 34, RULE_joinType = 35, 
		RULE_joinTarget = 36, RULE_joinRestriction = 37, RULE_selectClause = 38, 
		RULE_selectionList = 39, RULE_selection = 40, RULE_selectExpression = 41, 
		RULE_mapEntrySelection = 42, RULE_instantiation = 43, RULE_instantiationTarget = 44, 
		RULE_instantiationArguments = 45, RULE_instantiationArgument = 46, RULE_instantiationArgumentExpression = 47, 
		RULE_jpaSelectObjectSyntax = 48, RULE_simplePath = 49, RULE_simplePathElement = 50, 
		RULE_path = 51, RULE_pathContinuation = 52, RULE_syntacticDomainPath = 53, 
		RULE_generalPathFragment = 54, RULE_indexedPathAccessFragment = 55, RULE_treatedNavigablePath = 56, 
		RULE_collectionValueNavigablePath = 57, RULE_mapKeyNavigablePath = 58, 
		RULE_groupByClause = 59, RULE_groupByExpression = 60, RULE_havingClause = 61, 
		RULE_orderByClause = 62, RULE_orderByFragment = 63, RULE_sortSpecification = 64, 
		RULE_nullsPrecedence = 65, RULE_sortExpression = 66, RULE_sortDirection = 67, 
		RULE_collateFunction = 68, RULE_collation = 69, RULE_limitClause = 70, 
		RULE_offsetClause = 71, RULE_fetchClause = 72, RULE_fetchCountOrPercent = 73, 
		RULE_parameterOrIntegerLiteral = 74, RULE_parameterOrNumberLiteral = 75, 
		RULE_whereClause = 76, RULE_predicate = 77, RULE_comparisonOperator = 78, 
		RULE_inList = 79, RULE_likeEscape = 80, RULE_expression = 81, RULE_primaryExpression = 82, 
		RULE_expressionOrPredicate = 83, RULE_collectionQuantifier = 84, RULE_elementValueQuantifier = 85, 
		RULE_indexKeyQuantifier = 86, RULE_elementsValuesQuantifier = 87, RULE_indicesKeysQuantifier = 88, 
		RULE_multiplicativeOperator = 89, RULE_additiveOperator = 90, RULE_signOperator = 91, 
		RULE_entityTypeReference = 92, RULE_entityIdReference = 93, RULE_entityVersionReference = 94, 
		RULE_entityNaturalIdReference = 95, RULE_toOneFkReference = 96, RULE_caseList = 97, 
		RULE_simpleCaseList = 98, RULE_simpleCaseWhen = 99, RULE_caseOtherwise = 100, 
		RULE_searchedCaseList = 101, RULE_searchedCaseWhen = 102, RULE_literal = 103, 
		RULE_booleanLiteral = 104, RULE_numericLiteral = 105, RULE_binaryLiteral = 106, 
		RULE_temporalLiteral = 107, RULE_dateTimeLiteral = 108, RULE_localDateTimeLiteral = 109, 
		RULE_zonedDateTimeLiteral = 110, RULE_offsetDateTimeLiteral = 111, RULE_dateLiteral = 112, 
		RULE_timeLiteral = 113, RULE_dateTime = 114, RULE_localDateTime = 115, 
		RULE_zonedDateTime = 116, RULE_offsetDateTime = 117, RULE_offsetDateTimeWithMinutes = 118, 
		RULE_date = 119, RULE_time = 120, RULE_offset = 121, RULE_offsetWithMinutes = 122, 
		RULE_year = 123, RULE_month = 124, RULE_day = 125, RULE_hour = 126, RULE_minute = 127, 
		RULE_second = 128, RULE_zoneId = 129, RULE_jdbcTimestampLiteral = 130, 
		RULE_jdbcDateLiteral = 131, RULE_jdbcTimeLiteral = 132, RULE_genericTemporalLiteralText = 133, 
		RULE_generalizedLiteral = 134, RULE_generalizedLiteralType = 135, RULE_generalizedLiteralText = 136, 
		RULE_parameter = 137, RULE_function = 138, RULE_jpaNonstandardFunction = 139, 
		RULE_jpaNonstandardFunctionName = 140, RULE_columnFunction = 141, RULE_genericFunction = 142, 
		RULE_genericFunctionName = 143, RULE_genericFunctionArguments = 144, RULE_collectionSizeFunction = 145, 
		RULE_collectionAggregateFunction = 146, RULE_collectionFunctionMisuse = 147, 
		RULE_aggregateFunction = 148, RULE_everyFunction = 149, RULE_anyFunction = 150, 
		RULE_everyAllQuantifier = 151, RULE_anySomeQuantifier = 152, RULE_listaggFunction = 153, 
		RULE_onOverflowClause = 154, RULE_withinGroupClause = 155, RULE_filterClause = 156, 
		RULE_nullsClause = 157, RULE_nthSideClause = 158, RULE_overClause = 159, 
		RULE_partitionClause = 160, RULE_frameClause = 161, RULE_frameStart = 162, 
		RULE_frameEnd = 163, RULE_frameExclusion = 164, RULE_standardFunction = 165, 
		RULE_castFunction = 166, RULE_castTarget = 167, RULE_castTargetType = 168, 
		RULE_substringFunction = 169, RULE_substringFunctionStartArgument = 170, 
		RULE_substringFunctionLengthArgument = 171, RULE_trimFunction = 172, RULE_trimSpecification = 173, 
		RULE_trimCharacter = 174, RULE_padFunction = 175, RULE_padSpecification = 176, 
		RULE_padCharacter = 177, RULE_padLength = 178, RULE_overlayFunction = 179, 
		RULE_overlayFunctionStringArgument = 180, RULE_overlayFunctionReplacementArgument = 181, 
		RULE_overlayFunctionStartArgument = 182, RULE_overlayFunctionLengthArgument = 183, 
		RULE_currentDateFunction = 184, RULE_currentTimeFunction = 185, RULE_currentTimestampFunction = 186, 
		RULE_instantFunction = 187, RULE_localDateTimeFunction = 188, RULE_offsetDateTimeFunction = 189, 
		RULE_localDateFunction = 190, RULE_localTimeFunction = 191, RULE_formatFunction = 192, 
		RULE_format = 193, RULE_extractFunction = 194, RULE_truncFunction = 195, 
		RULE_extractField = 196, RULE_datetimeField = 197, RULE_dayField = 198, 
		RULE_weekField = 199, RULE_timeZoneField = 200, RULE_dateOrTimeField = 201, 
		RULE_positionFunction = 202, RULE_positionFunctionPatternArgument = 203, 
		RULE_positionFunctionStringArgument = 204, RULE_cube = 205, RULE_rollup = 206, 
		RULE_nakedIdentifier = 207, RULE_identifier = 208;
	private static String[] makeRuleNames() {
		return new String[] {
			"statement", "selectStatement", "subquery", "targetEntity", "deleteStatement", 
			"updateStatement", "setClause", "assignment", "insertStatement", "targetFields", 
			"valuesList", "values", "conflictClause", "conflictTarget", "conflictAction", 
			"withClause", "cte", "cteAttributes", "searchClause", "searchSpecifications", 
			"searchSpecification", "cycleClause", "queryExpression", "orderedQuery", 
			"setOperator", "queryOrder", "query", "fromClause", "entityWithJoins", 
			"fromRoot", "entityName", "variable", "crossJoin", "jpaCollectionJoin", 
			"join", "joinType", "joinTarget", "joinRestriction", "selectClause", 
			"selectionList", "selection", "selectExpression", "mapEntrySelection", 
			"instantiation", "instantiationTarget", "instantiationArguments", "instantiationArgument", 
			"instantiationArgumentExpression", "jpaSelectObjectSyntax", "simplePath", 
			"simplePathElement", "path", "pathContinuation", "syntacticDomainPath", 
			"generalPathFragment", "indexedPathAccessFragment", "treatedNavigablePath", 
			"collectionValueNavigablePath", "mapKeyNavigablePath", "groupByClause", 
			"groupByExpression", "havingClause", "orderByClause", "orderByFragment", 
			"sortSpecification", "nullsPrecedence", "sortExpression", "sortDirection", 
			"collateFunction", "collation", "limitClause", "offsetClause", "fetchClause", 
			"fetchCountOrPercent", "parameterOrIntegerLiteral", "parameterOrNumberLiteral", 
			"whereClause", "predicate", "comparisonOperator", "inList", "likeEscape", 
			"expression", "primaryExpression", "expressionOrPredicate", "collectionQuantifier", 
			"elementValueQuantifier", "indexKeyQuantifier", "elementsValuesQuantifier", 
			"indicesKeysQuantifier", "multiplicativeOperator", "additiveOperator", 
			"signOperator", "entityTypeReference", "entityIdReference", "entityVersionReference", 
			"entityNaturalIdReference", "toOneFkReference", "caseList", "simpleCaseList", 
			"simpleCaseWhen", "caseOtherwise", "searchedCaseList", "searchedCaseWhen", 
			"literal", "booleanLiteral", "numericLiteral", "binaryLiteral", "temporalLiteral", 
			"dateTimeLiteral", "localDateTimeLiteral", "zonedDateTimeLiteral", "offsetDateTimeLiteral", 
			"dateLiteral", "timeLiteral", "dateTime", "localDateTime", "zonedDateTime", 
			"offsetDateTime", "offsetDateTimeWithMinutes", "date", "time", "offset", 
			"offsetWithMinutes", "year", "month", "day", "hour", "minute", "second", 
			"zoneId", "jdbcTimestampLiteral", "jdbcDateLiteral", "jdbcTimeLiteral", 
			"genericTemporalLiteralText", "generalizedLiteral", "generalizedLiteralType", 
			"generalizedLiteralText", "parameter", "function", "jpaNonstandardFunction", 
			"jpaNonstandardFunctionName", "columnFunction", "genericFunction", "genericFunctionName", 
			"genericFunctionArguments", "collectionSizeFunction", "collectionAggregateFunction", 
			"collectionFunctionMisuse", "aggregateFunction", "everyFunction", "anyFunction", 
			"everyAllQuantifier", "anySomeQuantifier", "listaggFunction", "onOverflowClause", 
			"withinGroupClause", "filterClause", "nullsClause", "nthSideClause", 
			"overClause", "partitionClause", "frameClause", "frameStart", "frameEnd", 
			"frameExclusion", "standardFunction", "castFunction", "castTarget", "castTargetType", 
			"substringFunction", "substringFunctionStartArgument", "substringFunctionLengthArgument", 
			"trimFunction", "trimSpecification", "trimCharacter", "padFunction", 
			"padSpecification", "padCharacter", "padLength", "overlayFunction", "overlayFunctionStringArgument", 
			"overlayFunctionReplacementArgument", "overlayFunctionStartArgument", 
			"overlayFunctionLengthArgument", "currentDateFunction", "currentTimeFunction", 
			"currentTimestampFunction", "instantFunction", "localDateTimeFunction", 
			"offsetDateTimeFunction", "localDateFunction", "localTimeFunction", "formatFunction", 
			"format", "extractFunction", "truncFunction", "extractField", "datetimeField", 
			"dayField", "weekField", "timeZoneField", "dateOrTimeField", "positionFunction", 
			"positionFunctionPatternArgument", "positionFunctionStringArgument", 
			"cube", "rollup", "nakedIdentifier", "identifier"
		};
	}
	public static final String[] ruleNames = makeRuleNames();

	private static String[] makeLiteralNames() {
		return new String[] {
			null, null, null, null, null, null, null, null, null, null, null, null, 
			null, "'{ts'", "'{d'", "'{t'", "'='", null, "'>'", "'>='", "'<'", "'<='", 
			"','", "'.'", "'('", "')'", "'['", "']'", "'{'", "'}'", "'+'", "'-'", 
			"'*'", "'/'", "'%'", "'&'", "';'", "':'", "'|'", "'||'", "'?'", "'->'"
		};
	}
	private static final String[] _LITERAL_NAMES = makeLiteralNames();
	private static String[] makeSymbolicNames() {
		return new String[] {
			null, "WS", "COMMENT", "INTEGER_LITERAL", "LONG_LITERAL", "FLOAT_LITERAL", 
			"DOUBLE_LITERAL", "BIG_INTEGER_LITERAL", "BIG_DECIMAL_LITERAL", "HEX_LITERAL", 
			"STRING_LITERAL", "JAVA_STRING_LITERAL", "BINARY_LITERAL", "TIMESTAMP_ESCAPE_START", 
			"DATE_ESCAPE_START", "TIME_ESCAPE_START", "EQUAL", "NOT_EQUAL", "GREATER", 
			"GREATER_EQUAL", "LESS", "LESS_EQUAL", "COMMA", "DOT", "LEFT_PAREN", 
			"RIGHT_PAREN", "LEFT_BRACKET", "RIGHT_BRACKET", "LEFT_BRACE", "RIGHT_BRACE", 
			"PLUS", "MINUS", "ASTERISK", "SLASH", "PERCENT_OP", "AMPERSAND", "SEMICOLON", 
			"COLON", "PIPE", "DOUBLE_PIPE", "QUESTION_MARK", "ARROW", "ID", "VERSION", 
			"VERSIONED", "NATURALID", "FK", "ALL", "AND", "ANY", "AS", "ASC", "AVG", 
			"BETWEEN", "BOTH", "BREADTH", "BY", "CASE", "CAST", "COLLATE", "COLUMN", 
			"CONFLICT", "CONSTRAINT", "COUNT", "CROSS", "CUBE", "CURRENT", "CURRENT_DATE", 
			"CURRENT_INSTANT", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CYCLE", "DATE", 
			"DATETIME", "DAY", "DEFAULT", "DELETE", "DEPTH", "DESC", "DISTINCT", 
			"DO", "ELEMENT", "ELEMENTS", "ELSE", "EMPTY", "END", "ENTRY", "EPOCH", 
			"ERROR", "ESCAPE", "EVERY", "EXCEPT", "EXCLUDE", "EXISTS", "EXTRACT", 
			"FETCH", "FILTER", "FIRST", "FOLLOWING", "FOR", "FORMAT", "FROM", "FULL", 
			"FUNCTION", "GROUP", "GROUPS", "HAVING", "HOUR", "IGNORE", "ILIKE", "IN", 
			"INDEX", "INDICES", "INNER", "INSERT", "INSTANT", "INTERSECT", "INTO", 
			"IS", "JOIN", "KEY", "KEYS", "LAST", "LATERAL", "LEADING", "LEFT", "LIKE", 
			"LIMIT", "LIST", "LISTAGG", "LOCAL", "LOCAL_DATE", "LOCAL_DATETIME", 
			"LOCAL_TIME", "MAP", "MATERIALIZED", "MAX", "MAXELEMENT", "MAXINDEX", 
			"MEMBER", "MICROSECOND", "MILLISECOND", "MIN", "MINELEMENT", "MININDEX", 
			"MINUTE", "MONTH", "NANOSECOND", "NEW", "NEXT", "NO", "NOT", "NOTHING", 
			"NULLS", "OBJECT", "OF", "OFFSET", "OFFSET_DATETIME", "ON", "ONLY", "OR", 
			"ORDER", "OTHERS", "OUTER", "OVER", "OVERFLOW", "OVERLAY", "PAD", "PARTITION", 
			"PERCENT", "PLACING", "POSITION", "PRECEDING", "QUARTER", "RANGE", "RESPECT", 
			"RIGHT", "ROLLUP", "ROW", "ROWS", "SEARCH", "SECOND", "SELECT", "SET", 
			"SIZE", "SOME", "SUBSTRING", "SUM", "THEN", "TIES", "TIME", "TIMESTAMP", 
			"TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TO", "TRAILING", "TREAT", "TRIM", 
			"TRUNC", "TRUNCATE", "TYPE", "UNBOUNDED", "UNION", "UPDATE", "USING", 
			"VALUE", "VALUES", "WEEK", "WHEN", "WHERE", "WITH", "WITHIN", "WITHOUT", 
			"YEAR", "ZONED", "TRUE", "FALSE", "NULL", "IDENTIFIER", "QUOTED_IDENTIFIER"
		};
	}
	private static final String[] _SYMBOLIC_NAMES = makeSymbolicNames();
	public static final Vocabulary VOCABULARY = new VocabularyImpl(_LITERAL_NAMES, _SYMBOLIC_NAMES);

	/**
	 * @deprecated Use {@link #VOCABULARY} instead.
	 */
	@Deprecated
	public static final String[] tokenNames;
	static {
		tokenNames = new String[_SYMBOLIC_NAMES.length];
		for (int i = 0; i < tokenNames.length; i++) {
			tokenNames[i] = VOCABULARY.getLiteralName(i);
			if (tokenNames[i] == null) {
				tokenNames[i] = VOCABULARY.getSymbolicName(i);
			}

			if (tokenNames[i] == null) {
				tokenNames[i] = "<INVALID>";
			}
		}
	}

	@Override
	@Deprecated
	public String[] getTokenNames() {
		return tokenNames;
	}

	@Override

	public Vocabulary getVocabulary() {
		return VOCABULARY;
	}

	@Override
	public String getGrammarFileName() { return "HqlParser.g4"; }

	@Override
	public String[] getRuleNames() { return ruleNames; }

	@Override
	public String getSerializedATN() { return _serializedATN; }

	@Override
	public ATN getATN() { return _ATN; }


		protected void logUseOfReservedWordAsIdentifier(Token token) {
		}

	public HqlParser(TokenStream input) {
		super(input);
		_interp = new ParserATNSimulator(this,_ATN,_decisionToDFA,_sharedContextCache);
	}

	@SuppressWarnings("CheckReturnValue")
	public static class StatementContext extends ParserRuleContext {
		public TerminalNode EOF() { return getToken(HqlParser.EOF, 0); }
		public SelectStatementContext selectStatement() {
			return getRuleContext(SelectStatementContext.class,0);
		}
		public UpdateStatementContext updateStatement() {
			return getRuleContext(UpdateStatementContext.class,0);
		}
		public DeleteStatementContext deleteStatement() {
			return getRuleContext(DeleteStatementContext.class,0);
		}
		public InsertStatementContext insertStatement() {
			return getRuleContext(InsertStatementContext.class,0);
		}
		public StatementContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_statement; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterStatement(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitStatement(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitStatement(this);
			else return visitor.visitChildren(this);
		}
	}

	public final StatementContext statement() throws RecognitionException {
		StatementContext _localctx = new StatementContext(_ctx, getState());
		enterRule(_localctx, 0, RULE_statement);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(422);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case LEFT_PAREN:
			case FROM:
			case ORDER:
			case SELECT:
			case WHERE:
			case WITH:
				{
				setState(418);
				selectStatement();
				}
				break;
			case UPDATE:
				{
				setState(419);
				updateStatement();
				}
				break;
			case DELETE:
				{
				setState(420);
				deleteStatement();
				}
				break;
			case INSERT:
				{
				setState(421);
				insertStatement();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
			setState(424);
			match(EOF);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SelectStatementContext extends ParserRuleContext {
		public QueryExpressionContext queryExpression() {
			return getRuleContext(QueryExpressionContext.class,0);
		}
		public SelectStatementContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_selectStatement; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSelectStatement(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSelectStatement(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSelectStatement(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SelectStatementContext selectStatement() throws RecognitionException {
		SelectStatementContext _localctx = new SelectStatementContext(_ctx, getState());
		enterRule(_localctx, 2, RULE_selectStatement);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(426);
			queryExpression();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SubqueryContext extends ParserRuleContext {
		public QueryExpressionContext queryExpression() {
			return getRuleContext(QueryExpressionContext.class,0);
		}
		public SubqueryContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_subquery; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSubquery(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSubquery(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSubquery(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SubqueryContext subquery() throws RecognitionException {
		SubqueryContext _localctx = new SubqueryContext(_ctx, getState());
		enterRule(_localctx, 4, RULE_subquery);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(428);
			queryExpression();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class TargetEntityContext extends ParserRuleContext {
		public EntityNameContext entityName() {
			return getRuleContext(EntityNameContext.class,0);
		}
		public VariableContext variable() {
			return getRuleContext(VariableContext.class,0);
		}
		public TargetEntityContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_targetEntity; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTargetEntity(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTargetEntity(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTargetEntity(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TargetEntityContext targetEntity() throws RecognitionException {
		TargetEntityContext _localctx = new TargetEntityContext(_ctx, getState());
		enterRule(_localctx, 6, RULE_targetEntity);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(430);
			entityName();
			setState(432);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (((((_la - 42)) & ~0x3f) == 0 && ((1L << (_la - 42)) & -1152921504606846977L) != 0) || ((((_la - 106)) & ~0x3f) == 0 && ((1L << (_la - 106)) & -144115188076380289L) != 0) || ((((_la - 170)) & ~0x3f) == 0 && ((1L << (_la - 170)) & 879609302220735L) != 0)) {
				{
				setState(431);
				variable();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class DeleteStatementContext extends ParserRuleContext {
		public TerminalNode DELETE() { return getToken(HqlParser.DELETE, 0); }
		public EntityWithJoinsContext entityWithJoins() {
			return getRuleContext(EntityWithJoinsContext.class,0);
		}
		public TerminalNode FROM() { return getToken(HqlParser.FROM, 0); }
		public WhereClauseContext whereClause() {
			return getRuleContext(WhereClauseContext.class,0);
		}
		public DeleteStatementContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_deleteStatement; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterDeleteStatement(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitDeleteStatement(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitDeleteStatement(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DeleteStatementContext deleteStatement() throws RecognitionException {
		DeleteStatementContext _localctx = new DeleteStatementContext(_ctx, getState());
		enterRule(_localctx, 8, RULE_deleteStatement);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(434);
			match(DELETE);
			setState(436);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,2,_ctx) ) {
			case 1:
				{
				setState(435);
				match(FROM);
				}
				break;
			}
			setState(438);
			entityWithJoins();
			setState(440);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==WHERE) {
				{
				setState(439);
				whereClause();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class UpdateStatementContext extends ParserRuleContext {
		public TerminalNode UPDATE() { return getToken(HqlParser.UPDATE, 0); }
		public EntityWithJoinsContext entityWithJoins() {
			return getRuleContext(EntityWithJoinsContext.class,0);
		}
		public SetClauseContext setClause() {
			return getRuleContext(SetClauseContext.class,0);
		}
		public TerminalNode VERSIONED() { return getToken(HqlParser.VERSIONED, 0); }
		public WhereClauseContext whereClause() {
			return getRuleContext(WhereClauseContext.class,0);
		}
		public UpdateStatementContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_updateStatement; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterUpdateStatement(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitUpdateStatement(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitUpdateStatement(this);
			else return visitor.visitChildren(this);
		}
	}

	public final UpdateStatementContext updateStatement() throws RecognitionException {
		UpdateStatementContext _localctx = new UpdateStatementContext(_ctx, getState());
		enterRule(_localctx, 10, RULE_updateStatement);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(442);
			match(UPDATE);
			setState(444);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,4,_ctx) ) {
			case 1:
				{
				setState(443);
				match(VERSIONED);
				}
				break;
			}
			setState(446);
			entityWithJoins();
			setState(447);
			setClause();
			setState(449);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==WHERE) {
				{
				setState(448);
				whereClause();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SetClauseContext extends ParserRuleContext {
		public TerminalNode SET() { return getToken(HqlParser.SET, 0); }
		public List<AssignmentContext> assignment() {
			return getRuleContexts(AssignmentContext.class);
		}
		public AssignmentContext assignment(int i) {
			return getRuleContext(AssignmentContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public SetClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_setClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSetClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSetClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSetClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SetClauseContext setClause() throws RecognitionException {
		SetClauseContext _localctx = new SetClauseContext(_ctx, getState());
		enterRule(_localctx, 12, RULE_setClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(451);
			match(SET);
			setState(452);
			assignment();
			setState(457);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(453);
				match(COMMA);
				setState(454);
				assignment();
				}
				}
				setState(459);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class AssignmentContext extends ParserRuleContext {
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public TerminalNode EQUAL() { return getToken(HqlParser.EQUAL, 0); }
		public ExpressionOrPredicateContext expressionOrPredicate() {
			return getRuleContext(ExpressionOrPredicateContext.class,0);
		}
		public AssignmentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_assignment; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterAssignment(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitAssignment(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitAssignment(this);
			else return visitor.visitChildren(this);
		}
	}

	public final AssignmentContext assignment() throws RecognitionException {
		AssignmentContext _localctx = new AssignmentContext(_ctx, getState());
		enterRule(_localctx, 14, RULE_assignment);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(460);
			simplePath();
			setState(461);
			match(EQUAL);
			setState(462);
			expressionOrPredicate();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class InsertStatementContext extends ParserRuleContext {
		public TerminalNode INSERT() { return getToken(HqlParser.INSERT, 0); }
		public TargetEntityContext targetEntity() {
			return getRuleContext(TargetEntityContext.class,0);
		}
		public TargetFieldsContext targetFields() {
			return getRuleContext(TargetFieldsContext.class,0);
		}
		public QueryExpressionContext queryExpression() {
			return getRuleContext(QueryExpressionContext.class,0);
		}
		public ValuesListContext valuesList() {
			return getRuleContext(ValuesListContext.class,0);
		}
		public TerminalNode INTO() { return getToken(HqlParser.INTO, 0); }
		public ConflictClauseContext conflictClause() {
			return getRuleContext(ConflictClauseContext.class,0);
		}
		public InsertStatementContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_insertStatement; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterInsertStatement(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitInsertStatement(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitInsertStatement(this);
			else return visitor.visitChildren(this);
		}
	}

	public final InsertStatementContext insertStatement() throws RecognitionException {
		InsertStatementContext _localctx = new InsertStatementContext(_ctx, getState());
		enterRule(_localctx, 16, RULE_insertStatement);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(464);
			match(INSERT);
			setState(466);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,7,_ctx) ) {
			case 1:
				{
				setState(465);
				match(INTO);
				}
				break;
			}
			setState(468);
			targetEntity();
			setState(469);
			targetFields();
			setState(472);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case LEFT_PAREN:
			case FROM:
			case ORDER:
			case SELECT:
			case WHERE:
			case WITH:
				{
				setState(470);
				queryExpression();
				}
				break;
			case VALUES:
				{
				setState(471);
				valuesList();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
			setState(475);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==ON) {
				{
				setState(474);
				conflictClause();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class TargetFieldsContext extends ParserRuleContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public List<SimplePathContext> simplePath() {
			return getRuleContexts(SimplePathContext.class);
		}
		public SimplePathContext simplePath(int i) {
			return getRuleContext(SimplePathContext.class,i);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public TargetFieldsContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_targetFields; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTargetFields(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTargetFields(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTargetFields(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TargetFieldsContext targetFields() throws RecognitionException {
		TargetFieldsContext _localctx = new TargetFieldsContext(_ctx, getState());
		enterRule(_localctx, 18, RULE_targetFields);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(477);
			match(LEFT_PAREN);
			setState(478);
			simplePath();
			setState(483);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(479);
				match(COMMA);
				setState(480);
				simplePath();
				}
				}
				setState(485);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			setState(486);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class ValuesListContext extends ParserRuleContext {
		public TerminalNode VALUES() { return getToken(HqlParser.VALUES, 0); }
		public List<ValuesContext> values() {
			return getRuleContexts(ValuesContext.class);
		}
		public ValuesContext values(int i) {
			return getRuleContext(ValuesContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public ValuesListContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_valuesList; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterValuesList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitValuesList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitValuesList(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ValuesListContext valuesList() throws RecognitionException {
		ValuesListContext _localctx = new ValuesListContext(_ctx, getState());
		enterRule(_localctx, 20, RULE_valuesList);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(488);
			match(VALUES);
			setState(489);
			values();
			setState(494);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(490);
				match(COMMA);
				setState(491);
				values();
				}
				}
				setState(496);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class ValuesContext extends ParserRuleContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public List<ExpressionOrPredicateContext> expressionOrPredicate() {
			return getRuleContexts(ExpressionOrPredicateContext.class);
		}
		public ExpressionOrPredicateContext expressionOrPredicate(int i) {
			return getRuleContext(ExpressionOrPredicateContext.class,i);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public ValuesContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_values; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterValues(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitValues(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitValues(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ValuesContext values() throws RecognitionException {
		ValuesContext _localctx = new ValuesContext(_ctx, getState());
		enterRule(_localctx, 22, RULE_values);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(497);
			match(LEFT_PAREN);
			setState(498);
			expressionOrPredicate();
			setState(503);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(499);
				match(COMMA);
				setState(500);
				expressionOrPredicate();
				}
				}
				setState(505);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			setState(506);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class ConflictClauseContext extends ParserRuleContext {
		public TerminalNode ON() { return getToken(HqlParser.ON, 0); }
		public TerminalNode CONFLICT() { return getToken(HqlParser.CONFLICT, 0); }
		public TerminalNode DO() { return getToken(HqlParser.DO, 0); }
		public ConflictActionContext conflictAction() {
			return getRuleContext(ConflictActionContext.class,0);
		}
		public ConflictTargetContext conflictTarget() {
			return getRuleContext(ConflictTargetContext.class,0);
		}
		public ConflictClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_conflictClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterConflictClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitConflictClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitConflictClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ConflictClauseContext conflictClause() throws RecognitionException {
		ConflictClauseContext _localctx = new ConflictClauseContext(_ctx, getState());
		enterRule(_localctx, 24, RULE_conflictClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(508);
			match(ON);
			setState(509);
			match(CONFLICT);
			setState(511);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==LEFT_PAREN || _la==ON) {
				{
				setState(510);
				conflictTarget();
				}
			}

			setState(513);
			match(DO);
			setState(514);
			conflictAction();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class ConflictTargetContext extends ParserRuleContext {
		public TerminalNode ON() { return getToken(HqlParser.ON, 0); }
		public TerminalNode CONSTRAINT() { return getToken(HqlParser.CONSTRAINT, 0); }
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public List<SimplePathContext> simplePath() {
			return getRuleContexts(SimplePathContext.class);
		}
		public SimplePathContext simplePath(int i) {
			return getRuleContext(SimplePathContext.class,i);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public ConflictTargetContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_conflictTarget; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterConflictTarget(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitConflictTarget(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitConflictTarget(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ConflictTargetContext conflictTarget() throws RecognitionException {
		ConflictTargetContext _localctx = new ConflictTargetContext(_ctx, getState());
		enterRule(_localctx, 26, RULE_conflictTarget);
		int _la;
		try {
			setState(530);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case ON:
				enterOuterAlt(_localctx, 1);
				{
				setState(516);
				match(ON);
				setState(517);
				match(CONSTRAINT);
				setState(518);
				identifier();
				}
				break;
			case LEFT_PAREN:
				enterOuterAlt(_localctx, 2);
				{
				setState(519);
				match(LEFT_PAREN);
				setState(520);
				simplePath();
				setState(525);
				_errHandler.sync(this);
				_la = _input.LA(1);
				while (_la==COMMA) {
					{
					{
					setState(521);
					match(COMMA);
					setState(522);
					simplePath();
					}
					}
					setState(527);
					_errHandler.sync(this);
					_la = _input.LA(1);
				}
				setState(528);
				match(RIGHT_PAREN);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class ConflictActionContext extends ParserRuleContext {
		public TerminalNode NOTHING() { return getToken(HqlParser.NOTHING, 0); }
		public TerminalNode UPDATE() { return getToken(HqlParser.UPDATE, 0); }
		public SetClauseContext setClause() {
			return getRuleContext(SetClauseContext.class,0);
		}
		public WhereClauseContext whereClause() {
			return getRuleContext(WhereClauseContext.class,0);
		}
		public ConflictActionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_conflictAction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterConflictAction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitConflictAction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitConflictAction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ConflictActionContext conflictAction() throws RecognitionException {
		ConflictActionContext _localctx = new ConflictActionContext(_ctx, getState());
		enterRule(_localctx, 28, RULE_conflictAction);
		int _la;
		try {
			setState(538);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case NOTHING:
				enterOuterAlt(_localctx, 1);
				{
				setState(532);
				match(NOTHING);
				}
				break;
			case UPDATE:
				enterOuterAlt(_localctx, 2);
				{
				setState(533);
				match(UPDATE);
				setState(534);
				setClause();
				setState(536);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==WHERE) {
					{
					setState(535);
					whereClause();
					}
				}

				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class WithClauseContext extends ParserRuleContext {
		public TerminalNode WITH() { return getToken(HqlParser.WITH, 0); }
		public List<CteContext> cte() {
			return getRuleContexts(CteContext.class);
		}
		public CteContext cte(int i) {
			return getRuleContext(CteContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public WithClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_withClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterWithClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitWithClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitWithClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final WithClauseContext withClause() throws RecognitionException {
		WithClauseContext _localctx = new WithClauseContext(_ctx, getState());
		enterRule(_localctx, 30, RULE_withClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(540);
			match(WITH);
			setState(541);
			cte();
			setState(546);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(542);
				match(COMMA);
				setState(543);
				cte();
				}
				}
				setState(548);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class CteContext extends ParserRuleContext {
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public TerminalNode AS() { return getToken(HqlParser.AS, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public QueryExpressionContext queryExpression() {
			return getRuleContext(QueryExpressionContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode MATERIALIZED() { return getToken(HqlParser.MATERIALIZED, 0); }
		public SearchClauseContext searchClause() {
			return getRuleContext(SearchClauseContext.class,0);
		}
		public CycleClauseContext cycleClause() {
			return getRuleContext(CycleClauseContext.class,0);
		}
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public CteContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_cte; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCte(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCte(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCte(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CteContext cte() throws RecognitionException {
		CteContext _localctx = new CteContext(_ctx, getState());
		enterRule(_localctx, 32, RULE_cte);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(549);
			identifier();
			setState(550);
			match(AS);
			setState(555);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==MATERIALIZED || _la==NOT) {
				{
				setState(552);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==NOT) {
					{
					setState(551);
					match(NOT);
					}
				}

				setState(554);
				match(MATERIALIZED);
				}
			}

			setState(557);
			match(LEFT_PAREN);
			setState(558);
			queryExpression();
			setState(559);
			match(RIGHT_PAREN);
			setState(561);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==SEARCH) {
				{
				setState(560);
				searchClause();
				}
			}

			setState(564);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==CYCLE) {
				{
				setState(563);
				cycleClause();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class CteAttributesContext extends ParserRuleContext {
		public List<IdentifierContext> identifier() {
			return getRuleContexts(IdentifierContext.class);
		}
		public IdentifierContext identifier(int i) {
			return getRuleContext(IdentifierContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public CteAttributesContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_cteAttributes; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCteAttributes(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCteAttributes(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCteAttributes(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CteAttributesContext cteAttributes() throws RecognitionException {
		CteAttributesContext _localctx = new CteAttributesContext(_ctx, getState());
		enterRule(_localctx, 34, RULE_cteAttributes);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(566);
			identifier();
			setState(571);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(567);
				match(COMMA);
				setState(568);
				identifier();
				}
				}
				setState(573);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SearchClauseContext extends ParserRuleContext {
		public TerminalNode SEARCH() { return getToken(HqlParser.SEARCH, 0); }
		public TerminalNode FIRST() { return getToken(HqlParser.FIRST, 0); }
		public TerminalNode BY() { return getToken(HqlParser.BY, 0); }
		public SearchSpecificationsContext searchSpecifications() {
			return getRuleContext(SearchSpecificationsContext.class,0);
		}
		public TerminalNode SET() { return getToken(HqlParser.SET, 0); }
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public TerminalNode BREADTH() { return getToken(HqlParser.BREADTH, 0); }
		public TerminalNode DEPTH() { return getToken(HqlParser.DEPTH, 0); }
		public SearchClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_searchClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSearchClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSearchClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSearchClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SearchClauseContext searchClause() throws RecognitionException {
		SearchClauseContext _localctx = new SearchClauseContext(_ctx, getState());
		enterRule(_localctx, 36, RULE_searchClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(574);
			match(SEARCH);
			setState(575);
			_la = _input.LA(1);
			if ( !(_la==BREADTH || _la==DEPTH) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			setState(576);
			match(FIRST);
			setState(577);
			match(BY);
			setState(578);
			searchSpecifications();
			setState(579);
			match(SET);
			setState(580);
			identifier();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SearchSpecificationsContext extends ParserRuleContext {
		public List<SearchSpecificationContext> searchSpecification() {
			return getRuleContexts(SearchSpecificationContext.class);
		}
		public SearchSpecificationContext searchSpecification(int i) {
			return getRuleContext(SearchSpecificationContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public SearchSpecificationsContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_searchSpecifications; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSearchSpecifications(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSearchSpecifications(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSearchSpecifications(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SearchSpecificationsContext searchSpecifications() throws RecognitionException {
		SearchSpecificationsContext _localctx = new SearchSpecificationsContext(_ctx, getState());
		enterRule(_localctx, 38, RULE_searchSpecifications);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(582);
			searchSpecification();
			setState(587);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(583);
				match(COMMA);
				setState(584);
				searchSpecification();
				}
				}
				setState(589);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SearchSpecificationContext extends ParserRuleContext {
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public SortDirectionContext sortDirection() {
			return getRuleContext(SortDirectionContext.class,0);
		}
		public NullsPrecedenceContext nullsPrecedence() {
			return getRuleContext(NullsPrecedenceContext.class,0);
		}
		public SearchSpecificationContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_searchSpecification; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSearchSpecification(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSearchSpecification(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSearchSpecification(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SearchSpecificationContext searchSpecification() throws RecognitionException {
		SearchSpecificationContext _localctx = new SearchSpecificationContext(_ctx, getState());
		enterRule(_localctx, 40, RULE_searchSpecification);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(590);
			identifier();
			setState(592);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==ASC || _la==DESC) {
				{
				setState(591);
				sortDirection();
				}
			}

			setState(595);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==NULLS) {
				{
				setState(594);
				nullsPrecedence();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class CycleClauseContext extends ParserRuleContext {
		public TerminalNode CYCLE() { return getToken(HqlParser.CYCLE, 0); }
		public CteAttributesContext cteAttributes() {
			return getRuleContext(CteAttributesContext.class,0);
		}
		public TerminalNode SET() { return getToken(HqlParser.SET, 0); }
		public List<IdentifierContext> identifier() {
			return getRuleContexts(IdentifierContext.class);
		}
		public IdentifierContext identifier(int i) {
			return getRuleContext(IdentifierContext.class,i);
		}
		public TerminalNode TO() { return getToken(HqlParser.TO, 0); }
		public List<LiteralContext> literal() {
			return getRuleContexts(LiteralContext.class);
		}
		public LiteralContext literal(int i) {
			return getRuleContext(LiteralContext.class,i);
		}
		public TerminalNode DEFAULT() { return getToken(HqlParser.DEFAULT, 0); }
		public TerminalNode USING() { return getToken(HqlParser.USING, 0); }
		public CycleClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_cycleClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCycleClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCycleClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCycleClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CycleClauseContext cycleClause() throws RecognitionException {
		CycleClauseContext _localctx = new CycleClauseContext(_ctx, getState());
		enterRule(_localctx, 42, RULE_cycleClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(597);
			match(CYCLE);
			setState(598);
			cteAttributes();
			setState(599);
			match(SET);
			setState(600);
			identifier();
			setState(606);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==TO) {
				{
				setState(601);
				match(TO);
				setState(602);
				literal();
				setState(603);
				match(DEFAULT);
				setState(604);
				literal();
				}
			}

			setState(610);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==USING) {
				{
				setState(608);
				match(USING);
				setState(609);
				identifier();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class QueryExpressionContext extends ParserRuleContext {
		public QueryExpressionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_queryExpression; }
	 
		public QueryExpressionContext() { }
		public void copyFrom(QueryExpressionContext ctx) {
			super.copyFrom(ctx);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class SetQueryGroupContext extends QueryExpressionContext {
		public List<OrderedQueryContext> orderedQuery() {
			return getRuleContexts(OrderedQueryContext.class);
		}
		public OrderedQueryContext orderedQuery(int i) {
			return getRuleContext(OrderedQueryContext.class,i);
		}
		public WithClauseContext withClause() {
			return getRuleContext(WithClauseContext.class,0);
		}
		public List<SetOperatorContext> setOperator() {
			return getRuleContexts(SetOperatorContext.class);
		}
		public SetOperatorContext setOperator(int i) {
			return getRuleContext(SetOperatorContext.class,i);
		}
		public SetQueryGroupContext(QueryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSetQueryGroup(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSetQueryGroup(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSetQueryGroup(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class SimpleQueryGroupContext extends QueryExpressionContext {
		public OrderedQueryContext orderedQuery() {
			return getRuleContext(OrderedQueryContext.class,0);
		}
		public WithClauseContext withClause() {
			return getRuleContext(WithClauseContext.class,0);
		}
		public SimpleQueryGroupContext(QueryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSimpleQueryGroup(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSimpleQueryGroup(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSimpleQueryGroup(this);
			else return visitor.visitChildren(this);
		}
	}

	public final QueryExpressionContext queryExpression() throws RecognitionException {
		QueryExpressionContext _localctx = new QueryExpressionContext(_ctx, getState());
		enterRule(_localctx, 44, RULE_queryExpression);
		int _la;
		try {
			setState(627);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,32,_ctx) ) {
			case 1:
				_localctx = new SimpleQueryGroupContext(_localctx);
				enterOuterAlt(_localctx, 1);
				{
				setState(613);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==WITH) {
					{
					setState(612);
					withClause();
					}
				}

				setState(615);
				orderedQuery();
				}
				break;
			case 2:
				_localctx = new SetQueryGroupContext(_localctx);
				enterOuterAlt(_localctx, 2);
				{
				setState(617);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==WITH) {
					{
					setState(616);
					withClause();
					}
				}

				setState(619);
				orderedQuery();
				setState(623); 
				_errHandler.sync(this);
				_la = _input.LA(1);
				do {
					{
					{
					setState(620);
					setOperator();
					setState(621);
					orderedQuery();
					}
					}
					setState(625); 
					_errHandler.sync(this);
					_la = _input.LA(1);
				} while ( _la==EXCEPT || _la==INTERSECT || _la==UNION );
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class OrderedQueryContext extends ParserRuleContext {
		public OrderedQueryContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_orderedQuery; }
	 
		public OrderedQueryContext() { }
		public void copyFrom(OrderedQueryContext ctx) {
			super.copyFrom(ctx);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class QueryOrderExpressionContext extends OrderedQueryContext {
		public QueryOrderContext queryOrder() {
			return getRuleContext(QueryOrderContext.class,0);
		}
		public QueryOrderExpressionContext(OrderedQueryContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterQueryOrderExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitQueryOrderExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitQueryOrderExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class QuerySpecExpressionContext extends OrderedQueryContext {
		public QueryContext query() {
			return getRuleContext(QueryContext.class,0);
		}
		public QueryOrderContext queryOrder() {
			return getRuleContext(QueryOrderContext.class,0);
		}
		public QuerySpecExpressionContext(OrderedQueryContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterQuerySpecExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitQuerySpecExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitQuerySpecExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class NestedQueryExpressionContext extends OrderedQueryContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public QueryExpressionContext queryExpression() {
			return getRuleContext(QueryExpressionContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public QueryOrderContext queryOrder() {
			return getRuleContext(QueryOrderContext.class,0);
		}
		public NestedQueryExpressionContext(OrderedQueryContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterNestedQueryExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitNestedQueryExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitNestedQueryExpression(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OrderedQueryContext orderedQuery() throws RecognitionException {
		OrderedQueryContext _localctx = new OrderedQueryContext(_ctx, getState());
		enterRule(_localctx, 46, RULE_orderedQuery);
		int _la;
		try {
			setState(640);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case FROM:
			case SELECT:
			case WHERE:
				_localctx = new QuerySpecExpressionContext(_localctx);
				enterOuterAlt(_localctx, 1);
				{
				setState(629);
				query();
				setState(631);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==ORDER) {
					{
					setState(630);
					queryOrder();
					}
				}

				}
				break;
			case LEFT_PAREN:
				_localctx = new NestedQueryExpressionContext(_localctx);
				enterOuterAlt(_localctx, 2);
				{
				setState(633);
				match(LEFT_PAREN);
				setState(634);
				queryExpression();
				setState(635);
				match(RIGHT_PAREN);
				setState(637);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==ORDER) {
					{
					setState(636);
					queryOrder();
					}
				}

				}
				break;
			case ORDER:
				_localctx = new QueryOrderExpressionContext(_localctx);
				enterOuterAlt(_localctx, 3);
				{
				setState(639);
				queryOrder();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SetOperatorContext extends ParserRuleContext {
		public TerminalNode UNION() { return getToken(HqlParser.UNION, 0); }
		public TerminalNode ALL() { return getToken(HqlParser.ALL, 0); }
		public TerminalNode INTERSECT() { return getToken(HqlParser.INTERSECT, 0); }
		public TerminalNode EXCEPT() { return getToken(HqlParser.EXCEPT, 0); }
		public SetOperatorContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_setOperator; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSetOperator(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSetOperator(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSetOperator(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SetOperatorContext setOperator() throws RecognitionException {
		SetOperatorContext _localctx = new SetOperatorContext(_ctx, getState());
		enterRule(_localctx, 48, RULE_setOperator);
		int _la;
		try {
			setState(654);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case UNION:
				enterOuterAlt(_localctx, 1);
				{
				setState(642);
				match(UNION);
				setState(644);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==ALL) {
					{
					setState(643);
					match(ALL);
					}
				}

				}
				break;
			case INTERSECT:
				enterOuterAlt(_localctx, 2);
				{
				setState(646);
				match(INTERSECT);
				setState(648);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==ALL) {
					{
					setState(647);
					match(ALL);
					}
				}

				}
				break;
			case EXCEPT:
				enterOuterAlt(_localctx, 3);
				{
				setState(650);
				match(EXCEPT);
				setState(652);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==ALL) {
					{
					setState(651);
					match(ALL);
					}
				}

				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class QueryOrderContext extends ParserRuleContext {
		public OrderByClauseContext orderByClause() {
			return getRuleContext(OrderByClauseContext.class,0);
		}
		public LimitClauseContext limitClause() {
			return getRuleContext(LimitClauseContext.class,0);
		}
		public OffsetClauseContext offsetClause() {
			return getRuleContext(OffsetClauseContext.class,0);
		}
		public FetchClauseContext fetchClause() {
			return getRuleContext(FetchClauseContext.class,0);
		}
		public QueryOrderContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_queryOrder; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterQueryOrder(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitQueryOrder(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitQueryOrder(this);
			else return visitor.visitChildren(this);
		}
	}

	public final QueryOrderContext queryOrder() throws RecognitionException {
		QueryOrderContext _localctx = new QueryOrderContext(_ctx, getState());
		enterRule(_localctx, 50, RULE_queryOrder);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(656);
			orderByClause();
			setState(658);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==LIMIT) {
				{
				setState(657);
				limitClause();
				}
			}

			setState(661);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==OFFSET) {
				{
				setState(660);
				offsetClause();
				}
			}

			setState(664);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==FETCH) {
				{
				setState(663);
				fetchClause();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class QueryContext extends ParserRuleContext {
		public SelectClauseContext selectClause() {
			return getRuleContext(SelectClauseContext.class,0);
		}
		public FromClauseContext fromClause() {
			return getRuleContext(FromClauseContext.class,0);
		}
		public WhereClauseContext whereClause() {
			return getRuleContext(WhereClauseContext.class,0);
		}
		public GroupByClauseContext groupByClause() {
			return getRuleContext(GroupByClauseContext.class,0);
		}
		public HavingClauseContext havingClause() {
			return getRuleContext(HavingClauseContext.class,0);
		}
		public QueryContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_query; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterQuery(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitQuery(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitQuery(this);
			else return visitor.visitChildren(this);
		}
	}

	public final QueryContext query() throws RecognitionException {
		QueryContext _localctx = new QueryContext(_ctx, getState());
		enterRule(_localctx, 52, RULE_query);
		int _la;
		try {
			setState(693);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case SELECT:
				enterOuterAlt(_localctx, 1);
				{
				setState(666);
				selectClause();
				setState(668);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==FROM) {
					{
					setState(667);
					fromClause();
					}
				}

				setState(671);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==WHERE) {
					{
					setState(670);
					whereClause();
					}
				}

				setState(677);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==GROUP) {
					{
					setState(673);
					groupByClause();
					setState(675);
					_errHandler.sync(this);
					_la = _input.LA(1);
					if (_la==HAVING) {
						{
						setState(674);
						havingClause();
						}
					}

					}
				}

				}
				break;
			case FROM:
				enterOuterAlt(_localctx, 2);
				{
				setState(679);
				fromClause();
				setState(681);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==WHERE) {
					{
					setState(680);
					whereClause();
					}
				}

				setState(687);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==GROUP) {
					{
					setState(683);
					groupByClause();
					setState(685);
					_errHandler.sync(this);
					_la = _input.LA(1);
					if (_la==HAVING) {
						{
						setState(684);
						havingClause();
						}
					}

					}
				}

				setState(690);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==SELECT) {
					{
					setState(689);
					selectClause();
					}
				}

				}
				break;
			case WHERE:
				enterOuterAlt(_localctx, 3);
				{
				setState(692);
				whereClause();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class FromClauseContext extends ParserRuleContext {
		public TerminalNode FROM() { return getToken(HqlParser.FROM, 0); }
		public List<EntityWithJoinsContext> entityWithJoins() {
			return getRuleContexts(EntityWithJoinsContext.class);
		}
		public EntityWithJoinsContext entityWithJoins(int i) {
			return getRuleContext(EntityWithJoinsContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public FromClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_fromClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFromClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFromClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFromClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FromClauseContext fromClause() throws RecognitionException {
		FromClauseContext _localctx = new FromClauseContext(_ctx, getState());
		enterRule(_localctx, 54, RULE_fromClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(695);
			match(FROM);
			setState(696);
			entityWithJoins();
			setState(701);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(697);
				match(COMMA);
				setState(698);
				entityWithJoins();
				}
				}
				setState(703);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class EntityWithJoinsContext extends ParserRuleContext {
		public FromRootContext fromRoot() {
			return getRuleContext(FromRootContext.class,0);
		}
		public List<JoinContext> join() {
			return getRuleContexts(JoinContext.class);
		}
		public JoinContext join(int i) {
			return getRuleContext(JoinContext.class,i);
		}
		public List<CrossJoinContext> crossJoin() {
			return getRuleContexts(CrossJoinContext.class);
		}
		public CrossJoinContext crossJoin(int i) {
			return getRuleContext(CrossJoinContext.class,i);
		}
		public List<JpaCollectionJoinContext> jpaCollectionJoin() {
			return getRuleContexts(JpaCollectionJoinContext.class);
		}
		public JpaCollectionJoinContext jpaCollectionJoin(int i) {
			return getRuleContext(JpaCollectionJoinContext.class,i);
		}
		public EntityWithJoinsContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_entityWithJoins; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityWithJoins(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityWithJoins(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityWithJoins(this);
			else return visitor.visitChildren(this);
		}
	}

	public final EntityWithJoinsContext entityWithJoins() throws RecognitionException {
		EntityWithJoinsContext _localctx = new EntityWithJoinsContext(_ctx, getState());
		enterRule(_localctx, 56, RULE_entityWithJoins);
		try {
			int _alt;
			enterOuterAlt(_localctx, 1);
			{
			setState(704);
			fromRoot();
			setState(710);
			_errHandler.sync(this);
			_alt = getInterpreter().adaptivePredict(_input,54,_ctx);
			while ( _alt!=2 && _alt!=org.antlr.v4.runtime.atn.ATN.INVALID_ALT_NUMBER ) {
				if ( _alt==1 ) {
					{
					setState(708);
					_errHandler.sync(this);
					switch (_input.LA(1)) {
					case FULL:
					case INNER:
					case JOIN:
					case LEFT:
					case OUTER:
					case RIGHT:
						{
						setState(705);
						join();
						}
						break;
					case CROSS:
						{
						setState(706);
						crossJoin();
						}
						break;
					case COMMA:
						{
						setState(707);
						jpaCollectionJoin();
						}
						break;
					default:
						throw new NoViableAltException(this);
					}
					} 
				}
				setState(712);
				_errHandler.sync(this);
				_alt = getInterpreter().adaptivePredict(_input,54,_ctx);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class FromRootContext extends ParserRuleContext {
		public FromRootContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_fromRoot; }
	 
		public FromRootContext() { }
		public void copyFrom(FromRootContext ctx) {
			super.copyFrom(ctx);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class RootSubqueryContext extends FromRootContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public SubqueryContext subquery() {
			return getRuleContext(SubqueryContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public VariableContext variable() {
			return getRuleContext(VariableContext.class,0);
		}
		public RootSubqueryContext(FromRootContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterRootSubquery(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitRootSubquery(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitRootSubquery(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class RootEntityContext extends FromRootContext {
		public EntityNameContext entityName() {
			return getRuleContext(EntityNameContext.class,0);
		}
		public VariableContext variable() {
			return getRuleContext(VariableContext.class,0);
		}
		public RootEntityContext(FromRootContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterRootEntity(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitRootEntity(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitRootEntity(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FromRootContext fromRoot() throws RecognitionException {
		FromRootContext _localctx = new FromRootContext(_ctx, getState());
		enterRule(_localctx, 58, RULE_fromRoot);
		try {
			setState(723);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case ID:
			case VERSION:
			case VERSIONED:
			case NATURALID:
			case FK:
			case ALL:
			case AND:
			case ANY:
			case AS:
			case ASC:
			case AVG:
			case BETWEEN:
			case BOTH:
			case BREADTH:
			case BY:
			case CASE:
			case CAST:
			case COLLATE:
			case COLUMN:
			case CONFLICT:
			case CONSTRAINT:
			case COUNT:
			case CROSS:
			case CUBE:
			case CURRENT:
			case CURRENT_DATE:
			case CURRENT_INSTANT:
			case CURRENT_TIME:
			case CURRENT_TIMESTAMP:
			case CYCLE:
			case DATE:
			case DATETIME:
			case DAY:
			case DEFAULT:
			case DELETE:
			case DEPTH:
			case DESC:
			case DISTINCT:
			case DO:
			case ELEMENT:
			case ELEMENTS:
			case ELSE:
			case EMPTY:
			case END:
			case ENTRY:
			case EPOCH:
			case ERROR:
			case ESCAPE:
			case EVERY:
			case EXCEPT:
			case EXCLUDE:
			case EXISTS:
			case EXTRACT:
			case FETCH:
			case FILTER:
			case FIRST:
			case FOLLOWING:
			case FOR:
			case FORMAT:
			case FROM:
			case FULL:
			case FUNCTION:
			case GROUP:
			case GROUPS:
			case HAVING:
			case HOUR:
			case IGNORE:
			case ILIKE:
			case IN:
			case INDEX:
			case INDICES:
			case INNER:
			case INSERT:
			case INSTANT:
			case INTERSECT:
			case INTO:
			case IS:
			case JOIN:
			case KEY:
			case KEYS:
			case LAST:
			case LATERAL:
			case LEADING:
			case LEFT:
			case LIKE:
			case LIMIT:
			case LIST:
			case LISTAGG:
			case LOCAL:
			case LOCAL_DATE:
			case LOCAL_DATETIME:
			case LOCAL_TIME:
			case MAP:
			case MATERIALIZED:
			case MAX:
			case MAXELEMENT:
			case MAXINDEX:
			case MEMBER:
			case MICROSECOND:
			case MILLISECOND:
			case MIN:
			case MINELEMENT:
			case MININDEX:
			case MINUTE:
			case MONTH:
			case NANOSECOND:
			case NEW:
			case NEXT:
			case NO:
			case NOT:
			case NOTHING:
			case NULLS:
			case OBJECT:
			case OF:
			case OFFSET:
			case OFFSET_DATETIME:
			case ON:
			case ONLY:
			case OR:
			case ORDER:
			case OTHERS:
			case OUTER:
			case OVER:
			case OVERFLOW:
			case OVERLAY:
			case PAD:
			case PARTITION:
			case PERCENT:
			case PLACING:
			case POSITION:
			case PRECEDING:
			case QUARTER:
			case RANGE:
			case RESPECT:
			case RIGHT:
			case ROLLUP:
			case ROW:
			case ROWS:
			case SEARCH:
			case SECOND:
			case SELECT:
			case SET:
			case SIZE:
			case SOME:
			case SUBSTRING:
			case SUM:
			case THEN:
			case TIES:
			case TIME:
			case TIMESTAMP:
			case TIMEZONE_HOUR:
			case TIMEZONE_MINUTE:
			case TO:
			case TRAILING:
			case TREAT:
			case TRIM:
			case TRUNC:
			case TRUNCATE:
			case TYPE:
			case UNBOUNDED:
			case UNION:
			case UPDATE:
			case USING:
			case VALUE:
			case VALUES:
			case WEEK:
			case WHEN:
			case WHERE:
			case WITH:
			case WITHIN:
			case WITHOUT:
			case YEAR:
			case ZONED:
			case IDENTIFIER:
			case QUOTED_IDENTIFIER:
				_localctx = new RootEntityContext(_localctx);
				enterOuterAlt(_localctx, 1);
				{
				setState(713);
				entityName();
				setState(715);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,55,_ctx) ) {
				case 1:
					{
					setState(714);
					variable();
					}
					break;
				}
				}
				break;
			case LEFT_PAREN:
				_localctx = new RootSubqueryContext(_localctx);
				enterOuterAlt(_localctx, 2);
				{
				setState(717);
				match(LEFT_PAREN);
				setState(718);
				subquery();
				setState(719);
				match(RIGHT_PAREN);
				setState(721);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,56,_ctx) ) {
				case 1:
					{
					setState(720);
					variable();
					}
					break;
				}
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class EntityNameContext extends ParserRuleContext {
		public List<IdentifierContext> identifier() {
			return getRuleContexts(IdentifierContext.class);
		}
		public IdentifierContext identifier(int i) {
			return getRuleContext(IdentifierContext.class,i);
		}
		public List<TerminalNode> DOT() { return getTokens(HqlParser.DOT); }
		public TerminalNode DOT(int i) {
			return getToken(HqlParser.DOT, i);
		}
		public EntityNameContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_entityName; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityName(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityName(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityName(this);
			else return visitor.visitChildren(this);
		}
	}

	public final EntityNameContext entityName() throws RecognitionException {
		EntityNameContext _localctx = new EntityNameContext(_ctx, getState());
		enterRule(_localctx, 60, RULE_entityName);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(725);
			identifier();
			setState(730);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==DOT) {
				{
				{
				setState(726);
				match(DOT);
				setState(727);
				identifier();
				}
				}
				setState(732);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class VariableContext extends ParserRuleContext {
		public TerminalNode AS() { return getToken(HqlParser.AS, 0); }
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public NakedIdentifierContext nakedIdentifier() {
			return getRuleContext(NakedIdentifierContext.class,0);
		}
		public VariableContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_variable; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterVariable(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitVariable(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitVariable(this);
			else return visitor.visitChildren(this);
		}
	}

	public final VariableContext variable() throws RecognitionException {
		VariableContext _localctx = new VariableContext(_ctx, getState());
		enterRule(_localctx, 62, RULE_variable);
		try {
			setState(736);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,59,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(733);
				match(AS);
				setState(734);
				identifier();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(735);
				nakedIdentifier();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class CrossJoinContext extends ParserRuleContext {
		public TerminalNode CROSS() { return getToken(HqlParser.CROSS, 0); }
		public TerminalNode JOIN() { return getToken(HqlParser.JOIN, 0); }
		public EntityNameContext entityName() {
			return getRuleContext(EntityNameContext.class,0);
		}
		public VariableContext variable() {
			return getRuleContext(VariableContext.class,0);
		}
		public CrossJoinContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_crossJoin; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCrossJoin(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCrossJoin(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCrossJoin(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CrossJoinContext crossJoin() throws RecognitionException {
		CrossJoinContext _localctx = new CrossJoinContext(_ctx, getState());
		enterRule(_localctx, 64, RULE_crossJoin);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(738);
			match(CROSS);
			setState(739);
			match(JOIN);
			setState(740);
			entityName();
			setState(742);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,60,_ctx) ) {
			case 1:
				{
				setState(741);
				variable();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class JpaCollectionJoinContext extends ParserRuleContext {
		public TerminalNode COMMA() { return getToken(HqlParser.COMMA, 0); }
		public TerminalNode IN() { return getToken(HqlParser.IN, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public VariableContext variable() {
			return getRuleContext(VariableContext.class,0);
		}
		public JpaCollectionJoinContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_jpaCollectionJoin; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJpaCollectionJoin(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJpaCollectionJoin(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJpaCollectionJoin(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JpaCollectionJoinContext jpaCollectionJoin() throws RecognitionException {
		JpaCollectionJoinContext _localctx = new JpaCollectionJoinContext(_ctx, getState());
		enterRule(_localctx, 66, RULE_jpaCollectionJoin);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(744);
			match(COMMA);
			setState(745);
			match(IN);
			setState(746);
			match(LEFT_PAREN);
			setState(747);
			path();
			setState(748);
			match(RIGHT_PAREN);
			setState(750);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,61,_ctx) ) {
			case 1:
				{
				setState(749);
				variable();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class JoinContext extends ParserRuleContext {
		public JoinTypeContext joinType() {
			return getRuleContext(JoinTypeContext.class,0);
		}
		public TerminalNode JOIN() { return getToken(HqlParser.JOIN, 0); }
		public JoinTargetContext joinTarget() {
			return getRuleContext(JoinTargetContext.class,0);
		}
		public TerminalNode FETCH() { return getToken(HqlParser.FETCH, 0); }
		public JoinRestrictionContext joinRestriction() {
			return getRuleContext(JoinRestrictionContext.class,0);
		}
		public JoinContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_join; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJoin(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJoin(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJoin(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JoinContext join() throws RecognitionException {
		JoinContext _localctx = new JoinContext(_ctx, getState());
		enterRule(_localctx, 68, RULE_join);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(752);
			joinType();
			setState(753);
			match(JOIN);
			setState(755);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,62,_ctx) ) {
			case 1:
				{
				setState(754);
				match(FETCH);
				}
				break;
			}
			setState(757);
			joinTarget();
			setState(759);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,63,_ctx) ) {
			case 1:
				{
				setState(758);
				joinRestriction();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class JoinTypeContext extends ParserRuleContext {
		public TerminalNode INNER() { return getToken(HqlParser.INNER, 0); }
		public TerminalNode OUTER() { return getToken(HqlParser.OUTER, 0); }
		public TerminalNode LEFT() { return getToken(HqlParser.LEFT, 0); }
		public TerminalNode RIGHT() { return getToken(HqlParser.RIGHT, 0); }
		public TerminalNode FULL() { return getToken(HqlParser.FULL, 0); }
		public JoinTypeContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_joinType; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJoinType(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJoinType(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJoinType(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JoinTypeContext joinType() throws RecognitionException {
		JoinTypeContext _localctx = new JoinTypeContext(_ctx, getState());
		enterRule(_localctx, 70, RULE_joinType);
		int _la;
		try {
			setState(770);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,67,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(762);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==INNER) {
					{
					setState(761);
					match(INNER);
					}
				}

				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(765);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==FULL || _la==LEFT || _la==RIGHT) {
					{
					setState(764);
					_la = _input.LA(1);
					if ( !(_la==FULL || _la==LEFT || _la==RIGHT) ) {
					_errHandler.recoverInline(this);
					}
					else {
						if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
						_errHandler.reportMatch(this);
						consume();
					}
					}
				}

				setState(768);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==OUTER) {
					{
					setState(767);
					match(OUTER);
					}
				}

				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class JoinTargetContext extends ParserRuleContext {
		public JoinTargetContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_joinTarget; }
	 
		public JoinTargetContext() { }
		public void copyFrom(JoinTargetContext ctx) {
			super.copyFrom(ctx);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class JoinPathContext extends JoinTargetContext {
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public VariableContext variable() {
			return getRuleContext(VariableContext.class,0);
		}
		public JoinPathContext(JoinTargetContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJoinPath(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJoinPath(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJoinPath(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class JoinSubqueryContext extends JoinTargetContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public SubqueryContext subquery() {
			return getRuleContext(SubqueryContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode LATERAL() { return getToken(HqlParser.LATERAL, 0); }
		public VariableContext variable() {
			return getRuleContext(VariableContext.class,0);
		}
		public JoinSubqueryContext(JoinTargetContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJoinSubquery(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJoinSubquery(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJoinSubquery(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JoinTargetContext joinTarget() throws RecognitionException {
		JoinTargetContext _localctx = new JoinTargetContext(_ctx, getState());
		enterRule(_localctx, 72, RULE_joinTarget);
		int _la;
		try {
			setState(785);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,71,_ctx) ) {
			case 1:
				_localctx = new JoinPathContext(_localctx);
				enterOuterAlt(_localctx, 1);
				{
				setState(772);
				path();
				setState(774);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,68,_ctx) ) {
				case 1:
					{
					setState(773);
					variable();
					}
					break;
				}
				}
				break;
			case 2:
				_localctx = new JoinSubqueryContext(_localctx);
				enterOuterAlt(_localctx, 2);
				{
				setState(777);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==LATERAL) {
					{
					setState(776);
					match(LATERAL);
					}
				}

				setState(779);
				match(LEFT_PAREN);
				setState(780);
				subquery();
				setState(781);
				match(RIGHT_PAREN);
				setState(783);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,70,_ctx) ) {
				case 1:
					{
					setState(782);
					variable();
					}
					break;
				}
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class JoinRestrictionContext extends ParserRuleContext {
		public PredicateContext predicate() {
			return getRuleContext(PredicateContext.class,0);
		}
		public TerminalNode ON() { return getToken(HqlParser.ON, 0); }
		public TerminalNode WITH() { return getToken(HqlParser.WITH, 0); }
		public JoinRestrictionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_joinRestriction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJoinRestriction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJoinRestriction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJoinRestriction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JoinRestrictionContext joinRestriction() throws RecognitionException {
		JoinRestrictionContext _localctx = new JoinRestrictionContext(_ctx, getState());
		enterRule(_localctx, 74, RULE_joinRestriction);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(787);
			_la = _input.LA(1);
			if ( !(_la==ON || _la==WITH) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			setState(788);
			predicate(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SelectClauseContext extends ParserRuleContext {
		public TerminalNode SELECT() { return getToken(HqlParser.SELECT, 0); }
		public SelectionListContext selectionList() {
			return getRuleContext(SelectionListContext.class,0);
		}
		public TerminalNode DISTINCT() { return getToken(HqlParser.DISTINCT, 0); }
		public SelectClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_selectClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSelectClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSelectClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSelectClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SelectClauseContext selectClause() throws RecognitionException {
		SelectClauseContext _localctx = new SelectClauseContext(_ctx, getState());
		enterRule(_localctx, 76, RULE_selectClause);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(790);
			match(SELECT);
			setState(792);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,72,_ctx) ) {
			case 1:
				{
				setState(791);
				match(DISTINCT);
				}
				break;
			}
			setState(794);
			selectionList();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SelectionListContext extends ParserRuleContext {
		public List<SelectionContext> selection() {
			return getRuleContexts(SelectionContext.class);
		}
		public SelectionContext selection(int i) {
			return getRuleContext(SelectionContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public SelectionListContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_selectionList; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSelectionList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSelectionList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSelectionList(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SelectionListContext selectionList() throws RecognitionException {
		SelectionListContext _localctx = new SelectionListContext(_ctx, getState());
		enterRule(_localctx, 78, RULE_selectionList);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(796);
			selection();
			setState(801);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(797);
				match(COMMA);
				setState(798);
				selection();
				}
				}
				setState(803);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SelectionContext extends ParserRuleContext {
		public SelectExpressionContext selectExpression() {
			return getRuleContext(SelectExpressionContext.class,0);
		}
		public VariableContext variable() {
			return getRuleContext(VariableContext.class,0);
		}
		public SelectionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_selection; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSelection(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSelection(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSelection(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SelectionContext selection() throws RecognitionException {
		SelectionContext _localctx = new SelectionContext(_ctx, getState());
		enterRule(_localctx, 80, RULE_selection);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(804);
			selectExpression();
			setState(806);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,74,_ctx) ) {
			case 1:
				{
				setState(805);
				variable();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SelectExpressionContext extends ParserRuleContext {
		public InstantiationContext instantiation() {
			return getRuleContext(InstantiationContext.class,0);
		}
		public MapEntrySelectionContext mapEntrySelection() {
			return getRuleContext(MapEntrySelectionContext.class,0);
		}
		public JpaSelectObjectSyntaxContext jpaSelectObjectSyntax() {
			return getRuleContext(JpaSelectObjectSyntaxContext.class,0);
		}
		public ExpressionOrPredicateContext expressionOrPredicate() {
			return getRuleContext(ExpressionOrPredicateContext.class,0);
		}
		public SelectExpressionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_selectExpression; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSelectExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSelectExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSelectExpression(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SelectExpressionContext selectExpression() throws RecognitionException {
		SelectExpressionContext _localctx = new SelectExpressionContext(_ctx, getState());
		enterRule(_localctx, 82, RULE_selectExpression);
		try {
			setState(812);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,75,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(808);
				instantiation();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(809);
				mapEntrySelection();
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(810);
				jpaSelectObjectSyntax();
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(811);
				expressionOrPredicate();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class MapEntrySelectionContext extends ParserRuleContext {
		public TerminalNode ENTRY() { return getToken(HqlParser.ENTRY, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public MapEntrySelectionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_mapEntrySelection; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterMapEntrySelection(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitMapEntrySelection(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitMapEntrySelection(this);
			else return visitor.visitChildren(this);
		}
	}

	public final MapEntrySelectionContext mapEntrySelection() throws RecognitionException {
		MapEntrySelectionContext _localctx = new MapEntrySelectionContext(_ctx, getState());
		enterRule(_localctx, 84, RULE_mapEntrySelection);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(814);
			match(ENTRY);
			setState(815);
			match(LEFT_PAREN);
			setState(816);
			path();
			setState(817);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class InstantiationContext extends ParserRuleContext {
		public TerminalNode NEW() { return getToken(HqlParser.NEW, 0); }
		public InstantiationTargetContext instantiationTarget() {
			return getRuleContext(InstantiationTargetContext.class,0);
		}
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public InstantiationArgumentsContext instantiationArguments() {
			return getRuleContext(InstantiationArgumentsContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public InstantiationContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_instantiation; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterInstantiation(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitInstantiation(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitInstantiation(this);
			else return visitor.visitChildren(this);
		}
	}

	public final InstantiationContext instantiation() throws RecognitionException {
		InstantiationContext _localctx = new InstantiationContext(_ctx, getState());
		enterRule(_localctx, 86, RULE_instantiation);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(819);
			match(NEW);
			setState(820);
			instantiationTarget();
			setState(821);
			match(LEFT_PAREN);
			setState(822);
			instantiationArguments();
			setState(823);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class InstantiationTargetContext extends ParserRuleContext {
		public TerminalNode LIST() { return getToken(HqlParser.LIST, 0); }
		public TerminalNode MAP() { return getToken(HqlParser.MAP, 0); }
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public InstantiationTargetContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_instantiationTarget; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterInstantiationTarget(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitInstantiationTarget(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitInstantiationTarget(this);
			else return visitor.visitChildren(this);
		}
	}

	public final InstantiationTargetContext instantiationTarget() throws RecognitionException {
		InstantiationTargetContext _localctx = new InstantiationTargetContext(_ctx, getState());
		enterRule(_localctx, 88, RULE_instantiationTarget);
		try {
			setState(828);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,76,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(825);
				match(LIST);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(826);
				match(MAP);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(827);
				simplePath();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class InstantiationArgumentsContext extends ParserRuleContext {
		public List<InstantiationArgumentContext> instantiationArgument() {
			return getRuleContexts(InstantiationArgumentContext.class);
		}
		public InstantiationArgumentContext instantiationArgument(int i) {
			return getRuleContext(InstantiationArgumentContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public InstantiationArgumentsContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_instantiationArguments; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterInstantiationArguments(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitInstantiationArguments(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitInstantiationArguments(this);
			else return visitor.visitChildren(this);
		}
	}

	public final InstantiationArgumentsContext instantiationArguments() throws RecognitionException {
		InstantiationArgumentsContext _localctx = new InstantiationArgumentsContext(_ctx, getState());
		enterRule(_localctx, 90, RULE_instantiationArguments);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(830);
			instantiationArgument();
			setState(835);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(831);
				match(COMMA);
				setState(832);
				instantiationArgument();
				}
				}
				setState(837);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class InstantiationArgumentContext extends ParserRuleContext {
		public InstantiationArgumentExpressionContext instantiationArgumentExpression() {
			return getRuleContext(InstantiationArgumentExpressionContext.class,0);
		}
		public VariableContext variable() {
			return getRuleContext(VariableContext.class,0);
		}
		public InstantiationArgumentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_instantiationArgument; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterInstantiationArgument(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitInstantiationArgument(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitInstantiationArgument(this);
			else return visitor.visitChildren(this);
		}
	}

	public final InstantiationArgumentContext instantiationArgument() throws RecognitionException {
		InstantiationArgumentContext _localctx = new InstantiationArgumentContext(_ctx, getState());
		enterRule(_localctx, 92, RULE_instantiationArgument);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(838);
			instantiationArgumentExpression();
			setState(840);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (((((_la - 42)) & ~0x3f) == 0 && ((1L << (_la - 42)) & -1152921504606846977L) != 0) || ((((_la - 106)) & ~0x3f) == 0 && ((1L << (_la - 106)) & -144115188076380289L) != 0) || ((((_la - 170)) & ~0x3f) == 0 && ((1L << (_la - 170)) & 879609302220735L) != 0)) {
				{
				setState(839);
				variable();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class InstantiationArgumentExpressionContext extends ParserRuleContext {
		public ExpressionOrPredicateContext expressionOrPredicate() {
			return getRuleContext(ExpressionOrPredicateContext.class,0);
		}
		public InstantiationContext instantiation() {
			return getRuleContext(InstantiationContext.class,0);
		}
		public InstantiationArgumentExpressionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_instantiationArgumentExpression; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterInstantiationArgumentExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitInstantiationArgumentExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitInstantiationArgumentExpression(this);
			else return visitor.visitChildren(this);
		}
	}

	public final InstantiationArgumentExpressionContext instantiationArgumentExpression() throws RecognitionException {
		InstantiationArgumentExpressionContext _localctx = new InstantiationArgumentExpressionContext(_ctx, getState());
		enterRule(_localctx, 94, RULE_instantiationArgumentExpression);
		try {
			setState(844);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,79,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(842);
				expressionOrPredicate();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(843);
				instantiation();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class JpaSelectObjectSyntaxContext extends ParserRuleContext {
		public TerminalNode OBJECT() { return getToken(HqlParser.OBJECT, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public JpaSelectObjectSyntaxContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_jpaSelectObjectSyntax; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJpaSelectObjectSyntax(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJpaSelectObjectSyntax(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJpaSelectObjectSyntax(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JpaSelectObjectSyntaxContext jpaSelectObjectSyntax() throws RecognitionException {
		JpaSelectObjectSyntaxContext _localctx = new JpaSelectObjectSyntaxContext(_ctx, getState());
		enterRule(_localctx, 96, RULE_jpaSelectObjectSyntax);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(846);
			match(OBJECT);
			setState(847);
			match(LEFT_PAREN);
			setState(848);
			identifier();
			setState(849);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SimplePathContext extends ParserRuleContext {
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public List<SimplePathElementContext> simplePathElement() {
			return getRuleContexts(SimplePathElementContext.class);
		}
		public SimplePathElementContext simplePathElement(int i) {
			return getRuleContext(SimplePathElementContext.class,i);
		}
		public SimplePathContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_simplePath; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSimplePath(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSimplePath(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSimplePath(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SimplePathContext simplePath() throws RecognitionException {
		SimplePathContext _localctx = new SimplePathContext(_ctx, getState());
		enterRule(_localctx, 98, RULE_simplePath);
		try {
			int _alt;
			enterOuterAlt(_localctx, 1);
			{
			setState(851);
			identifier();
			setState(855);
			_errHandler.sync(this);
			_alt = getInterpreter().adaptivePredict(_input,80,_ctx);
			while ( _alt!=2 && _alt!=org.antlr.v4.runtime.atn.ATN.INVALID_ALT_NUMBER ) {
				if ( _alt==1 ) {
					{
					{
					setState(852);
					simplePathElement();
					}
					} 
				}
				setState(857);
				_errHandler.sync(this);
				_alt = getInterpreter().adaptivePredict(_input,80,_ctx);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SimplePathElementContext extends ParserRuleContext {
		public TerminalNode DOT() { return getToken(HqlParser.DOT, 0); }
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public SimplePathElementContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_simplePathElement; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSimplePathElement(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSimplePathElement(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSimplePathElement(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SimplePathElementContext simplePathElement() throws RecognitionException {
		SimplePathElementContext _localctx = new SimplePathElementContext(_ctx, getState());
		enterRule(_localctx, 100, RULE_simplePathElement);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(858);
			match(DOT);
			setState(859);
			identifier();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class PathContext extends ParserRuleContext {
		public SyntacticDomainPathContext syntacticDomainPath() {
			return getRuleContext(SyntacticDomainPathContext.class,0);
		}
		public PathContinuationContext pathContinuation() {
			return getRuleContext(PathContinuationContext.class,0);
		}
		public GeneralPathFragmentContext generalPathFragment() {
			return getRuleContext(GeneralPathFragmentContext.class,0);
		}
		public PathContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_path; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPath(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPath(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPath(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PathContext path() throws RecognitionException {
		PathContext _localctx = new PathContext(_ctx, getState());
		enterRule(_localctx, 102, RULE_path);
		try {
			setState(866);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,82,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(861);
				syntacticDomainPath();
				setState(863);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,81,_ctx) ) {
				case 1:
					{
					setState(862);
					pathContinuation();
					}
					break;
				}
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(865);
				generalPathFragment();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class PathContinuationContext extends ParserRuleContext {
		public TerminalNode DOT() { return getToken(HqlParser.DOT, 0); }
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public PathContinuationContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_pathContinuation; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPathContinuation(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPathContinuation(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPathContinuation(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PathContinuationContext pathContinuation() throws RecognitionException {
		PathContinuationContext _localctx = new PathContinuationContext(_ctx, getState());
		enterRule(_localctx, 104, RULE_pathContinuation);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(868);
			match(DOT);
			setState(869);
			simplePath();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SyntacticDomainPathContext extends ParserRuleContext {
		public TreatedNavigablePathContext treatedNavigablePath() {
			return getRuleContext(TreatedNavigablePathContext.class,0);
		}
		public CollectionValueNavigablePathContext collectionValueNavigablePath() {
			return getRuleContext(CollectionValueNavigablePathContext.class,0);
		}
		public MapKeyNavigablePathContext mapKeyNavigablePath() {
			return getRuleContext(MapKeyNavigablePathContext.class,0);
		}
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public IndexedPathAccessFragmentContext indexedPathAccessFragment() {
			return getRuleContext(IndexedPathAccessFragmentContext.class,0);
		}
		public SyntacticDomainPathContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_syntacticDomainPath; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSyntacticDomainPath(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSyntacticDomainPath(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSyntacticDomainPath(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SyntacticDomainPathContext syntacticDomainPath() throws RecognitionException {
		SyntacticDomainPathContext _localctx = new SyntacticDomainPathContext(_ctx, getState());
		enterRule(_localctx, 106, RULE_syntacticDomainPath);
		try {
			setState(877);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,83,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(871);
				treatedNavigablePath();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(872);
				collectionValueNavigablePath();
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(873);
				mapKeyNavigablePath();
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(874);
				simplePath();
				setState(875);
				indexedPathAccessFragment();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class GeneralPathFragmentContext extends ParserRuleContext {
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public IndexedPathAccessFragmentContext indexedPathAccessFragment() {
			return getRuleContext(IndexedPathAccessFragmentContext.class,0);
		}
		public GeneralPathFragmentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_generalPathFragment; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGeneralPathFragment(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGeneralPathFragment(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGeneralPathFragment(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GeneralPathFragmentContext generalPathFragment() throws RecognitionException {
		GeneralPathFragmentContext _localctx = new GeneralPathFragmentContext(_ctx, getState());
		enterRule(_localctx, 108, RULE_generalPathFragment);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(879);
			simplePath();
			setState(881);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,84,_ctx) ) {
			case 1:
				{
				setState(880);
				indexedPathAccessFragment();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class IndexedPathAccessFragmentContext extends ParserRuleContext {
		public TerminalNode LEFT_BRACKET() { return getToken(HqlParser.LEFT_BRACKET, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode RIGHT_BRACKET() { return getToken(HqlParser.RIGHT_BRACKET, 0); }
		public TerminalNode DOT() { return getToken(HqlParser.DOT, 0); }
		public GeneralPathFragmentContext generalPathFragment() {
			return getRuleContext(GeneralPathFragmentContext.class,0);
		}
		public IndexedPathAccessFragmentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_indexedPathAccessFragment; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterIndexedPathAccessFragment(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitIndexedPathAccessFragment(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitIndexedPathAccessFragment(this);
			else return visitor.visitChildren(this);
		}
	}

	public final IndexedPathAccessFragmentContext indexedPathAccessFragment() throws RecognitionException {
		IndexedPathAccessFragmentContext _localctx = new IndexedPathAccessFragmentContext(_ctx, getState());
		enterRule(_localctx, 110, RULE_indexedPathAccessFragment);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(883);
			match(LEFT_BRACKET);
			setState(884);
			expression(0);
			setState(885);
			match(RIGHT_BRACKET);
			setState(888);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,85,_ctx) ) {
			case 1:
				{
				setState(886);
				match(DOT);
				setState(887);
				generalPathFragment();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class TreatedNavigablePathContext extends ParserRuleContext {
		public TerminalNode TREAT() { return getToken(HqlParser.TREAT, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode AS() { return getToken(HqlParser.AS, 0); }
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public PathContinuationContext pathContinuation() {
			return getRuleContext(PathContinuationContext.class,0);
		}
		public TreatedNavigablePathContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_treatedNavigablePath; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTreatedNavigablePath(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTreatedNavigablePath(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTreatedNavigablePath(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TreatedNavigablePathContext treatedNavigablePath() throws RecognitionException {
		TreatedNavigablePathContext _localctx = new TreatedNavigablePathContext(_ctx, getState());
		enterRule(_localctx, 112, RULE_treatedNavigablePath);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(890);
			match(TREAT);
			setState(891);
			match(LEFT_PAREN);
			setState(892);
			path();
			setState(893);
			match(AS);
			setState(894);
			simplePath();
			setState(895);
			match(RIGHT_PAREN);
			setState(897);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,86,_ctx) ) {
			case 1:
				{
				setState(896);
				pathContinuation();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class CollectionValueNavigablePathContext extends ParserRuleContext {
		public ElementValueQuantifierContext elementValueQuantifier() {
			return getRuleContext(ElementValueQuantifierContext.class,0);
		}
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public PathContinuationContext pathContinuation() {
			return getRuleContext(PathContinuationContext.class,0);
		}
		public CollectionValueNavigablePathContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_collectionValueNavigablePath; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCollectionValueNavigablePath(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCollectionValueNavigablePath(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCollectionValueNavigablePath(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CollectionValueNavigablePathContext collectionValueNavigablePath() throws RecognitionException {
		CollectionValueNavigablePathContext _localctx = new CollectionValueNavigablePathContext(_ctx, getState());
		enterRule(_localctx, 114, RULE_collectionValueNavigablePath);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(899);
			elementValueQuantifier();
			setState(900);
			match(LEFT_PAREN);
			setState(901);
			path();
			setState(902);
			match(RIGHT_PAREN);
			setState(904);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,87,_ctx) ) {
			case 1:
				{
				setState(903);
				pathContinuation();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class MapKeyNavigablePathContext extends ParserRuleContext {
		public IndexKeyQuantifierContext indexKeyQuantifier() {
			return getRuleContext(IndexKeyQuantifierContext.class,0);
		}
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public PathContinuationContext pathContinuation() {
			return getRuleContext(PathContinuationContext.class,0);
		}
		public MapKeyNavigablePathContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_mapKeyNavigablePath; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterMapKeyNavigablePath(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitMapKeyNavigablePath(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitMapKeyNavigablePath(this);
			else return visitor.visitChildren(this);
		}
	}

	public final MapKeyNavigablePathContext mapKeyNavigablePath() throws RecognitionException {
		MapKeyNavigablePathContext _localctx = new MapKeyNavigablePathContext(_ctx, getState());
		enterRule(_localctx, 116, RULE_mapKeyNavigablePath);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(906);
			indexKeyQuantifier();
			setState(907);
			match(LEFT_PAREN);
			setState(908);
			path();
			setState(909);
			match(RIGHT_PAREN);
			setState(911);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,88,_ctx) ) {
			case 1:
				{
				setState(910);
				pathContinuation();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class GroupByClauseContext extends ParserRuleContext {
		public TerminalNode GROUP() { return getToken(HqlParser.GROUP, 0); }
		public TerminalNode BY() { return getToken(HqlParser.BY, 0); }
		public List<GroupByExpressionContext> groupByExpression() {
			return getRuleContexts(GroupByExpressionContext.class);
		}
		public GroupByExpressionContext groupByExpression(int i) {
			return getRuleContext(GroupByExpressionContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public GroupByClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_groupByClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGroupByClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGroupByClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGroupByClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GroupByClauseContext groupByClause() throws RecognitionException {
		GroupByClauseContext _localctx = new GroupByClauseContext(_ctx, getState());
		enterRule(_localctx, 118, RULE_groupByClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(913);
			match(GROUP);
			setState(914);
			match(BY);
			setState(915);
			groupByExpression();
			setState(920);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(916);
				match(COMMA);
				setState(917);
				groupByExpression();
				}
				}
				setState(922);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class GroupByExpressionContext extends ParserRuleContext {
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public GroupByExpressionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_groupByExpression; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGroupByExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGroupByExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGroupByExpression(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GroupByExpressionContext groupByExpression() throws RecognitionException {
		GroupByExpressionContext _localctx = new GroupByExpressionContext(_ctx, getState());
		enterRule(_localctx, 120, RULE_groupByExpression);
		try {
			setState(926);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,90,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(923);
				identifier();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(924);
				match(INTEGER_LITERAL);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(925);
				expression(0);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class HavingClauseContext extends ParserRuleContext {
		public TerminalNode HAVING() { return getToken(HqlParser.HAVING, 0); }
		public PredicateContext predicate() {
			return getRuleContext(PredicateContext.class,0);
		}
		public HavingClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_havingClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterHavingClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitHavingClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitHavingClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final HavingClauseContext havingClause() throws RecognitionException {
		HavingClauseContext _localctx = new HavingClauseContext(_ctx, getState());
		enterRule(_localctx, 122, RULE_havingClause);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(928);
			match(HAVING);
			setState(929);
			predicate(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class OrderByClauseContext extends ParserRuleContext {
		public TerminalNode ORDER() { return getToken(HqlParser.ORDER, 0); }
		public TerminalNode BY() { return getToken(HqlParser.BY, 0); }
		public List<SortSpecificationContext> sortSpecification() {
			return getRuleContexts(SortSpecificationContext.class);
		}
		public SortSpecificationContext sortSpecification(int i) {
			return getRuleContext(SortSpecificationContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public OrderByClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_orderByClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOrderByClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOrderByClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOrderByClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OrderByClauseContext orderByClause() throws RecognitionException {
		OrderByClauseContext _localctx = new OrderByClauseContext(_ctx, getState());
		enterRule(_localctx, 124, RULE_orderByClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(931);
			match(ORDER);
			setState(932);
			match(BY);
			setState(933);
			sortSpecification();
			setState(938);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(934);
				match(COMMA);
				setState(935);
				sortSpecification();
				}
				}
				setState(940);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class OrderByFragmentContext extends ParserRuleContext {
		public List<SortSpecificationContext> sortSpecification() {
			return getRuleContexts(SortSpecificationContext.class);
		}
		public SortSpecificationContext sortSpecification(int i) {
			return getRuleContext(SortSpecificationContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public OrderByFragmentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_orderByFragment; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOrderByFragment(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOrderByFragment(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOrderByFragment(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OrderByFragmentContext orderByFragment() throws RecognitionException {
		OrderByFragmentContext _localctx = new OrderByFragmentContext(_ctx, getState());
		enterRule(_localctx, 126, RULE_orderByFragment);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(941);
			sortSpecification();
			setState(946);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(942);
				match(COMMA);
				setState(943);
				sortSpecification();
				}
				}
				setState(948);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SortSpecificationContext extends ParserRuleContext {
		public SortExpressionContext sortExpression() {
			return getRuleContext(SortExpressionContext.class,0);
		}
		public SortDirectionContext sortDirection() {
			return getRuleContext(SortDirectionContext.class,0);
		}
		public NullsPrecedenceContext nullsPrecedence() {
			return getRuleContext(NullsPrecedenceContext.class,0);
		}
		public SortSpecificationContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_sortSpecification; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSortSpecification(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSortSpecification(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSortSpecification(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SortSpecificationContext sortSpecification() throws RecognitionException {
		SortSpecificationContext _localctx = new SortSpecificationContext(_ctx, getState());
		enterRule(_localctx, 128, RULE_sortSpecification);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(949);
			sortExpression();
			setState(951);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==ASC || _la==DESC) {
				{
				setState(950);
				sortDirection();
				}
			}

			setState(954);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==NULLS) {
				{
				setState(953);
				nullsPrecedence();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class NullsPrecedenceContext extends ParserRuleContext {
		public TerminalNode NULLS() { return getToken(HqlParser.NULLS, 0); }
		public TerminalNode FIRST() { return getToken(HqlParser.FIRST, 0); }
		public TerminalNode LAST() { return getToken(HqlParser.LAST, 0); }
		public NullsPrecedenceContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_nullsPrecedence; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterNullsPrecedence(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitNullsPrecedence(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitNullsPrecedence(this);
			else return visitor.visitChildren(this);
		}
	}

	public final NullsPrecedenceContext nullsPrecedence() throws RecognitionException {
		NullsPrecedenceContext _localctx = new NullsPrecedenceContext(_ctx, getState());
		enterRule(_localctx, 130, RULE_nullsPrecedence);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(956);
			match(NULLS);
			setState(957);
			_la = _input.LA(1);
			if ( !(_la==FIRST || _la==LAST) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SortExpressionContext extends ParserRuleContext {
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public SortExpressionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_sortExpression; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSortExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSortExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSortExpression(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SortExpressionContext sortExpression() throws RecognitionException {
		SortExpressionContext _localctx = new SortExpressionContext(_ctx, getState());
		enterRule(_localctx, 132, RULE_sortExpression);
		try {
			setState(962);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,95,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(959);
				identifier();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(960);
				match(INTEGER_LITERAL);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(961);
				expression(0);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SortDirectionContext extends ParserRuleContext {
		public TerminalNode ASC() { return getToken(HqlParser.ASC, 0); }
		public TerminalNode DESC() { return getToken(HqlParser.DESC, 0); }
		public SortDirectionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_sortDirection; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSortDirection(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSortDirection(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSortDirection(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SortDirectionContext sortDirection() throws RecognitionException {
		SortDirectionContext _localctx = new SortDirectionContext(_ctx, getState());
		enterRule(_localctx, 134, RULE_sortDirection);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(964);
			_la = _input.LA(1);
			if ( !(_la==ASC || _la==DESC) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class CollateFunctionContext extends ParserRuleContext {
		public TerminalNode COLLATE() { return getToken(HqlParser.COLLATE, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode AS() { return getToken(HqlParser.AS, 0); }
		public CollationContext collation() {
			return getRuleContext(CollationContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public CollateFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_collateFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCollateFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCollateFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCollateFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CollateFunctionContext collateFunction() throws RecognitionException {
		CollateFunctionContext _localctx = new CollateFunctionContext(_ctx, getState());
		enterRule(_localctx, 136, RULE_collateFunction);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(966);
			match(COLLATE);
			setState(967);
			match(LEFT_PAREN);
			setState(968);
			expression(0);
			setState(969);
			match(AS);
			setState(970);
			collation();
			setState(971);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class CollationContext extends ParserRuleContext {
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public CollationContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_collation; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCollation(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCollation(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCollation(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CollationContext collation() throws RecognitionException {
		CollationContext _localctx = new CollationContext(_ctx, getState());
		enterRule(_localctx, 138, RULE_collation);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(973);
			simplePath();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class LimitClauseContext extends ParserRuleContext {
		public TerminalNode LIMIT() { return getToken(HqlParser.LIMIT, 0); }
		public ParameterOrIntegerLiteralContext parameterOrIntegerLiteral() {
			return getRuleContext(ParameterOrIntegerLiteralContext.class,0);
		}
		public LimitClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_limitClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterLimitClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitLimitClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitLimitClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final LimitClauseContext limitClause() throws RecognitionException {
		LimitClauseContext _localctx = new LimitClauseContext(_ctx, getState());
		enterRule(_localctx, 140, RULE_limitClause);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(975);
			match(LIMIT);
			setState(976);
			parameterOrIntegerLiteral();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class OffsetClauseContext extends ParserRuleContext {
		public TerminalNode OFFSET() { return getToken(HqlParser.OFFSET, 0); }
		public ParameterOrIntegerLiteralContext parameterOrIntegerLiteral() {
			return getRuleContext(ParameterOrIntegerLiteralContext.class,0);
		}
		public TerminalNode ROW() { return getToken(HqlParser.ROW, 0); }
		public TerminalNode ROWS() { return getToken(HqlParser.ROWS, 0); }
		public OffsetClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_offsetClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOffsetClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOffsetClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOffsetClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OffsetClauseContext offsetClause() throws RecognitionException {
		OffsetClauseContext _localctx = new OffsetClauseContext(_ctx, getState());
		enterRule(_localctx, 142, RULE_offsetClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(978);
			match(OFFSET);
			setState(979);
			parameterOrIntegerLiteral();
			setState(981);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==ROW || _la==ROWS) {
				{
				setState(980);
				_la = _input.LA(1);
				if ( !(_la==ROW || _la==ROWS) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class FetchClauseContext extends ParserRuleContext {
		public TerminalNode FETCH() { return getToken(HqlParser.FETCH, 0); }
		public FetchCountOrPercentContext fetchCountOrPercent() {
			return getRuleContext(FetchCountOrPercentContext.class,0);
		}
		public TerminalNode FIRST() { return getToken(HqlParser.FIRST, 0); }
		public TerminalNode NEXT() { return getToken(HqlParser.NEXT, 0); }
		public TerminalNode ROW() { return getToken(HqlParser.ROW, 0); }
		public TerminalNode ROWS() { return getToken(HqlParser.ROWS, 0); }
		public TerminalNode ONLY() { return getToken(HqlParser.ONLY, 0); }
		public TerminalNode WITH() { return getToken(HqlParser.WITH, 0); }
		public TerminalNode TIES() { return getToken(HqlParser.TIES, 0); }
		public FetchClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_fetchClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFetchClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFetchClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFetchClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FetchClauseContext fetchClause() throws RecognitionException {
		FetchClauseContext _localctx = new FetchClauseContext(_ctx, getState());
		enterRule(_localctx, 144, RULE_fetchClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(983);
			match(FETCH);
			setState(984);
			_la = _input.LA(1);
			if ( !(_la==FIRST || _la==NEXT) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			setState(985);
			fetchCountOrPercent();
			setState(986);
			_la = _input.LA(1);
			if ( !(_la==ROW || _la==ROWS) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			setState(990);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case ONLY:
				{
				setState(987);
				match(ONLY);
				}
				break;
			case WITH:
				{
				setState(988);
				match(WITH);
				setState(989);
				match(TIES);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class FetchCountOrPercentContext extends ParserRuleContext {
		public ParameterOrIntegerLiteralContext parameterOrIntegerLiteral() {
			return getRuleContext(ParameterOrIntegerLiteralContext.class,0);
		}
		public ParameterOrNumberLiteralContext parameterOrNumberLiteral() {
			return getRuleContext(ParameterOrNumberLiteralContext.class,0);
		}
		public TerminalNode PERCENT() { return getToken(HqlParser.PERCENT, 0); }
		public FetchCountOrPercentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_fetchCountOrPercent; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFetchCountOrPercent(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFetchCountOrPercent(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFetchCountOrPercent(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FetchCountOrPercentContext fetchCountOrPercent() throws RecognitionException {
		FetchCountOrPercentContext _localctx = new FetchCountOrPercentContext(_ctx, getState());
		enterRule(_localctx, 146, RULE_fetchCountOrPercent);
		try {
			setState(996);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,98,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(992);
				parameterOrIntegerLiteral();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(993);
				parameterOrNumberLiteral();
				setState(994);
				match(PERCENT);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class ParameterOrIntegerLiteralContext extends ParserRuleContext {
		public ParameterContext parameter() {
			return getRuleContext(ParameterContext.class,0);
		}
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public ParameterOrIntegerLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_parameterOrIntegerLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterParameterOrIntegerLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitParameterOrIntegerLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitParameterOrIntegerLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ParameterOrIntegerLiteralContext parameterOrIntegerLiteral() throws RecognitionException {
		ParameterOrIntegerLiteralContext _localctx = new ParameterOrIntegerLiteralContext(_ctx, getState());
		enterRule(_localctx, 148, RULE_parameterOrIntegerLiteral);
		try {
			setState(1000);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case COLON:
			case QUESTION_MARK:
				enterOuterAlt(_localctx, 1);
				{
				setState(998);
				parameter();
				}
				break;
			case INTEGER_LITERAL:
				enterOuterAlt(_localctx, 2);
				{
				setState(999);
				match(INTEGER_LITERAL);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class ParameterOrNumberLiteralContext extends ParserRuleContext {
		public ParameterContext parameter() {
			return getRuleContext(ParameterContext.class,0);
		}
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public TerminalNode LONG_LITERAL() { return getToken(HqlParser.LONG_LITERAL, 0); }
		public TerminalNode FLOAT_LITERAL() { return getToken(HqlParser.FLOAT_LITERAL, 0); }
		public TerminalNode DOUBLE_LITERAL() { return getToken(HqlParser.DOUBLE_LITERAL, 0); }
		public ParameterOrNumberLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_parameterOrNumberLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterParameterOrNumberLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitParameterOrNumberLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitParameterOrNumberLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ParameterOrNumberLiteralContext parameterOrNumberLiteral() throws RecognitionException {
		ParameterOrNumberLiteralContext _localctx = new ParameterOrNumberLiteralContext(_ctx, getState());
		enterRule(_localctx, 150, RULE_parameterOrNumberLiteral);
		try {
			setState(1007);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case COLON:
			case QUESTION_MARK:
				enterOuterAlt(_localctx, 1);
				{
				setState(1002);
				parameter();
				}
				break;
			case INTEGER_LITERAL:
				enterOuterAlt(_localctx, 2);
				{
				setState(1003);
				match(INTEGER_LITERAL);
				}
				break;
			case LONG_LITERAL:
				enterOuterAlt(_localctx, 3);
				{
				setState(1004);
				match(LONG_LITERAL);
				}
				break;
			case FLOAT_LITERAL:
				enterOuterAlt(_localctx, 4);
				{
				setState(1005);
				match(FLOAT_LITERAL);
				}
				break;
			case DOUBLE_LITERAL:
				enterOuterAlt(_localctx, 5);
				{
				setState(1006);
				match(DOUBLE_LITERAL);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class WhereClauseContext extends ParserRuleContext {
		public TerminalNode WHERE() { return getToken(HqlParser.WHERE, 0); }
		public PredicateContext predicate() {
			return getRuleContext(PredicateContext.class,0);
		}
		public WhereClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_whereClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterWhereClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitWhereClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitWhereClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final WhereClauseContext whereClause() throws RecognitionException {
		WhereClauseContext _localctx = new WhereClauseContext(_ctx, getState());
		enterRule(_localctx, 152, RULE_whereClause);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1009);
			match(WHERE);
			setState(1010);
			predicate(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class PredicateContext extends ParserRuleContext {
		public PredicateContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_predicate; }
	 
		public PredicateContext() { }
		public void copyFrom(PredicateContext ctx) {
			super.copyFrom(ctx);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class IsDistinctFromPredicateContext extends PredicateContext {
		public List<ExpressionContext> expression() {
			return getRuleContexts(ExpressionContext.class);
		}
		public ExpressionContext expression(int i) {
			return getRuleContext(ExpressionContext.class,i);
		}
		public TerminalNode IS() { return getToken(HqlParser.IS, 0); }
		public TerminalNode DISTINCT() { return getToken(HqlParser.DISTINCT, 0); }
		public TerminalNode FROM() { return getToken(HqlParser.FROM, 0); }
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public IsDistinctFromPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterIsDistinctFromPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitIsDistinctFromPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitIsDistinctFromPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class BetweenPredicateContext extends PredicateContext {
		public List<ExpressionContext> expression() {
			return getRuleContexts(ExpressionContext.class);
		}
		public ExpressionContext expression(int i) {
			return getRuleContext(ExpressionContext.class,i);
		}
		public TerminalNode BETWEEN() { return getToken(HqlParser.BETWEEN, 0); }
		public TerminalNode AND() { return getToken(HqlParser.AND, 0); }
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public BetweenPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterBetweenPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitBetweenPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitBetweenPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class ExistsPredicateContext extends PredicateContext {
		public TerminalNode EXISTS() { return getToken(HqlParser.EXISTS, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public ExistsPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterExistsPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitExistsPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitExistsPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class AndPredicateContext extends PredicateContext {
		public List<PredicateContext> predicate() {
			return getRuleContexts(PredicateContext.class);
		}
		public PredicateContext predicate(int i) {
			return getRuleContext(PredicateContext.class,i);
		}
		public TerminalNode AND() { return getToken(HqlParser.AND, 0); }
		public AndPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterAndPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitAndPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitAndPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class IsFalsePredicateContext extends PredicateContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode IS() { return getToken(HqlParser.IS, 0); }
		public TerminalNode FALSE() { return getToken(HqlParser.FALSE, 0); }
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public IsFalsePredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterIsFalsePredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitIsFalsePredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitIsFalsePredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class GroupedPredicateContext extends PredicateContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PredicateContext predicate() {
			return getRuleContext(PredicateContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public GroupedPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGroupedPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGroupedPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGroupedPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class LikePredicateContext extends PredicateContext {
		public List<ExpressionContext> expression() {
			return getRuleContexts(ExpressionContext.class);
		}
		public ExpressionContext expression(int i) {
			return getRuleContext(ExpressionContext.class,i);
		}
		public TerminalNode LIKE() { return getToken(HqlParser.LIKE, 0); }
		public TerminalNode ILIKE() { return getToken(HqlParser.ILIKE, 0); }
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public LikeEscapeContext likeEscape() {
			return getRuleContext(LikeEscapeContext.class,0);
		}
		public LikePredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterLikePredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitLikePredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitLikePredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class InPredicateContext extends PredicateContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode IN() { return getToken(HqlParser.IN, 0); }
		public InListContext inList() {
			return getRuleContext(InListContext.class,0);
		}
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public InPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterInPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitInPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitInPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class ComparisonPredicateContext extends PredicateContext {
		public List<ExpressionContext> expression() {
			return getRuleContexts(ExpressionContext.class);
		}
		public ExpressionContext expression(int i) {
			return getRuleContext(ExpressionContext.class,i);
		}
		public ComparisonOperatorContext comparisonOperator() {
			return getRuleContext(ComparisonOperatorContext.class,0);
		}
		public ComparisonPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterComparisonPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitComparisonPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitComparisonPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class ExistsCollectionPartPredicateContext extends PredicateContext {
		public TerminalNode EXISTS() { return getToken(HqlParser.EXISTS, 0); }
		public CollectionQuantifierContext collectionQuantifier() {
			return getRuleContext(CollectionQuantifierContext.class,0);
		}
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public ExistsCollectionPartPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterExistsCollectionPartPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitExistsCollectionPartPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitExistsCollectionPartPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class NegatedPredicateContext extends PredicateContext {
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public PredicateContext predicate() {
			return getRuleContext(PredicateContext.class,0);
		}
		public NegatedPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterNegatedPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitNegatedPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitNegatedPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class BooleanExpressionPredicateContext extends PredicateContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public BooleanExpressionPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterBooleanExpressionPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitBooleanExpressionPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitBooleanExpressionPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class OrPredicateContext extends PredicateContext {
		public List<PredicateContext> predicate() {
			return getRuleContexts(PredicateContext.class);
		}
		public PredicateContext predicate(int i) {
			return getRuleContext(PredicateContext.class,i);
		}
		public TerminalNode OR() { return getToken(HqlParser.OR, 0); }
		public OrPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOrPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOrPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOrPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class MemberOfPredicateContext extends PredicateContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode MEMBER() { return getToken(HqlParser.MEMBER, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public TerminalNode OF() { return getToken(HqlParser.OF, 0); }
		public MemberOfPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterMemberOfPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitMemberOfPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitMemberOfPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class IsEmptyPredicateContext extends PredicateContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode IS() { return getToken(HqlParser.IS, 0); }
		public TerminalNode EMPTY() { return getToken(HqlParser.EMPTY, 0); }
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public IsEmptyPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterIsEmptyPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitIsEmptyPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitIsEmptyPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class IsNullPredicateContext extends PredicateContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode IS() { return getToken(HqlParser.IS, 0); }
		public TerminalNode NULL() { return getToken(HqlParser.NULL, 0); }
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public IsNullPredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterIsNullPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitIsNullPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitIsNullPredicate(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class IsTruePredicateContext extends PredicateContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode IS() { return getToken(HqlParser.IS, 0); }
		public TerminalNode TRUE() { return getToken(HqlParser.TRUE, 0); }
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public IsTruePredicateContext(PredicateContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterIsTruePredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitIsTruePredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitIsTruePredicate(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PredicateContext predicate() throws RecognitionException {
		return predicate(0);
	}

	private PredicateContext predicate(int _p) throws RecognitionException {
		ParserRuleContext _parentctx = _ctx;
		int _parentState = getState();
		PredicateContext _localctx = new PredicateContext(_ctx, _parentState);
		PredicateContext _prevctx = _localctx;
		int _startState = 154;
		enterRecursionRule(_localctx, 154, RULE_predicate, _p);
		int _la;
		try {
			int _alt;
			enterOuterAlt(_localctx, 1);
			{
			setState(1104);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,112,_ctx) ) {
			case 1:
				{
				_localctx = new GroupedPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;

				setState(1013);
				match(LEFT_PAREN);
				setState(1014);
				predicate(0);
				setState(1015);
				match(RIGHT_PAREN);
				}
				break;
			case 2:
				{
				_localctx = new IsNullPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1017);
				expression(0);
				setState(1018);
				match(IS);
				setState(1020);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==NOT) {
					{
					setState(1019);
					match(NOT);
					}
				}

				setState(1022);
				match(NULL);
				}
				break;
			case 3:
				{
				_localctx = new IsEmptyPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1024);
				expression(0);
				setState(1025);
				match(IS);
				setState(1027);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==NOT) {
					{
					setState(1026);
					match(NOT);
					}
				}

				setState(1029);
				match(EMPTY);
				}
				break;
			case 4:
				{
				_localctx = new IsTruePredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1031);
				expression(0);
				setState(1032);
				match(IS);
				setState(1034);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==NOT) {
					{
					setState(1033);
					match(NOT);
					}
				}

				setState(1036);
				match(TRUE);
				}
				break;
			case 5:
				{
				_localctx = new IsFalsePredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1038);
				expression(0);
				setState(1039);
				match(IS);
				setState(1041);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==NOT) {
					{
					setState(1040);
					match(NOT);
					}
				}

				setState(1043);
				match(FALSE);
				}
				break;
			case 6:
				{
				_localctx = new IsDistinctFromPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1045);
				expression(0);
				setState(1046);
				match(IS);
				setState(1048);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==NOT) {
					{
					setState(1047);
					match(NOT);
					}
				}

				setState(1050);
				match(DISTINCT);
				setState(1051);
				match(FROM);
				setState(1052);
				expression(0);
				}
				break;
			case 7:
				{
				_localctx = new MemberOfPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1054);
				expression(0);
				setState(1056);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==NOT) {
					{
					setState(1055);
					match(NOT);
					}
				}

				setState(1058);
				match(MEMBER);
				setState(1060);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,107,_ctx) ) {
				case 1:
					{
					setState(1059);
					match(OF);
					}
					break;
				}
				setState(1062);
				path();
				}
				break;
			case 8:
				{
				_localctx = new InPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1064);
				expression(0);
				setState(1066);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==NOT) {
					{
					setState(1065);
					match(NOT);
					}
				}

				setState(1068);
				match(IN);
				setState(1069);
				inList();
				}
				break;
			case 9:
				{
				_localctx = new BetweenPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1071);
				expression(0);
				setState(1073);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==NOT) {
					{
					setState(1072);
					match(NOT);
					}
				}

				setState(1075);
				match(BETWEEN);
				setState(1076);
				expression(0);
				setState(1077);
				match(AND);
				setState(1078);
				expression(0);
				}
				break;
			case 10:
				{
				_localctx = new LikePredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1080);
				expression(0);
				setState(1082);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==NOT) {
					{
					setState(1081);
					match(NOT);
					}
				}

				setState(1084);
				_la = _input.LA(1);
				if ( !(_la==ILIKE || _la==LIKE) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1085);
				expression(0);
				setState(1087);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,111,_ctx) ) {
				case 1:
					{
					setState(1086);
					likeEscape();
					}
					break;
				}
				}
				break;
			case 11:
				{
				_localctx = new ComparisonPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1089);
				expression(0);
				setState(1090);
				comparisonOperator();
				setState(1091);
				expression(0);
				}
				break;
			case 12:
				{
				_localctx = new ExistsCollectionPartPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1093);
				match(EXISTS);
				setState(1094);
				collectionQuantifier();
				setState(1095);
				match(LEFT_PAREN);
				setState(1096);
				simplePath();
				setState(1097);
				match(RIGHT_PAREN);
				}
				break;
			case 13:
				{
				_localctx = new ExistsPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1099);
				match(EXISTS);
				setState(1100);
				expression(0);
				}
				break;
			case 14:
				{
				_localctx = new NegatedPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1101);
				match(NOT);
				setState(1102);
				predicate(4);
				}
				break;
			case 15:
				{
				_localctx = new BooleanExpressionPredicateContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1103);
				expression(0);
				}
				break;
			}
			_ctx.stop = _input.LT(-1);
			setState(1114);
			_errHandler.sync(this);
			_alt = getInterpreter().adaptivePredict(_input,114,_ctx);
			while ( _alt!=2 && _alt!=org.antlr.v4.runtime.atn.ATN.INVALID_ALT_NUMBER ) {
				if ( _alt==1 ) {
					if ( _parseListeners!=null ) triggerExitRuleEvent();
					_prevctx = _localctx;
					{
					setState(1112);
					_errHandler.sync(this);
					switch ( getInterpreter().adaptivePredict(_input,113,_ctx) ) {
					case 1:
						{
						_localctx = new AndPredicateContext(new PredicateContext(_parentctx, _parentState));
						pushNewRecursionContext(_localctx, _startState, RULE_predicate);
						setState(1106);
						if (!(precpred(_ctx, 3))) throw new FailedPredicateException(this, "precpred(_ctx, 3)");
						setState(1107);
						match(AND);
						setState(1108);
						predicate(4);
						}
						break;
					case 2:
						{
						_localctx = new OrPredicateContext(new PredicateContext(_parentctx, _parentState));
						pushNewRecursionContext(_localctx, _startState, RULE_predicate);
						setState(1109);
						if (!(precpred(_ctx, 2))) throw new FailedPredicateException(this, "precpred(_ctx, 2)");
						setState(1110);
						match(OR);
						setState(1111);
						predicate(3);
						}
						break;
					}
					} 
				}
				setState(1116);
				_errHandler.sync(this);
				_alt = getInterpreter().adaptivePredict(_input,114,_ctx);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			unrollRecursionContexts(_parentctx);
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class ComparisonOperatorContext extends ParserRuleContext {
		public TerminalNode EQUAL() { return getToken(HqlParser.EQUAL, 0); }
		public TerminalNode NOT_EQUAL() { return getToken(HqlParser.NOT_EQUAL, 0); }
		public TerminalNode GREATER() { return getToken(HqlParser.GREATER, 0); }
		public TerminalNode GREATER_EQUAL() { return getToken(HqlParser.GREATER_EQUAL, 0); }
		public TerminalNode LESS() { return getToken(HqlParser.LESS, 0); }
		public TerminalNode LESS_EQUAL() { return getToken(HqlParser.LESS_EQUAL, 0); }
		public ComparisonOperatorContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_comparisonOperator; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterComparisonOperator(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitComparisonOperator(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitComparisonOperator(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ComparisonOperatorContext comparisonOperator() throws RecognitionException {
		ComparisonOperatorContext _localctx = new ComparisonOperatorContext(_ctx, getState());
		enterRule(_localctx, 156, RULE_comparisonOperator);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1117);
			_la = _input.LA(1);
			if ( !((((_la) & ~0x3f) == 0 && ((1L << _la) & 4128768L) != 0)) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class InListContext extends ParserRuleContext {
		public InListContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_inList; }
	 
		public InListContext() { }
		public void copyFrom(InListContext ctx) {
			super.copyFrom(ctx);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class SubqueryInListContext extends InListContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public SubqueryContext subquery() {
			return getRuleContext(SubqueryContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public SubqueryInListContext(InListContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSubqueryInList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSubqueryInList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSubqueryInList(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class PersistentCollectionReferenceInListContext extends InListContext {
		public CollectionQuantifierContext collectionQuantifier() {
			return getRuleContext(CollectionQuantifierContext.class,0);
		}
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public PersistentCollectionReferenceInListContext(InListContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPersistentCollectionReferenceInList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPersistentCollectionReferenceInList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPersistentCollectionReferenceInList(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class ParamInListContext extends InListContext {
		public ParameterContext parameter() {
			return getRuleContext(ParameterContext.class,0);
		}
		public ParamInListContext(InListContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterParamInList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitParamInList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitParamInList(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class ExplicitTupleInListContext extends InListContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public List<ExpressionOrPredicateContext> expressionOrPredicate() {
			return getRuleContexts(ExpressionOrPredicateContext.class);
		}
		public ExpressionOrPredicateContext expressionOrPredicate(int i) {
			return getRuleContext(ExpressionOrPredicateContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public ExplicitTupleInListContext(InListContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterExplicitTupleInList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitExplicitTupleInList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitExplicitTupleInList(this);
			else return visitor.visitChildren(this);
		}
	}

	public final InListContext inList() throws RecognitionException {
		InListContext _localctx = new InListContext(_ctx, getState());
		enterRule(_localctx, 158, RULE_inList);
		int _la;
		try {
			setState(1141);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,117,_ctx) ) {
			case 1:
				_localctx = new PersistentCollectionReferenceInListContext(_localctx);
				enterOuterAlt(_localctx, 1);
				{
				setState(1119);
				collectionQuantifier();
				setState(1120);
				match(LEFT_PAREN);
				setState(1121);
				simplePath();
				setState(1122);
				match(RIGHT_PAREN);
				}
				break;
			case 2:
				_localctx = new ExplicitTupleInListContext(_localctx);
				enterOuterAlt(_localctx, 2);
				{
				setState(1124);
				match(LEFT_PAREN);
				setState(1133);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if ((((_la) & ~0x3f) == 0 && ((1L << _la) & -3157589426184L) != 0) || ((((_la - 64)) & ~0x3f) == 0 && ((1L << (_la - 64)) & -1L) != 0) || ((((_la - 128)) & ~0x3f) == 0 && ((1L << (_la - 128)) & -1L) != 0) || ((((_la - 192)) & ~0x3f) == 0 && ((1L << (_la - 192)) & 268435455L) != 0)) {
					{
					setState(1125);
					expressionOrPredicate();
					setState(1130);
					_errHandler.sync(this);
					_la = _input.LA(1);
					while (_la==COMMA) {
						{
						{
						setState(1126);
						match(COMMA);
						setState(1127);
						expressionOrPredicate();
						}
						}
						setState(1132);
						_errHandler.sync(this);
						_la = _input.LA(1);
					}
					}
				}

				setState(1135);
				match(RIGHT_PAREN);
				}
				break;
			case 3:
				_localctx = new SubqueryInListContext(_localctx);
				enterOuterAlt(_localctx, 3);
				{
				setState(1136);
				match(LEFT_PAREN);
				setState(1137);
				subquery();
				setState(1138);
				match(RIGHT_PAREN);
				}
				break;
			case 4:
				_localctx = new ParamInListContext(_localctx);
				enterOuterAlt(_localctx, 4);
				{
				setState(1140);
				parameter();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class LikeEscapeContext extends ParserRuleContext {
		public TerminalNode ESCAPE() { return getToken(HqlParser.ESCAPE, 0); }
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public TerminalNode JAVA_STRING_LITERAL() { return getToken(HqlParser.JAVA_STRING_LITERAL, 0); }
		public ParameterContext parameter() {
			return getRuleContext(ParameterContext.class,0);
		}
		public LikeEscapeContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_likeEscape; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterLikeEscape(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitLikeEscape(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitLikeEscape(this);
			else return visitor.visitChildren(this);
		}
	}

	public final LikeEscapeContext likeEscape() throws RecognitionException {
		LikeEscapeContext _localctx = new LikeEscapeContext(_ctx, getState());
		enterRule(_localctx, 160, RULE_likeEscape);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1143);
			match(ESCAPE);
			setState(1147);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case STRING_LITERAL:
				{
				setState(1144);
				match(STRING_LITERAL);
				}
				break;
			case JAVA_STRING_LITERAL:
				{
				setState(1145);
				match(JAVA_STRING_LITERAL);
				}
				break;
			case COLON:
			case QUESTION_MARK:
				{
				setState(1146);
				parameter();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class ExpressionContext extends ParserRuleContext {
		public ExpressionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_expression; }
	 
		public ExpressionContext() { }
		public void copyFrom(ExpressionContext ctx) {
			super.copyFrom(ctx);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class AdditionExpressionContext extends ExpressionContext {
		public List<ExpressionContext> expression() {
			return getRuleContexts(ExpressionContext.class);
		}
		public ExpressionContext expression(int i) {
			return getRuleContext(ExpressionContext.class,i);
		}
		public AdditiveOperatorContext additiveOperator() {
			return getRuleContext(AdditiveOperatorContext.class,0);
		}
		public AdditionExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterAdditionExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitAdditionExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitAdditionExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class FromDurationExpressionContext extends ExpressionContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode BY() { return getToken(HqlParser.BY, 0); }
		public DatetimeFieldContext datetimeField() {
			return getRuleContext(DatetimeFieldContext.class,0);
		}
		public FromDurationExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFromDurationExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFromDurationExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFromDurationExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class BarePrimaryExpressionContext extends ExpressionContext {
		public PrimaryExpressionContext primaryExpression() {
			return getRuleContext(PrimaryExpressionContext.class,0);
		}
		public BarePrimaryExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterBarePrimaryExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitBarePrimaryExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitBarePrimaryExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class TupleExpressionContext extends ExpressionContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public List<ExpressionOrPredicateContext> expressionOrPredicate() {
			return getRuleContexts(ExpressionOrPredicateContext.class);
		}
		public ExpressionOrPredicateContext expressionOrPredicate(int i) {
			return getRuleContext(ExpressionOrPredicateContext.class,i);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public TupleExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTupleExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTupleExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTupleExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class UnaryExpressionContext extends ExpressionContext {
		public SignOperatorContext signOperator() {
			return getRuleContext(SignOperatorContext.class,0);
		}
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public UnaryExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterUnaryExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitUnaryExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitUnaryExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class GroupedExpressionContext extends ExpressionContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public GroupedExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGroupedExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGroupedExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGroupedExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class ConcatenationExpressionContext extends ExpressionContext {
		public List<ExpressionContext> expression() {
			return getRuleContexts(ExpressionContext.class);
		}
		public ExpressionContext expression(int i) {
			return getRuleContext(ExpressionContext.class,i);
		}
		public TerminalNode DOUBLE_PIPE() { return getToken(HqlParser.DOUBLE_PIPE, 0); }
		public ConcatenationExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterConcatenationExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitConcatenationExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitConcatenationExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class MultiplicationExpressionContext extends ExpressionContext {
		public List<ExpressionContext> expression() {
			return getRuleContexts(ExpressionContext.class);
		}
		public ExpressionContext expression(int i) {
			return getRuleContext(ExpressionContext.class,i);
		}
		public MultiplicativeOperatorContext multiplicativeOperator() {
			return getRuleContext(MultiplicativeOperatorContext.class,0);
		}
		public MultiplicationExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterMultiplicationExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitMultiplicationExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitMultiplicationExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class ToDurationExpressionContext extends ExpressionContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public DatetimeFieldContext datetimeField() {
			return getRuleContext(DatetimeFieldContext.class,0);
		}
		public ToDurationExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterToDurationExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitToDurationExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitToDurationExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class SubqueryExpressionContext extends ExpressionContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public SubqueryContext subquery() {
			return getRuleContext(SubqueryContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public SubqueryExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSubqueryExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSubqueryExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSubqueryExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class UnaryNumericLiteralExpressionContext extends ExpressionContext {
		public SignOperatorContext signOperator() {
			return getRuleContext(SignOperatorContext.class,0);
		}
		public NumericLiteralContext numericLiteral() {
			return getRuleContext(NumericLiteralContext.class,0);
		}
		public UnaryNumericLiteralExpressionContext(ExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterUnaryNumericLiteralExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitUnaryNumericLiteralExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitUnaryNumericLiteralExpression(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ExpressionContext expression() throws RecognitionException {
		return expression(0);
	}

	private ExpressionContext expression(int _p) throws RecognitionException {
		ParserRuleContext _parentctx = _ctx;
		int _parentState = getState();
		ExpressionContext _localctx = new ExpressionContext(_ctx, _parentState);
		ExpressionContext _prevctx = _localctx;
		int _startState = 162;
		enterRecursionRule(_localctx, 162, RULE_expression, _p);
		int _la;
		try {
			int _alt;
			enterOuterAlt(_localctx, 1);
			{
			setState(1175);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,120,_ctx) ) {
			case 1:
				{
				_localctx = new GroupedExpressionContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;

				setState(1150);
				match(LEFT_PAREN);
				setState(1151);
				expression(0);
				setState(1152);
				match(RIGHT_PAREN);
				}
				break;
			case 2:
				{
				_localctx = new TupleExpressionContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1154);
				match(LEFT_PAREN);
				setState(1155);
				expressionOrPredicate();
				setState(1158); 
				_errHandler.sync(this);
				_la = _input.LA(1);
				do {
					{
					{
					setState(1156);
					match(COMMA);
					setState(1157);
					expressionOrPredicate();
					}
					}
					setState(1160); 
					_errHandler.sync(this);
					_la = _input.LA(1);
				} while ( _la==COMMA );
				setState(1162);
				match(RIGHT_PAREN);
				}
				break;
			case 3:
				{
				_localctx = new SubqueryExpressionContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1164);
				match(LEFT_PAREN);
				setState(1165);
				subquery();
				setState(1166);
				match(RIGHT_PAREN);
				}
				break;
			case 4:
				{
				_localctx = new BarePrimaryExpressionContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1168);
				primaryExpression();
				}
				break;
			case 5:
				{
				_localctx = new UnaryNumericLiteralExpressionContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1169);
				signOperator();
				setState(1170);
				numericLiteral();
				}
				break;
			case 6:
				{
				_localctx = new UnaryExpressionContext(_localctx);
				_ctx = _localctx;
				_prevctx = _localctx;
				setState(1172);
				signOperator();
				setState(1173);
				expression(6);
				}
				break;
			}
			_ctx.stop = _input.LT(-1);
			setState(1195);
			_errHandler.sync(this);
			_alt = getInterpreter().adaptivePredict(_input,122,_ctx);
			while ( _alt!=2 && _alt!=org.antlr.v4.runtime.atn.ATN.INVALID_ALT_NUMBER ) {
				if ( _alt==1 ) {
					if ( _parseListeners!=null ) triggerExitRuleEvent();
					_prevctx = _localctx;
					{
					setState(1193);
					_errHandler.sync(this);
					switch ( getInterpreter().adaptivePredict(_input,121,_ctx) ) {
					case 1:
						{
						_localctx = new MultiplicationExpressionContext(new ExpressionContext(_parentctx, _parentState));
						pushNewRecursionContext(_localctx, _startState, RULE_expression);
						setState(1177);
						if (!(precpred(_ctx, 3))) throw new FailedPredicateException(this, "precpred(_ctx, 3)");
						setState(1178);
						multiplicativeOperator();
						setState(1179);
						expression(4);
						}
						break;
					case 2:
						{
						_localctx = new AdditionExpressionContext(new ExpressionContext(_parentctx, _parentState));
						pushNewRecursionContext(_localctx, _startState, RULE_expression);
						setState(1181);
						if (!(precpred(_ctx, 2))) throw new FailedPredicateException(this, "precpred(_ctx, 2)");
						setState(1182);
						additiveOperator();
						setState(1183);
						expression(3);
						}
						break;
					case 3:
						{
						_localctx = new ConcatenationExpressionContext(new ExpressionContext(_parentctx, _parentState));
						pushNewRecursionContext(_localctx, _startState, RULE_expression);
						setState(1185);
						if (!(precpred(_ctx, 1))) throw new FailedPredicateException(this, "precpred(_ctx, 1)");
						setState(1186);
						match(DOUBLE_PIPE);
						setState(1187);
						expression(2);
						}
						break;
					case 4:
						{
						_localctx = new ToDurationExpressionContext(new ExpressionContext(_parentctx, _parentState));
						pushNewRecursionContext(_localctx, _startState, RULE_expression);
						setState(1188);
						if (!(precpred(_ctx, 5))) throw new FailedPredicateException(this, "precpred(_ctx, 5)");
						setState(1189);
						datetimeField();
						}
						break;
					case 5:
						{
						_localctx = new FromDurationExpressionContext(new ExpressionContext(_parentctx, _parentState));
						pushNewRecursionContext(_localctx, _startState, RULE_expression);
						setState(1190);
						if (!(precpred(_ctx, 4))) throw new FailedPredicateException(this, "precpred(_ctx, 4)");
						setState(1191);
						match(BY);
						setState(1192);
						datetimeField();
						}
						break;
					}
					} 
				}
				setState(1197);
				_errHandler.sync(this);
				_alt = getInterpreter().adaptivePredict(_input,122,_ctx);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			unrollRecursionContexts(_parentctx);
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class PrimaryExpressionContext extends ParserRuleContext {
		public PrimaryExpressionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_primaryExpression; }
	 
		public PrimaryExpressionContext() { }
		public void copyFrom(PrimaryExpressionContext ctx) {
			super.copyFrom(ctx);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class FunctionExpressionContext extends PrimaryExpressionContext {
		public FunctionContext function() {
			return getRuleContext(FunctionContext.class,0);
		}
		public FunctionExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFunctionExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFunctionExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFunctionExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class LiteralExpressionContext extends PrimaryExpressionContext {
		public LiteralContext literal() {
			return getRuleContext(LiteralContext.class,0);
		}
		public LiteralExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterLiteralExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitLiteralExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitLiteralExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class ParameterExpressionContext extends PrimaryExpressionContext {
		public ParameterContext parameter() {
			return getRuleContext(ParameterContext.class,0);
		}
		public ParameterExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterParameterExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitParameterExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitParameterExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class EntityTypeExpressionContext extends PrimaryExpressionContext {
		public EntityTypeReferenceContext entityTypeReference() {
			return getRuleContext(EntityTypeReferenceContext.class,0);
		}
		public EntityTypeExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityTypeExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityTypeExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityTypeExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class EntityIdExpressionContext extends PrimaryExpressionContext {
		public EntityIdReferenceContext entityIdReference() {
			return getRuleContext(EntityIdReferenceContext.class,0);
		}
		public EntityIdExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityIdExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityIdExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityIdExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class EntityVersionExpressionContext extends PrimaryExpressionContext {
		public EntityVersionReferenceContext entityVersionReference() {
			return getRuleContext(EntityVersionReferenceContext.class,0);
		}
		public EntityVersionExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityVersionExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityVersionExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityVersionExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class GeneralPathExpressionContext extends PrimaryExpressionContext {
		public GeneralPathFragmentContext generalPathFragment() {
			return getRuleContext(GeneralPathFragmentContext.class,0);
		}
		public GeneralPathExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGeneralPathExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGeneralPathExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGeneralPathExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class EntityNaturalIdExpressionContext extends PrimaryExpressionContext {
		public EntityNaturalIdReferenceContext entityNaturalIdReference() {
			return getRuleContext(EntityNaturalIdReferenceContext.class,0);
		}
		public EntityNaturalIdExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityNaturalIdExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityNaturalIdExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityNaturalIdExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class CaseExpressionContext extends PrimaryExpressionContext {
		public CaseListContext caseList() {
			return getRuleContext(CaseListContext.class,0);
		}
		public CaseExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCaseExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCaseExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCaseExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class ToOneFkExpressionContext extends PrimaryExpressionContext {
		public ToOneFkReferenceContext toOneFkReference() {
			return getRuleContext(ToOneFkReferenceContext.class,0);
		}
		public ToOneFkExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterToOneFkExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitToOneFkExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitToOneFkExpression(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class SyntacticPathExpressionContext extends PrimaryExpressionContext {
		public SyntacticDomainPathContext syntacticDomainPath() {
			return getRuleContext(SyntacticDomainPathContext.class,0);
		}
		public PathContinuationContext pathContinuation() {
			return getRuleContext(PathContinuationContext.class,0);
		}
		public SyntacticPathExpressionContext(PrimaryExpressionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSyntacticPathExpression(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSyntacticPathExpression(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSyntacticPathExpression(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PrimaryExpressionContext primaryExpression() throws RecognitionException {
		PrimaryExpressionContext _localctx = new PrimaryExpressionContext(_ctx, getState());
		enterRule(_localctx, 164, RULE_primaryExpression);
		try {
			setState(1212);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,124,_ctx) ) {
			case 1:
				_localctx = new CaseExpressionContext(_localctx);
				enterOuterAlt(_localctx, 1);
				{
				setState(1198);
				caseList();
				}
				break;
			case 2:
				_localctx = new LiteralExpressionContext(_localctx);
				enterOuterAlt(_localctx, 2);
				{
				setState(1199);
				literal();
				}
				break;
			case 3:
				_localctx = new ParameterExpressionContext(_localctx);
				enterOuterAlt(_localctx, 3);
				{
				setState(1200);
				parameter();
				}
				break;
			case 4:
				_localctx = new EntityTypeExpressionContext(_localctx);
				enterOuterAlt(_localctx, 4);
				{
				setState(1201);
				entityTypeReference();
				}
				break;
			case 5:
				_localctx = new EntityIdExpressionContext(_localctx);
				enterOuterAlt(_localctx, 5);
				{
				setState(1202);
				entityIdReference();
				}
				break;
			case 6:
				_localctx = new EntityVersionExpressionContext(_localctx);
				enterOuterAlt(_localctx, 6);
				{
				setState(1203);
				entityVersionReference();
				}
				break;
			case 7:
				_localctx = new EntityNaturalIdExpressionContext(_localctx);
				enterOuterAlt(_localctx, 7);
				{
				setState(1204);
				entityNaturalIdReference();
				}
				break;
			case 8:
				_localctx = new ToOneFkExpressionContext(_localctx);
				enterOuterAlt(_localctx, 8);
				{
				setState(1205);
				toOneFkReference();
				}
				break;
			case 9:
				_localctx = new SyntacticPathExpressionContext(_localctx);
				enterOuterAlt(_localctx, 9);
				{
				setState(1206);
				syntacticDomainPath();
				setState(1208);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,123,_ctx) ) {
				case 1:
					{
					setState(1207);
					pathContinuation();
					}
					break;
				}
				}
				break;
			case 10:
				_localctx = new FunctionExpressionContext(_localctx);
				enterOuterAlt(_localctx, 10);
				{
				setState(1210);
				function();
				}
				break;
			case 11:
				_localctx = new GeneralPathExpressionContext(_localctx);
				enterOuterAlt(_localctx, 11);
				{
				setState(1211);
				generalPathFragment();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class ExpressionOrPredicateContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public PredicateContext predicate() {
			return getRuleContext(PredicateContext.class,0);
		}
		public ExpressionOrPredicateContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_expressionOrPredicate; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterExpressionOrPredicate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitExpressionOrPredicate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitExpressionOrPredicate(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ExpressionOrPredicateContext expressionOrPredicate() throws RecognitionException {
		ExpressionOrPredicateContext _localctx = new ExpressionOrPredicateContext(_ctx, getState());
		enterRule(_localctx, 166, RULE_expressionOrPredicate);
		try {
			setState(1216);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,125,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1214);
				expression(0);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1215);
				predicate(0);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class CollectionQuantifierContext extends ParserRuleContext {
		public ElementsValuesQuantifierContext elementsValuesQuantifier() {
			return getRuleContext(ElementsValuesQuantifierContext.class,0);
		}
		public IndicesKeysQuantifierContext indicesKeysQuantifier() {
			return getRuleContext(IndicesKeysQuantifierContext.class,0);
		}
		public CollectionQuantifierContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_collectionQuantifier; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCollectionQuantifier(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCollectionQuantifier(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCollectionQuantifier(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CollectionQuantifierContext collectionQuantifier() throws RecognitionException {
		CollectionQuantifierContext _localctx = new CollectionQuantifierContext(_ctx, getState());
		enterRule(_localctx, 168, RULE_collectionQuantifier);
		try {
			setState(1220);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case ELEMENTS:
			case VALUES:
				enterOuterAlt(_localctx, 1);
				{
				setState(1218);
				elementsValuesQuantifier();
				}
				break;
			case INDICES:
			case KEYS:
				enterOuterAlt(_localctx, 2);
				{
				setState(1219);
				indicesKeysQuantifier();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class ElementValueQuantifierContext extends ParserRuleContext {
		public TerminalNode ELEMENT() { return getToken(HqlParser.ELEMENT, 0); }
		public TerminalNode VALUE() { return getToken(HqlParser.VALUE, 0); }
		public ElementValueQuantifierContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_elementValueQuantifier; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterElementValueQuantifier(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitElementValueQuantifier(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitElementValueQuantifier(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ElementValueQuantifierContext elementValueQuantifier() throws RecognitionException {
		ElementValueQuantifierContext _localctx = new ElementValueQuantifierContext(_ctx, getState());
		enterRule(_localctx, 170, RULE_elementValueQuantifier);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1222);
			_la = _input.LA(1);
			if ( !(_la==ELEMENT || _la==VALUE) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class IndexKeyQuantifierContext extends ParserRuleContext {
		public TerminalNode INDEX() { return getToken(HqlParser.INDEX, 0); }
		public TerminalNode KEY() { return getToken(HqlParser.KEY, 0); }
		public IndexKeyQuantifierContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_indexKeyQuantifier; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterIndexKeyQuantifier(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitIndexKeyQuantifier(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitIndexKeyQuantifier(this);
			else return visitor.visitChildren(this);
		}
	}

	public final IndexKeyQuantifierContext indexKeyQuantifier() throws RecognitionException {
		IndexKeyQuantifierContext _localctx = new IndexKeyQuantifierContext(_ctx, getState());
		enterRule(_localctx, 172, RULE_indexKeyQuantifier);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1224);
			_la = _input.LA(1);
			if ( !(_la==INDEX || _la==KEY) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class ElementsValuesQuantifierContext extends ParserRuleContext {
		public TerminalNode ELEMENTS() { return getToken(HqlParser.ELEMENTS, 0); }
		public TerminalNode VALUES() { return getToken(HqlParser.VALUES, 0); }
		public ElementsValuesQuantifierContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_elementsValuesQuantifier; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterElementsValuesQuantifier(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitElementsValuesQuantifier(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitElementsValuesQuantifier(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ElementsValuesQuantifierContext elementsValuesQuantifier() throws RecognitionException {
		ElementsValuesQuantifierContext _localctx = new ElementsValuesQuantifierContext(_ctx, getState());
		enterRule(_localctx, 174, RULE_elementsValuesQuantifier);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1226);
			_la = _input.LA(1);
			if ( !(_la==ELEMENTS || _la==VALUES) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class IndicesKeysQuantifierContext extends ParserRuleContext {
		public TerminalNode INDICES() { return getToken(HqlParser.INDICES, 0); }
		public TerminalNode KEYS() { return getToken(HqlParser.KEYS, 0); }
		public IndicesKeysQuantifierContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_indicesKeysQuantifier; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterIndicesKeysQuantifier(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitIndicesKeysQuantifier(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitIndicesKeysQuantifier(this);
			else return visitor.visitChildren(this);
		}
	}

	public final IndicesKeysQuantifierContext indicesKeysQuantifier() throws RecognitionException {
		IndicesKeysQuantifierContext _localctx = new IndicesKeysQuantifierContext(_ctx, getState());
		enterRule(_localctx, 176, RULE_indicesKeysQuantifier);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1228);
			_la = _input.LA(1);
			if ( !(_la==INDICES || _la==KEYS) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class MultiplicativeOperatorContext extends ParserRuleContext {
		public TerminalNode SLASH() { return getToken(HqlParser.SLASH, 0); }
		public TerminalNode PERCENT_OP() { return getToken(HqlParser.PERCENT_OP, 0); }
		public TerminalNode ASTERISK() { return getToken(HqlParser.ASTERISK, 0); }
		public MultiplicativeOperatorContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_multiplicativeOperator; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterMultiplicativeOperator(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitMultiplicativeOperator(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitMultiplicativeOperator(this);
			else return visitor.visitChildren(this);
		}
	}

	public final MultiplicativeOperatorContext multiplicativeOperator() throws RecognitionException {
		MultiplicativeOperatorContext _localctx = new MultiplicativeOperatorContext(_ctx, getState());
		enterRule(_localctx, 178, RULE_multiplicativeOperator);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1230);
			_la = _input.LA(1);
			if ( !((((_la) & ~0x3f) == 0 && ((1L << _la) & 30064771072L) != 0)) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class AdditiveOperatorContext extends ParserRuleContext {
		public TerminalNode PLUS() { return getToken(HqlParser.PLUS, 0); }
		public TerminalNode MINUS() { return getToken(HqlParser.MINUS, 0); }
		public AdditiveOperatorContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_additiveOperator; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterAdditiveOperator(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitAdditiveOperator(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitAdditiveOperator(this);
			else return visitor.visitChildren(this);
		}
	}

	public final AdditiveOperatorContext additiveOperator() throws RecognitionException {
		AdditiveOperatorContext _localctx = new AdditiveOperatorContext(_ctx, getState());
		enterRule(_localctx, 180, RULE_additiveOperator);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1232);
			_la = _input.LA(1);
			if ( !(_la==PLUS || _la==MINUS) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SignOperatorContext extends ParserRuleContext {
		public TerminalNode PLUS() { return getToken(HqlParser.PLUS, 0); }
		public TerminalNode MINUS() { return getToken(HqlParser.MINUS, 0); }
		public SignOperatorContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_signOperator; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSignOperator(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSignOperator(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSignOperator(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SignOperatorContext signOperator() throws RecognitionException {
		SignOperatorContext _localctx = new SignOperatorContext(_ctx, getState());
		enterRule(_localctx, 182, RULE_signOperator);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1234);
			_la = _input.LA(1);
			if ( !(_la==PLUS || _la==MINUS) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class EntityTypeReferenceContext extends ParserRuleContext {
		public TerminalNode TYPE() { return getToken(HqlParser.TYPE, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public ParameterContext parameter() {
			return getRuleContext(ParameterContext.class,0);
		}
		public EntityTypeReferenceContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_entityTypeReference; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityTypeReference(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityTypeReference(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityTypeReference(this);
			else return visitor.visitChildren(this);
		}
	}

	public final EntityTypeReferenceContext entityTypeReference() throws RecognitionException {
		EntityTypeReferenceContext _localctx = new EntityTypeReferenceContext(_ctx, getState());
		enterRule(_localctx, 184, RULE_entityTypeReference);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1236);
			match(TYPE);
			setState(1237);
			match(LEFT_PAREN);
			setState(1240);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case ID:
			case VERSION:
			case VERSIONED:
			case NATURALID:
			case FK:
			case ALL:
			case AND:
			case ANY:
			case AS:
			case ASC:
			case AVG:
			case BETWEEN:
			case BOTH:
			case BREADTH:
			case BY:
			case CASE:
			case CAST:
			case COLLATE:
			case COLUMN:
			case CONFLICT:
			case CONSTRAINT:
			case COUNT:
			case CROSS:
			case CUBE:
			case CURRENT:
			case CURRENT_DATE:
			case CURRENT_INSTANT:
			case CURRENT_TIME:
			case CURRENT_TIMESTAMP:
			case CYCLE:
			case DATE:
			case DATETIME:
			case DAY:
			case DEFAULT:
			case DELETE:
			case DEPTH:
			case DESC:
			case DISTINCT:
			case DO:
			case ELEMENT:
			case ELEMENTS:
			case ELSE:
			case EMPTY:
			case END:
			case ENTRY:
			case EPOCH:
			case ERROR:
			case ESCAPE:
			case EVERY:
			case EXCEPT:
			case EXCLUDE:
			case EXISTS:
			case EXTRACT:
			case FETCH:
			case FILTER:
			case FIRST:
			case FOLLOWING:
			case FOR:
			case FORMAT:
			case FROM:
			case FULL:
			case FUNCTION:
			case GROUP:
			case GROUPS:
			case HAVING:
			case HOUR:
			case IGNORE:
			case ILIKE:
			case IN:
			case INDEX:
			case INDICES:
			case INNER:
			case INSERT:
			case INSTANT:
			case INTERSECT:
			case INTO:
			case IS:
			case JOIN:
			case KEY:
			case KEYS:
			case LAST:
			case LATERAL:
			case LEADING:
			case LEFT:
			case LIKE:
			case LIMIT:
			case LIST:
			case LISTAGG:
			case LOCAL:
			case LOCAL_DATE:
			case LOCAL_DATETIME:
			case LOCAL_TIME:
			case MAP:
			case MATERIALIZED:
			case MAX:
			case MAXELEMENT:
			case MAXINDEX:
			case MEMBER:
			case MICROSECOND:
			case MILLISECOND:
			case MIN:
			case MINELEMENT:
			case MININDEX:
			case MINUTE:
			case MONTH:
			case NANOSECOND:
			case NEW:
			case NEXT:
			case NO:
			case NOT:
			case NOTHING:
			case NULLS:
			case OBJECT:
			case OF:
			case OFFSET:
			case OFFSET_DATETIME:
			case ON:
			case ONLY:
			case OR:
			case ORDER:
			case OTHERS:
			case OUTER:
			case OVER:
			case OVERFLOW:
			case OVERLAY:
			case PAD:
			case PARTITION:
			case PERCENT:
			case PLACING:
			case POSITION:
			case PRECEDING:
			case QUARTER:
			case RANGE:
			case RESPECT:
			case RIGHT:
			case ROLLUP:
			case ROW:
			case ROWS:
			case SEARCH:
			case SECOND:
			case SELECT:
			case SET:
			case SIZE:
			case SOME:
			case SUBSTRING:
			case SUM:
			case THEN:
			case TIES:
			case TIME:
			case TIMESTAMP:
			case TIMEZONE_HOUR:
			case TIMEZONE_MINUTE:
			case TO:
			case TRAILING:
			case TREAT:
			case TRIM:
			case TRUNC:
			case TRUNCATE:
			case TYPE:
			case UNBOUNDED:
			case UNION:
			case UPDATE:
			case USING:
			case VALUE:
			case VALUES:
			case WEEK:
			case WHEN:
			case WHERE:
			case WITH:
			case WITHIN:
			case WITHOUT:
			case YEAR:
			case ZONED:
			case IDENTIFIER:
			case QUOTED_IDENTIFIER:
				{
				setState(1238);
				path();
				}
				break;
			case COLON:
			case QUESTION_MARK:
				{
				setState(1239);
				parameter();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
			setState(1242);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class EntityIdReferenceContext extends ParserRuleContext {
		public TerminalNode ID() { return getToken(HqlParser.ID, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public PathContinuationContext pathContinuation() {
			return getRuleContext(PathContinuationContext.class,0);
		}
		public EntityIdReferenceContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_entityIdReference; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityIdReference(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityIdReference(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityIdReference(this);
			else return visitor.visitChildren(this);
		}
	}

	public final EntityIdReferenceContext entityIdReference() throws RecognitionException {
		EntityIdReferenceContext _localctx = new EntityIdReferenceContext(_ctx, getState());
		enterRule(_localctx, 186, RULE_entityIdReference);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1244);
			match(ID);
			setState(1245);
			match(LEFT_PAREN);
			setState(1246);
			path();
			setState(1247);
			match(RIGHT_PAREN);
			setState(1249);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,128,_ctx) ) {
			case 1:
				{
				setState(1248);
				pathContinuation();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class EntityVersionReferenceContext extends ParserRuleContext {
		public TerminalNode VERSION() { return getToken(HqlParser.VERSION, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public EntityVersionReferenceContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_entityVersionReference; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityVersionReference(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityVersionReference(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityVersionReference(this);
			else return visitor.visitChildren(this);
		}
	}

	public final EntityVersionReferenceContext entityVersionReference() throws RecognitionException {
		EntityVersionReferenceContext _localctx = new EntityVersionReferenceContext(_ctx, getState());
		enterRule(_localctx, 188, RULE_entityVersionReference);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1251);
			match(VERSION);
			setState(1252);
			match(LEFT_PAREN);
			setState(1253);
			path();
			setState(1254);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class EntityNaturalIdReferenceContext extends ParserRuleContext {
		public TerminalNode NATURALID() { return getToken(HqlParser.NATURALID, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public PathContinuationContext pathContinuation() {
			return getRuleContext(PathContinuationContext.class,0);
		}
		public EntityNaturalIdReferenceContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_entityNaturalIdReference; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEntityNaturalIdReference(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEntityNaturalIdReference(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEntityNaturalIdReference(this);
			else return visitor.visitChildren(this);
		}
	}

	public final EntityNaturalIdReferenceContext entityNaturalIdReference() throws RecognitionException {
		EntityNaturalIdReferenceContext _localctx = new EntityNaturalIdReferenceContext(_ctx, getState());
		enterRule(_localctx, 190, RULE_entityNaturalIdReference);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1256);
			match(NATURALID);
			setState(1257);
			match(LEFT_PAREN);
			setState(1258);
			path();
			setState(1259);
			match(RIGHT_PAREN);
			setState(1261);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,129,_ctx) ) {
			case 1:
				{
				setState(1260);
				pathContinuation();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class ToOneFkReferenceContext extends ParserRuleContext {
		public TerminalNode FK() { return getToken(HqlParser.FK, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public ToOneFkReferenceContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_toOneFkReference; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterToOneFkReference(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitToOneFkReference(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitToOneFkReference(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ToOneFkReferenceContext toOneFkReference() throws RecognitionException {
		ToOneFkReferenceContext _localctx = new ToOneFkReferenceContext(_ctx, getState());
		enterRule(_localctx, 192, RULE_toOneFkReference);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1263);
			match(FK);
			setState(1264);
			match(LEFT_PAREN);
			setState(1265);
			path();
			setState(1266);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class CaseListContext extends ParserRuleContext {
		public SimpleCaseListContext simpleCaseList() {
			return getRuleContext(SimpleCaseListContext.class,0);
		}
		public SearchedCaseListContext searchedCaseList() {
			return getRuleContext(SearchedCaseListContext.class,0);
		}
		public CaseListContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_caseList; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCaseList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCaseList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCaseList(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CaseListContext caseList() throws RecognitionException {
		CaseListContext _localctx = new CaseListContext(_ctx, getState());
		enterRule(_localctx, 194, RULE_caseList);
		try {
			setState(1270);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,130,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1268);
				simpleCaseList();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1269);
				searchedCaseList();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SimpleCaseListContext extends ParserRuleContext {
		public TerminalNode CASE() { return getToken(HqlParser.CASE, 0); }
		public ExpressionOrPredicateContext expressionOrPredicate() {
			return getRuleContext(ExpressionOrPredicateContext.class,0);
		}
		public TerminalNode END() { return getToken(HqlParser.END, 0); }
		public List<SimpleCaseWhenContext> simpleCaseWhen() {
			return getRuleContexts(SimpleCaseWhenContext.class);
		}
		public SimpleCaseWhenContext simpleCaseWhen(int i) {
			return getRuleContext(SimpleCaseWhenContext.class,i);
		}
		public CaseOtherwiseContext caseOtherwise() {
			return getRuleContext(CaseOtherwiseContext.class,0);
		}
		public SimpleCaseListContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_simpleCaseList; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSimpleCaseList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSimpleCaseList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSimpleCaseList(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SimpleCaseListContext simpleCaseList() throws RecognitionException {
		SimpleCaseListContext _localctx = new SimpleCaseListContext(_ctx, getState());
		enterRule(_localctx, 196, RULE_simpleCaseList);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1272);
			match(CASE);
			setState(1273);
			expressionOrPredicate();
			setState(1275); 
			_errHandler.sync(this);
			_la = _input.LA(1);
			do {
				{
				{
				setState(1274);
				simpleCaseWhen();
				}
				}
				setState(1277); 
				_errHandler.sync(this);
				_la = _input.LA(1);
			} while ( _la==WHEN );
			setState(1280);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==ELSE) {
				{
				setState(1279);
				caseOtherwise();
				}
			}

			setState(1282);
			match(END);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SimpleCaseWhenContext extends ParserRuleContext {
		public TerminalNode WHEN() { return getToken(HqlParser.WHEN, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode THEN() { return getToken(HqlParser.THEN, 0); }
		public ExpressionOrPredicateContext expressionOrPredicate() {
			return getRuleContext(ExpressionOrPredicateContext.class,0);
		}
		public SimpleCaseWhenContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_simpleCaseWhen; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSimpleCaseWhen(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSimpleCaseWhen(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSimpleCaseWhen(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SimpleCaseWhenContext simpleCaseWhen() throws RecognitionException {
		SimpleCaseWhenContext _localctx = new SimpleCaseWhenContext(_ctx, getState());
		enterRule(_localctx, 198, RULE_simpleCaseWhen);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1284);
			match(WHEN);
			setState(1285);
			expression(0);
			setState(1286);
			match(THEN);
			setState(1287);
			expressionOrPredicate();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class CaseOtherwiseContext extends ParserRuleContext {
		public TerminalNode ELSE() { return getToken(HqlParser.ELSE, 0); }
		public ExpressionOrPredicateContext expressionOrPredicate() {
			return getRuleContext(ExpressionOrPredicateContext.class,0);
		}
		public CaseOtherwiseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_caseOtherwise; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCaseOtherwise(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCaseOtherwise(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCaseOtherwise(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CaseOtherwiseContext caseOtherwise() throws RecognitionException {
		CaseOtherwiseContext _localctx = new CaseOtherwiseContext(_ctx, getState());
		enterRule(_localctx, 200, RULE_caseOtherwise);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1289);
			match(ELSE);
			setState(1290);
			expressionOrPredicate();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SearchedCaseListContext extends ParserRuleContext {
		public TerminalNode CASE() { return getToken(HqlParser.CASE, 0); }
		public TerminalNode END() { return getToken(HqlParser.END, 0); }
		public List<SearchedCaseWhenContext> searchedCaseWhen() {
			return getRuleContexts(SearchedCaseWhenContext.class);
		}
		public SearchedCaseWhenContext searchedCaseWhen(int i) {
			return getRuleContext(SearchedCaseWhenContext.class,i);
		}
		public CaseOtherwiseContext caseOtherwise() {
			return getRuleContext(CaseOtherwiseContext.class,0);
		}
		public SearchedCaseListContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_searchedCaseList; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSearchedCaseList(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSearchedCaseList(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSearchedCaseList(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SearchedCaseListContext searchedCaseList() throws RecognitionException {
		SearchedCaseListContext _localctx = new SearchedCaseListContext(_ctx, getState());
		enterRule(_localctx, 202, RULE_searchedCaseList);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1292);
			match(CASE);
			setState(1294); 
			_errHandler.sync(this);
			_la = _input.LA(1);
			do {
				{
				{
				setState(1293);
				searchedCaseWhen();
				}
				}
				setState(1296); 
				_errHandler.sync(this);
				_la = _input.LA(1);
			} while ( _la==WHEN );
			setState(1299);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==ELSE) {
				{
				setState(1298);
				caseOtherwise();
				}
			}

			setState(1301);
			match(END);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SearchedCaseWhenContext extends ParserRuleContext {
		public TerminalNode WHEN() { return getToken(HqlParser.WHEN, 0); }
		public PredicateContext predicate() {
			return getRuleContext(PredicateContext.class,0);
		}
		public TerminalNode THEN() { return getToken(HqlParser.THEN, 0); }
		public ExpressionOrPredicateContext expressionOrPredicate() {
			return getRuleContext(ExpressionOrPredicateContext.class,0);
		}
		public SearchedCaseWhenContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_searchedCaseWhen; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSearchedCaseWhen(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSearchedCaseWhen(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSearchedCaseWhen(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SearchedCaseWhenContext searchedCaseWhen() throws RecognitionException {
		SearchedCaseWhenContext _localctx = new SearchedCaseWhenContext(_ctx, getState());
		enterRule(_localctx, 204, RULE_searchedCaseWhen);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1303);
			match(WHEN);
			setState(1304);
			predicate(0);
			setState(1305);
			match(THEN);
			setState(1306);
			expressionOrPredicate();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class LiteralContext extends ParserRuleContext {
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public TerminalNode JAVA_STRING_LITERAL() { return getToken(HqlParser.JAVA_STRING_LITERAL, 0); }
		public TerminalNode NULL() { return getToken(HqlParser.NULL, 0); }
		public BooleanLiteralContext booleanLiteral() {
			return getRuleContext(BooleanLiteralContext.class,0);
		}
		public NumericLiteralContext numericLiteral() {
			return getRuleContext(NumericLiteralContext.class,0);
		}
		public BinaryLiteralContext binaryLiteral() {
			return getRuleContext(BinaryLiteralContext.class,0);
		}
		public TemporalLiteralContext temporalLiteral() {
			return getRuleContext(TemporalLiteralContext.class,0);
		}
		public GeneralizedLiteralContext generalizedLiteral() {
			return getRuleContext(GeneralizedLiteralContext.class,0);
		}
		public LiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_literal; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final LiteralContext literal() throws RecognitionException {
		LiteralContext _localctx = new LiteralContext(_ctx, getState());
		enterRule(_localctx, 206, RULE_literal);
		try {
			setState(1316);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,135,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1308);
				match(STRING_LITERAL);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1309);
				match(JAVA_STRING_LITERAL);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1310);
				match(NULL);
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(1311);
				booleanLiteral();
				}
				break;
			case 5:
				enterOuterAlt(_localctx, 5);
				{
				setState(1312);
				numericLiteral();
				}
				break;
			case 6:
				enterOuterAlt(_localctx, 6);
				{
				setState(1313);
				binaryLiteral();
				}
				break;
			case 7:
				enterOuterAlt(_localctx, 7);
				{
				setState(1314);
				temporalLiteral();
				}
				break;
			case 8:
				enterOuterAlt(_localctx, 8);
				{
				setState(1315);
				generalizedLiteral();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class BooleanLiteralContext extends ParserRuleContext {
		public TerminalNode TRUE() { return getToken(HqlParser.TRUE, 0); }
		public TerminalNode FALSE() { return getToken(HqlParser.FALSE, 0); }
		public BooleanLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_booleanLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterBooleanLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitBooleanLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitBooleanLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final BooleanLiteralContext booleanLiteral() throws RecognitionException {
		BooleanLiteralContext _localctx = new BooleanLiteralContext(_ctx, getState());
		enterRule(_localctx, 208, RULE_booleanLiteral);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1318);
			_la = _input.LA(1);
			if ( !(_la==TRUE || _la==FALSE) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class NumericLiteralContext extends ParserRuleContext {
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public TerminalNode LONG_LITERAL() { return getToken(HqlParser.LONG_LITERAL, 0); }
		public TerminalNode BIG_INTEGER_LITERAL() { return getToken(HqlParser.BIG_INTEGER_LITERAL, 0); }
		public TerminalNode FLOAT_LITERAL() { return getToken(HqlParser.FLOAT_LITERAL, 0); }
		public TerminalNode DOUBLE_LITERAL() { return getToken(HqlParser.DOUBLE_LITERAL, 0); }
		public TerminalNode BIG_DECIMAL_LITERAL() { return getToken(HqlParser.BIG_DECIMAL_LITERAL, 0); }
		public TerminalNode HEX_LITERAL() { return getToken(HqlParser.HEX_LITERAL, 0); }
		public NumericLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_numericLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterNumericLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitNumericLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitNumericLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final NumericLiteralContext numericLiteral() throws RecognitionException {
		NumericLiteralContext _localctx = new NumericLiteralContext(_ctx, getState());
		enterRule(_localctx, 210, RULE_numericLiteral);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1320);
			_la = _input.LA(1);
			if ( !((((_la) & ~0x3f) == 0 && ((1L << _la) & 1016L) != 0)) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class BinaryLiteralContext extends ParserRuleContext {
		public TerminalNode BINARY_LITERAL() { return getToken(HqlParser.BINARY_LITERAL, 0); }
		public TerminalNode LEFT_BRACE() { return getToken(HqlParser.LEFT_BRACE, 0); }
		public List<TerminalNode> HEX_LITERAL() { return getTokens(HqlParser.HEX_LITERAL); }
		public TerminalNode HEX_LITERAL(int i) {
			return getToken(HqlParser.HEX_LITERAL, i);
		}
		public TerminalNode RIGHT_BRACE() { return getToken(HqlParser.RIGHT_BRACE, 0); }
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public BinaryLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_binaryLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterBinaryLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitBinaryLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitBinaryLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final BinaryLiteralContext binaryLiteral() throws RecognitionException {
		BinaryLiteralContext _localctx = new BinaryLiteralContext(_ctx, getState());
		enterRule(_localctx, 212, RULE_binaryLiteral);
		int _la;
		try {
			setState(1333);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case BINARY_LITERAL:
				enterOuterAlt(_localctx, 1);
				{
				setState(1322);
				match(BINARY_LITERAL);
				}
				break;
			case LEFT_BRACE:
				enterOuterAlt(_localctx, 2);
				{
				setState(1323);
				match(LEFT_BRACE);
				setState(1324);
				match(HEX_LITERAL);
				setState(1329);
				_errHandler.sync(this);
				_la = _input.LA(1);
				while (_la==COMMA) {
					{
					{
					setState(1325);
					match(COMMA);
					setState(1326);
					match(HEX_LITERAL);
					}
					}
					setState(1331);
					_errHandler.sync(this);
					_la = _input.LA(1);
				}
				setState(1332);
				match(RIGHT_BRACE);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class TemporalLiteralContext extends ParserRuleContext {
		public DateTimeLiteralContext dateTimeLiteral() {
			return getRuleContext(DateTimeLiteralContext.class,0);
		}
		public DateLiteralContext dateLiteral() {
			return getRuleContext(DateLiteralContext.class,0);
		}
		public TimeLiteralContext timeLiteral() {
			return getRuleContext(TimeLiteralContext.class,0);
		}
		public JdbcTimestampLiteralContext jdbcTimestampLiteral() {
			return getRuleContext(JdbcTimestampLiteralContext.class,0);
		}
		public JdbcDateLiteralContext jdbcDateLiteral() {
			return getRuleContext(JdbcDateLiteralContext.class,0);
		}
		public JdbcTimeLiteralContext jdbcTimeLiteral() {
			return getRuleContext(JdbcTimeLiteralContext.class,0);
		}
		public TemporalLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_temporalLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTemporalLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTemporalLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTemporalLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TemporalLiteralContext temporalLiteral() throws RecognitionException {
		TemporalLiteralContext _localctx = new TemporalLiteralContext(_ctx, getState());
		enterRule(_localctx, 214, RULE_temporalLiteral);
		try {
			setState(1341);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,138,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1335);
				dateTimeLiteral();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1336);
				dateLiteral();
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1337);
				timeLiteral();
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(1338);
				jdbcTimestampLiteral();
				}
				break;
			case 5:
				enterOuterAlt(_localctx, 5);
				{
				setState(1339);
				jdbcDateLiteral();
				}
				break;
			case 6:
				enterOuterAlt(_localctx, 6);
				{
				setState(1340);
				jdbcTimeLiteral();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class DateTimeLiteralContext extends ParserRuleContext {
		public LocalDateTimeLiteralContext localDateTimeLiteral() {
			return getRuleContext(LocalDateTimeLiteralContext.class,0);
		}
		public ZonedDateTimeLiteralContext zonedDateTimeLiteral() {
			return getRuleContext(ZonedDateTimeLiteralContext.class,0);
		}
		public OffsetDateTimeLiteralContext offsetDateTimeLiteral() {
			return getRuleContext(OffsetDateTimeLiteralContext.class,0);
		}
		public DateTimeLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_dateTimeLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterDateTimeLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitDateTimeLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitDateTimeLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DateTimeLiteralContext dateTimeLiteral() throws RecognitionException {
		DateTimeLiteralContext _localctx = new DateTimeLiteralContext(_ctx, getState());
		enterRule(_localctx, 216, RULE_dateTimeLiteral);
		try {
			setState(1346);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,139,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1343);
				localDateTimeLiteral();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1344);
				zonedDateTimeLiteral();
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1345);
				offsetDateTimeLiteral();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class LocalDateTimeLiteralContext extends ParserRuleContext {
		public TerminalNode LEFT_BRACE() { return getToken(HqlParser.LEFT_BRACE, 0); }
		public LocalDateTimeContext localDateTime() {
			return getRuleContext(LocalDateTimeContext.class,0);
		}
		public TerminalNode RIGHT_BRACE() { return getToken(HqlParser.RIGHT_BRACE, 0); }
		public TerminalNode DATETIME() { return getToken(HqlParser.DATETIME, 0); }
		public TerminalNode LOCAL() { return getToken(HqlParser.LOCAL, 0); }
		public LocalDateTimeLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_localDateTimeLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterLocalDateTimeLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitLocalDateTimeLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitLocalDateTimeLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final LocalDateTimeLiteralContext localDateTimeLiteral() throws RecognitionException {
		LocalDateTimeLiteralContext _localctx = new LocalDateTimeLiteralContext(_ctx, getState());
		enterRule(_localctx, 218, RULE_localDateTimeLiteral);
		int _la;
		try {
			setState(1357);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case LEFT_BRACE:
				enterOuterAlt(_localctx, 1);
				{
				setState(1348);
				match(LEFT_BRACE);
				setState(1349);
				localDateTime();
				setState(1350);
				match(RIGHT_BRACE);
				}
				break;
			case DATETIME:
			case LOCAL:
				enterOuterAlt(_localctx, 2);
				{
				setState(1353);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==LOCAL) {
					{
					setState(1352);
					match(LOCAL);
					}
				}

				setState(1355);
				match(DATETIME);
				setState(1356);
				localDateTime();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class ZonedDateTimeLiteralContext extends ParserRuleContext {
		public TerminalNode LEFT_BRACE() { return getToken(HqlParser.LEFT_BRACE, 0); }
		public ZonedDateTimeContext zonedDateTime() {
			return getRuleContext(ZonedDateTimeContext.class,0);
		}
		public TerminalNode RIGHT_BRACE() { return getToken(HqlParser.RIGHT_BRACE, 0); }
		public TerminalNode DATETIME() { return getToken(HqlParser.DATETIME, 0); }
		public TerminalNode ZONED() { return getToken(HqlParser.ZONED, 0); }
		public ZonedDateTimeLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_zonedDateTimeLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterZonedDateTimeLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitZonedDateTimeLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitZonedDateTimeLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ZonedDateTimeLiteralContext zonedDateTimeLiteral() throws RecognitionException {
		ZonedDateTimeLiteralContext _localctx = new ZonedDateTimeLiteralContext(_ctx, getState());
		enterRule(_localctx, 220, RULE_zonedDateTimeLiteral);
		int _la;
		try {
			setState(1368);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case LEFT_BRACE:
				enterOuterAlt(_localctx, 1);
				{
				setState(1359);
				match(LEFT_BRACE);
				setState(1360);
				zonedDateTime();
				setState(1361);
				match(RIGHT_BRACE);
				}
				break;
			case DATETIME:
			case ZONED:
				enterOuterAlt(_localctx, 2);
				{
				setState(1364);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==ZONED) {
					{
					setState(1363);
					match(ZONED);
					}
				}

				setState(1366);
				match(DATETIME);
				setState(1367);
				zonedDateTime();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class OffsetDateTimeLiteralContext extends ParserRuleContext {
		public TerminalNode LEFT_BRACE() { return getToken(HqlParser.LEFT_BRACE, 0); }
		public OffsetDateTimeContext offsetDateTime() {
			return getRuleContext(OffsetDateTimeContext.class,0);
		}
		public TerminalNode RIGHT_BRACE() { return getToken(HqlParser.RIGHT_BRACE, 0); }
		public TerminalNode DATETIME() { return getToken(HqlParser.DATETIME, 0); }
		public OffsetDateTimeWithMinutesContext offsetDateTimeWithMinutes() {
			return getRuleContext(OffsetDateTimeWithMinutesContext.class,0);
		}
		public TerminalNode OFFSET() { return getToken(HqlParser.OFFSET, 0); }
		public OffsetDateTimeLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_offsetDateTimeLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOffsetDateTimeLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOffsetDateTimeLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOffsetDateTimeLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OffsetDateTimeLiteralContext offsetDateTimeLiteral() throws RecognitionException {
		OffsetDateTimeLiteralContext _localctx = new OffsetDateTimeLiteralContext(_ctx, getState());
		enterRule(_localctx, 222, RULE_offsetDateTimeLiteral);
		int _la;
		try {
			setState(1379);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case LEFT_BRACE:
				enterOuterAlt(_localctx, 1);
				{
				setState(1370);
				match(LEFT_BRACE);
				setState(1371);
				offsetDateTime();
				setState(1372);
				match(RIGHT_BRACE);
				}
				break;
			case DATETIME:
			case OFFSET:
				enterOuterAlt(_localctx, 2);
				{
				setState(1375);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==OFFSET) {
					{
					setState(1374);
					match(OFFSET);
					}
				}

				setState(1377);
				match(DATETIME);
				setState(1378);
				offsetDateTimeWithMinutes();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class DateLiteralContext extends ParserRuleContext {
		public TerminalNode LEFT_BRACE() { return getToken(HqlParser.LEFT_BRACE, 0); }
		public DateContext date() {
			return getRuleContext(DateContext.class,0);
		}
		public TerminalNode RIGHT_BRACE() { return getToken(HqlParser.RIGHT_BRACE, 0); }
		public TerminalNode DATE() { return getToken(HqlParser.DATE, 0); }
		public TerminalNode LOCAL() { return getToken(HqlParser.LOCAL, 0); }
		public DateLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_dateLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterDateLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitDateLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitDateLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DateLiteralContext dateLiteral() throws RecognitionException {
		DateLiteralContext _localctx = new DateLiteralContext(_ctx, getState());
		enterRule(_localctx, 224, RULE_dateLiteral);
		int _la;
		try {
			setState(1390);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case LEFT_BRACE:
				enterOuterAlt(_localctx, 1);
				{
				setState(1381);
				match(LEFT_BRACE);
				setState(1382);
				date();
				setState(1383);
				match(RIGHT_BRACE);
				}
				break;
			case DATE:
			case LOCAL:
				enterOuterAlt(_localctx, 2);
				{
				setState(1386);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==LOCAL) {
					{
					setState(1385);
					match(LOCAL);
					}
				}

				setState(1388);
				match(DATE);
				setState(1389);
				date();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class TimeLiteralContext extends ParserRuleContext {
		public TerminalNode LEFT_BRACE() { return getToken(HqlParser.LEFT_BRACE, 0); }
		public TimeContext time() {
			return getRuleContext(TimeContext.class,0);
		}
		public TerminalNode RIGHT_BRACE() { return getToken(HqlParser.RIGHT_BRACE, 0); }
		public TerminalNode TIME() { return getToken(HqlParser.TIME, 0); }
		public TerminalNode LOCAL() { return getToken(HqlParser.LOCAL, 0); }
		public TimeLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_timeLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTimeLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTimeLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTimeLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TimeLiteralContext timeLiteral() throws RecognitionException {
		TimeLiteralContext _localctx = new TimeLiteralContext(_ctx, getState());
		enterRule(_localctx, 226, RULE_timeLiteral);
		int _la;
		try {
			setState(1401);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case LEFT_BRACE:
				enterOuterAlt(_localctx, 1);
				{
				setState(1392);
				match(LEFT_BRACE);
				setState(1393);
				time();
				setState(1394);
				match(RIGHT_BRACE);
				}
				break;
			case LOCAL:
			case TIME:
				enterOuterAlt(_localctx, 2);
				{
				setState(1397);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==LOCAL) {
					{
					setState(1396);
					match(LOCAL);
					}
				}

				setState(1399);
				match(TIME);
				setState(1400);
				time();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class DateTimeContext extends ParserRuleContext {
		public LocalDateTimeContext localDateTime() {
			return getRuleContext(LocalDateTimeContext.class,0);
		}
		public ZonedDateTimeContext zonedDateTime() {
			return getRuleContext(ZonedDateTimeContext.class,0);
		}
		public OffsetDateTimeContext offsetDateTime() {
			return getRuleContext(OffsetDateTimeContext.class,0);
		}
		public DateTimeContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_dateTime; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterDateTime(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitDateTime(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitDateTime(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DateTimeContext dateTime() throws RecognitionException {
		DateTimeContext _localctx = new DateTimeContext(_ctx, getState());
		enterRule(_localctx, 228, RULE_dateTime);
		try {
			setState(1406);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,150,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1403);
				localDateTime();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1404);
				zonedDateTime();
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1405);
				offsetDateTime();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class LocalDateTimeContext extends ParserRuleContext {
		public DateContext date() {
			return getRuleContext(DateContext.class,0);
		}
		public TimeContext time() {
			return getRuleContext(TimeContext.class,0);
		}
		public LocalDateTimeContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_localDateTime; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterLocalDateTime(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitLocalDateTime(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitLocalDateTime(this);
			else return visitor.visitChildren(this);
		}
	}

	public final LocalDateTimeContext localDateTime() throws RecognitionException {
		LocalDateTimeContext _localctx = new LocalDateTimeContext(_ctx, getState());
		enterRule(_localctx, 230, RULE_localDateTime);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1408);
			date();
			setState(1409);
			time();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class ZonedDateTimeContext extends ParserRuleContext {
		public DateContext date() {
			return getRuleContext(DateContext.class,0);
		}
		public TimeContext time() {
			return getRuleContext(TimeContext.class,0);
		}
		public ZoneIdContext zoneId() {
			return getRuleContext(ZoneIdContext.class,0);
		}
		public ZonedDateTimeContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_zonedDateTime; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterZonedDateTime(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitZonedDateTime(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitZonedDateTime(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ZonedDateTimeContext zonedDateTime() throws RecognitionException {
		ZonedDateTimeContext _localctx = new ZonedDateTimeContext(_ctx, getState());
		enterRule(_localctx, 232, RULE_zonedDateTime);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1411);
			date();
			setState(1412);
			time();
			setState(1413);
			zoneId();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class OffsetDateTimeContext extends ParserRuleContext {
		public DateContext date() {
			return getRuleContext(DateContext.class,0);
		}
		public TimeContext time() {
			return getRuleContext(TimeContext.class,0);
		}
		public OffsetContext offset() {
			return getRuleContext(OffsetContext.class,0);
		}
		public OffsetDateTimeContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_offsetDateTime; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOffsetDateTime(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOffsetDateTime(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOffsetDateTime(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OffsetDateTimeContext offsetDateTime() throws RecognitionException {
		OffsetDateTimeContext _localctx = new OffsetDateTimeContext(_ctx, getState());
		enterRule(_localctx, 234, RULE_offsetDateTime);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1415);
			date();
			setState(1416);
			time();
			setState(1417);
			offset();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class OffsetDateTimeWithMinutesContext extends ParserRuleContext {
		public DateContext date() {
			return getRuleContext(DateContext.class,0);
		}
		public TimeContext time() {
			return getRuleContext(TimeContext.class,0);
		}
		public OffsetWithMinutesContext offsetWithMinutes() {
			return getRuleContext(OffsetWithMinutesContext.class,0);
		}
		public OffsetDateTimeWithMinutesContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_offsetDateTimeWithMinutes; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOffsetDateTimeWithMinutes(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOffsetDateTimeWithMinutes(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOffsetDateTimeWithMinutes(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OffsetDateTimeWithMinutesContext offsetDateTimeWithMinutes() throws RecognitionException {
		OffsetDateTimeWithMinutesContext _localctx = new OffsetDateTimeWithMinutesContext(_ctx, getState());
		enterRule(_localctx, 236, RULE_offsetDateTimeWithMinutes);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1419);
			date();
			setState(1420);
			time();
			setState(1421);
			offsetWithMinutes();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class DateContext extends ParserRuleContext {
		public YearContext year() {
			return getRuleContext(YearContext.class,0);
		}
		public List<TerminalNode> MINUS() { return getTokens(HqlParser.MINUS); }
		public TerminalNode MINUS(int i) {
			return getToken(HqlParser.MINUS, i);
		}
		public MonthContext month() {
			return getRuleContext(MonthContext.class,0);
		}
		public DayContext day() {
			return getRuleContext(DayContext.class,0);
		}
		public DateContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_date; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterDate(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitDate(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitDate(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DateContext date() throws RecognitionException {
		DateContext _localctx = new DateContext(_ctx, getState());
		enterRule(_localctx, 238, RULE_date);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1423);
			year();
			setState(1424);
			match(MINUS);
			setState(1425);
			month();
			setState(1426);
			match(MINUS);
			setState(1427);
			day();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class TimeContext extends ParserRuleContext {
		public HourContext hour() {
			return getRuleContext(HourContext.class,0);
		}
		public List<TerminalNode> COLON() { return getTokens(HqlParser.COLON); }
		public TerminalNode COLON(int i) {
			return getToken(HqlParser.COLON, i);
		}
		public MinuteContext minute() {
			return getRuleContext(MinuteContext.class,0);
		}
		public SecondContext second() {
			return getRuleContext(SecondContext.class,0);
		}
		public TimeContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_time; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTime(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTime(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTime(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TimeContext time() throws RecognitionException {
		TimeContext _localctx = new TimeContext(_ctx, getState());
		enterRule(_localctx, 240, RULE_time);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1429);
			hour();
			setState(1430);
			match(COLON);
			setState(1431);
			minute();
			setState(1434);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,151,_ctx) ) {
			case 1:
				{
				setState(1432);
				match(COLON);
				setState(1433);
				second();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class OffsetContext extends ParserRuleContext {
		public HourContext hour() {
			return getRuleContext(HourContext.class,0);
		}
		public TerminalNode PLUS() { return getToken(HqlParser.PLUS, 0); }
		public TerminalNode MINUS() { return getToken(HqlParser.MINUS, 0); }
		public TerminalNode COLON() { return getToken(HqlParser.COLON, 0); }
		public MinuteContext minute() {
			return getRuleContext(MinuteContext.class,0);
		}
		public OffsetContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_offset; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOffset(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOffset(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOffset(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OffsetContext offset() throws RecognitionException {
		OffsetContext _localctx = new OffsetContext(_ctx, getState());
		enterRule(_localctx, 242, RULE_offset);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1436);
			_la = _input.LA(1);
			if ( !(_la==PLUS || _la==MINUS) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			setState(1437);
			hour();
			setState(1440);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==COLON) {
				{
				setState(1438);
				match(COLON);
				setState(1439);
				minute();
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class OffsetWithMinutesContext extends ParserRuleContext {
		public HourContext hour() {
			return getRuleContext(HourContext.class,0);
		}
		public TerminalNode COLON() { return getToken(HqlParser.COLON, 0); }
		public MinuteContext minute() {
			return getRuleContext(MinuteContext.class,0);
		}
		public TerminalNode PLUS() { return getToken(HqlParser.PLUS, 0); }
		public TerminalNode MINUS() { return getToken(HqlParser.MINUS, 0); }
		public OffsetWithMinutesContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_offsetWithMinutes; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOffsetWithMinutes(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOffsetWithMinutes(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOffsetWithMinutes(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OffsetWithMinutesContext offsetWithMinutes() throws RecognitionException {
		OffsetWithMinutesContext _localctx = new OffsetWithMinutesContext(_ctx, getState());
		enterRule(_localctx, 244, RULE_offsetWithMinutes);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1442);
			_la = _input.LA(1);
			if ( !(_la==PLUS || _la==MINUS) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			setState(1443);
			hour();
			setState(1444);
			match(COLON);
			setState(1445);
			minute();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class YearContext extends ParserRuleContext {
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public YearContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_year; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterYear(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitYear(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitYear(this);
			else return visitor.visitChildren(this);
		}
	}

	public final YearContext year() throws RecognitionException {
		YearContext _localctx = new YearContext(_ctx, getState());
		enterRule(_localctx, 246, RULE_year);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1447);
			match(INTEGER_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class MonthContext extends ParserRuleContext {
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public MonthContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_month; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterMonth(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitMonth(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitMonth(this);
			else return visitor.visitChildren(this);
		}
	}

	public final MonthContext month() throws RecognitionException {
		MonthContext _localctx = new MonthContext(_ctx, getState());
		enterRule(_localctx, 248, RULE_month);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1449);
			match(INTEGER_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class DayContext extends ParserRuleContext {
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public DayContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_day; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterDay(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitDay(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitDay(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DayContext day() throws RecognitionException {
		DayContext _localctx = new DayContext(_ctx, getState());
		enterRule(_localctx, 250, RULE_day);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1451);
			match(INTEGER_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class HourContext extends ParserRuleContext {
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public HourContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_hour; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterHour(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitHour(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitHour(this);
			else return visitor.visitChildren(this);
		}
	}

	public final HourContext hour() throws RecognitionException {
		HourContext _localctx = new HourContext(_ctx, getState());
		enterRule(_localctx, 252, RULE_hour);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1453);
			match(INTEGER_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class MinuteContext extends ParserRuleContext {
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public MinuteContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_minute; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterMinute(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitMinute(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitMinute(this);
			else return visitor.visitChildren(this);
		}
	}

	public final MinuteContext minute() throws RecognitionException {
		MinuteContext _localctx = new MinuteContext(_ctx, getState());
		enterRule(_localctx, 254, RULE_minute);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1455);
			match(INTEGER_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SecondContext extends ParserRuleContext {
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public TerminalNode DOUBLE_LITERAL() { return getToken(HqlParser.DOUBLE_LITERAL, 0); }
		public SecondContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_second; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSecond(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSecond(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSecond(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SecondContext second() throws RecognitionException {
		SecondContext _localctx = new SecondContext(_ctx, getState());
		enterRule(_localctx, 256, RULE_second);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1457);
			_la = _input.LA(1);
			if ( !(_la==INTEGER_LITERAL || _la==DOUBLE_LITERAL) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class ZoneIdContext extends ParserRuleContext {
		public List<TerminalNode> IDENTIFIER() { return getTokens(HqlParser.IDENTIFIER); }
		public TerminalNode IDENTIFIER(int i) {
			return getToken(HqlParser.IDENTIFIER, i);
		}
		public TerminalNode SLASH() { return getToken(HqlParser.SLASH, 0); }
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public ZoneIdContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_zoneId; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterZoneId(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitZoneId(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitZoneId(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ZoneIdContext zoneId() throws RecognitionException {
		ZoneIdContext _localctx = new ZoneIdContext(_ctx, getState());
		enterRule(_localctx, 258, RULE_zoneId);
		try {
			setState(1465);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case IDENTIFIER:
				enterOuterAlt(_localctx, 1);
				{
				setState(1459);
				match(IDENTIFIER);
				setState(1462);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,153,_ctx) ) {
				case 1:
					{
					setState(1460);
					match(SLASH);
					setState(1461);
					match(IDENTIFIER);
					}
					break;
				}
				}
				break;
			case STRING_LITERAL:
				enterOuterAlt(_localctx, 2);
				{
				setState(1464);
				match(STRING_LITERAL);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class JdbcTimestampLiteralContext extends ParserRuleContext {
		public TerminalNode TIMESTAMP_ESCAPE_START() { return getToken(HqlParser.TIMESTAMP_ESCAPE_START, 0); }
		public TerminalNode RIGHT_BRACE() { return getToken(HqlParser.RIGHT_BRACE, 0); }
		public DateTimeContext dateTime() {
			return getRuleContext(DateTimeContext.class,0);
		}
		public GenericTemporalLiteralTextContext genericTemporalLiteralText() {
			return getRuleContext(GenericTemporalLiteralTextContext.class,0);
		}
		public JdbcTimestampLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_jdbcTimestampLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJdbcTimestampLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJdbcTimestampLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJdbcTimestampLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JdbcTimestampLiteralContext jdbcTimestampLiteral() throws RecognitionException {
		JdbcTimestampLiteralContext _localctx = new JdbcTimestampLiteralContext(_ctx, getState());
		enterRule(_localctx, 260, RULE_jdbcTimestampLiteral);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1467);
			match(TIMESTAMP_ESCAPE_START);
			setState(1470);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case INTEGER_LITERAL:
				{
				setState(1468);
				dateTime();
				}
				break;
			case STRING_LITERAL:
				{
				setState(1469);
				genericTemporalLiteralText();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
			setState(1472);
			match(RIGHT_BRACE);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class JdbcDateLiteralContext extends ParserRuleContext {
		public TerminalNode DATE_ESCAPE_START() { return getToken(HqlParser.DATE_ESCAPE_START, 0); }
		public TerminalNode RIGHT_BRACE() { return getToken(HqlParser.RIGHT_BRACE, 0); }
		public DateContext date() {
			return getRuleContext(DateContext.class,0);
		}
		public GenericTemporalLiteralTextContext genericTemporalLiteralText() {
			return getRuleContext(GenericTemporalLiteralTextContext.class,0);
		}
		public JdbcDateLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_jdbcDateLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJdbcDateLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJdbcDateLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJdbcDateLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JdbcDateLiteralContext jdbcDateLiteral() throws RecognitionException {
		JdbcDateLiteralContext _localctx = new JdbcDateLiteralContext(_ctx, getState());
		enterRule(_localctx, 262, RULE_jdbcDateLiteral);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1474);
			match(DATE_ESCAPE_START);
			setState(1477);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case INTEGER_LITERAL:
				{
				setState(1475);
				date();
				}
				break;
			case STRING_LITERAL:
				{
				setState(1476);
				genericTemporalLiteralText();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
			setState(1479);
			match(RIGHT_BRACE);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class JdbcTimeLiteralContext extends ParserRuleContext {
		public TerminalNode TIME_ESCAPE_START() { return getToken(HqlParser.TIME_ESCAPE_START, 0); }
		public TerminalNode RIGHT_BRACE() { return getToken(HqlParser.RIGHT_BRACE, 0); }
		public TimeContext time() {
			return getRuleContext(TimeContext.class,0);
		}
		public GenericTemporalLiteralTextContext genericTemporalLiteralText() {
			return getRuleContext(GenericTemporalLiteralTextContext.class,0);
		}
		public JdbcTimeLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_jdbcTimeLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJdbcTimeLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJdbcTimeLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJdbcTimeLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JdbcTimeLiteralContext jdbcTimeLiteral() throws RecognitionException {
		JdbcTimeLiteralContext _localctx = new JdbcTimeLiteralContext(_ctx, getState());
		enterRule(_localctx, 264, RULE_jdbcTimeLiteral);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1481);
			match(TIME_ESCAPE_START);
			setState(1484);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case INTEGER_LITERAL:
				{
				setState(1482);
				time();
				}
				break;
			case STRING_LITERAL:
				{
				setState(1483);
				genericTemporalLiteralText();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
			setState(1486);
			match(RIGHT_BRACE);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class GenericTemporalLiteralTextContext extends ParserRuleContext {
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public GenericTemporalLiteralTextContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_genericTemporalLiteralText; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGenericTemporalLiteralText(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGenericTemporalLiteralText(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGenericTemporalLiteralText(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GenericTemporalLiteralTextContext genericTemporalLiteralText() throws RecognitionException {
		GenericTemporalLiteralTextContext _localctx = new GenericTemporalLiteralTextContext(_ctx, getState());
		enterRule(_localctx, 266, RULE_genericTemporalLiteralText);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1488);
			match(STRING_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class GeneralizedLiteralContext extends ParserRuleContext {
		public TerminalNode LEFT_BRACE() { return getToken(HqlParser.LEFT_BRACE, 0); }
		public GeneralizedLiteralTypeContext generalizedLiteralType() {
			return getRuleContext(GeneralizedLiteralTypeContext.class,0);
		}
		public TerminalNode COLON() { return getToken(HqlParser.COLON, 0); }
		public GeneralizedLiteralTextContext generalizedLiteralText() {
			return getRuleContext(GeneralizedLiteralTextContext.class,0);
		}
		public TerminalNode RIGHT_BRACE() { return getToken(HqlParser.RIGHT_BRACE, 0); }
		public GeneralizedLiteralContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_generalizedLiteral; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGeneralizedLiteral(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGeneralizedLiteral(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGeneralizedLiteral(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GeneralizedLiteralContext generalizedLiteral() throws RecognitionException {
		GeneralizedLiteralContext _localctx = new GeneralizedLiteralContext(_ctx, getState());
		enterRule(_localctx, 268, RULE_generalizedLiteral);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1490);
			match(LEFT_BRACE);
			setState(1491);
			generalizedLiteralType();
			setState(1492);
			match(COLON);
			setState(1493);
			generalizedLiteralText();
			setState(1494);
			match(RIGHT_BRACE);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class GeneralizedLiteralTypeContext extends ParserRuleContext {
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public GeneralizedLiteralTypeContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_generalizedLiteralType; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGeneralizedLiteralType(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGeneralizedLiteralType(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGeneralizedLiteralType(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GeneralizedLiteralTypeContext generalizedLiteralType() throws RecognitionException {
		GeneralizedLiteralTypeContext _localctx = new GeneralizedLiteralTypeContext(_ctx, getState());
		enterRule(_localctx, 270, RULE_generalizedLiteralType);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1496);
			match(STRING_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class GeneralizedLiteralTextContext extends ParserRuleContext {
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public GeneralizedLiteralTextContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_generalizedLiteralText; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGeneralizedLiteralText(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGeneralizedLiteralText(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGeneralizedLiteralText(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GeneralizedLiteralTextContext generalizedLiteralText() throws RecognitionException {
		GeneralizedLiteralTextContext _localctx = new GeneralizedLiteralTextContext(_ctx, getState());
		enterRule(_localctx, 272, RULE_generalizedLiteralText);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1498);
			match(STRING_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class ParameterContext extends ParserRuleContext {
		public ParameterContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_parameter; }
	 
		public ParameterContext() { }
		public void copyFrom(ParameterContext ctx) {
			super.copyFrom(ctx);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class NamedParameterContext extends ParameterContext {
		public TerminalNode COLON() { return getToken(HqlParser.COLON, 0); }
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public NamedParameterContext(ParameterContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterNamedParameter(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitNamedParameter(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitNamedParameter(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class PositionalParameterContext extends ParameterContext {
		public TerminalNode QUESTION_MARK() { return getToken(HqlParser.QUESTION_MARK, 0); }
		public TerminalNode INTEGER_LITERAL() { return getToken(HqlParser.INTEGER_LITERAL, 0); }
		public PositionalParameterContext(ParameterContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPositionalParameter(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPositionalParameter(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPositionalParameter(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ParameterContext parameter() throws RecognitionException {
		ParameterContext _localctx = new ParameterContext(_ctx, getState());
		enterRule(_localctx, 274, RULE_parameter);
		try {
			setState(1506);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case COLON:
				_localctx = new NamedParameterContext(_localctx);
				enterOuterAlt(_localctx, 1);
				{
				setState(1500);
				match(COLON);
				setState(1501);
				identifier();
				}
				break;
			case QUESTION_MARK:
				_localctx = new PositionalParameterContext(_localctx);
				enterOuterAlt(_localctx, 2);
				{
				setState(1502);
				match(QUESTION_MARK);
				setState(1504);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,158,_ctx) ) {
				case 1:
					{
					setState(1503);
					match(INTEGER_LITERAL);
					}
					break;
				}
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class FunctionContext extends ParserRuleContext {
		public StandardFunctionContext standardFunction() {
			return getRuleContext(StandardFunctionContext.class,0);
		}
		public AggregateFunctionContext aggregateFunction() {
			return getRuleContext(AggregateFunctionContext.class,0);
		}
		public CollectionSizeFunctionContext collectionSizeFunction() {
			return getRuleContext(CollectionSizeFunctionContext.class,0);
		}
		public CollectionAggregateFunctionContext collectionAggregateFunction() {
			return getRuleContext(CollectionAggregateFunctionContext.class,0);
		}
		public CollectionFunctionMisuseContext collectionFunctionMisuse() {
			return getRuleContext(CollectionFunctionMisuseContext.class,0);
		}
		public JpaNonstandardFunctionContext jpaNonstandardFunction() {
			return getRuleContext(JpaNonstandardFunctionContext.class,0);
		}
		public ColumnFunctionContext columnFunction() {
			return getRuleContext(ColumnFunctionContext.class,0);
		}
		public GenericFunctionContext genericFunction() {
			return getRuleContext(GenericFunctionContext.class,0);
		}
		public FunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_function; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FunctionContext function() throws RecognitionException {
		FunctionContext _localctx = new FunctionContext(_ctx, getState());
		enterRule(_localctx, 276, RULE_function);
		try {
			setState(1516);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,160,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1508);
				standardFunction();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1509);
				aggregateFunction();
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1510);
				collectionSizeFunction();
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(1511);
				collectionAggregateFunction();
				}
				break;
			case 5:
				enterOuterAlt(_localctx, 5);
				{
				setState(1512);
				collectionFunctionMisuse();
				}
				break;
			case 6:
				enterOuterAlt(_localctx, 6);
				{
				setState(1513);
				jpaNonstandardFunction();
				}
				break;
			case 7:
				enterOuterAlt(_localctx, 7);
				{
				setState(1514);
				columnFunction();
				}
				break;
			case 8:
				enterOuterAlt(_localctx, 8);
				{
				setState(1515);
				genericFunction();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class JpaNonstandardFunctionContext extends ParserRuleContext {
		public TerminalNode FUNCTION() { return getToken(HqlParser.FUNCTION, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public JpaNonstandardFunctionNameContext jpaNonstandardFunctionName() {
			return getRuleContext(JpaNonstandardFunctionNameContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode AS() { return getToken(HqlParser.AS, 0); }
		public CastTargetContext castTarget() {
			return getRuleContext(CastTargetContext.class,0);
		}
		public TerminalNode COMMA() { return getToken(HqlParser.COMMA, 0); }
		public GenericFunctionArgumentsContext genericFunctionArguments() {
			return getRuleContext(GenericFunctionArgumentsContext.class,0);
		}
		public JpaNonstandardFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_jpaNonstandardFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJpaNonstandardFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJpaNonstandardFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJpaNonstandardFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JpaNonstandardFunctionContext jpaNonstandardFunction() throws RecognitionException {
		JpaNonstandardFunctionContext _localctx = new JpaNonstandardFunctionContext(_ctx, getState());
		enterRule(_localctx, 278, RULE_jpaNonstandardFunction);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1518);
			match(FUNCTION);
			setState(1519);
			match(LEFT_PAREN);
			setState(1520);
			jpaNonstandardFunctionName();
			setState(1523);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==AS) {
				{
				setState(1521);
				match(AS);
				setState(1522);
				castTarget();
				}
			}

			setState(1527);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==COMMA) {
				{
				setState(1525);
				match(COMMA);
				setState(1526);
				genericFunctionArguments();
				}
			}

			setState(1529);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class JpaNonstandardFunctionNameContext extends ParserRuleContext {
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public IdentifierContext identifier() {
			return getRuleContext(IdentifierContext.class,0);
		}
		public JpaNonstandardFunctionNameContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_jpaNonstandardFunctionName; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterJpaNonstandardFunctionName(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitJpaNonstandardFunctionName(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitJpaNonstandardFunctionName(this);
			else return visitor.visitChildren(this);
		}
	}

	public final JpaNonstandardFunctionNameContext jpaNonstandardFunctionName() throws RecognitionException {
		JpaNonstandardFunctionNameContext _localctx = new JpaNonstandardFunctionNameContext(_ctx, getState());
		enterRule(_localctx, 280, RULE_jpaNonstandardFunctionName);
		try {
			setState(1533);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case STRING_LITERAL:
				enterOuterAlt(_localctx, 1);
				{
				setState(1531);
				match(STRING_LITERAL);
				}
				break;
			case ID:
			case VERSION:
			case VERSIONED:
			case NATURALID:
			case FK:
			case ALL:
			case AND:
			case ANY:
			case AS:
			case ASC:
			case AVG:
			case BETWEEN:
			case BOTH:
			case BREADTH:
			case BY:
			case CASE:
			case CAST:
			case COLLATE:
			case COLUMN:
			case CONFLICT:
			case CONSTRAINT:
			case COUNT:
			case CROSS:
			case CUBE:
			case CURRENT:
			case CURRENT_DATE:
			case CURRENT_INSTANT:
			case CURRENT_TIME:
			case CURRENT_TIMESTAMP:
			case CYCLE:
			case DATE:
			case DATETIME:
			case DAY:
			case DEFAULT:
			case DELETE:
			case DEPTH:
			case DESC:
			case DISTINCT:
			case DO:
			case ELEMENT:
			case ELEMENTS:
			case ELSE:
			case EMPTY:
			case END:
			case ENTRY:
			case EPOCH:
			case ERROR:
			case ESCAPE:
			case EVERY:
			case EXCEPT:
			case EXCLUDE:
			case EXISTS:
			case EXTRACT:
			case FETCH:
			case FILTER:
			case FIRST:
			case FOLLOWING:
			case FOR:
			case FORMAT:
			case FROM:
			case FULL:
			case FUNCTION:
			case GROUP:
			case GROUPS:
			case HAVING:
			case HOUR:
			case IGNORE:
			case ILIKE:
			case IN:
			case INDEX:
			case INDICES:
			case INNER:
			case INSERT:
			case INSTANT:
			case INTERSECT:
			case INTO:
			case IS:
			case JOIN:
			case KEY:
			case KEYS:
			case LAST:
			case LATERAL:
			case LEADING:
			case LEFT:
			case LIKE:
			case LIMIT:
			case LIST:
			case LISTAGG:
			case LOCAL:
			case LOCAL_DATE:
			case LOCAL_DATETIME:
			case LOCAL_TIME:
			case MAP:
			case MATERIALIZED:
			case MAX:
			case MAXELEMENT:
			case MAXINDEX:
			case MEMBER:
			case MICROSECOND:
			case MILLISECOND:
			case MIN:
			case MINELEMENT:
			case MININDEX:
			case MINUTE:
			case MONTH:
			case NANOSECOND:
			case NEW:
			case NEXT:
			case NO:
			case NOT:
			case NOTHING:
			case NULLS:
			case OBJECT:
			case OF:
			case OFFSET:
			case OFFSET_DATETIME:
			case ON:
			case ONLY:
			case OR:
			case ORDER:
			case OTHERS:
			case OUTER:
			case OVER:
			case OVERFLOW:
			case OVERLAY:
			case PAD:
			case PARTITION:
			case PERCENT:
			case PLACING:
			case POSITION:
			case PRECEDING:
			case QUARTER:
			case RANGE:
			case RESPECT:
			case RIGHT:
			case ROLLUP:
			case ROW:
			case ROWS:
			case SEARCH:
			case SECOND:
			case SELECT:
			case SET:
			case SIZE:
			case SOME:
			case SUBSTRING:
			case SUM:
			case THEN:
			case TIES:
			case TIME:
			case TIMESTAMP:
			case TIMEZONE_HOUR:
			case TIMEZONE_MINUTE:
			case TO:
			case TRAILING:
			case TREAT:
			case TRIM:
			case TRUNC:
			case TRUNCATE:
			case TYPE:
			case UNBOUNDED:
			case UNION:
			case UPDATE:
			case USING:
			case VALUE:
			case VALUES:
			case WEEK:
			case WHEN:
			case WHERE:
			case WITH:
			case WITHIN:
			case WITHOUT:
			case YEAR:
			case ZONED:
			case IDENTIFIER:
			case QUOTED_IDENTIFIER:
				enterOuterAlt(_localctx, 2);
				{
				setState(1532);
				identifier();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class ColumnFunctionContext extends ParserRuleContext {
		public TerminalNode COLUMN() { return getToken(HqlParser.COLUMN, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode DOT() { return getToken(HqlParser.DOT, 0); }
		public JpaNonstandardFunctionNameContext jpaNonstandardFunctionName() {
			return getRuleContext(JpaNonstandardFunctionNameContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode AS() { return getToken(HqlParser.AS, 0); }
		public CastTargetContext castTarget() {
			return getRuleContext(CastTargetContext.class,0);
		}
		public ColumnFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_columnFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterColumnFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitColumnFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitColumnFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ColumnFunctionContext columnFunction() throws RecognitionException {
		ColumnFunctionContext _localctx = new ColumnFunctionContext(_ctx, getState());
		enterRule(_localctx, 282, RULE_columnFunction);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1535);
			match(COLUMN);
			setState(1536);
			match(LEFT_PAREN);
			setState(1537);
			path();
			setState(1538);
			match(DOT);
			setState(1539);
			jpaNonstandardFunctionName();
			setState(1542);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==AS) {
				{
				setState(1540);
				match(AS);
				setState(1541);
				castTarget();
				}
			}

			setState(1544);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class GenericFunctionContext extends ParserRuleContext {
		public GenericFunctionNameContext genericFunctionName() {
			return getRuleContext(GenericFunctionNameContext.class,0);
		}
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public GenericFunctionArgumentsContext genericFunctionArguments() {
			return getRuleContext(GenericFunctionArgumentsContext.class,0);
		}
		public TerminalNode ASTERISK() { return getToken(HqlParser.ASTERISK, 0); }
		public NthSideClauseContext nthSideClause() {
			return getRuleContext(NthSideClauseContext.class,0);
		}
		public NullsClauseContext nullsClause() {
			return getRuleContext(NullsClauseContext.class,0);
		}
		public WithinGroupClauseContext withinGroupClause() {
			return getRuleContext(WithinGroupClauseContext.class,0);
		}
		public FilterClauseContext filterClause() {
			return getRuleContext(FilterClauseContext.class,0);
		}
		public OverClauseContext overClause() {
			return getRuleContext(OverClauseContext.class,0);
		}
		public GenericFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_genericFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGenericFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGenericFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGenericFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GenericFunctionContext genericFunction() throws RecognitionException {
		GenericFunctionContext _localctx = new GenericFunctionContext(_ctx, getState());
		enterRule(_localctx, 284, RULE_genericFunction);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1546);
			genericFunctionName();
			setState(1547);
			match(LEFT_PAREN);
			setState(1550);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case INTEGER_LITERAL:
			case LONG_LITERAL:
			case FLOAT_LITERAL:
			case DOUBLE_LITERAL:
			case BIG_INTEGER_LITERAL:
			case BIG_DECIMAL_LITERAL:
			case HEX_LITERAL:
			case STRING_LITERAL:
			case JAVA_STRING_LITERAL:
			case BINARY_LITERAL:
			case TIMESTAMP_ESCAPE_START:
			case DATE_ESCAPE_START:
			case TIME_ESCAPE_START:
			case LEFT_PAREN:
			case LEFT_BRACE:
			case PLUS:
			case MINUS:
			case COLON:
			case QUESTION_MARK:
			case ID:
			case VERSION:
			case VERSIONED:
			case NATURALID:
			case FK:
			case ALL:
			case AND:
			case ANY:
			case AS:
			case ASC:
			case AVG:
			case BETWEEN:
			case BOTH:
			case BREADTH:
			case BY:
			case CASE:
			case CAST:
			case COLLATE:
			case COLUMN:
			case CONFLICT:
			case CONSTRAINT:
			case COUNT:
			case CROSS:
			case CUBE:
			case CURRENT:
			case CURRENT_DATE:
			case CURRENT_INSTANT:
			case CURRENT_TIME:
			case CURRENT_TIMESTAMP:
			case CYCLE:
			case DATE:
			case DATETIME:
			case DAY:
			case DEFAULT:
			case DELETE:
			case DEPTH:
			case DESC:
			case DISTINCT:
			case DO:
			case ELEMENT:
			case ELEMENTS:
			case ELSE:
			case EMPTY:
			case END:
			case ENTRY:
			case EPOCH:
			case ERROR:
			case ESCAPE:
			case EVERY:
			case EXCEPT:
			case EXCLUDE:
			case EXISTS:
			case EXTRACT:
			case FETCH:
			case FILTER:
			case FIRST:
			case FOLLOWING:
			case FOR:
			case FORMAT:
			case FROM:
			case FULL:
			case FUNCTION:
			case GROUP:
			case GROUPS:
			case HAVING:
			case HOUR:
			case IGNORE:
			case ILIKE:
			case IN:
			case INDEX:
			case INDICES:
			case INNER:
			case INSERT:
			case INSTANT:
			case INTERSECT:
			case INTO:
			case IS:
			case JOIN:
			case KEY:
			case KEYS:
			case LAST:
			case LATERAL:
			case LEADING:
			case LEFT:
			case LIKE:
			case LIMIT:
			case LIST:
			case LISTAGG:
			case LOCAL:
			case LOCAL_DATE:
			case LOCAL_DATETIME:
			case LOCAL_TIME:
			case MAP:
			case MATERIALIZED:
			case MAX:
			case MAXELEMENT:
			case MAXINDEX:
			case MEMBER:
			case MICROSECOND:
			case MILLISECOND:
			case MIN:
			case MINELEMENT:
			case MININDEX:
			case MINUTE:
			case MONTH:
			case NANOSECOND:
			case NEW:
			case NEXT:
			case NO:
			case NOT:
			case NOTHING:
			case NULLS:
			case OBJECT:
			case OF:
			case OFFSET:
			case OFFSET_DATETIME:
			case ON:
			case ONLY:
			case OR:
			case ORDER:
			case OTHERS:
			case OUTER:
			case OVER:
			case OVERFLOW:
			case OVERLAY:
			case PAD:
			case PARTITION:
			case PERCENT:
			case PLACING:
			case POSITION:
			case PRECEDING:
			case QUARTER:
			case RANGE:
			case RESPECT:
			case RIGHT:
			case ROLLUP:
			case ROW:
			case ROWS:
			case SEARCH:
			case SECOND:
			case SELECT:
			case SET:
			case SIZE:
			case SOME:
			case SUBSTRING:
			case SUM:
			case THEN:
			case TIES:
			case TIME:
			case TIMESTAMP:
			case TIMEZONE_HOUR:
			case TIMEZONE_MINUTE:
			case TO:
			case TRAILING:
			case TREAT:
			case TRIM:
			case TRUNC:
			case TRUNCATE:
			case TYPE:
			case UNBOUNDED:
			case UNION:
			case UPDATE:
			case USING:
			case VALUE:
			case VALUES:
			case WEEK:
			case WHEN:
			case WHERE:
			case WITH:
			case WITHIN:
			case WITHOUT:
			case YEAR:
			case ZONED:
			case TRUE:
			case FALSE:
			case NULL:
			case IDENTIFIER:
			case QUOTED_IDENTIFIER:
				{
				setState(1548);
				genericFunctionArguments();
				}
				break;
			case ASTERISK:
				{
				setState(1549);
				match(ASTERISK);
				}
				break;
			case RIGHT_PAREN:
				break;
			default:
				break;
			}
			setState(1552);
			match(RIGHT_PAREN);
			setState(1554);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,166,_ctx) ) {
			case 1:
				{
				setState(1553);
				nthSideClause();
				}
				break;
			}
			setState(1557);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,167,_ctx) ) {
			case 1:
				{
				setState(1556);
				nullsClause();
				}
				break;
			}
			setState(1560);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,168,_ctx) ) {
			case 1:
				{
				setState(1559);
				withinGroupClause();
				}
				break;
			}
			setState(1563);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,169,_ctx) ) {
			case 1:
				{
				setState(1562);
				filterClause();
				}
				break;
			}
			setState(1566);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,170,_ctx) ) {
			case 1:
				{
				setState(1565);
				overClause();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class GenericFunctionNameContext extends ParserRuleContext {
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public GenericFunctionNameContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_genericFunctionName; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGenericFunctionName(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGenericFunctionName(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGenericFunctionName(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GenericFunctionNameContext genericFunctionName() throws RecognitionException {
		GenericFunctionNameContext _localctx = new GenericFunctionNameContext(_ctx, getState());
		enterRule(_localctx, 286, RULE_genericFunctionName);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1568);
			simplePath();
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class GenericFunctionArgumentsContext extends ParserRuleContext {
		public List<ExpressionOrPredicateContext> expressionOrPredicate() {
			return getRuleContexts(ExpressionOrPredicateContext.class);
		}
		public ExpressionOrPredicateContext expressionOrPredicate(int i) {
			return getRuleContext(ExpressionOrPredicateContext.class,i);
		}
		public TerminalNode DISTINCT() { return getToken(HqlParser.DISTINCT, 0); }
		public DatetimeFieldContext datetimeField() {
			return getRuleContext(DatetimeFieldContext.class,0);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public GenericFunctionArgumentsContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_genericFunctionArguments; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterGenericFunctionArguments(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitGenericFunctionArguments(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitGenericFunctionArguments(this);
			else return visitor.visitChildren(this);
		}
	}

	public final GenericFunctionArgumentsContext genericFunctionArguments() throws RecognitionException {
		GenericFunctionArgumentsContext _localctx = new GenericFunctionArgumentsContext(_ctx, getState());
		enterRule(_localctx, 288, RULE_genericFunctionArguments);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1574);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,171,_ctx) ) {
			case 1:
				{
				setState(1570);
				match(DISTINCT);
				}
				break;
			case 2:
				{
				setState(1571);
				datetimeField();
				setState(1572);
				match(COMMA);
				}
				break;
			}
			setState(1576);
			expressionOrPredicate();
			setState(1581);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(1577);
				match(COMMA);
				setState(1578);
				expressionOrPredicate();
				}
				}
				setState(1583);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class CollectionSizeFunctionContext extends ParserRuleContext {
		public TerminalNode SIZE() { return getToken(HqlParser.SIZE, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public CollectionSizeFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_collectionSizeFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCollectionSizeFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCollectionSizeFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCollectionSizeFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CollectionSizeFunctionContext collectionSizeFunction() throws RecognitionException {
		CollectionSizeFunctionContext _localctx = new CollectionSizeFunctionContext(_ctx, getState());
		enterRule(_localctx, 290, RULE_collectionSizeFunction);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1584);
			match(SIZE);
			setState(1585);
			match(LEFT_PAREN);
			setState(1586);
			path();
			setState(1587);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class CollectionAggregateFunctionContext extends ParserRuleContext {
		public CollectionAggregateFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_collectionAggregateFunction; }
	 
		public CollectionAggregateFunctionContext() { }
		public void copyFrom(CollectionAggregateFunctionContext ctx) {
			super.copyFrom(ctx);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class IndexAggregateFunctionContext extends CollectionAggregateFunctionContext {
		public List<TerminalNode> LEFT_PAREN() { return getTokens(HqlParser.LEFT_PAREN); }
		public TerminalNode LEFT_PAREN(int i) {
			return getToken(HqlParser.LEFT_PAREN, i);
		}
		public IndicesKeysQuantifierContext indicesKeysQuantifier() {
			return getRuleContext(IndicesKeysQuantifierContext.class,0);
		}
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public List<TerminalNode> RIGHT_PAREN() { return getTokens(HqlParser.RIGHT_PAREN); }
		public TerminalNode RIGHT_PAREN(int i) {
			return getToken(HqlParser.RIGHT_PAREN, i);
		}
		public TerminalNode MAX() { return getToken(HqlParser.MAX, 0); }
		public TerminalNode MIN() { return getToken(HqlParser.MIN, 0); }
		public TerminalNode SUM() { return getToken(HqlParser.SUM, 0); }
		public TerminalNode AVG() { return getToken(HqlParser.AVG, 0); }
		public TerminalNode MAXINDEX() { return getToken(HqlParser.MAXINDEX, 0); }
		public TerminalNode MININDEX() { return getToken(HqlParser.MININDEX, 0); }
		public IndexAggregateFunctionContext(CollectionAggregateFunctionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterIndexAggregateFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitIndexAggregateFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitIndexAggregateFunction(this);
			else return visitor.visitChildren(this);
		}
	}
	@SuppressWarnings("CheckReturnValue")
	public static class ElementAggregateFunctionContext extends CollectionAggregateFunctionContext {
		public List<TerminalNode> LEFT_PAREN() { return getTokens(HqlParser.LEFT_PAREN); }
		public TerminalNode LEFT_PAREN(int i) {
			return getToken(HqlParser.LEFT_PAREN, i);
		}
		public ElementsValuesQuantifierContext elementsValuesQuantifier() {
			return getRuleContext(ElementsValuesQuantifierContext.class,0);
		}
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public List<TerminalNode> RIGHT_PAREN() { return getTokens(HqlParser.RIGHT_PAREN); }
		public TerminalNode RIGHT_PAREN(int i) {
			return getToken(HqlParser.RIGHT_PAREN, i);
		}
		public TerminalNode MAX() { return getToken(HqlParser.MAX, 0); }
		public TerminalNode MIN() { return getToken(HqlParser.MIN, 0); }
		public TerminalNode SUM() { return getToken(HqlParser.SUM, 0); }
		public TerminalNode AVG() { return getToken(HqlParser.AVG, 0); }
		public TerminalNode MAXELEMENT() { return getToken(HqlParser.MAXELEMENT, 0); }
		public TerminalNode MINELEMENT() { return getToken(HqlParser.MINELEMENT, 0); }
		public ElementAggregateFunctionContext(CollectionAggregateFunctionContext ctx) { copyFrom(ctx); }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterElementAggregateFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitElementAggregateFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitElementAggregateFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CollectionAggregateFunctionContext collectionAggregateFunction() throws RecognitionException {
		CollectionAggregateFunctionContext _localctx = new CollectionAggregateFunctionContext(_ctx, getState());
		enterRule(_localctx, 292, RULE_collectionAggregateFunction);
		int _la;
		try {
			setState(1615);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,173,_ctx) ) {
			case 1:
				_localctx = new ElementAggregateFunctionContext(_localctx);
				enterOuterAlt(_localctx, 1);
				{
				setState(1589);
				_la = _input.LA(1);
				if ( !(_la==AVG || ((((_la - 136)) & ~0x3f) == 0 && ((1L << (_la - 136)) & 2251799813685313L) != 0)) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1590);
				match(LEFT_PAREN);
				setState(1591);
				elementsValuesQuantifier();
				setState(1592);
				match(LEFT_PAREN);
				setState(1593);
				path();
				setState(1594);
				match(RIGHT_PAREN);
				setState(1595);
				match(RIGHT_PAREN);
				}
				break;
			case 2:
				_localctx = new IndexAggregateFunctionContext(_localctx);
				enterOuterAlt(_localctx, 2);
				{
				setState(1597);
				_la = _input.LA(1);
				if ( !(_la==AVG || ((((_la - 136)) & ~0x3f) == 0 && ((1L << (_la - 136)) & 2251799813685313L) != 0)) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1598);
				match(LEFT_PAREN);
				setState(1599);
				indicesKeysQuantifier();
				setState(1600);
				match(LEFT_PAREN);
				setState(1601);
				path();
				setState(1602);
				match(RIGHT_PAREN);
				setState(1603);
				match(RIGHT_PAREN);
				}
				break;
			case 3:
				_localctx = new ElementAggregateFunctionContext(_localctx);
				enterOuterAlt(_localctx, 3);
				{
				setState(1605);
				_la = _input.LA(1);
				if ( !(_la==MAXELEMENT || _la==MINELEMENT) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1606);
				match(LEFT_PAREN);
				setState(1607);
				path();
				setState(1608);
				match(RIGHT_PAREN);
				}
				break;
			case 4:
				_localctx = new IndexAggregateFunctionContext(_localctx);
				enterOuterAlt(_localctx, 4);
				{
				setState(1610);
				_la = _input.LA(1);
				if ( !(_la==MAXINDEX || _la==MININDEX) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1611);
				match(LEFT_PAREN);
				setState(1612);
				path();
				setState(1613);
				match(RIGHT_PAREN);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class CollectionFunctionMisuseContext extends ParserRuleContext {
		public ElementsValuesQuantifierContext elementsValuesQuantifier() {
			return getRuleContext(ElementsValuesQuantifierContext.class,0);
		}
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PathContext path() {
			return getRuleContext(PathContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public IndicesKeysQuantifierContext indicesKeysQuantifier() {
			return getRuleContext(IndicesKeysQuantifierContext.class,0);
		}
		public CollectionFunctionMisuseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_collectionFunctionMisuse; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCollectionFunctionMisuse(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCollectionFunctionMisuse(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCollectionFunctionMisuse(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CollectionFunctionMisuseContext collectionFunctionMisuse() throws RecognitionException {
		CollectionFunctionMisuseContext _localctx = new CollectionFunctionMisuseContext(_ctx, getState());
		enterRule(_localctx, 294, RULE_collectionFunctionMisuse);
		try {
			setState(1627);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case ELEMENTS:
			case VALUES:
				enterOuterAlt(_localctx, 1);
				{
				setState(1617);
				elementsValuesQuantifier();
				setState(1618);
				match(LEFT_PAREN);
				setState(1619);
				path();
				setState(1620);
				match(RIGHT_PAREN);
				}
				break;
			case INDICES:
			case KEYS:
				enterOuterAlt(_localctx, 2);
				{
				setState(1622);
				indicesKeysQuantifier();
				setState(1623);
				match(LEFT_PAREN);
				setState(1624);
				path();
				setState(1625);
				match(RIGHT_PAREN);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class AggregateFunctionContext extends ParserRuleContext {
		public EveryFunctionContext everyFunction() {
			return getRuleContext(EveryFunctionContext.class,0);
		}
		public AnyFunctionContext anyFunction() {
			return getRuleContext(AnyFunctionContext.class,0);
		}
		public ListaggFunctionContext listaggFunction() {
			return getRuleContext(ListaggFunctionContext.class,0);
		}
		public AggregateFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_aggregateFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterAggregateFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitAggregateFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitAggregateFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final AggregateFunctionContext aggregateFunction() throws RecognitionException {
		AggregateFunctionContext _localctx = new AggregateFunctionContext(_ctx, getState());
		enterRule(_localctx, 296, RULE_aggregateFunction);
		try {
			setState(1632);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case ALL:
			case EVERY:
				enterOuterAlt(_localctx, 1);
				{
				setState(1629);
				everyFunction();
				}
				break;
			case ANY:
			case SOME:
				enterOuterAlt(_localctx, 2);
				{
				setState(1630);
				anyFunction();
				}
				break;
			case LISTAGG:
				enterOuterAlt(_localctx, 3);
				{
				setState(1631);
				listaggFunction();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class EveryFunctionContext extends ParserRuleContext {
		public EveryAllQuantifierContext everyAllQuantifier() {
			return getRuleContext(EveryAllQuantifierContext.class,0);
		}
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PredicateContext predicate() {
			return getRuleContext(PredicateContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public FilterClauseContext filterClause() {
			return getRuleContext(FilterClauseContext.class,0);
		}
		public OverClauseContext overClause() {
			return getRuleContext(OverClauseContext.class,0);
		}
		public SubqueryContext subquery() {
			return getRuleContext(SubqueryContext.class,0);
		}
		public CollectionQuantifierContext collectionQuantifier() {
			return getRuleContext(CollectionQuantifierContext.class,0);
		}
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public EveryFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_everyFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEveryFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEveryFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEveryFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final EveryFunctionContext everyFunction() throws RecognitionException {
		EveryFunctionContext _localctx = new EveryFunctionContext(_ctx, getState());
		enterRule(_localctx, 298, RULE_everyFunction);
		try {
			setState(1655);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,178,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1634);
				everyAllQuantifier();
				setState(1635);
				match(LEFT_PAREN);
				setState(1636);
				predicate(0);
				setState(1637);
				match(RIGHT_PAREN);
				setState(1639);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,176,_ctx) ) {
				case 1:
					{
					setState(1638);
					filterClause();
					}
					break;
				}
				setState(1642);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,177,_ctx) ) {
				case 1:
					{
					setState(1641);
					overClause();
					}
					break;
				}
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1644);
				everyAllQuantifier();
				setState(1645);
				match(LEFT_PAREN);
				setState(1646);
				subquery();
				setState(1647);
				match(RIGHT_PAREN);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1649);
				everyAllQuantifier();
				setState(1650);
				collectionQuantifier();
				setState(1651);
				match(LEFT_PAREN);
				setState(1652);
				simplePath();
				setState(1653);
				match(RIGHT_PAREN);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class AnyFunctionContext extends ParserRuleContext {
		public AnySomeQuantifierContext anySomeQuantifier() {
			return getRuleContext(AnySomeQuantifierContext.class,0);
		}
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PredicateContext predicate() {
			return getRuleContext(PredicateContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public FilterClauseContext filterClause() {
			return getRuleContext(FilterClauseContext.class,0);
		}
		public OverClauseContext overClause() {
			return getRuleContext(OverClauseContext.class,0);
		}
		public SubqueryContext subquery() {
			return getRuleContext(SubqueryContext.class,0);
		}
		public CollectionQuantifierContext collectionQuantifier() {
			return getRuleContext(CollectionQuantifierContext.class,0);
		}
		public SimplePathContext simplePath() {
			return getRuleContext(SimplePathContext.class,0);
		}
		public AnyFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_anyFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterAnyFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitAnyFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitAnyFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final AnyFunctionContext anyFunction() throws RecognitionException {
		AnyFunctionContext _localctx = new AnyFunctionContext(_ctx, getState());
		enterRule(_localctx, 300, RULE_anyFunction);
		try {
			setState(1678);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,181,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1657);
				anySomeQuantifier();
				setState(1658);
				match(LEFT_PAREN);
				setState(1659);
				predicate(0);
				setState(1660);
				match(RIGHT_PAREN);
				setState(1662);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,179,_ctx) ) {
				case 1:
					{
					setState(1661);
					filterClause();
					}
					break;
				}
				setState(1665);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,180,_ctx) ) {
				case 1:
					{
					setState(1664);
					overClause();
					}
					break;
				}
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1667);
				anySomeQuantifier();
				setState(1668);
				match(LEFT_PAREN);
				setState(1669);
				subquery();
				setState(1670);
				match(RIGHT_PAREN);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1672);
				anySomeQuantifier();
				setState(1673);
				collectionQuantifier();
				setState(1674);
				match(LEFT_PAREN);
				setState(1675);
				simplePath();
				setState(1676);
				match(RIGHT_PAREN);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class EveryAllQuantifierContext extends ParserRuleContext {
		public TerminalNode EVERY() { return getToken(HqlParser.EVERY, 0); }
		public TerminalNode ALL() { return getToken(HqlParser.ALL, 0); }
		public EveryAllQuantifierContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_everyAllQuantifier; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterEveryAllQuantifier(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitEveryAllQuantifier(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitEveryAllQuantifier(this);
			else return visitor.visitChildren(this);
		}
	}

	public final EveryAllQuantifierContext everyAllQuantifier() throws RecognitionException {
		EveryAllQuantifierContext _localctx = new EveryAllQuantifierContext(_ctx, getState());
		enterRule(_localctx, 302, RULE_everyAllQuantifier);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1680);
			_la = _input.LA(1);
			if ( !(_la==ALL || _la==EVERY) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class AnySomeQuantifierContext extends ParserRuleContext {
		public TerminalNode ANY() { return getToken(HqlParser.ANY, 0); }
		public TerminalNode SOME() { return getToken(HqlParser.SOME, 0); }
		public AnySomeQuantifierContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_anySomeQuantifier; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterAnySomeQuantifier(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitAnySomeQuantifier(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitAnySomeQuantifier(this);
			else return visitor.visitChildren(this);
		}
	}

	public final AnySomeQuantifierContext anySomeQuantifier() throws RecognitionException {
		AnySomeQuantifierContext _localctx = new AnySomeQuantifierContext(_ctx, getState());
		enterRule(_localctx, 304, RULE_anySomeQuantifier);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1682);
			_la = _input.LA(1);
			if ( !(_la==ANY || _la==SOME) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class ListaggFunctionContext extends ParserRuleContext {
		public TerminalNode LISTAGG() { return getToken(HqlParser.LISTAGG, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public List<ExpressionOrPredicateContext> expressionOrPredicate() {
			return getRuleContexts(ExpressionOrPredicateContext.class);
		}
		public ExpressionOrPredicateContext expressionOrPredicate(int i) {
			return getRuleContext(ExpressionOrPredicateContext.class,i);
		}
		public TerminalNode COMMA() { return getToken(HqlParser.COMMA, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode DISTINCT() { return getToken(HqlParser.DISTINCT, 0); }
		public OnOverflowClauseContext onOverflowClause() {
			return getRuleContext(OnOverflowClauseContext.class,0);
		}
		public WithinGroupClauseContext withinGroupClause() {
			return getRuleContext(WithinGroupClauseContext.class,0);
		}
		public FilterClauseContext filterClause() {
			return getRuleContext(FilterClauseContext.class,0);
		}
		public OverClauseContext overClause() {
			return getRuleContext(OverClauseContext.class,0);
		}
		public ListaggFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_listaggFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterListaggFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitListaggFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitListaggFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ListaggFunctionContext listaggFunction() throws RecognitionException {
		ListaggFunctionContext _localctx = new ListaggFunctionContext(_ctx, getState());
		enterRule(_localctx, 306, RULE_listaggFunction);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1684);
			match(LISTAGG);
			setState(1685);
			match(LEFT_PAREN);
			setState(1687);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,182,_ctx) ) {
			case 1:
				{
				setState(1686);
				match(DISTINCT);
				}
				break;
			}
			setState(1689);
			expressionOrPredicate();
			setState(1690);
			match(COMMA);
			setState(1691);
			expressionOrPredicate();
			setState(1693);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==ON) {
				{
				setState(1692);
				onOverflowClause();
				}
			}

			setState(1695);
			match(RIGHT_PAREN);
			setState(1697);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,184,_ctx) ) {
			case 1:
				{
				setState(1696);
				withinGroupClause();
				}
				break;
			}
			setState(1700);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,185,_ctx) ) {
			case 1:
				{
				setState(1699);
				filterClause();
				}
				break;
			}
			setState(1703);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,186,_ctx) ) {
			case 1:
				{
				setState(1702);
				overClause();
				}
				break;
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class OnOverflowClauseContext extends ParserRuleContext {
		public TerminalNode ON() { return getToken(HqlParser.ON, 0); }
		public TerminalNode OVERFLOW() { return getToken(HqlParser.OVERFLOW, 0); }
		public TerminalNode ERROR() { return getToken(HqlParser.ERROR, 0); }
		public TerminalNode TRUNCATE() { return getToken(HqlParser.TRUNCATE, 0); }
		public TerminalNode COUNT() { return getToken(HqlParser.COUNT, 0); }
		public TerminalNode WITH() { return getToken(HqlParser.WITH, 0); }
		public TerminalNode WITHOUT() { return getToken(HqlParser.WITHOUT, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public OnOverflowClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_onOverflowClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOnOverflowClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOnOverflowClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOnOverflowClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OnOverflowClauseContext onOverflowClause() throws RecognitionException {
		OnOverflowClauseContext _localctx = new OnOverflowClauseContext(_ctx, getState());
		enterRule(_localctx, 308, RULE_onOverflowClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1705);
			match(ON);
			setState(1706);
			match(OVERFLOW);
			setState(1714);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case ERROR:
				{
				setState(1707);
				match(ERROR);
				}
				break;
			case TRUNCATE:
				{
				setState(1708);
				match(TRUNCATE);
				setState(1710);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,187,_ctx) ) {
				case 1:
					{
					setState(1709);
					expression(0);
					}
					break;
				}
				setState(1712);
				_la = _input.LA(1);
				if ( !(_la==WITH || _la==WITHOUT) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1713);
				match(COUNT);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class WithinGroupClauseContext extends ParserRuleContext {
		public TerminalNode WITHIN() { return getToken(HqlParser.WITHIN, 0); }
		public TerminalNode GROUP() { return getToken(HqlParser.GROUP, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public OrderByClauseContext orderByClause() {
			return getRuleContext(OrderByClauseContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public WithinGroupClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_withinGroupClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterWithinGroupClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitWithinGroupClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitWithinGroupClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final WithinGroupClauseContext withinGroupClause() throws RecognitionException {
		WithinGroupClauseContext _localctx = new WithinGroupClauseContext(_ctx, getState());
		enterRule(_localctx, 310, RULE_withinGroupClause);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1716);
			match(WITHIN);
			setState(1717);
			match(GROUP);
			setState(1718);
			match(LEFT_PAREN);
			setState(1719);
			orderByClause();
			setState(1720);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class FilterClauseContext extends ParserRuleContext {
		public TerminalNode FILTER() { return getToken(HqlParser.FILTER, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public WhereClauseContext whereClause() {
			return getRuleContext(WhereClauseContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public FilterClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_filterClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFilterClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFilterClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFilterClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FilterClauseContext filterClause() throws RecognitionException {
		FilterClauseContext _localctx = new FilterClauseContext(_ctx, getState());
		enterRule(_localctx, 312, RULE_filterClause);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1722);
			match(FILTER);
			setState(1723);
			match(LEFT_PAREN);
			setState(1724);
			whereClause();
			setState(1725);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class NullsClauseContext extends ParserRuleContext {
		public TerminalNode RESPECT() { return getToken(HqlParser.RESPECT, 0); }
		public TerminalNode NULLS() { return getToken(HqlParser.NULLS, 0); }
		public TerminalNode IGNORE() { return getToken(HqlParser.IGNORE, 0); }
		public NullsClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_nullsClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterNullsClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitNullsClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitNullsClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final NullsClauseContext nullsClause() throws RecognitionException {
		NullsClauseContext _localctx = new NullsClauseContext(_ctx, getState());
		enterRule(_localctx, 314, RULE_nullsClause);
		try {
			setState(1731);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case RESPECT:
				enterOuterAlt(_localctx, 1);
				{
				setState(1727);
				match(RESPECT);
				setState(1728);
				match(NULLS);
				}
				break;
			case IGNORE:
				enterOuterAlt(_localctx, 2);
				{
				setState(1729);
				match(IGNORE);
				setState(1730);
				match(NULLS);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class NthSideClauseContext extends ParserRuleContext {
		public TerminalNode FROM() { return getToken(HqlParser.FROM, 0); }
		public TerminalNode FIRST() { return getToken(HqlParser.FIRST, 0); }
		public TerminalNode LAST() { return getToken(HqlParser.LAST, 0); }
		public NthSideClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_nthSideClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterNthSideClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitNthSideClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitNthSideClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final NthSideClauseContext nthSideClause() throws RecognitionException {
		NthSideClauseContext _localctx = new NthSideClauseContext(_ctx, getState());
		enterRule(_localctx, 316, RULE_nthSideClause);
		try {
			setState(1737);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,190,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1733);
				match(FROM);
				setState(1734);
				match(FIRST);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1735);
				match(FROM);
				setState(1736);
				match(LAST);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class OverClauseContext extends ParserRuleContext {
		public TerminalNode OVER() { return getToken(HqlParser.OVER, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public PartitionClauseContext partitionClause() {
			return getRuleContext(PartitionClauseContext.class,0);
		}
		public OrderByClauseContext orderByClause() {
			return getRuleContext(OrderByClauseContext.class,0);
		}
		public FrameClauseContext frameClause() {
			return getRuleContext(FrameClauseContext.class,0);
		}
		public OverClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_overClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOverClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOverClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOverClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OverClauseContext overClause() throws RecognitionException {
		OverClauseContext _localctx = new OverClauseContext(_ctx, getState());
		enterRule(_localctx, 318, RULE_overClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1739);
			match(OVER);
			setState(1740);
			match(LEFT_PAREN);
			setState(1742);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==PARTITION) {
				{
				setState(1741);
				partitionClause();
				}
			}

			setState(1745);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==ORDER) {
				{
				setState(1744);
				orderByClause();
				}
			}

			setState(1748);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==GROUPS || _la==RANGE || _la==ROWS) {
				{
				setState(1747);
				frameClause();
				}
			}

			setState(1750);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class PartitionClauseContext extends ParserRuleContext {
		public TerminalNode PARTITION() { return getToken(HqlParser.PARTITION, 0); }
		public TerminalNode BY() { return getToken(HqlParser.BY, 0); }
		public List<ExpressionContext> expression() {
			return getRuleContexts(ExpressionContext.class);
		}
		public ExpressionContext expression(int i) {
			return getRuleContext(ExpressionContext.class,i);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public PartitionClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_partitionClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPartitionClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPartitionClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPartitionClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PartitionClauseContext partitionClause() throws RecognitionException {
		PartitionClauseContext _localctx = new PartitionClauseContext(_ctx, getState());
		enterRule(_localctx, 320, RULE_partitionClause);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1752);
			match(PARTITION);
			setState(1753);
			match(BY);
			setState(1754);
			expression(0);
			setState(1759);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(1755);
				match(COMMA);
				setState(1756);
				expression(0);
				}
				}
				setState(1761);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class FrameClauseContext extends ParserRuleContext {
		public FrameStartContext frameStart() {
			return getRuleContext(FrameStartContext.class,0);
		}
		public TerminalNode RANGE() { return getToken(HqlParser.RANGE, 0); }
		public TerminalNode ROWS() { return getToken(HqlParser.ROWS, 0); }
		public TerminalNode GROUPS() { return getToken(HqlParser.GROUPS, 0); }
		public FrameExclusionContext frameExclusion() {
			return getRuleContext(FrameExclusionContext.class,0);
		}
		public TerminalNode BETWEEN() { return getToken(HqlParser.BETWEEN, 0); }
		public TerminalNode AND() { return getToken(HqlParser.AND, 0); }
		public FrameEndContext frameEnd() {
			return getRuleContext(FrameEndContext.class,0);
		}
		public FrameClauseContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_frameClause; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFrameClause(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFrameClause(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFrameClause(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FrameClauseContext frameClause() throws RecognitionException {
		FrameClauseContext _localctx = new FrameClauseContext(_ctx, getState());
		enterRule(_localctx, 322, RULE_frameClause);
		int _la;
		try {
			setState(1775);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,197,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1762);
				_la = _input.LA(1);
				if ( !(_la==GROUPS || _la==RANGE || _la==ROWS) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1763);
				frameStart();
				setState(1765);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==EXCLUDE) {
					{
					setState(1764);
					frameExclusion();
					}
				}

				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1767);
				_la = _input.LA(1);
				if ( !(_la==GROUPS || _la==RANGE || _la==ROWS) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}
				setState(1768);
				match(BETWEEN);
				setState(1769);
				frameStart();
				setState(1770);
				match(AND);
				setState(1771);
				frameEnd();
				setState(1773);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==EXCLUDE) {
					{
					setState(1772);
					frameExclusion();
					}
				}

				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class FrameStartContext extends ParserRuleContext {
		public TerminalNode CURRENT() { return getToken(HqlParser.CURRENT, 0); }
		public TerminalNode ROW() { return getToken(HqlParser.ROW, 0); }
		public TerminalNode UNBOUNDED() { return getToken(HqlParser.UNBOUNDED, 0); }
		public TerminalNode PRECEDING() { return getToken(HqlParser.PRECEDING, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode FOLLOWING() { return getToken(HqlParser.FOLLOWING, 0); }
		public FrameStartContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_frameStart; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFrameStart(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFrameStart(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFrameStart(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FrameStartContext frameStart() throws RecognitionException {
		FrameStartContext _localctx = new FrameStartContext(_ctx, getState());
		enterRule(_localctx, 324, RULE_frameStart);
		try {
			setState(1787);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,198,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1777);
				match(CURRENT);
				setState(1778);
				match(ROW);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1779);
				match(UNBOUNDED);
				setState(1780);
				match(PRECEDING);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1781);
				expression(0);
				setState(1782);
				match(PRECEDING);
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(1784);
				expression(0);
				setState(1785);
				match(FOLLOWING);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class FrameEndContext extends ParserRuleContext {
		public TerminalNode CURRENT() { return getToken(HqlParser.CURRENT, 0); }
		public TerminalNode ROW() { return getToken(HqlParser.ROW, 0); }
		public TerminalNode UNBOUNDED() { return getToken(HqlParser.UNBOUNDED, 0); }
		public TerminalNode FOLLOWING() { return getToken(HqlParser.FOLLOWING, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode PRECEDING() { return getToken(HqlParser.PRECEDING, 0); }
		public FrameEndContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_frameEnd; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFrameEnd(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFrameEnd(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFrameEnd(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FrameEndContext frameEnd() throws RecognitionException {
		FrameEndContext _localctx = new FrameEndContext(_ctx, getState());
		enterRule(_localctx, 326, RULE_frameEnd);
		try {
			setState(1799);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,199,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1789);
				match(CURRENT);
				setState(1790);
				match(ROW);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1791);
				match(UNBOUNDED);
				setState(1792);
				match(FOLLOWING);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1793);
				expression(0);
				setState(1794);
				match(PRECEDING);
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(1796);
				expression(0);
				setState(1797);
				match(FOLLOWING);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class FrameExclusionContext extends ParserRuleContext {
		public TerminalNode EXCLUDE() { return getToken(HqlParser.EXCLUDE, 0); }
		public TerminalNode CURRENT() { return getToken(HqlParser.CURRENT, 0); }
		public TerminalNode ROW() { return getToken(HqlParser.ROW, 0); }
		public TerminalNode GROUP() { return getToken(HqlParser.GROUP, 0); }
		public TerminalNode TIES() { return getToken(HqlParser.TIES, 0); }
		public TerminalNode NO() { return getToken(HqlParser.NO, 0); }
		public TerminalNode OTHERS() { return getToken(HqlParser.OTHERS, 0); }
		public FrameExclusionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_frameExclusion; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFrameExclusion(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFrameExclusion(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFrameExclusion(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FrameExclusionContext frameExclusion() throws RecognitionException {
		FrameExclusionContext _localctx = new FrameExclusionContext(_ctx, getState());
		enterRule(_localctx, 328, RULE_frameExclusion);
		try {
			setState(1811);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,200,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1801);
				match(EXCLUDE);
				setState(1802);
				match(CURRENT);
				setState(1803);
				match(ROW);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1804);
				match(EXCLUDE);
				setState(1805);
				match(GROUP);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1806);
				match(EXCLUDE);
				setState(1807);
				match(TIES);
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(1808);
				match(EXCLUDE);
				setState(1809);
				match(NO);
				setState(1810);
				match(OTHERS);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class StandardFunctionContext extends ParserRuleContext {
		public CastFunctionContext castFunction() {
			return getRuleContext(CastFunctionContext.class,0);
		}
		public ExtractFunctionContext extractFunction() {
			return getRuleContext(ExtractFunctionContext.class,0);
		}
		public TruncFunctionContext truncFunction() {
			return getRuleContext(TruncFunctionContext.class,0);
		}
		public FormatFunctionContext formatFunction() {
			return getRuleContext(FormatFunctionContext.class,0);
		}
		public CollateFunctionContext collateFunction() {
			return getRuleContext(CollateFunctionContext.class,0);
		}
		public SubstringFunctionContext substringFunction() {
			return getRuleContext(SubstringFunctionContext.class,0);
		}
		public OverlayFunctionContext overlayFunction() {
			return getRuleContext(OverlayFunctionContext.class,0);
		}
		public TrimFunctionContext trimFunction() {
			return getRuleContext(TrimFunctionContext.class,0);
		}
		public PadFunctionContext padFunction() {
			return getRuleContext(PadFunctionContext.class,0);
		}
		public PositionFunctionContext positionFunction() {
			return getRuleContext(PositionFunctionContext.class,0);
		}
		public CurrentDateFunctionContext currentDateFunction() {
			return getRuleContext(CurrentDateFunctionContext.class,0);
		}
		public CurrentTimeFunctionContext currentTimeFunction() {
			return getRuleContext(CurrentTimeFunctionContext.class,0);
		}
		public CurrentTimestampFunctionContext currentTimestampFunction() {
			return getRuleContext(CurrentTimestampFunctionContext.class,0);
		}
		public InstantFunctionContext instantFunction() {
			return getRuleContext(InstantFunctionContext.class,0);
		}
		public LocalDateFunctionContext localDateFunction() {
			return getRuleContext(LocalDateFunctionContext.class,0);
		}
		public LocalTimeFunctionContext localTimeFunction() {
			return getRuleContext(LocalTimeFunctionContext.class,0);
		}
		public LocalDateTimeFunctionContext localDateTimeFunction() {
			return getRuleContext(LocalDateTimeFunctionContext.class,0);
		}
		public OffsetDateTimeFunctionContext offsetDateTimeFunction() {
			return getRuleContext(OffsetDateTimeFunctionContext.class,0);
		}
		public CubeContext cube() {
			return getRuleContext(CubeContext.class,0);
		}
		public RollupContext rollup() {
			return getRuleContext(RollupContext.class,0);
		}
		public StandardFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_standardFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterStandardFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitStandardFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitStandardFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final StandardFunctionContext standardFunction() throws RecognitionException {
		StandardFunctionContext _localctx = new StandardFunctionContext(_ctx, getState());
		enterRule(_localctx, 330, RULE_standardFunction);
		try {
			setState(1833);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,201,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1813);
				castFunction();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1814);
				extractFunction();
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(1815);
				truncFunction();
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(1816);
				formatFunction();
				}
				break;
			case 5:
				enterOuterAlt(_localctx, 5);
				{
				setState(1817);
				collateFunction();
				}
				break;
			case 6:
				enterOuterAlt(_localctx, 6);
				{
				setState(1818);
				substringFunction();
				}
				break;
			case 7:
				enterOuterAlt(_localctx, 7);
				{
				setState(1819);
				overlayFunction();
				}
				break;
			case 8:
				enterOuterAlt(_localctx, 8);
				{
				setState(1820);
				trimFunction();
				}
				break;
			case 9:
				enterOuterAlt(_localctx, 9);
				{
				setState(1821);
				padFunction();
				}
				break;
			case 10:
				enterOuterAlt(_localctx, 10);
				{
				setState(1822);
				positionFunction();
				}
				break;
			case 11:
				enterOuterAlt(_localctx, 11);
				{
				setState(1823);
				currentDateFunction();
				}
				break;
			case 12:
				enterOuterAlt(_localctx, 12);
				{
				setState(1824);
				currentTimeFunction();
				}
				break;
			case 13:
				enterOuterAlt(_localctx, 13);
				{
				setState(1825);
				currentTimestampFunction();
				}
				break;
			case 14:
				enterOuterAlt(_localctx, 14);
				{
				setState(1826);
				instantFunction();
				}
				break;
			case 15:
				enterOuterAlt(_localctx, 15);
				{
				setState(1827);
				localDateFunction();
				}
				break;
			case 16:
				enterOuterAlt(_localctx, 16);
				{
				setState(1828);
				localTimeFunction();
				}
				break;
			case 17:
				enterOuterAlt(_localctx, 17);
				{
				setState(1829);
				localDateTimeFunction();
				}
				break;
			case 18:
				enterOuterAlt(_localctx, 18);
				{
				setState(1830);
				offsetDateTimeFunction();
				}
				break;
			case 19:
				enterOuterAlt(_localctx, 19);
				{
				setState(1831);
				cube();
				}
				break;
			case 20:
				enterOuterAlt(_localctx, 20);
				{
				setState(1832);
				rollup();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class CastFunctionContext extends ParserRuleContext {
		public TerminalNode CAST() { return getToken(HqlParser.CAST, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode AS() { return getToken(HqlParser.AS, 0); }
		public CastTargetContext castTarget() {
			return getRuleContext(CastTargetContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public CastFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_castFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCastFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCastFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCastFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CastFunctionContext castFunction() throws RecognitionException {
		CastFunctionContext _localctx = new CastFunctionContext(_ctx, getState());
		enterRule(_localctx, 332, RULE_castFunction);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1835);
			match(CAST);
			setState(1836);
			match(LEFT_PAREN);
			setState(1837);
			expression(0);
			setState(1838);
			match(AS);
			setState(1839);
			castTarget();
			setState(1840);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class CastTargetContext extends ParserRuleContext {
		public CastTargetTypeContext castTargetType() {
			return getRuleContext(CastTargetTypeContext.class,0);
		}
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public List<TerminalNode> INTEGER_LITERAL() { return getTokens(HqlParser.INTEGER_LITERAL); }
		public TerminalNode INTEGER_LITERAL(int i) {
			return getToken(HqlParser.INTEGER_LITERAL, i);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode COMMA() { return getToken(HqlParser.COMMA, 0); }
		public CastTargetContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_castTarget; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCastTarget(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCastTarget(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCastTarget(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CastTargetContext castTarget() throws RecognitionException {
		CastTargetContext _localctx = new CastTargetContext(_ctx, getState());
		enterRule(_localctx, 334, RULE_castTarget);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1842);
			castTargetType();
			setState(1850);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==LEFT_PAREN) {
				{
				setState(1843);
				match(LEFT_PAREN);
				setState(1844);
				match(INTEGER_LITERAL);
				setState(1847);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==COMMA) {
					{
					setState(1845);
					match(COMMA);
					setState(1846);
					match(INTEGER_LITERAL);
					}
				}

				setState(1849);
				match(RIGHT_PAREN);
				}
			}

			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class CastTargetTypeContext extends ParserRuleContext {
		public String fullTargetName;
		public IdentifierContext i;
		public IdentifierContext c;
		public List<IdentifierContext> identifier() {
			return getRuleContexts(IdentifierContext.class);
		}
		public IdentifierContext identifier(int i) {
			return getRuleContext(IdentifierContext.class,i);
		}
		public List<TerminalNode> DOT() { return getTokens(HqlParser.DOT); }
		public TerminalNode DOT(int i) {
			return getToken(HqlParser.DOT, i);
		}
		public CastTargetTypeContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_castTargetType; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCastTargetType(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCastTargetType(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCastTargetType(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CastTargetTypeContext castTargetType() throws RecognitionException {
		CastTargetTypeContext _localctx = new CastTargetTypeContext(_ctx, getState());
		enterRule(_localctx, 336, RULE_castTargetType);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			{
			setState(1852);
			((CastTargetTypeContext)_localctx).i = identifier();
			 ((CastTargetTypeContext)_localctx).fullTargetName =  _localctx.i.getText(); 
			}
			setState(1861);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==DOT) {
				{
				{
				setState(1855);
				match(DOT);
				setState(1856);
				((CastTargetTypeContext)_localctx).c = identifier();
				 _localctx.fullTargetName += ("." + _localctx.c.getText() ); 
				}
				}
				setState(1863);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SubstringFunctionContext extends ParserRuleContext {
		public TerminalNode SUBSTRING() { return getToken(HqlParser.SUBSTRING, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public SubstringFunctionStartArgumentContext substringFunctionStartArgument() {
			return getRuleContext(SubstringFunctionStartArgumentContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public SubstringFunctionLengthArgumentContext substringFunctionLengthArgument() {
			return getRuleContext(SubstringFunctionLengthArgumentContext.class,0);
		}
		public TerminalNode FROM() { return getToken(HqlParser.FROM, 0); }
		public TerminalNode FOR() { return getToken(HqlParser.FOR, 0); }
		public SubstringFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_substringFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSubstringFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSubstringFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSubstringFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SubstringFunctionContext substringFunction() throws RecognitionException {
		SubstringFunctionContext _localctx = new SubstringFunctionContext(_ctx, getState());
		enterRule(_localctx, 338, RULE_substringFunction);
		int _la;
		try {
			setState(1886);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,207,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(1864);
				match(SUBSTRING);
				setState(1865);
				match(LEFT_PAREN);
				setState(1866);
				expression(0);
				setState(1867);
				match(COMMA);
				setState(1868);
				substringFunctionStartArgument();
				setState(1871);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==COMMA) {
					{
					setState(1869);
					match(COMMA);
					setState(1870);
					substringFunctionLengthArgument();
					}
				}

				setState(1873);
				match(RIGHT_PAREN);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(1875);
				match(SUBSTRING);
				setState(1876);
				match(LEFT_PAREN);
				setState(1877);
				expression(0);
				setState(1878);
				match(FROM);
				setState(1879);
				substringFunctionStartArgument();
				setState(1882);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==FOR) {
					{
					setState(1880);
					match(FOR);
					setState(1881);
					substringFunctionLengthArgument();
					}
				}

				setState(1884);
				match(RIGHT_PAREN);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SubstringFunctionStartArgumentContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public SubstringFunctionStartArgumentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_substringFunctionStartArgument; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSubstringFunctionStartArgument(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSubstringFunctionStartArgument(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSubstringFunctionStartArgument(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SubstringFunctionStartArgumentContext substringFunctionStartArgument() throws RecognitionException {
		SubstringFunctionStartArgumentContext _localctx = new SubstringFunctionStartArgumentContext(_ctx, getState());
		enterRule(_localctx, 340, RULE_substringFunctionStartArgument);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1888);
			expression(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class SubstringFunctionLengthArgumentContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public SubstringFunctionLengthArgumentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_substringFunctionLengthArgument; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterSubstringFunctionLengthArgument(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitSubstringFunctionLengthArgument(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitSubstringFunctionLengthArgument(this);
			else return visitor.visitChildren(this);
		}
	}

	public final SubstringFunctionLengthArgumentContext substringFunctionLengthArgument() throws RecognitionException {
		SubstringFunctionLengthArgumentContext _localctx = new SubstringFunctionLengthArgumentContext(_ctx, getState());
		enterRule(_localctx, 342, RULE_substringFunctionLengthArgument);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1890);
			expression(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class TrimFunctionContext extends ParserRuleContext {
		public TerminalNode TRIM() { return getToken(HqlParser.TRIM, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TrimSpecificationContext trimSpecification() {
			return getRuleContext(TrimSpecificationContext.class,0);
		}
		public TrimCharacterContext trimCharacter() {
			return getRuleContext(TrimCharacterContext.class,0);
		}
		public TerminalNode FROM() { return getToken(HqlParser.FROM, 0); }
		public TrimFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_trimFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTrimFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTrimFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTrimFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TrimFunctionContext trimFunction() throws RecognitionException {
		TrimFunctionContext _localctx = new TrimFunctionContext(_ctx, getState());
		enterRule(_localctx, 344, RULE_trimFunction);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1892);
			match(TRIM);
			setState(1893);
			match(LEFT_PAREN);
			setState(1895);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,208,_ctx) ) {
			case 1:
				{
				setState(1894);
				trimSpecification();
				}
				break;
			}
			setState(1898);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,209,_ctx) ) {
			case 1:
				{
				setState(1897);
				trimCharacter();
				}
				break;
			}
			setState(1901);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,210,_ctx) ) {
			case 1:
				{
				setState(1900);
				match(FROM);
				}
				break;
			}
			setState(1903);
			expression(0);
			setState(1904);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class TrimSpecificationContext extends ParserRuleContext {
		public TerminalNode LEADING() { return getToken(HqlParser.LEADING, 0); }
		public TerminalNode TRAILING() { return getToken(HqlParser.TRAILING, 0); }
		public TerminalNode BOTH() { return getToken(HqlParser.BOTH, 0); }
		public TrimSpecificationContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_trimSpecification; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTrimSpecification(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTrimSpecification(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTrimSpecification(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TrimSpecificationContext trimSpecification() throws RecognitionException {
		TrimSpecificationContext _localctx = new TrimSpecificationContext(_ctx, getState());
		enterRule(_localctx, 346, RULE_trimSpecification);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1906);
			_la = _input.LA(1);
			if ( !(_la==BOTH || _la==LEADING || _la==TRAILING) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class TrimCharacterContext extends ParserRuleContext {
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public ParameterContext parameter() {
			return getRuleContext(ParameterContext.class,0);
		}
		public TrimCharacterContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_trimCharacter; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTrimCharacter(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTrimCharacter(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTrimCharacter(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TrimCharacterContext trimCharacter() throws RecognitionException {
		TrimCharacterContext _localctx = new TrimCharacterContext(_ctx, getState());
		enterRule(_localctx, 348, RULE_trimCharacter);
		try {
			setState(1910);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case STRING_LITERAL:
				enterOuterAlt(_localctx, 1);
				{
				setState(1908);
				match(STRING_LITERAL);
				}
				break;
			case COLON:
			case QUESTION_MARK:
				enterOuterAlt(_localctx, 2);
				{
				setState(1909);
				parameter();
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class PadFunctionContext extends ParserRuleContext {
		public TerminalNode PAD() { return getToken(HqlParser.PAD, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode WITH() { return getToken(HqlParser.WITH, 0); }
		public PadLengthContext padLength() {
			return getRuleContext(PadLengthContext.class,0);
		}
		public PadSpecificationContext padSpecification() {
			return getRuleContext(PadSpecificationContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public PadCharacterContext padCharacter() {
			return getRuleContext(PadCharacterContext.class,0);
		}
		public PadFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_padFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPadFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPadFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPadFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PadFunctionContext padFunction() throws RecognitionException {
		PadFunctionContext _localctx = new PadFunctionContext(_ctx, getState());
		enterRule(_localctx, 350, RULE_padFunction);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1912);
			match(PAD);
			setState(1913);
			match(LEFT_PAREN);
			setState(1914);
			expression(0);
			setState(1915);
			match(WITH);
			setState(1916);
			padLength();
			setState(1917);
			padSpecification();
			setState(1919);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==STRING_LITERAL) {
				{
				setState(1918);
				padCharacter();
				}
			}

			setState(1921);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class PadSpecificationContext extends ParserRuleContext {
		public TerminalNode LEADING() { return getToken(HqlParser.LEADING, 0); }
		public TerminalNode TRAILING() { return getToken(HqlParser.TRAILING, 0); }
		public PadSpecificationContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_padSpecification; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPadSpecification(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPadSpecification(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPadSpecification(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PadSpecificationContext padSpecification() throws RecognitionException {
		PadSpecificationContext _localctx = new PadSpecificationContext(_ctx, getState());
		enterRule(_localctx, 352, RULE_padSpecification);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1923);
			_la = _input.LA(1);
			if ( !(_la==LEADING || _la==TRAILING) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class PadCharacterContext extends ParserRuleContext {
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public PadCharacterContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_padCharacter; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPadCharacter(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPadCharacter(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPadCharacter(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PadCharacterContext padCharacter() throws RecognitionException {
		PadCharacterContext _localctx = new PadCharacterContext(_ctx, getState());
		enterRule(_localctx, 354, RULE_padCharacter);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1925);
			match(STRING_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class PadLengthContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public PadLengthContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_padLength; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPadLength(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPadLength(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPadLength(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PadLengthContext padLength() throws RecognitionException {
		PadLengthContext _localctx = new PadLengthContext(_ctx, getState());
		enterRule(_localctx, 356, RULE_padLength);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1927);
			expression(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class OverlayFunctionContext extends ParserRuleContext {
		public TerminalNode OVERLAY() { return getToken(HqlParser.OVERLAY, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public OverlayFunctionStringArgumentContext overlayFunctionStringArgument() {
			return getRuleContext(OverlayFunctionStringArgumentContext.class,0);
		}
		public TerminalNode PLACING() { return getToken(HqlParser.PLACING, 0); }
		public OverlayFunctionReplacementArgumentContext overlayFunctionReplacementArgument() {
			return getRuleContext(OverlayFunctionReplacementArgumentContext.class,0);
		}
		public TerminalNode FROM() { return getToken(HqlParser.FROM, 0); }
		public OverlayFunctionStartArgumentContext overlayFunctionStartArgument() {
			return getRuleContext(OverlayFunctionStartArgumentContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode FOR() { return getToken(HqlParser.FOR, 0); }
		public OverlayFunctionLengthArgumentContext overlayFunctionLengthArgument() {
			return getRuleContext(OverlayFunctionLengthArgumentContext.class,0);
		}
		public OverlayFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_overlayFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOverlayFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOverlayFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOverlayFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OverlayFunctionContext overlayFunction() throws RecognitionException {
		OverlayFunctionContext _localctx = new OverlayFunctionContext(_ctx, getState());
		enterRule(_localctx, 358, RULE_overlayFunction);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1929);
			match(OVERLAY);
			setState(1930);
			match(LEFT_PAREN);
			setState(1931);
			overlayFunctionStringArgument();
			setState(1932);
			match(PLACING);
			setState(1933);
			overlayFunctionReplacementArgument();
			setState(1934);
			match(FROM);
			setState(1935);
			overlayFunctionStartArgument();
			setState(1938);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==FOR) {
				{
				setState(1936);
				match(FOR);
				setState(1937);
				overlayFunctionLengthArgument();
				}
			}

			setState(1940);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class OverlayFunctionStringArgumentContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public OverlayFunctionStringArgumentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_overlayFunctionStringArgument; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOverlayFunctionStringArgument(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOverlayFunctionStringArgument(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOverlayFunctionStringArgument(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OverlayFunctionStringArgumentContext overlayFunctionStringArgument() throws RecognitionException {
		OverlayFunctionStringArgumentContext _localctx = new OverlayFunctionStringArgumentContext(_ctx, getState());
		enterRule(_localctx, 360, RULE_overlayFunctionStringArgument);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1942);
			expression(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class OverlayFunctionReplacementArgumentContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public OverlayFunctionReplacementArgumentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_overlayFunctionReplacementArgument; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOverlayFunctionReplacementArgument(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOverlayFunctionReplacementArgument(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOverlayFunctionReplacementArgument(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OverlayFunctionReplacementArgumentContext overlayFunctionReplacementArgument() throws RecognitionException {
		OverlayFunctionReplacementArgumentContext _localctx = new OverlayFunctionReplacementArgumentContext(_ctx, getState());
		enterRule(_localctx, 362, RULE_overlayFunctionReplacementArgument);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1944);
			expression(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class OverlayFunctionStartArgumentContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public OverlayFunctionStartArgumentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_overlayFunctionStartArgument; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOverlayFunctionStartArgument(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOverlayFunctionStartArgument(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOverlayFunctionStartArgument(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OverlayFunctionStartArgumentContext overlayFunctionStartArgument() throws RecognitionException {
		OverlayFunctionStartArgumentContext _localctx = new OverlayFunctionStartArgumentContext(_ctx, getState());
		enterRule(_localctx, 364, RULE_overlayFunctionStartArgument);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1946);
			expression(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class OverlayFunctionLengthArgumentContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public OverlayFunctionLengthArgumentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_overlayFunctionLengthArgument; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOverlayFunctionLengthArgument(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOverlayFunctionLengthArgument(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOverlayFunctionLengthArgument(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OverlayFunctionLengthArgumentContext overlayFunctionLengthArgument() throws RecognitionException {
		OverlayFunctionLengthArgumentContext _localctx = new OverlayFunctionLengthArgumentContext(_ctx, getState());
		enterRule(_localctx, 366, RULE_overlayFunctionLengthArgument);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(1948);
			expression(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class CurrentDateFunctionContext extends ParserRuleContext {
		public TerminalNode CURRENT_DATE() { return getToken(HqlParser.CURRENT_DATE, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode CURRENT() { return getToken(HqlParser.CURRENT, 0); }
		public TerminalNode DATE() { return getToken(HqlParser.DATE, 0); }
		public CurrentDateFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_currentDateFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCurrentDateFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCurrentDateFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCurrentDateFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CurrentDateFunctionContext currentDateFunction() throws RecognitionException {
		CurrentDateFunctionContext _localctx = new CurrentDateFunctionContext(_ctx, getState());
		enterRule(_localctx, 368, RULE_currentDateFunction);
		try {
			setState(1957);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case CURRENT_DATE:
				enterOuterAlt(_localctx, 1);
				{
				setState(1950);
				match(CURRENT_DATE);
				setState(1953);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,214,_ctx) ) {
				case 1:
					{
					setState(1951);
					match(LEFT_PAREN);
					setState(1952);
					match(RIGHT_PAREN);
					}
					break;
				}
				}
				break;
			case CURRENT:
				enterOuterAlt(_localctx, 2);
				{
				setState(1955);
				match(CURRENT);
				setState(1956);
				match(DATE);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class CurrentTimeFunctionContext extends ParserRuleContext {
		public TerminalNode CURRENT_TIME() { return getToken(HqlParser.CURRENT_TIME, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode CURRENT() { return getToken(HqlParser.CURRENT, 0); }
		public TerminalNode TIME() { return getToken(HqlParser.TIME, 0); }
		public CurrentTimeFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_currentTimeFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCurrentTimeFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCurrentTimeFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCurrentTimeFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CurrentTimeFunctionContext currentTimeFunction() throws RecognitionException {
		CurrentTimeFunctionContext _localctx = new CurrentTimeFunctionContext(_ctx, getState());
		enterRule(_localctx, 370, RULE_currentTimeFunction);
		try {
			setState(1966);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case CURRENT_TIME:
				enterOuterAlt(_localctx, 1);
				{
				setState(1959);
				match(CURRENT_TIME);
				setState(1962);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,216,_ctx) ) {
				case 1:
					{
					setState(1960);
					match(LEFT_PAREN);
					setState(1961);
					match(RIGHT_PAREN);
					}
					break;
				}
				}
				break;
			case CURRENT:
				enterOuterAlt(_localctx, 2);
				{
				setState(1964);
				match(CURRENT);
				setState(1965);
				match(TIME);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class CurrentTimestampFunctionContext extends ParserRuleContext {
		public TerminalNode CURRENT_TIMESTAMP() { return getToken(HqlParser.CURRENT_TIMESTAMP, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode CURRENT() { return getToken(HqlParser.CURRENT, 0); }
		public TerminalNode TIMESTAMP() { return getToken(HqlParser.TIMESTAMP, 0); }
		public CurrentTimestampFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_currentTimestampFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCurrentTimestampFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCurrentTimestampFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCurrentTimestampFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CurrentTimestampFunctionContext currentTimestampFunction() throws RecognitionException {
		CurrentTimestampFunctionContext _localctx = new CurrentTimestampFunctionContext(_ctx, getState());
		enterRule(_localctx, 372, RULE_currentTimestampFunction);
		try {
			setState(1975);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case CURRENT_TIMESTAMP:
				enterOuterAlt(_localctx, 1);
				{
				setState(1968);
				match(CURRENT_TIMESTAMP);
				setState(1971);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,218,_ctx) ) {
				case 1:
					{
					setState(1969);
					match(LEFT_PAREN);
					setState(1970);
					match(RIGHT_PAREN);
					}
					break;
				}
				}
				break;
			case CURRENT:
				enterOuterAlt(_localctx, 2);
				{
				setState(1973);
				match(CURRENT);
				setState(1974);
				match(TIMESTAMP);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class InstantFunctionContext extends ParserRuleContext {
		public TerminalNode CURRENT_INSTANT() { return getToken(HqlParser.CURRENT_INSTANT, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode INSTANT() { return getToken(HqlParser.INSTANT, 0); }
		public InstantFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_instantFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterInstantFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitInstantFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitInstantFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final InstantFunctionContext instantFunction() throws RecognitionException {
		InstantFunctionContext _localctx = new InstantFunctionContext(_ctx, getState());
		enterRule(_localctx, 374, RULE_instantFunction);
		try {
			setState(1983);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case CURRENT_INSTANT:
				enterOuterAlt(_localctx, 1);
				{
				setState(1977);
				match(CURRENT_INSTANT);
				setState(1980);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,220,_ctx) ) {
				case 1:
					{
					setState(1978);
					match(LEFT_PAREN);
					setState(1979);
					match(RIGHT_PAREN);
					}
					break;
				}
				}
				break;
			case INSTANT:
				enterOuterAlt(_localctx, 2);
				{
				setState(1982);
				match(INSTANT);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class LocalDateTimeFunctionContext extends ParserRuleContext {
		public TerminalNode LOCAL_DATETIME() { return getToken(HqlParser.LOCAL_DATETIME, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode LOCAL() { return getToken(HqlParser.LOCAL, 0); }
		public TerminalNode DATETIME() { return getToken(HqlParser.DATETIME, 0); }
		public LocalDateTimeFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_localDateTimeFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterLocalDateTimeFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitLocalDateTimeFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitLocalDateTimeFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final LocalDateTimeFunctionContext localDateTimeFunction() throws RecognitionException {
		LocalDateTimeFunctionContext _localctx = new LocalDateTimeFunctionContext(_ctx, getState());
		enterRule(_localctx, 376, RULE_localDateTimeFunction);
		try {
			setState(1992);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case LOCAL_DATETIME:
				enterOuterAlt(_localctx, 1);
				{
				setState(1985);
				match(LOCAL_DATETIME);
				setState(1988);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,222,_ctx) ) {
				case 1:
					{
					setState(1986);
					match(LEFT_PAREN);
					setState(1987);
					match(RIGHT_PAREN);
					}
					break;
				}
				}
				break;
			case LOCAL:
				enterOuterAlt(_localctx, 2);
				{
				setState(1990);
				match(LOCAL);
				setState(1991);
				match(DATETIME);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class OffsetDateTimeFunctionContext extends ParserRuleContext {
		public TerminalNode OFFSET_DATETIME() { return getToken(HqlParser.OFFSET_DATETIME, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode OFFSET() { return getToken(HqlParser.OFFSET, 0); }
		public TerminalNode DATETIME() { return getToken(HqlParser.DATETIME, 0); }
		public OffsetDateTimeFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_offsetDateTimeFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterOffsetDateTimeFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitOffsetDateTimeFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitOffsetDateTimeFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final OffsetDateTimeFunctionContext offsetDateTimeFunction() throws RecognitionException {
		OffsetDateTimeFunctionContext _localctx = new OffsetDateTimeFunctionContext(_ctx, getState());
		enterRule(_localctx, 378, RULE_offsetDateTimeFunction);
		try {
			setState(2001);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case OFFSET_DATETIME:
				enterOuterAlt(_localctx, 1);
				{
				setState(1994);
				match(OFFSET_DATETIME);
				setState(1997);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,224,_ctx) ) {
				case 1:
					{
					setState(1995);
					match(LEFT_PAREN);
					setState(1996);
					match(RIGHT_PAREN);
					}
					break;
				}
				}
				break;
			case OFFSET:
				enterOuterAlt(_localctx, 2);
				{
				setState(1999);
				match(OFFSET);
				setState(2000);
				match(DATETIME);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class LocalDateFunctionContext extends ParserRuleContext {
		public TerminalNode LOCAL_DATE() { return getToken(HqlParser.LOCAL_DATE, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode LOCAL() { return getToken(HqlParser.LOCAL, 0); }
		public TerminalNode DATE() { return getToken(HqlParser.DATE, 0); }
		public LocalDateFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_localDateFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterLocalDateFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitLocalDateFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitLocalDateFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final LocalDateFunctionContext localDateFunction() throws RecognitionException {
		LocalDateFunctionContext _localctx = new LocalDateFunctionContext(_ctx, getState());
		enterRule(_localctx, 380, RULE_localDateFunction);
		try {
			setState(2010);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case LOCAL_DATE:
				enterOuterAlt(_localctx, 1);
				{
				setState(2003);
				match(LOCAL_DATE);
				setState(2006);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,226,_ctx) ) {
				case 1:
					{
					setState(2004);
					match(LEFT_PAREN);
					setState(2005);
					match(RIGHT_PAREN);
					}
					break;
				}
				}
				break;
			case LOCAL:
				enterOuterAlt(_localctx, 2);
				{
				setState(2008);
				match(LOCAL);
				setState(2009);
				match(DATE);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class LocalTimeFunctionContext extends ParserRuleContext {
		public TerminalNode LOCAL_TIME() { return getToken(HqlParser.LOCAL_TIME, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode LOCAL() { return getToken(HqlParser.LOCAL, 0); }
		public TerminalNode TIME() { return getToken(HqlParser.TIME, 0); }
		public LocalTimeFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_localTimeFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterLocalTimeFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitLocalTimeFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitLocalTimeFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final LocalTimeFunctionContext localTimeFunction() throws RecognitionException {
		LocalTimeFunctionContext _localctx = new LocalTimeFunctionContext(_ctx, getState());
		enterRule(_localctx, 382, RULE_localTimeFunction);
		try {
			setState(2019);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case LOCAL_TIME:
				enterOuterAlt(_localctx, 1);
				{
				setState(2012);
				match(LOCAL_TIME);
				setState(2015);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,228,_ctx) ) {
				case 1:
					{
					setState(2013);
					match(LEFT_PAREN);
					setState(2014);
					match(RIGHT_PAREN);
					}
					break;
				}
				}
				break;
			case LOCAL:
				enterOuterAlt(_localctx, 2);
				{
				setState(2017);
				match(LOCAL);
				setState(2018);
				match(TIME);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class FormatFunctionContext extends ParserRuleContext {
		public TerminalNode FORMAT() { return getToken(HqlParser.FORMAT, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode AS() { return getToken(HqlParser.AS, 0); }
		public FormatContext format() {
			return getRuleContext(FormatContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public FormatFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_formatFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFormatFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFormatFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFormatFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FormatFunctionContext formatFunction() throws RecognitionException {
		FormatFunctionContext _localctx = new FormatFunctionContext(_ctx, getState());
		enterRule(_localctx, 384, RULE_formatFunction);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(2021);
			match(FORMAT);
			setState(2022);
			match(LEFT_PAREN);
			setState(2023);
			expression(0);
			setState(2024);
			match(AS);
			setState(2025);
			format();
			setState(2026);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class FormatContext extends ParserRuleContext {
		public TerminalNode STRING_LITERAL() { return getToken(HqlParser.STRING_LITERAL, 0); }
		public FormatContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_format; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterFormat(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitFormat(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitFormat(this);
			else return visitor.visitChildren(this);
		}
	}

	public final FormatContext format() throws RecognitionException {
		FormatContext _localctx = new FormatContext(_ctx, getState());
		enterRule(_localctx, 386, RULE_format);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(2028);
			match(STRING_LITERAL);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class ExtractFunctionContext extends ParserRuleContext {
		public TerminalNode EXTRACT() { return getToken(HqlParser.EXTRACT, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public ExtractFieldContext extractField() {
			return getRuleContext(ExtractFieldContext.class,0);
		}
		public TerminalNode FROM() { return getToken(HqlParser.FROM, 0); }
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public DatetimeFieldContext datetimeField() {
			return getRuleContext(DatetimeFieldContext.class,0);
		}
		public ExtractFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_extractFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterExtractFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitExtractFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitExtractFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ExtractFunctionContext extractFunction() throws RecognitionException {
		ExtractFunctionContext _localctx = new ExtractFunctionContext(_ctx, getState());
		enterRule(_localctx, 388, RULE_extractFunction);
		try {
			setState(2042);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case EXTRACT:
				enterOuterAlt(_localctx, 1);
				{
				setState(2030);
				match(EXTRACT);
				setState(2031);
				match(LEFT_PAREN);
				setState(2032);
				extractField();
				setState(2033);
				match(FROM);
				setState(2034);
				expression(0);
				setState(2035);
				match(RIGHT_PAREN);
				}
				break;
			case DAY:
			case EPOCH:
			case HOUR:
			case MINUTE:
			case MONTH:
			case NANOSECOND:
			case QUARTER:
			case SECOND:
			case WEEK:
			case YEAR:
				enterOuterAlt(_localctx, 2);
				{
				setState(2037);
				datetimeField();
				setState(2038);
				match(LEFT_PAREN);
				setState(2039);
				expression(0);
				setState(2040);
				match(RIGHT_PAREN);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class TruncFunctionContext extends ParserRuleContext {
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public List<ExpressionContext> expression() {
			return getRuleContexts(ExpressionContext.class);
		}
		public ExpressionContext expression(int i) {
			return getRuleContext(ExpressionContext.class,i);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public TerminalNode TRUNC() { return getToken(HqlParser.TRUNC, 0); }
		public TerminalNode TRUNCATE() { return getToken(HqlParser.TRUNCATE, 0); }
		public TerminalNode COMMA() { return getToken(HqlParser.COMMA, 0); }
		public DatetimeFieldContext datetimeField() {
			return getRuleContext(DatetimeFieldContext.class,0);
		}
		public TruncFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_truncFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTruncFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTruncFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTruncFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TruncFunctionContext truncFunction() throws RecognitionException {
		TruncFunctionContext _localctx = new TruncFunctionContext(_ctx, getState());
		enterRule(_localctx, 390, RULE_truncFunction);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(2044);
			_la = _input.LA(1);
			if ( !(_la==TRUNC || _la==TRUNCATE) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			setState(2045);
			match(LEFT_PAREN);
			setState(2046);
			expression(0);
			setState(2052);
			_errHandler.sync(this);
			_la = _input.LA(1);
			if (_la==COMMA) {
				{
				setState(2047);
				match(COMMA);
				setState(2050);
				_errHandler.sync(this);
				switch ( getInterpreter().adaptivePredict(_input,231,_ctx) ) {
				case 1:
					{
					setState(2048);
					datetimeField();
					}
					break;
				case 2:
					{
					setState(2049);
					expression(0);
					}
					break;
				}
				}
			}

			setState(2054);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class ExtractFieldContext extends ParserRuleContext {
		public DatetimeFieldContext datetimeField() {
			return getRuleContext(DatetimeFieldContext.class,0);
		}
		public DayFieldContext dayField() {
			return getRuleContext(DayFieldContext.class,0);
		}
		public WeekFieldContext weekField() {
			return getRuleContext(WeekFieldContext.class,0);
		}
		public TimeZoneFieldContext timeZoneField() {
			return getRuleContext(TimeZoneFieldContext.class,0);
		}
		public DateOrTimeFieldContext dateOrTimeField() {
			return getRuleContext(DateOrTimeFieldContext.class,0);
		}
		public ExtractFieldContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_extractField; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterExtractField(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitExtractField(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitExtractField(this);
			else return visitor.visitChildren(this);
		}
	}

	public final ExtractFieldContext extractField() throws RecognitionException {
		ExtractFieldContext _localctx = new ExtractFieldContext(_ctx, getState());
		enterRule(_localctx, 392, RULE_extractField);
		try {
			setState(2061);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,233,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(2056);
				datetimeField();
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(2057);
				dayField();
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(2058);
				weekField();
				}
				break;
			case 4:
				enterOuterAlt(_localctx, 4);
				{
				setState(2059);
				timeZoneField();
				}
				break;
			case 5:
				enterOuterAlt(_localctx, 5);
				{
				setState(2060);
				dateOrTimeField();
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class DatetimeFieldContext extends ParserRuleContext {
		public TerminalNode YEAR() { return getToken(HqlParser.YEAR, 0); }
		public TerminalNode MONTH() { return getToken(HqlParser.MONTH, 0); }
		public TerminalNode DAY() { return getToken(HqlParser.DAY, 0); }
		public TerminalNode WEEK() { return getToken(HqlParser.WEEK, 0); }
		public TerminalNode QUARTER() { return getToken(HqlParser.QUARTER, 0); }
		public TerminalNode HOUR() { return getToken(HqlParser.HOUR, 0); }
		public TerminalNode MINUTE() { return getToken(HqlParser.MINUTE, 0); }
		public TerminalNode SECOND() { return getToken(HqlParser.SECOND, 0); }
		public TerminalNode NANOSECOND() { return getToken(HqlParser.NANOSECOND, 0); }
		public TerminalNode EPOCH() { return getToken(HqlParser.EPOCH, 0); }
		public DatetimeFieldContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_datetimeField; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterDatetimeField(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitDatetimeField(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitDatetimeField(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DatetimeFieldContext datetimeField() throws RecognitionException {
		DatetimeFieldContext _localctx = new DatetimeFieldContext(_ctx, getState());
		enterRule(_localctx, 394, RULE_datetimeField);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(2063);
			_la = _input.LA(1);
			if ( !(((((_la - 74)) & ~0x3f) == 0 && ((1L << (_la - 74)) & 8589942785L) != 0) || ((((_la - 145)) & ~0x3f) == 0 && ((1L << (_la - 145)) & 4611686087415300103L) != 0) || _la==YEAR) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class DayFieldContext extends ParserRuleContext {
		public TerminalNode DAY() { return getToken(HqlParser.DAY, 0); }
		public TerminalNode OF() { return getToken(HqlParser.OF, 0); }
		public TerminalNode MONTH() { return getToken(HqlParser.MONTH, 0); }
		public TerminalNode WEEK() { return getToken(HqlParser.WEEK, 0); }
		public TerminalNode YEAR() { return getToken(HqlParser.YEAR, 0); }
		public DayFieldContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_dayField; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterDayField(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitDayField(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitDayField(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DayFieldContext dayField() throws RecognitionException {
		DayFieldContext _localctx = new DayFieldContext(_ctx, getState());
		enterRule(_localctx, 396, RULE_dayField);
		try {
			setState(2074);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,234,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(2065);
				match(DAY);
				setState(2066);
				match(OF);
				setState(2067);
				match(MONTH);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(2068);
				match(DAY);
				setState(2069);
				match(OF);
				setState(2070);
				match(WEEK);
				}
				break;
			case 3:
				enterOuterAlt(_localctx, 3);
				{
				setState(2071);
				match(DAY);
				setState(2072);
				match(OF);
				setState(2073);
				match(YEAR);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class WeekFieldContext extends ParserRuleContext {
		public TerminalNode WEEK() { return getToken(HqlParser.WEEK, 0); }
		public TerminalNode OF() { return getToken(HqlParser.OF, 0); }
		public TerminalNode MONTH() { return getToken(HqlParser.MONTH, 0); }
		public TerminalNode YEAR() { return getToken(HqlParser.YEAR, 0); }
		public WeekFieldContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_weekField; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterWeekField(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitWeekField(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitWeekField(this);
			else return visitor.visitChildren(this);
		}
	}

	public final WeekFieldContext weekField() throws RecognitionException {
		WeekFieldContext _localctx = new WeekFieldContext(_ctx, getState());
		enterRule(_localctx, 398, RULE_weekField);
		try {
			setState(2082);
			_errHandler.sync(this);
			switch ( getInterpreter().adaptivePredict(_input,235,_ctx) ) {
			case 1:
				enterOuterAlt(_localctx, 1);
				{
				setState(2076);
				match(WEEK);
				setState(2077);
				match(OF);
				setState(2078);
				match(MONTH);
				}
				break;
			case 2:
				enterOuterAlt(_localctx, 2);
				{
				setState(2079);
				match(WEEK);
				setState(2080);
				match(OF);
				setState(2081);
				match(YEAR);
				}
				break;
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class TimeZoneFieldContext extends ParserRuleContext {
		public TerminalNode OFFSET() { return getToken(HqlParser.OFFSET, 0); }
		public TerminalNode HOUR() { return getToken(HqlParser.HOUR, 0); }
		public TerminalNode MINUTE() { return getToken(HqlParser.MINUTE, 0); }
		public TerminalNode TIMEZONE_HOUR() { return getToken(HqlParser.TIMEZONE_HOUR, 0); }
		public TerminalNode TIMEZONE_MINUTE() { return getToken(HqlParser.TIMEZONE_MINUTE, 0); }
		public TimeZoneFieldContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_timeZoneField; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterTimeZoneField(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitTimeZoneField(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitTimeZoneField(this);
			else return visitor.visitChildren(this);
		}
	}

	public final TimeZoneFieldContext timeZoneField() throws RecognitionException {
		TimeZoneFieldContext _localctx = new TimeZoneFieldContext(_ctx, getState());
		enterRule(_localctx, 400, RULE_timeZoneField);
		int _la;
		try {
			setState(2090);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case OFFSET:
				enterOuterAlt(_localctx, 1);
				{
				setState(2084);
				match(OFFSET);
				setState(2086);
				_errHandler.sync(this);
				_la = _input.LA(1);
				if (_la==HOUR || _la==MINUTE) {
					{
					setState(2085);
					_la = _input.LA(1);
					if ( !(_la==HOUR || _la==MINUTE) ) {
					_errHandler.recoverInline(this);
					}
					else {
						if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
						_errHandler.reportMatch(this);
						consume();
					}
					}
				}

				}
				break;
			case TIMEZONE_HOUR:
				enterOuterAlt(_localctx, 2);
				{
				setState(2088);
				match(TIMEZONE_HOUR);
				}
				break;
			case TIMEZONE_MINUTE:
				enterOuterAlt(_localctx, 3);
				{
				setState(2089);
				match(TIMEZONE_MINUTE);
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class DateOrTimeFieldContext extends ParserRuleContext {
		public TerminalNode DATE() { return getToken(HqlParser.DATE, 0); }
		public TerminalNode TIME() { return getToken(HqlParser.TIME, 0); }
		public DateOrTimeFieldContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_dateOrTimeField; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterDateOrTimeField(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitDateOrTimeField(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitDateOrTimeField(this);
			else return visitor.visitChildren(this);
		}
	}

	public final DateOrTimeFieldContext dateOrTimeField() throws RecognitionException {
		DateOrTimeFieldContext _localctx = new DateOrTimeFieldContext(_ctx, getState());
		enterRule(_localctx, 402, RULE_dateOrTimeField);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(2092);
			_la = _input.LA(1);
			if ( !(_la==DATE || _la==TIME) ) {
			_errHandler.recoverInline(this);
			}
			else {
				if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
				_errHandler.reportMatch(this);
				consume();
			}
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class PositionFunctionContext extends ParserRuleContext {
		public TerminalNode POSITION() { return getToken(HqlParser.POSITION, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public PositionFunctionPatternArgumentContext positionFunctionPatternArgument() {
			return getRuleContext(PositionFunctionPatternArgumentContext.class,0);
		}
		public TerminalNode IN() { return getToken(HqlParser.IN, 0); }
		public PositionFunctionStringArgumentContext positionFunctionStringArgument() {
			return getRuleContext(PositionFunctionStringArgumentContext.class,0);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public PositionFunctionContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_positionFunction; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPositionFunction(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPositionFunction(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPositionFunction(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PositionFunctionContext positionFunction() throws RecognitionException {
		PositionFunctionContext _localctx = new PositionFunctionContext(_ctx, getState());
		enterRule(_localctx, 404, RULE_positionFunction);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(2094);
			match(POSITION);
			setState(2095);
			match(LEFT_PAREN);
			setState(2096);
			positionFunctionPatternArgument();
			setState(2097);
			match(IN);
			setState(2098);
			positionFunctionStringArgument();
			setState(2099);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class PositionFunctionPatternArgumentContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public PositionFunctionPatternArgumentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_positionFunctionPatternArgument; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPositionFunctionPatternArgument(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPositionFunctionPatternArgument(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPositionFunctionPatternArgument(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PositionFunctionPatternArgumentContext positionFunctionPatternArgument() throws RecognitionException {
		PositionFunctionPatternArgumentContext _localctx = new PositionFunctionPatternArgumentContext(_ctx, getState());
		enterRule(_localctx, 406, RULE_positionFunctionPatternArgument);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(2101);
			expression(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class PositionFunctionStringArgumentContext extends ParserRuleContext {
		public ExpressionContext expression() {
			return getRuleContext(ExpressionContext.class,0);
		}
		public PositionFunctionStringArgumentContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_positionFunctionStringArgument; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterPositionFunctionStringArgument(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitPositionFunctionStringArgument(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitPositionFunctionStringArgument(this);
			else return visitor.visitChildren(this);
		}
	}

	public final PositionFunctionStringArgumentContext positionFunctionStringArgument() throws RecognitionException {
		PositionFunctionStringArgumentContext _localctx = new PositionFunctionStringArgumentContext(_ctx, getState());
		enterRule(_localctx, 408, RULE_positionFunctionStringArgument);
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(2103);
			expression(0);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class CubeContext extends ParserRuleContext {
		public TerminalNode CUBE() { return getToken(HqlParser.CUBE, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public List<ExpressionOrPredicateContext> expressionOrPredicate() {
			return getRuleContexts(ExpressionOrPredicateContext.class);
		}
		public ExpressionOrPredicateContext expressionOrPredicate(int i) {
			return getRuleContext(ExpressionOrPredicateContext.class,i);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public CubeContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_cube; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterCube(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitCube(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitCube(this);
			else return visitor.visitChildren(this);
		}
	}

	public final CubeContext cube() throws RecognitionException {
		CubeContext _localctx = new CubeContext(_ctx, getState());
		enterRule(_localctx, 410, RULE_cube);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(2105);
			match(CUBE);
			setState(2106);
			match(LEFT_PAREN);
			setState(2107);
			expressionOrPredicate();
			setState(2112);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(2108);
				match(COMMA);
				setState(2109);
				expressionOrPredicate();
				}
				}
				setState(2114);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			setState(2115);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class RollupContext extends ParserRuleContext {
		public TerminalNode ROLLUP() { return getToken(HqlParser.ROLLUP, 0); }
		public TerminalNode LEFT_PAREN() { return getToken(HqlParser.LEFT_PAREN, 0); }
		public List<ExpressionOrPredicateContext> expressionOrPredicate() {
			return getRuleContexts(ExpressionOrPredicateContext.class);
		}
		public ExpressionOrPredicateContext expressionOrPredicate(int i) {
			return getRuleContext(ExpressionOrPredicateContext.class,i);
		}
		public TerminalNode RIGHT_PAREN() { return getToken(HqlParser.RIGHT_PAREN, 0); }
		public List<TerminalNode> COMMA() { return getTokens(HqlParser.COMMA); }
		public TerminalNode COMMA(int i) {
			return getToken(HqlParser.COMMA, i);
		}
		public RollupContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_rollup; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterRollup(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitRollup(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitRollup(this);
			else return visitor.visitChildren(this);
		}
	}

	public final RollupContext rollup() throws RecognitionException {
		RollupContext _localctx = new RollupContext(_ctx, getState());
		enterRule(_localctx, 412, RULE_rollup);
		int _la;
		try {
			enterOuterAlt(_localctx, 1);
			{
			setState(2117);
			match(ROLLUP);
			setState(2118);
			match(LEFT_PAREN);
			setState(2119);
			expressionOrPredicate();
			setState(2124);
			_errHandler.sync(this);
			_la = _input.LA(1);
			while (_la==COMMA) {
				{
				{
				setState(2120);
				match(COMMA);
				setState(2121);
				expressionOrPredicate();
				}
				}
				setState(2126);
				_errHandler.sync(this);
				_la = _input.LA(1);
			}
			setState(2127);
			match(RIGHT_PAREN);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class NakedIdentifierContext extends ParserRuleContext {
		public TerminalNode IDENTIFIER() { return getToken(HqlParser.IDENTIFIER, 0); }
		public TerminalNode QUOTED_IDENTIFIER() { return getToken(HqlParser.QUOTED_IDENTIFIER, 0); }
		public TerminalNode ALL() { return getToken(HqlParser.ALL, 0); }
		public TerminalNode AND() { return getToken(HqlParser.AND, 0); }
		public TerminalNode ANY() { return getToken(HqlParser.ANY, 0); }
		public TerminalNode AS() { return getToken(HqlParser.AS, 0); }
		public TerminalNode ASC() { return getToken(HqlParser.ASC, 0); }
		public TerminalNode AVG() { return getToken(HqlParser.AVG, 0); }
		public TerminalNode BETWEEN() { return getToken(HqlParser.BETWEEN, 0); }
		public TerminalNode BOTH() { return getToken(HqlParser.BOTH, 0); }
		public TerminalNode BREADTH() { return getToken(HqlParser.BREADTH, 0); }
		public TerminalNode BY() { return getToken(HqlParser.BY, 0); }
		public TerminalNode CASE() { return getToken(HqlParser.CASE, 0); }
		public TerminalNode CAST() { return getToken(HqlParser.CAST, 0); }
		public TerminalNode COLLATE() { return getToken(HqlParser.COLLATE, 0); }
		public TerminalNode COLUMN() { return getToken(HqlParser.COLUMN, 0); }
		public TerminalNode CONFLICT() { return getToken(HqlParser.CONFLICT, 0); }
		public TerminalNode CONSTRAINT() { return getToken(HqlParser.CONSTRAINT, 0); }
		public TerminalNode COUNT() { return getToken(HqlParser.COUNT, 0); }
		public TerminalNode CROSS() { return getToken(HqlParser.CROSS, 0); }
		public TerminalNode CUBE() { return getToken(HqlParser.CUBE, 0); }
		public TerminalNode CURRENT() { return getToken(HqlParser.CURRENT, 0); }
		public TerminalNode CURRENT_DATE() { return getToken(HqlParser.CURRENT_DATE, 0); }
		public TerminalNode CURRENT_INSTANT() { return getToken(HqlParser.CURRENT_INSTANT, 0); }
		public TerminalNode CURRENT_TIME() { return getToken(HqlParser.CURRENT_TIME, 0); }
		public TerminalNode CURRENT_TIMESTAMP() { return getToken(HqlParser.CURRENT_TIMESTAMP, 0); }
		public TerminalNode CYCLE() { return getToken(HqlParser.CYCLE, 0); }
		public TerminalNode DATE() { return getToken(HqlParser.DATE, 0); }
		public TerminalNode DATETIME() { return getToken(HqlParser.DATETIME, 0); }
		public TerminalNode DAY() { return getToken(HqlParser.DAY, 0); }
		public TerminalNode DEFAULT() { return getToken(HqlParser.DEFAULT, 0); }
		public TerminalNode DELETE() { return getToken(HqlParser.DELETE, 0); }
		public TerminalNode DEPTH() { return getToken(HqlParser.DEPTH, 0); }
		public TerminalNode DESC() { return getToken(HqlParser.DESC, 0); }
		public TerminalNode DISTINCT() { return getToken(HqlParser.DISTINCT, 0); }
		public TerminalNode DO() { return getToken(HqlParser.DO, 0); }
		public TerminalNode ELEMENT() { return getToken(HqlParser.ELEMENT, 0); }
		public TerminalNode ELEMENTS() { return getToken(HqlParser.ELEMENTS, 0); }
		public TerminalNode ELSE() { return getToken(HqlParser.ELSE, 0); }
		public TerminalNode EMPTY() { return getToken(HqlParser.EMPTY, 0); }
		public TerminalNode END() { return getToken(HqlParser.END, 0); }
		public TerminalNode ENTRY() { return getToken(HqlParser.ENTRY, 0); }
		public TerminalNode EPOCH() { return getToken(HqlParser.EPOCH, 0); }
		public TerminalNode ERROR() { return getToken(HqlParser.ERROR, 0); }
		public TerminalNode ESCAPE() { return getToken(HqlParser.ESCAPE, 0); }
		public TerminalNode EVERY() { return getToken(HqlParser.EVERY, 0); }
		public TerminalNode EXCEPT() { return getToken(HqlParser.EXCEPT, 0); }
		public TerminalNode EXCLUDE() { return getToken(HqlParser.EXCLUDE, 0); }
		public TerminalNode EXISTS() { return getToken(HqlParser.EXISTS, 0); }
		public TerminalNode EXTRACT() { return getToken(HqlParser.EXTRACT, 0); }
		public TerminalNode FETCH() { return getToken(HqlParser.FETCH, 0); }
		public TerminalNode FILTER() { return getToken(HqlParser.FILTER, 0); }
		public TerminalNode FIRST() { return getToken(HqlParser.FIRST, 0); }
		public TerminalNode FK() { return getToken(HqlParser.FK, 0); }
		public TerminalNode FOLLOWING() { return getToken(HqlParser.FOLLOWING, 0); }
		public TerminalNode FOR() { return getToken(HqlParser.FOR, 0); }
		public TerminalNode FORMAT() { return getToken(HqlParser.FORMAT, 0); }
		public TerminalNode FROM() { return getToken(HqlParser.FROM, 0); }
		public TerminalNode FUNCTION() { return getToken(HqlParser.FUNCTION, 0); }
		public TerminalNode GROUP() { return getToken(HqlParser.GROUP, 0); }
		public TerminalNode GROUPS() { return getToken(HqlParser.GROUPS, 0); }
		public TerminalNode HAVING() { return getToken(HqlParser.HAVING, 0); }
		public TerminalNode HOUR() { return getToken(HqlParser.HOUR, 0); }
		public TerminalNode ID() { return getToken(HqlParser.ID, 0); }
		public TerminalNode IGNORE() { return getToken(HqlParser.IGNORE, 0); }
		public TerminalNode ILIKE() { return getToken(HqlParser.ILIKE, 0); }
		public TerminalNode IN() { return getToken(HqlParser.IN, 0); }
		public TerminalNode INDEX() { return getToken(HqlParser.INDEX, 0); }
		public TerminalNode INDICES() { return getToken(HqlParser.INDICES, 0); }
		public TerminalNode INSERT() { return getToken(HqlParser.INSERT, 0); }
		public TerminalNode INSTANT() { return getToken(HqlParser.INSTANT, 0); }
		public TerminalNode INTERSECT() { return getToken(HqlParser.INTERSECT, 0); }
		public TerminalNode INTO() { return getToken(HqlParser.INTO, 0); }
		public TerminalNode IS() { return getToken(HqlParser.IS, 0); }
		public TerminalNode JOIN() { return getToken(HqlParser.JOIN, 0); }
		public TerminalNode KEY() { return getToken(HqlParser.KEY, 0); }
		public TerminalNode KEYS() { return getToken(HqlParser.KEYS, 0); }
		public TerminalNode LAST() { return getToken(HqlParser.LAST, 0); }
		public TerminalNode LATERAL() { return getToken(HqlParser.LATERAL, 0); }
		public TerminalNode LEADING() { return getToken(HqlParser.LEADING, 0); }
		public TerminalNode LIKE() { return getToken(HqlParser.LIKE, 0); }
		public TerminalNode LIMIT() { return getToken(HqlParser.LIMIT, 0); }
		public TerminalNode LIST() { return getToken(HqlParser.LIST, 0); }
		public TerminalNode LISTAGG() { return getToken(HqlParser.LISTAGG, 0); }
		public TerminalNode LOCAL() { return getToken(HqlParser.LOCAL, 0); }
		public TerminalNode LOCAL_DATE() { return getToken(HqlParser.LOCAL_DATE, 0); }
		public TerminalNode LOCAL_DATETIME() { return getToken(HqlParser.LOCAL_DATETIME, 0); }
		public TerminalNode LOCAL_TIME() { return getToken(HqlParser.LOCAL_TIME, 0); }
		public TerminalNode MAP() { return getToken(HqlParser.MAP, 0); }
		public TerminalNode MATERIALIZED() { return getToken(HqlParser.MATERIALIZED, 0); }
		public TerminalNode MAX() { return getToken(HqlParser.MAX, 0); }
		public TerminalNode MAXELEMENT() { return getToken(HqlParser.MAXELEMENT, 0); }
		public TerminalNode MAXINDEX() { return getToken(HqlParser.MAXINDEX, 0); }
		public TerminalNode MEMBER() { return getToken(HqlParser.MEMBER, 0); }
		public TerminalNode MICROSECOND() { return getToken(HqlParser.MICROSECOND, 0); }
		public TerminalNode MILLISECOND() { return getToken(HqlParser.MILLISECOND, 0); }
		public TerminalNode MIN() { return getToken(HqlParser.MIN, 0); }
		public TerminalNode MINELEMENT() { return getToken(HqlParser.MINELEMENT, 0); }
		public TerminalNode MININDEX() { return getToken(HqlParser.MININDEX, 0); }
		public TerminalNode MINUTE() { return getToken(HqlParser.MINUTE, 0); }
		public TerminalNode MONTH() { return getToken(HqlParser.MONTH, 0); }
		public TerminalNode NANOSECOND() { return getToken(HqlParser.NANOSECOND, 0); }
		public TerminalNode NATURALID() { return getToken(HqlParser.NATURALID, 0); }
		public TerminalNode NEW() { return getToken(HqlParser.NEW, 0); }
		public TerminalNode NEXT() { return getToken(HqlParser.NEXT, 0); }
		public TerminalNode NO() { return getToken(HqlParser.NO, 0); }
		public TerminalNode NOT() { return getToken(HqlParser.NOT, 0); }
		public TerminalNode NOTHING() { return getToken(HqlParser.NOTHING, 0); }
		public TerminalNode NULLS() { return getToken(HqlParser.NULLS, 0); }
		public TerminalNode OBJECT() { return getToken(HqlParser.OBJECT, 0); }
		public TerminalNode OF() { return getToken(HqlParser.OF, 0); }
		public TerminalNode OFFSET() { return getToken(HqlParser.OFFSET, 0); }
		public TerminalNode OFFSET_DATETIME() { return getToken(HqlParser.OFFSET_DATETIME, 0); }
		public TerminalNode ON() { return getToken(HqlParser.ON, 0); }
		public TerminalNode ONLY() { return getToken(HqlParser.ONLY, 0); }
		public TerminalNode OR() { return getToken(HqlParser.OR, 0); }
		public TerminalNode ORDER() { return getToken(HqlParser.ORDER, 0); }
		public TerminalNode OTHERS() { return getToken(HqlParser.OTHERS, 0); }
		public TerminalNode OVER() { return getToken(HqlParser.OVER, 0); }
		public TerminalNode OVERFLOW() { return getToken(HqlParser.OVERFLOW, 0); }
		public TerminalNode OVERLAY() { return getToken(HqlParser.OVERLAY, 0); }
		public TerminalNode PAD() { return getToken(HqlParser.PAD, 0); }
		public TerminalNode PARTITION() { return getToken(HqlParser.PARTITION, 0); }
		public TerminalNode PERCENT() { return getToken(HqlParser.PERCENT, 0); }
		public TerminalNode PLACING() { return getToken(HqlParser.PLACING, 0); }
		public TerminalNode POSITION() { return getToken(HqlParser.POSITION, 0); }
		public TerminalNode PRECEDING() { return getToken(HqlParser.PRECEDING, 0); }
		public TerminalNode QUARTER() { return getToken(HqlParser.QUARTER, 0); }
		public TerminalNode RANGE() { return getToken(HqlParser.RANGE, 0); }
		public TerminalNode RESPECT() { return getToken(HqlParser.RESPECT, 0); }
		public TerminalNode ROLLUP() { return getToken(HqlParser.ROLLUP, 0); }
		public TerminalNode ROW() { return getToken(HqlParser.ROW, 0); }
		public TerminalNode ROWS() { return getToken(HqlParser.ROWS, 0); }
		public TerminalNode SEARCH() { return getToken(HqlParser.SEARCH, 0); }
		public TerminalNode SECOND() { return getToken(HqlParser.SECOND, 0); }
		public TerminalNode SELECT() { return getToken(HqlParser.SELECT, 0); }
		public TerminalNode SET() { return getToken(HqlParser.SET, 0); }
		public TerminalNode SIZE() { return getToken(HqlParser.SIZE, 0); }
		public TerminalNode SOME() { return getToken(HqlParser.SOME, 0); }
		public TerminalNode SUBSTRING() { return getToken(HqlParser.SUBSTRING, 0); }
		public TerminalNode SUM() { return getToken(HqlParser.SUM, 0); }
		public TerminalNode THEN() { return getToken(HqlParser.THEN, 0); }
		public TerminalNode TIES() { return getToken(HqlParser.TIES, 0); }
		public TerminalNode TIME() { return getToken(HqlParser.TIME, 0); }
		public TerminalNode TIMESTAMP() { return getToken(HqlParser.TIMESTAMP, 0); }
		public TerminalNode TIMEZONE_HOUR() { return getToken(HqlParser.TIMEZONE_HOUR, 0); }
		public TerminalNode TIMEZONE_MINUTE() { return getToken(HqlParser.TIMEZONE_MINUTE, 0); }
		public TerminalNode TO() { return getToken(HqlParser.TO, 0); }
		public TerminalNode TRAILING() { return getToken(HqlParser.TRAILING, 0); }
		public TerminalNode TREAT() { return getToken(HqlParser.TREAT, 0); }
		public TerminalNode TRIM() { return getToken(HqlParser.TRIM, 0); }
		public TerminalNode TRUNC() { return getToken(HqlParser.TRUNC, 0); }
		public TerminalNode TRUNCATE() { return getToken(HqlParser.TRUNCATE, 0); }
		public TerminalNode TYPE() { return getToken(HqlParser.TYPE, 0); }
		public TerminalNode UNBOUNDED() { return getToken(HqlParser.UNBOUNDED, 0); }
		public TerminalNode UNION() { return getToken(HqlParser.UNION, 0); }
		public TerminalNode UPDATE() { return getToken(HqlParser.UPDATE, 0); }
		public TerminalNode USING() { return getToken(HqlParser.USING, 0); }
		public TerminalNode VALUE() { return getToken(HqlParser.VALUE, 0); }
		public TerminalNode VALUES() { return getToken(HqlParser.VALUES, 0); }
		public TerminalNode VERSION() { return getToken(HqlParser.VERSION, 0); }
		public TerminalNode VERSIONED() { return getToken(HqlParser.VERSIONED, 0); }
		public TerminalNode WEEK() { return getToken(HqlParser.WEEK, 0); }
		public TerminalNode WHEN() { return getToken(HqlParser.WHEN, 0); }
		public TerminalNode WHERE() { return getToken(HqlParser.WHERE, 0); }
		public TerminalNode WITH() { return getToken(HqlParser.WITH, 0); }
		public TerminalNode WITHIN() { return getToken(HqlParser.WITHIN, 0); }
		public TerminalNode WITHOUT() { return getToken(HqlParser.WITHOUT, 0); }
		public TerminalNode YEAR() { return getToken(HqlParser.YEAR, 0); }
		public TerminalNode ZONED() { return getToken(HqlParser.ZONED, 0); }
		public NakedIdentifierContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_nakedIdentifier; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterNakedIdentifier(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitNakedIdentifier(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitNakedIdentifier(this);
			else return visitor.visitChildren(this);
		}
	}

	public final NakedIdentifierContext nakedIdentifier() throws RecognitionException {
		NakedIdentifierContext _localctx = new NakedIdentifierContext(_ctx, getState());
		enterRule(_localctx, 414, RULE_nakedIdentifier);
		int _la;
		try {
			setState(2133);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case IDENTIFIER:
				enterOuterAlt(_localctx, 1);
				{
				setState(2129);
				match(IDENTIFIER);
				}
				break;
			case QUOTED_IDENTIFIER:
				enterOuterAlt(_localctx, 2);
				{
				setState(2130);
				match(QUOTED_IDENTIFIER);
				}
				break;
			case ID:
			case VERSION:
			case VERSIONED:
			case NATURALID:
			case FK:
			case ALL:
			case AND:
			case ANY:
			case AS:
			case ASC:
			case AVG:
			case BETWEEN:
			case BOTH:
			case BREADTH:
			case BY:
			case CASE:
			case CAST:
			case COLLATE:
			case COLUMN:
			case CONFLICT:
			case CONSTRAINT:
			case COUNT:
			case CROSS:
			case CUBE:
			case CURRENT:
			case CURRENT_DATE:
			case CURRENT_INSTANT:
			case CURRENT_TIME:
			case CURRENT_TIMESTAMP:
			case CYCLE:
			case DATE:
			case DATETIME:
			case DAY:
			case DEFAULT:
			case DELETE:
			case DEPTH:
			case DESC:
			case DISTINCT:
			case DO:
			case ELEMENT:
			case ELEMENTS:
			case ELSE:
			case EMPTY:
			case END:
			case ENTRY:
			case EPOCH:
			case ERROR:
			case ESCAPE:
			case EVERY:
			case EXCEPT:
			case EXCLUDE:
			case EXISTS:
			case EXTRACT:
			case FETCH:
			case FILTER:
			case FIRST:
			case FOLLOWING:
			case FOR:
			case FORMAT:
			case FROM:
			case FUNCTION:
			case GROUP:
			case GROUPS:
			case HAVING:
			case HOUR:
			case IGNORE:
			case ILIKE:
			case IN:
			case INDEX:
			case INDICES:
			case INSERT:
			case INSTANT:
			case INTERSECT:
			case INTO:
			case IS:
			case JOIN:
			case KEY:
			case KEYS:
			case LAST:
			case LATERAL:
			case LEADING:
			case LIKE:
			case LIMIT:
			case LIST:
			case LISTAGG:
			case LOCAL:
			case LOCAL_DATE:
			case LOCAL_DATETIME:
			case LOCAL_TIME:
			case MAP:
			case MATERIALIZED:
			case MAX:
			case MAXELEMENT:
			case MAXINDEX:
			case MEMBER:
			case MICROSECOND:
			case MILLISECOND:
			case MIN:
			case MINELEMENT:
			case MININDEX:
			case MINUTE:
			case MONTH:
			case NANOSECOND:
			case NEW:
			case NEXT:
			case NO:
			case NOT:
			case NOTHING:
			case NULLS:
			case OBJECT:
			case OF:
			case OFFSET:
			case OFFSET_DATETIME:
			case ON:
			case ONLY:
			case OR:
			case ORDER:
			case OTHERS:
			case OVER:
			case OVERFLOW:
			case OVERLAY:
			case PAD:
			case PARTITION:
			case PERCENT:
			case PLACING:
			case POSITION:
			case PRECEDING:
			case QUARTER:
			case RANGE:
			case RESPECT:
			case ROLLUP:
			case ROW:
			case ROWS:
			case SEARCH:
			case SECOND:
			case SELECT:
			case SET:
			case SIZE:
			case SOME:
			case SUBSTRING:
			case SUM:
			case THEN:
			case TIES:
			case TIME:
			case TIMESTAMP:
			case TIMEZONE_HOUR:
			case TIMEZONE_MINUTE:
			case TO:
			case TRAILING:
			case TREAT:
			case TRIM:
			case TRUNC:
			case TRUNCATE:
			case TYPE:
			case UNBOUNDED:
			case UNION:
			case UPDATE:
			case USING:
			case VALUE:
			case VALUES:
			case WEEK:
			case WHEN:
			case WHERE:
			case WITH:
			case WITHIN:
			case WITHOUT:
			case YEAR:
			case ZONED:
				enterOuterAlt(_localctx, 3);
				{
				setState(2131);
				_la = _input.LA(1);
				if ( !(((((_la - 42)) & ~0x3f) == 0 && ((1L << (_la - 42)) & -1152921504606846977L) != 0) || ((((_la - 106)) & ~0x3f) == 0 && ((1L << (_la - 106)) & -144115188076380289L) != 0) || ((((_la - 170)) & ~0x3f) == 0 && ((1L << (_la - 170)) & 35184372088767L) != 0)) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}

						logUseOfReservedWordAsIdentifier( getCurrentToken() );
					
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	@SuppressWarnings("CheckReturnValue")
	public static class IdentifierContext extends ParserRuleContext {
		public NakedIdentifierContext nakedIdentifier() {
			return getRuleContext(NakedIdentifierContext.class,0);
		}
		public TerminalNode FULL() { return getToken(HqlParser.FULL, 0); }
		public TerminalNode INNER() { return getToken(HqlParser.INNER, 0); }
		public TerminalNode LEFT() { return getToken(HqlParser.LEFT, 0); }
		public TerminalNode OUTER() { return getToken(HqlParser.OUTER, 0); }
		public TerminalNode RIGHT() { return getToken(HqlParser.RIGHT, 0); }
		public IdentifierContext(ParserRuleContext parent, int invokingState) {
			super(parent, invokingState);
		}
		@Override public int getRuleIndex() { return RULE_identifier; }
		@Override
		public void enterRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).enterIdentifier(this);
		}
		@Override
		public void exitRule(ParseTreeListener listener) {
			if ( listener instanceof HqlParserListener ) ((HqlParserListener)listener).exitIdentifier(this);
		}
		@Override
		public <T> T accept(ParseTreeVisitor<? extends T> visitor) {
			if ( visitor instanceof HqlParserVisitor ) return ((HqlParserVisitor<? extends T>)visitor).visitIdentifier(this);
			else return visitor.visitChildren(this);
		}
	}

	public final IdentifierContext identifier() throws RecognitionException {
		IdentifierContext _localctx = new IdentifierContext(_ctx, getState());
		enterRule(_localctx, 416, RULE_identifier);
		int _la;
		try {
			setState(2138);
			_errHandler.sync(this);
			switch (_input.LA(1)) {
			case ID:
			case VERSION:
			case VERSIONED:
			case NATURALID:
			case FK:
			case ALL:
			case AND:
			case ANY:
			case AS:
			case ASC:
			case AVG:
			case BETWEEN:
			case BOTH:
			case BREADTH:
			case BY:
			case CASE:
			case CAST:
			case COLLATE:
			case COLUMN:
			case CONFLICT:
			case CONSTRAINT:
			case COUNT:
			case CROSS:
			case CUBE:
			case CURRENT:
			case CURRENT_DATE:
			case CURRENT_INSTANT:
			case CURRENT_TIME:
			case CURRENT_TIMESTAMP:
			case CYCLE:
			case DATE:
			case DATETIME:
			case DAY:
			case DEFAULT:
			case DELETE:
			case DEPTH:
			case DESC:
			case DISTINCT:
			case DO:
			case ELEMENT:
			case ELEMENTS:
			case ELSE:
			case EMPTY:
			case END:
			case ENTRY:
			case EPOCH:
			case ERROR:
			case ESCAPE:
			case EVERY:
			case EXCEPT:
			case EXCLUDE:
			case EXISTS:
			case EXTRACT:
			case FETCH:
			case FILTER:
			case FIRST:
			case FOLLOWING:
			case FOR:
			case FORMAT:
			case FROM:
			case FUNCTION:
			case GROUP:
			case GROUPS:
			case HAVING:
			case HOUR:
			case IGNORE:
			case ILIKE:
			case IN:
			case INDEX:
			case INDICES:
			case INSERT:
			case INSTANT:
			case INTERSECT:
			case INTO:
			case IS:
			case JOIN:
			case KEY:
			case KEYS:
			case LAST:
			case LATERAL:
			case LEADING:
			case LIKE:
			case LIMIT:
			case LIST:
			case LISTAGG:
			case LOCAL:
			case LOCAL_DATE:
			case LOCAL_DATETIME:
			case LOCAL_TIME:
			case MAP:
			case MATERIALIZED:
			case MAX:
			case MAXELEMENT:
			case MAXINDEX:
			case MEMBER:
			case MICROSECOND:
			case MILLISECOND:
			case MIN:
			case MINELEMENT:
			case MININDEX:
			case MINUTE:
			case MONTH:
			case NANOSECOND:
			case NEW:
			case NEXT:
			case NO:
			case NOT:
			case NOTHING:
			case NULLS:
			case OBJECT:
			case OF:
			case OFFSET:
			case OFFSET_DATETIME:
			case ON:
			case ONLY:
			case OR:
			case ORDER:
			case OTHERS:
			case OVER:
			case OVERFLOW:
			case OVERLAY:
			case PAD:
			case PARTITION:
			case PERCENT:
			case PLACING:
			case POSITION:
			case PRECEDING:
			case QUARTER:
			case RANGE:
			case RESPECT:
			case ROLLUP:
			case ROW:
			case ROWS:
			case SEARCH:
			case SECOND:
			case SELECT:
			case SET:
			case SIZE:
			case SOME:
			case SUBSTRING:
			case SUM:
			case THEN:
			case TIES:
			case TIME:
			case TIMESTAMP:
			case TIMEZONE_HOUR:
			case TIMEZONE_MINUTE:
			case TO:
			case TRAILING:
			case TREAT:
			case TRIM:
			case TRUNC:
			case TRUNCATE:
			case TYPE:
			case UNBOUNDED:
			case UNION:
			case UPDATE:
			case USING:
			case VALUE:
			case VALUES:
			case WEEK:
			case WHEN:
			case WHERE:
			case WITH:
			case WITHIN:
			case WITHOUT:
			case YEAR:
			case ZONED:
			case IDENTIFIER:
			case QUOTED_IDENTIFIER:
				enterOuterAlt(_localctx, 1);
				{
				setState(2135);
				nakedIdentifier();
				}
				break;
			case FULL:
			case INNER:
			case LEFT:
			case OUTER:
			case RIGHT:
				enterOuterAlt(_localctx, 2);
				{
				setState(2136);
				_la = _input.LA(1);
				if ( !(((((_la - 102)) & ~0x3f) == 0 && ((1L << (_la - 102)) & 2305843009222084609L) != 0) || _la==RIGHT) ) {
				_errHandler.recoverInline(this);
				}
				else {
					if ( _input.LA(1)==Token.EOF ) matchedEOF = true;
					_errHandler.reportMatch(this);
					consume();
				}

						logUseOfReservedWordAsIdentifier( getCurrentToken() );
					
				}
				break;
			default:
				throw new NoViableAltException(this);
			}
		}
		catch (RecognitionException re) {
			_localctx.exception = re;
			_errHandler.reportError(this, re);
			_errHandler.recover(this, re);
		}
		finally {
			exitRule();
		}
		return _localctx;
	}

	public boolean sempred(RuleContext _localctx, int ruleIndex, int predIndex) {
		switch (ruleIndex) {
		case 77:
			return predicate_sempred((PredicateContext)_localctx, predIndex);
		case 81:
			return expression_sempred((ExpressionContext)_localctx, predIndex);
		}
		return true;
	}
	private boolean predicate_sempred(PredicateContext _localctx, int predIndex) {
		switch (predIndex) {
		case 0:
			return precpred(_ctx, 3);
		case 1:
			return precpred(_ctx, 2);
		}
		return true;
	}
	private boolean expression_sempred(ExpressionContext _localctx, int predIndex) {
		switch (predIndex) {
		case 2:
			return precpred(_ctx, 3);
		case 3:
			return precpred(_ctx, 2);
		case 4:
			return precpred(_ctx, 1);
		case 5:
			return precpred(_ctx, 5);
		case 6:
			return precpred(_ctx, 4);
		}
		return true;
	}

	public static final String _serializedATN =
		"\u0004\u0001\u00db\u085d\u0002\u0000\u0007\u0000\u0002\u0001\u0007\u0001"+
		"\u0002\u0002\u0007\u0002\u0002\u0003\u0007\u0003\u0002\u0004\u0007\u0004"+
		"\u0002\u0005\u0007\u0005\u0002\u0006\u0007\u0006\u0002\u0007\u0007\u0007"+
		"\u0002\b\u0007\b\u0002\t\u0007\t\u0002\n\u0007\n\u0002\u000b\u0007\u000b"+
		"\u0002\f\u0007\f\u0002\r\u0007\r\u0002\u000e\u0007\u000e\u0002\u000f\u0007"+
		"\u000f\u0002\u0010\u0007\u0010\u0002\u0011\u0007\u0011\u0002\u0012\u0007"+
		"\u0012\u0002\u0013\u0007\u0013\u0002\u0014\u0007\u0014\u0002\u0015\u0007"+
		"\u0015\u0002\u0016\u0007\u0016\u0002\u0017\u0007\u0017\u0002\u0018\u0007"+
		"\u0018\u0002\u0019\u0007\u0019\u0002\u001a\u0007\u001a\u0002\u001b\u0007"+
		"\u001b\u0002\u001c\u0007\u001c\u0002\u001d\u0007\u001d\u0002\u001e\u0007"+
		"\u001e\u0002\u001f\u0007\u001f\u0002 \u0007 \u0002!\u0007!\u0002\"\u0007"+
		"\"\u0002#\u0007#\u0002$\u0007$\u0002%\u0007%\u0002&\u0007&\u0002\'\u0007"+
		"\'\u0002(\u0007(\u0002)\u0007)\u0002*\u0007*\u0002+\u0007+\u0002,\u0007"+
		",\u0002-\u0007-\u0002.\u0007.\u0002/\u0007/\u00020\u00070\u00021\u0007"+
		"1\u00022\u00072\u00023\u00073\u00024\u00074\u00025\u00075\u00026\u0007"+
		"6\u00027\u00077\u00028\u00078\u00029\u00079\u0002:\u0007:\u0002;\u0007"+
		";\u0002<\u0007<\u0002=\u0007=\u0002>\u0007>\u0002?\u0007?\u0002@\u0007"+
		"@\u0002A\u0007A\u0002B\u0007B\u0002C\u0007C\u0002D\u0007D\u0002E\u0007"+
		"E\u0002F\u0007F\u0002G\u0007G\u0002H\u0007H\u0002I\u0007I\u0002J\u0007"+
		"J\u0002K\u0007K\u0002L\u0007L\u0002M\u0007M\u0002N\u0007N\u0002O\u0007"+
		"O\u0002P\u0007P\u0002Q\u0007Q\u0002R\u0007R\u0002S\u0007S\u0002T\u0007"+
		"T\u0002U\u0007U\u0002V\u0007V\u0002W\u0007W\u0002X\u0007X\u0002Y\u0007"+
		"Y\u0002Z\u0007Z\u0002[\u0007[\u0002\\\u0007\\\u0002]\u0007]\u0002^\u0007"+
		"^\u0002_\u0007_\u0002`\u0007`\u0002a\u0007a\u0002b\u0007b\u0002c\u0007"+
		"c\u0002d\u0007d\u0002e\u0007e\u0002f\u0007f\u0002g\u0007g\u0002h\u0007"+
		"h\u0002i\u0007i\u0002j\u0007j\u0002k\u0007k\u0002l\u0007l\u0002m\u0007"+
		"m\u0002n\u0007n\u0002o\u0007o\u0002p\u0007p\u0002q\u0007q\u0002r\u0007"+
		"r\u0002s\u0007s\u0002t\u0007t\u0002u\u0007u\u0002v\u0007v\u0002w\u0007"+
		"w\u0002x\u0007x\u0002y\u0007y\u0002z\u0007z\u0002{\u0007{\u0002|\u0007"+
		"|\u0002}\u0007}\u0002~\u0007~\u0002\u007f\u0007\u007f\u0002\u0080\u0007"+
		"\u0080\u0002\u0081\u0007\u0081\u0002\u0082\u0007\u0082\u0002\u0083\u0007"+
		"\u0083\u0002\u0084\u0007\u0084\u0002\u0085\u0007\u0085\u0002\u0086\u0007"+
		"\u0086\u0002\u0087\u0007\u0087\u0002\u0088\u0007\u0088\u0002\u0089\u0007"+
		"\u0089\u0002\u008a\u0007\u008a\u0002\u008b\u0007\u008b\u0002\u008c\u0007"+
		"\u008c\u0002\u008d\u0007\u008d\u0002\u008e\u0007\u008e\u0002\u008f\u0007"+
		"\u008f\u0002\u0090\u0007\u0090\u0002\u0091\u0007\u0091\u0002\u0092\u0007"+
		"\u0092\u0002\u0093\u0007\u0093\u0002\u0094\u0007\u0094\u0002\u0095\u0007"+
		"\u0095\u0002\u0096\u0007\u0096\u0002\u0097\u0007\u0097\u0002\u0098\u0007"+
		"\u0098\u0002\u0099\u0007\u0099\u0002\u009a\u0007\u009a\u0002\u009b\u0007"+
		"\u009b\u0002\u009c\u0007\u009c\u0002\u009d\u0007\u009d\u0002\u009e\u0007"+
		"\u009e\u0002\u009f\u0007\u009f\u0002\u00a0\u0007\u00a0\u0002\u00a1\u0007"+
		"\u00a1\u0002\u00a2\u0007\u00a2\u0002\u00a3\u0007\u00a3\u0002\u00a4\u0007"+
		"\u00a4\u0002\u00a5\u0007\u00a5\u0002\u00a6\u0007\u00a6\u0002\u00a7\u0007"+
		"\u00a7\u0002\u00a8\u0007\u00a8\u0002\u00a9\u0007\u00a9\u0002\u00aa\u0007"+
		"\u00aa\u0002\u00ab\u0007\u00ab\u0002\u00ac\u0007\u00ac\u0002\u00ad\u0007"+
		"\u00ad\u0002\u00ae\u0007\u00ae\u0002\u00af\u0007\u00af\u0002\u00b0\u0007"+
		"\u00b0\u0002\u00b1\u0007\u00b1\u0002\u00b2\u0007\u00b2\u0002\u00b3\u0007"+
		"\u00b3\u0002\u00b4\u0007\u00b4\u0002\u00b5\u0007\u00b5\u0002\u00b6\u0007"+
		"\u00b6\u0002\u00b7\u0007\u00b7\u0002\u00b8\u0007\u00b8\u0002\u00b9\u0007"+
		"\u00b9\u0002\u00ba\u0007\u00ba\u0002\u00bb\u0007\u00bb\u0002\u00bc\u0007"+
		"\u00bc\u0002\u00bd\u0007\u00bd\u0002\u00be\u0007\u00be\u0002\u00bf\u0007"+
		"\u00bf\u0002\u00c0\u0007\u00c0\u0002\u00c1\u0007\u00c1\u0002\u00c2\u0007"+
		"\u00c2\u0002\u00c3\u0007\u00c3\u0002\u00c4\u0007\u00c4\u0002\u00c5\u0007"+
		"\u00c5\u0002\u00c6\u0007\u00c6\u0002\u00c7\u0007\u00c7\u0002\u00c8\u0007"+
		"\u00c8\u0002\u00c9\u0007\u00c9\u0002\u00ca\u0007\u00ca\u0002\u00cb\u0007"+
		"\u00cb\u0002\u00cc\u0007\u00cc\u0002\u00cd\u0007\u00cd\u0002\u00ce\u0007"+
		"\u00ce\u0002\u00cf\u0007\u00cf\u0002\u00d0\u0007\u00d0\u0001\u0000\u0001"+
		"\u0000\u0001\u0000\u0001\u0000\u0003\u0000\u01a7\b\u0000\u0001\u0000\u0001"+
		"\u0000\u0001\u0001\u0001\u0001\u0001\u0002\u0001\u0002\u0001\u0003\u0001"+
		"\u0003\u0003\u0003\u01b1\b\u0003\u0001\u0004\u0001\u0004\u0003\u0004\u01b5"+
		"\b\u0004\u0001\u0004\u0001\u0004\u0003\u0004\u01b9\b\u0004\u0001\u0005"+
		"\u0001\u0005\u0003\u0005\u01bd\b\u0005\u0001\u0005\u0001\u0005\u0001\u0005"+
		"\u0003\u0005\u01c2\b\u0005\u0001\u0006\u0001\u0006\u0001\u0006\u0001\u0006"+
		"\u0005\u0006\u01c8\b\u0006\n\u0006\f\u0006\u01cb\t\u0006\u0001\u0007\u0001"+
		"\u0007\u0001\u0007\u0001\u0007\u0001\b\u0001\b\u0003\b\u01d3\b\b\u0001"+
		"\b\u0001\b\u0001\b\u0001\b\u0003\b\u01d9\b\b\u0001\b\u0003\b\u01dc\b\b"+
		"\u0001\t\u0001\t\u0001\t\u0001\t\u0005\t\u01e2\b\t\n\t\f\t\u01e5\t\t\u0001"+
		"\t\u0001\t\u0001\n\u0001\n\u0001\n\u0001\n\u0005\n\u01ed\b\n\n\n\f\n\u01f0"+
		"\t\n\u0001\u000b\u0001\u000b\u0001\u000b\u0001\u000b\u0005\u000b\u01f6"+
		"\b\u000b\n\u000b\f\u000b\u01f9\t\u000b\u0001\u000b\u0001\u000b\u0001\f"+
		"\u0001\f\u0001\f\u0003\f\u0200\b\f\u0001\f\u0001\f\u0001\f\u0001\r\u0001"+
		"\r\u0001\r\u0001\r\u0001\r\u0001\r\u0001\r\u0005\r\u020c\b\r\n\r\f\r\u020f"+
		"\t\r\u0001\r\u0001\r\u0003\r\u0213\b\r\u0001\u000e\u0001\u000e\u0001\u000e"+
		"\u0001\u000e\u0003\u000e\u0219\b\u000e\u0003\u000e\u021b\b\u000e\u0001"+
		"\u000f\u0001\u000f\u0001\u000f\u0001\u000f\u0005\u000f\u0221\b\u000f\n"+
		"\u000f\f\u000f\u0224\t\u000f\u0001\u0010\u0001\u0010\u0001\u0010\u0003"+
		"\u0010\u0229\b\u0010\u0001\u0010\u0003\u0010\u022c\b\u0010\u0001\u0010"+
		"\u0001\u0010\u0001\u0010\u0001\u0010\u0003\u0010\u0232\b\u0010\u0001\u0010"+
		"\u0003\u0010\u0235\b\u0010\u0001\u0011\u0001\u0011\u0001\u0011\u0005\u0011"+
		"\u023a\b\u0011\n\u0011\f\u0011\u023d\t\u0011\u0001\u0012\u0001\u0012\u0001"+
		"\u0012\u0001\u0012\u0001\u0012\u0001\u0012\u0001\u0012\u0001\u0012\u0001"+
		"\u0013\u0001\u0013\u0001\u0013\u0005\u0013\u024a\b\u0013\n\u0013\f\u0013"+
		"\u024d\t\u0013\u0001\u0014\u0001\u0014\u0003\u0014\u0251\b\u0014\u0001"+
		"\u0014\u0003\u0014\u0254\b\u0014\u0001\u0015\u0001\u0015\u0001\u0015\u0001"+
		"\u0015\u0001\u0015\u0001\u0015\u0001\u0015\u0001\u0015\u0001\u0015\u0003"+
		"\u0015\u025f\b\u0015\u0001\u0015\u0001\u0015\u0003\u0015\u0263\b\u0015"+
		"\u0001\u0016\u0003\u0016\u0266\b\u0016\u0001\u0016\u0001\u0016\u0003\u0016"+
		"\u026a\b\u0016\u0001\u0016\u0001\u0016\u0001\u0016\u0001\u0016\u0004\u0016"+
		"\u0270\b\u0016\u000b\u0016\f\u0016\u0271\u0003\u0016\u0274\b\u0016\u0001"+
		"\u0017\u0001\u0017\u0003\u0017\u0278\b\u0017\u0001\u0017\u0001\u0017\u0001"+
		"\u0017\u0001\u0017\u0003\u0017\u027e\b\u0017\u0001\u0017\u0003\u0017\u0281"+
		"\b\u0017\u0001\u0018\u0001\u0018\u0003\u0018\u0285\b\u0018\u0001\u0018"+
		"\u0001\u0018\u0003\u0018\u0289\b\u0018\u0001\u0018\u0001\u0018\u0003\u0018"+
		"\u028d\b\u0018\u0003\u0018\u028f\b\u0018\u0001\u0019\u0001\u0019\u0003"+
		"\u0019\u0293\b\u0019\u0001\u0019\u0003\u0019\u0296\b\u0019\u0001\u0019"+
		"\u0003\u0019\u0299\b\u0019\u0001\u001a\u0001\u001a\u0003\u001a\u029d\b"+
		"\u001a\u0001\u001a\u0003\u001a\u02a0\b\u001a\u0001\u001a\u0001\u001a\u0003"+
		"\u001a\u02a4\b\u001a\u0003\u001a\u02a6\b\u001a\u0001\u001a\u0001\u001a"+
		"\u0003\u001a\u02aa\b\u001a\u0001\u001a\u0001\u001a\u0003\u001a\u02ae\b"+
		"\u001a\u0003\u001a\u02b0\b\u001a\u0001\u001a\u0003\u001a\u02b3\b\u001a"+
		"\u0001\u001a\u0003\u001a\u02b6\b\u001a\u0001\u001b\u0001\u001b\u0001\u001b"+
		"\u0001\u001b\u0005\u001b\u02bc\b\u001b\n\u001b\f\u001b\u02bf\t\u001b\u0001"+
		"\u001c\u0001\u001c\u0001\u001c\u0001\u001c\u0005\u001c\u02c5\b\u001c\n"+
		"\u001c\f\u001c\u02c8\t\u001c\u0001\u001d\u0001\u001d\u0003\u001d\u02cc"+
		"\b\u001d\u0001\u001d\u0001\u001d\u0001\u001d\u0001\u001d\u0003\u001d\u02d2"+
		"\b\u001d\u0003\u001d\u02d4\b\u001d\u0001\u001e\u0001\u001e\u0001\u001e"+
		"\u0005\u001e\u02d9\b\u001e\n\u001e\f\u001e\u02dc\t\u001e\u0001\u001f\u0001"+
		"\u001f\u0001\u001f\u0003\u001f\u02e1\b\u001f\u0001 \u0001 \u0001 \u0001"+
		" \u0003 \u02e7\b \u0001!\u0001!\u0001!\u0001!\u0001!\u0001!\u0003!\u02ef"+
		"\b!\u0001\"\u0001\"\u0001\"\u0003\"\u02f4\b\"\u0001\"\u0001\"\u0003\""+
		"\u02f8\b\"\u0001#\u0003#\u02fb\b#\u0001#\u0003#\u02fe\b#\u0001#\u0003"+
		"#\u0301\b#\u0003#\u0303\b#\u0001$\u0001$\u0003$\u0307\b$\u0001$\u0003"+
		"$\u030a\b$\u0001$\u0001$\u0001$\u0001$\u0003$\u0310\b$\u0003$\u0312\b"+
		"$\u0001%\u0001%\u0001%\u0001&\u0001&\u0003&\u0319\b&\u0001&\u0001&\u0001"+
		"\'\u0001\'\u0001\'\u0005\'\u0320\b\'\n\'\f\'\u0323\t\'\u0001(\u0001(\u0003"+
		"(\u0327\b(\u0001)\u0001)\u0001)\u0001)\u0003)\u032d\b)\u0001*\u0001*\u0001"+
		"*\u0001*\u0001*\u0001+\u0001+\u0001+\u0001+\u0001+\u0001+\u0001,\u0001"+
		",\u0001,\u0003,\u033d\b,\u0001-\u0001-\u0001-\u0005-\u0342\b-\n-\f-\u0345"+
		"\t-\u0001.\u0001.\u0003.\u0349\b.\u0001/\u0001/\u0003/\u034d\b/\u0001"+
		"0\u00010\u00010\u00010\u00010\u00011\u00011\u00051\u0356\b1\n1\f1\u0359"+
		"\t1\u00012\u00012\u00012\u00013\u00013\u00033\u0360\b3\u00013\u00033\u0363"+
		"\b3\u00014\u00014\u00014\u00015\u00015\u00015\u00015\u00015\u00015\u0003"+
		"5\u036e\b5\u00016\u00016\u00036\u0372\b6\u00017\u00017\u00017\u00017\u0001"+
		"7\u00037\u0379\b7\u00018\u00018\u00018\u00018\u00018\u00018\u00018\u0003"+
		"8\u0382\b8\u00019\u00019\u00019\u00019\u00019\u00039\u0389\b9\u0001:\u0001"+
		":\u0001:\u0001:\u0001:\u0003:\u0390\b:\u0001;\u0001;\u0001;\u0001;\u0001"+
		";\u0005;\u0397\b;\n;\f;\u039a\t;\u0001<\u0001<\u0001<\u0003<\u039f\b<"+
		"\u0001=\u0001=\u0001=\u0001>\u0001>\u0001>\u0001>\u0001>\u0005>\u03a9"+
		"\b>\n>\f>\u03ac\t>\u0001?\u0001?\u0001?\u0005?\u03b1\b?\n?\f?\u03b4\t"+
		"?\u0001@\u0001@\u0003@\u03b8\b@\u0001@\u0003@\u03bb\b@\u0001A\u0001A\u0001"+
		"A\u0001B\u0001B\u0001B\u0003B\u03c3\bB\u0001C\u0001C\u0001D\u0001D\u0001"+
		"D\u0001D\u0001D\u0001D\u0001D\u0001E\u0001E\u0001F\u0001F\u0001F\u0001"+
		"G\u0001G\u0001G\u0003G\u03d6\bG\u0001H\u0001H\u0001H\u0001H\u0001H\u0001"+
		"H\u0001H\u0003H\u03df\bH\u0001I\u0001I\u0001I\u0001I\u0003I\u03e5\bI\u0001"+
		"J\u0001J\u0003J\u03e9\bJ\u0001K\u0001K\u0001K\u0001K\u0001K\u0003K\u03f0"+
		"\bK\u0001L\u0001L\u0001L\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001"+
		"M\u0001M\u0003M\u03fd\bM\u0001M\u0001M\u0001M\u0001M\u0001M\u0003M\u0404"+
		"\bM\u0001M\u0001M\u0001M\u0001M\u0001M\u0003M\u040b\bM\u0001M\u0001M\u0001"+
		"M\u0001M\u0001M\u0003M\u0412\bM\u0001M\u0001M\u0001M\u0001M\u0001M\u0003"+
		"M\u0419\bM\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0003M\u0421\bM\u0001"+
		"M\u0001M\u0003M\u0425\bM\u0001M\u0001M\u0001M\u0001M\u0003M\u042b\bM\u0001"+
		"M\u0001M\u0001M\u0001M\u0001M\u0003M\u0432\bM\u0001M\u0001M\u0001M\u0001"+
		"M\u0001M\u0001M\u0001M\u0003M\u043b\bM\u0001M\u0001M\u0001M\u0003M\u0440"+
		"\bM\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001M\u0001"+
		"M\u0001M\u0001M\u0001M\u0001M\u0001M\u0003M\u0451\bM\u0001M\u0001M\u0001"+
		"M\u0001M\u0001M\u0001M\u0005M\u0459\bM\nM\fM\u045c\tM\u0001N\u0001N\u0001"+
		"O\u0001O\u0001O\u0001O\u0001O\u0001O\u0001O\u0001O\u0001O\u0005O\u0469"+
		"\bO\nO\fO\u046c\tO\u0003O\u046e\bO\u0001O\u0001O\u0001O\u0001O\u0001O"+
		"\u0001O\u0003O\u0476\bO\u0001P\u0001P\u0001P\u0001P\u0003P\u047c\bP\u0001"+
		"Q\u0001Q\u0001Q\u0001Q\u0001Q\u0001Q\u0001Q\u0001Q\u0001Q\u0004Q\u0487"+
		"\bQ\u000bQ\fQ\u0488\u0001Q\u0001Q\u0001Q\u0001Q\u0001Q\u0001Q\u0001Q\u0001"+
		"Q\u0001Q\u0001Q\u0001Q\u0001Q\u0001Q\u0003Q\u0498\bQ\u0001Q\u0001Q\u0001"+
		"Q\u0001Q\u0001Q\u0001Q\u0001Q\u0001Q\u0001Q\u0001Q\u0001Q\u0001Q\u0001"+
		"Q\u0001Q\u0001Q\u0001Q\u0005Q\u04aa\bQ\nQ\fQ\u04ad\tQ\u0001R\u0001R\u0001"+
		"R\u0001R\u0001R\u0001R\u0001R\u0001R\u0001R\u0001R\u0003R\u04b9\bR\u0001"+
		"R\u0001R\u0003R\u04bd\bR\u0001S\u0001S\u0003S\u04c1\bS\u0001T\u0001T\u0003"+
		"T\u04c5\bT\u0001U\u0001U\u0001V\u0001V\u0001W\u0001W\u0001X\u0001X\u0001"+
		"Y\u0001Y\u0001Z\u0001Z\u0001[\u0001[\u0001\\\u0001\\\u0001\\\u0001\\\u0003"+
		"\\\u04d9\b\\\u0001\\\u0001\\\u0001]\u0001]\u0001]\u0001]\u0001]\u0003"+
		"]\u04e2\b]\u0001^\u0001^\u0001^\u0001^\u0001^\u0001_\u0001_\u0001_\u0001"+
		"_\u0001_\u0003_\u04ee\b_\u0001`\u0001`\u0001`\u0001`\u0001`\u0001a\u0001"+
		"a\u0003a\u04f7\ba\u0001b\u0001b\u0001b\u0004b\u04fc\bb\u000bb\fb\u04fd"+
		"\u0001b\u0003b\u0501\bb\u0001b\u0001b\u0001c\u0001c\u0001c\u0001c\u0001"+
		"c\u0001d\u0001d\u0001d\u0001e\u0001e\u0004e\u050f\be\u000be\fe\u0510\u0001"+
		"e\u0003e\u0514\be\u0001e\u0001e\u0001f\u0001f\u0001f\u0001f\u0001f\u0001"+
		"g\u0001g\u0001g\u0001g\u0001g\u0001g\u0001g\u0001g\u0003g\u0525\bg\u0001"+
		"h\u0001h\u0001i\u0001i\u0001j\u0001j\u0001j\u0001j\u0001j\u0005j\u0530"+
		"\bj\nj\fj\u0533\tj\u0001j\u0003j\u0536\bj\u0001k\u0001k\u0001k\u0001k"+
		"\u0001k\u0001k\u0003k\u053e\bk\u0001l\u0001l\u0001l\u0003l\u0543\bl\u0001"+
		"m\u0001m\u0001m\u0001m\u0001m\u0003m\u054a\bm\u0001m\u0001m\u0003m\u054e"+
		"\bm\u0001n\u0001n\u0001n\u0001n\u0001n\u0003n\u0555\bn\u0001n\u0001n\u0003"+
		"n\u0559\bn\u0001o\u0001o\u0001o\u0001o\u0001o\u0003o\u0560\bo\u0001o\u0001"+
		"o\u0003o\u0564\bo\u0001p\u0001p\u0001p\u0001p\u0001p\u0003p\u056b\bp\u0001"+
		"p\u0001p\u0003p\u056f\bp\u0001q\u0001q\u0001q\u0001q\u0001q\u0003q\u0576"+
		"\bq\u0001q\u0001q\u0003q\u057a\bq\u0001r\u0001r\u0001r\u0003r\u057f\b"+
		"r\u0001s\u0001s\u0001s\u0001t\u0001t\u0001t\u0001t\u0001u\u0001u\u0001"+
		"u\u0001u\u0001v\u0001v\u0001v\u0001v\u0001w\u0001w\u0001w\u0001w\u0001"+
		"w\u0001w\u0001x\u0001x\u0001x\u0001x\u0001x\u0003x\u059b\bx\u0001y\u0001"+
		"y\u0001y\u0001y\u0003y\u05a1\by\u0001z\u0001z\u0001z\u0001z\u0001z\u0001"+
		"{\u0001{\u0001|\u0001|\u0001}\u0001}\u0001~\u0001~\u0001\u007f\u0001\u007f"+
		"\u0001\u0080\u0001\u0080\u0001\u0081\u0001\u0081\u0001\u0081\u0003\u0081"+
		"\u05b7\b\u0081\u0001\u0081\u0003\u0081\u05ba\b\u0081\u0001\u0082\u0001"+
		"\u0082\u0001\u0082\u0003\u0082\u05bf\b\u0082\u0001\u0082\u0001\u0082\u0001"+
		"\u0083\u0001\u0083\u0001\u0083\u0003\u0083\u05c6\b\u0083\u0001\u0083\u0001"+
		"\u0083\u0001\u0084\u0001\u0084\u0001\u0084\u0003\u0084\u05cd\b\u0084\u0001"+
		"\u0084\u0001\u0084\u0001\u0085\u0001\u0085\u0001\u0086\u0001\u0086\u0001"+
		"\u0086\u0001\u0086\u0001\u0086\u0001\u0086\u0001\u0087\u0001\u0087\u0001"+
		"\u0088\u0001\u0088\u0001\u0089\u0001\u0089\u0001\u0089\u0001\u0089\u0003"+
		"\u0089\u05e1\b\u0089\u0003\u0089\u05e3\b\u0089\u0001\u008a\u0001\u008a"+
		"\u0001\u008a\u0001\u008a\u0001\u008a\u0001\u008a\u0001\u008a\u0001\u008a"+
		"\u0003\u008a\u05ed\b\u008a\u0001\u008b\u0001\u008b\u0001\u008b\u0001\u008b"+
		"\u0001\u008b\u0003\u008b\u05f4\b\u008b\u0001\u008b\u0001\u008b\u0003\u008b"+
		"\u05f8\b\u008b\u0001\u008b\u0001\u008b\u0001\u008c\u0001\u008c\u0003\u008c"+
		"\u05fe\b\u008c\u0001\u008d\u0001\u008d\u0001\u008d\u0001\u008d\u0001\u008d"+
		"\u0001\u008d\u0001\u008d\u0003\u008d\u0607\b\u008d\u0001\u008d\u0001\u008d"+
		"\u0001\u008e\u0001\u008e\u0001\u008e\u0001\u008e\u0003\u008e\u060f\b\u008e"+
		"\u0001\u008e\u0001\u008e\u0003\u008e\u0613\b\u008e\u0001\u008e\u0003\u008e"+
		"\u0616\b\u008e\u0001\u008e\u0003\u008e\u0619\b\u008e\u0001\u008e\u0003"+
		"\u008e\u061c\b\u008e\u0001\u008e\u0003\u008e\u061f\b\u008e\u0001\u008f"+
		"\u0001\u008f\u0001\u0090\u0001\u0090\u0001\u0090\u0001\u0090\u0003\u0090"+
		"\u0627\b\u0090\u0001\u0090\u0001\u0090\u0001\u0090\u0005\u0090\u062c\b"+
		"\u0090\n\u0090\f\u0090\u062f\t\u0090\u0001\u0091\u0001\u0091\u0001\u0091"+
		"\u0001\u0091\u0001\u0091\u0001\u0092\u0001\u0092\u0001\u0092\u0001\u0092"+
		"\u0001\u0092\u0001\u0092\u0001\u0092\u0001\u0092\u0001\u0092\u0001\u0092"+
		"\u0001\u0092\u0001\u0092\u0001\u0092\u0001\u0092\u0001\u0092\u0001\u0092"+
		"\u0001\u0092\u0001\u0092\u0001\u0092\u0001\u0092\u0001\u0092\u0001\u0092"+
		"\u0001\u0092\u0001\u0092\u0001\u0092\u0001\u0092\u0003\u0092\u0650\b\u0092"+
		"\u0001\u0093\u0001\u0093\u0001\u0093\u0001\u0093\u0001\u0093\u0001\u0093"+
		"\u0001\u0093\u0001\u0093\u0001\u0093\u0001\u0093\u0003\u0093\u065c\b\u0093"+
		"\u0001\u0094\u0001\u0094\u0001\u0094\u0003\u0094\u0661\b\u0094\u0001\u0095"+
		"\u0001\u0095\u0001\u0095\u0001\u0095\u0001\u0095\u0003\u0095\u0668\b\u0095"+
		"\u0001\u0095\u0003\u0095\u066b\b\u0095\u0001\u0095\u0001\u0095\u0001\u0095"+
		"\u0001\u0095\u0001\u0095\u0001\u0095\u0001\u0095\u0001\u0095\u0001\u0095"+
		"\u0001\u0095\u0001\u0095\u0003\u0095\u0678\b\u0095\u0001\u0096\u0001\u0096"+
		"\u0001\u0096\u0001\u0096\u0001\u0096\u0003\u0096\u067f\b\u0096\u0001\u0096"+
		"\u0003\u0096\u0682\b\u0096\u0001\u0096\u0001\u0096\u0001\u0096\u0001\u0096"+
		"\u0001\u0096\u0001\u0096\u0001\u0096\u0001\u0096\u0001\u0096\u0001\u0096"+
		"\u0001\u0096\u0003\u0096\u068f\b\u0096\u0001\u0097\u0001\u0097\u0001\u0098"+
		"\u0001\u0098\u0001\u0099\u0001\u0099\u0001\u0099\u0003\u0099\u0698\b\u0099"+
		"\u0001\u0099\u0001\u0099\u0001\u0099\u0001\u0099\u0003\u0099\u069e\b\u0099"+
		"\u0001\u0099\u0001\u0099\u0003\u0099\u06a2\b\u0099\u0001\u0099\u0003\u0099"+
		"\u06a5\b\u0099\u0001\u0099\u0003\u0099\u06a8\b\u0099\u0001\u009a\u0001"+
		"\u009a\u0001\u009a\u0001\u009a\u0001\u009a\u0003\u009a\u06af\b\u009a\u0001"+
		"\u009a\u0001\u009a\u0003\u009a\u06b3\b\u009a\u0001\u009b\u0001\u009b\u0001"+
		"\u009b\u0001\u009b\u0001\u009b\u0001\u009b\u0001\u009c\u0001\u009c\u0001"+
		"\u009c\u0001\u009c\u0001\u009c\u0001\u009d\u0001\u009d\u0001\u009d\u0001"+
		"\u009d\u0003\u009d\u06c4\b\u009d\u0001\u009e\u0001\u009e\u0001\u009e\u0001"+
		"\u009e\u0003\u009e\u06ca\b\u009e\u0001\u009f\u0001\u009f\u0001\u009f\u0003"+
		"\u009f\u06cf\b\u009f\u0001\u009f\u0003\u009f\u06d2\b\u009f\u0001\u009f"+
		"\u0003\u009f\u06d5\b\u009f\u0001\u009f\u0001\u009f\u0001\u00a0\u0001\u00a0"+
		"\u0001\u00a0\u0001\u00a0\u0001\u00a0\u0005\u00a0\u06de\b\u00a0\n\u00a0"+
		"\f\u00a0\u06e1\t\u00a0\u0001\u00a1\u0001\u00a1\u0001\u00a1\u0003\u00a1"+
		"\u06e6\b\u00a1\u0001\u00a1\u0001\u00a1\u0001\u00a1\u0001\u00a1\u0001\u00a1"+
		"\u0001\u00a1\u0003\u00a1\u06ee\b\u00a1\u0003\u00a1\u06f0\b\u00a1\u0001"+
		"\u00a2\u0001\u00a2\u0001\u00a2\u0001\u00a2\u0001\u00a2\u0001\u00a2\u0001"+
		"\u00a2\u0001\u00a2\u0001\u00a2\u0001\u00a2\u0003\u00a2\u06fc\b\u00a2\u0001"+
		"\u00a3\u0001\u00a3\u0001\u00a3\u0001\u00a3\u0001\u00a3\u0001\u00a3\u0001"+
		"\u00a3\u0001\u00a3\u0001\u00a3\u0001\u00a3\u0003\u00a3\u0708\b\u00a3\u0001"+
		"\u00a4\u0001\u00a4\u0001\u00a4\u0001\u00a4\u0001\u00a4\u0001\u00a4\u0001"+
		"\u00a4\u0001\u00a4\u0001\u00a4\u0001\u00a4\u0003\u00a4\u0714\b\u00a4\u0001"+
		"\u00a5\u0001\u00a5\u0001\u00a5\u0001\u00a5\u0001\u00a5\u0001\u00a5\u0001"+
		"\u00a5\u0001\u00a5\u0001\u00a5\u0001\u00a5\u0001\u00a5\u0001\u00a5\u0001"+
		"\u00a5\u0001\u00a5\u0001\u00a5\u0001\u00a5\u0001\u00a5\u0001\u00a5\u0001"+
		"\u00a5\u0001\u00a5\u0003\u00a5\u072a\b\u00a5\u0001\u00a6\u0001\u00a6\u0001"+
		"\u00a6\u0001\u00a6\u0001\u00a6\u0001\u00a6\u0001\u00a6\u0001\u00a7\u0001"+
		"\u00a7\u0001\u00a7\u0001\u00a7\u0001\u00a7\u0003\u00a7\u0738\b\u00a7\u0001"+
		"\u00a7\u0003\u00a7\u073b\b\u00a7\u0001\u00a8\u0001\u00a8\u0001\u00a8\u0001"+
		"\u00a8\u0001\u00a8\u0001\u00a8\u0001\u00a8\u0005\u00a8\u0744\b\u00a8\n"+
		"\u00a8\f\u00a8\u0747\t\u00a8\u0001\u00a9\u0001\u00a9\u0001\u00a9\u0001"+
		"\u00a9\u0001\u00a9\u0001\u00a9\u0001\u00a9\u0003\u00a9\u0750\b\u00a9\u0001"+
		"\u00a9\u0001\u00a9\u0001\u00a9\u0001\u00a9\u0001\u00a9\u0001\u00a9\u0001"+
		"\u00a9\u0001\u00a9\u0001\u00a9\u0003\u00a9\u075b\b\u00a9\u0001\u00a9\u0001"+
		"\u00a9\u0003\u00a9\u075f\b\u00a9\u0001\u00aa\u0001\u00aa\u0001\u00ab\u0001"+
		"\u00ab\u0001\u00ac\u0001\u00ac\u0001\u00ac\u0003\u00ac\u0768\b\u00ac\u0001"+
		"\u00ac\u0003\u00ac\u076b\b\u00ac\u0001\u00ac\u0003\u00ac\u076e\b\u00ac"+
		"\u0001\u00ac\u0001\u00ac\u0001\u00ac\u0001\u00ad\u0001\u00ad\u0001\u00ae"+
		"\u0001\u00ae\u0003\u00ae\u0777\b\u00ae\u0001\u00af\u0001\u00af\u0001\u00af"+
		"\u0001\u00af\u0001\u00af\u0001\u00af\u0001\u00af\u0003\u00af\u0780\b\u00af"+
		"\u0001\u00af\u0001\u00af\u0001\u00b0\u0001\u00b0\u0001\u00b1\u0001\u00b1"+
		"\u0001\u00b2\u0001\u00b2\u0001\u00b3\u0001\u00b3\u0001\u00b3\u0001\u00b3"+
		"\u0001\u00b3\u0001\u00b3\u0001\u00b3\u0001\u00b3\u0001\u00b3\u0003\u00b3"+
		"\u0793\b\u00b3\u0001\u00b3\u0001\u00b3\u0001\u00b4\u0001\u00b4\u0001\u00b5"+
		"\u0001\u00b5\u0001\u00b6\u0001\u00b6\u0001\u00b7\u0001\u00b7\u0001\u00b8"+
		"\u0001\u00b8\u0001\u00b8\u0003\u00b8\u07a2\b\u00b8\u0001\u00b8\u0001\u00b8"+
		"\u0003\u00b8\u07a6\b\u00b8\u0001\u00b9\u0001\u00b9\u0001\u00b9\u0003\u00b9"+
		"\u07ab\b\u00b9\u0001\u00b9\u0001\u00b9\u0003\u00b9\u07af\b\u00b9\u0001"+
		"\u00ba\u0001\u00ba\u0001\u00ba\u0003\u00ba\u07b4\b\u00ba\u0001\u00ba\u0001"+
		"\u00ba\u0003\u00ba\u07b8\b\u00ba\u0001\u00bb\u0001\u00bb\u0001\u00bb\u0003"+
		"\u00bb\u07bd\b\u00bb\u0001\u00bb\u0003\u00bb\u07c0\b\u00bb\u0001\u00bc"+
		"\u0001\u00bc\u0001\u00bc\u0003\u00bc\u07c5\b\u00bc\u0001\u00bc\u0001\u00bc"+
		"\u0003\u00bc\u07c9\b\u00bc\u0001\u00bd\u0001\u00bd\u0001\u00bd\u0003\u00bd"+
		"\u07ce\b\u00bd\u0001\u00bd\u0001\u00bd\u0003\u00bd\u07d2\b\u00bd\u0001"+
		"\u00be\u0001\u00be\u0001\u00be\u0003\u00be\u07d7\b\u00be\u0001\u00be\u0001"+
		"\u00be\u0003\u00be\u07db\b\u00be\u0001\u00bf\u0001\u00bf\u0001\u00bf\u0003"+
		"\u00bf\u07e0\b\u00bf\u0001\u00bf\u0001\u00bf\u0003\u00bf\u07e4\b\u00bf"+
		"\u0001\u00c0\u0001\u00c0\u0001\u00c0\u0001\u00c0\u0001\u00c0\u0001\u00c0"+
		"\u0001\u00c0\u0001\u00c1\u0001\u00c1\u0001\u00c2\u0001\u00c2\u0001\u00c2"+
		"\u0001\u00c2\u0001\u00c2\u0001\u00c2\u0001\u00c2\u0001\u00c2\u0001\u00c2"+
		"\u0001\u00c2\u0001\u00c2\u0001\u00c2\u0003\u00c2\u07fb\b\u00c2\u0001\u00c3"+
		"\u0001\u00c3\u0001\u00c3\u0001\u00c3\u0001\u00c3\u0001\u00c3\u0003\u00c3"+
		"\u0803\b\u00c3\u0003\u00c3\u0805\b\u00c3\u0001\u00c3\u0001\u00c3\u0001"+
		"\u00c4\u0001\u00c4\u0001\u00c4\u0001\u00c4\u0001\u00c4\u0003\u00c4\u080e"+
		"\b\u00c4\u0001\u00c5\u0001\u00c5\u0001\u00c6\u0001\u00c6\u0001\u00c6\u0001"+
		"\u00c6\u0001\u00c6\u0001\u00c6\u0001\u00c6\u0001\u00c6\u0001\u00c6\u0003"+
		"\u00c6\u081b\b\u00c6\u0001\u00c7\u0001\u00c7\u0001\u00c7\u0001\u00c7\u0001"+
		"\u00c7\u0001\u00c7\u0003\u00c7\u0823\b\u00c7\u0001\u00c8\u0001\u00c8\u0003"+
		"\u00c8\u0827\b\u00c8\u0001\u00c8\u0001\u00c8\u0003\u00c8\u082b\b\u00c8"+
		"\u0001\u00c9\u0001\u00c9\u0001\u00ca\u0001\u00ca\u0001\u00ca\u0001\u00ca"+
		"\u0001\u00ca\u0001\u00ca\u0001\u00ca\u0001\u00cb\u0001\u00cb\u0001\u00cc"+
		"\u0001\u00cc\u0001\u00cd\u0001\u00cd\u0001\u00cd\u0001\u00cd\u0001\u00cd"+
		"\u0005\u00cd\u083f\b\u00cd\n\u00cd\f\u00cd\u0842\t\u00cd\u0001\u00cd\u0001"+
		"\u00cd\u0001\u00ce\u0001\u00ce\u0001\u00ce\u0001\u00ce\u0001\u00ce\u0005"+
		"\u00ce\u084b\b\u00ce\n\u00ce\f\u00ce\u084e\t\u00ce\u0001\u00ce\u0001\u00ce"+
		"\u0001\u00cf\u0001\u00cf\u0001\u00cf\u0001\u00cf\u0003\u00cf\u0856\b\u00cf"+
		"\u0001\u00d0\u0001\u00d0\u0001\u00d0\u0003\u00d0\u085b\b\u00d0\u0001\u00d0"+
		"\u0000\u0002\u009a\u00a2\u00d1\u0000\u0002\u0004\u0006\b\n\f\u000e\u0010"+
		"\u0012\u0014\u0016\u0018\u001a\u001c\u001e \"$&(*,.02468:<>@BDFHJLNPR"+
		"TVXZ\\^`bdfhjlnprtvxz|~\u0080\u0082\u0084\u0086\u0088\u008a\u008c\u008e"+
		"\u0090\u0092\u0094\u0096\u0098\u009a\u009c\u009e\u00a0\u00a2\u00a4\u00a6"+
		"\u00a8\u00aa\u00ac\u00ae\u00b0\u00b2\u00b4\u00b6\u00b8\u00ba\u00bc\u00be"+
		"\u00c0\u00c2\u00c4\u00c6\u00c8\u00ca\u00cc\u00ce\u00d0\u00d2\u00d4\u00d6"+
		"\u00d8\u00da\u00dc\u00de\u00e0\u00e2\u00e4\u00e6\u00e8\u00ea\u00ec\u00ee"+
		"\u00f0\u00f2\u00f4\u00f6\u00f8\u00fa\u00fc\u00fe\u0100\u0102\u0104\u0106"+
		"\u0108\u010a\u010c\u010e\u0110\u0112\u0114\u0116\u0118\u011a\u011c\u011e"+
		"\u0120\u0122\u0124\u0126\u0128\u012a\u012c\u012e\u0130\u0132\u0134\u0136"+
		"\u0138\u013a\u013c\u013e\u0140\u0142\u0144\u0146\u0148\u014a\u014c\u014e"+
		"\u0150\u0152\u0154\u0156\u0158\u015a\u015c\u015e\u0160\u0162\u0164\u0166"+
		"\u0168\u016a\u016c\u016e\u0170\u0172\u0174\u0176\u0178\u017a\u017c\u017e"+
		"\u0180\u0182\u0184\u0186\u0188\u018a\u018c\u018e\u0190\u0192\u0194\u0196"+
		"\u0198\u019a\u019c\u019e\u01a0\u0000!\u0002\u000077MM\u0003\u0000ff}}"+
		"\u00b0\u00b0\u0002\u0000\u009e\u009e\u00d2\u00d2\u0002\u0000aazz\u0002"+
		"\u000033NN\u0001\u0000\u00b2\u00b3\u0002\u0000aa\u0095\u0095\u0002\u0000"+
		"mm~~\u0001\u0000\u0010\u0015\u0002\u0000QQ\u00cd\u00cd\u0002\u0000oox"+
		"x\u0002\u0000RR\u00ce\u00ce\u0002\u0000ppyy\u0001\u0000 \"\u0001\u0000"+
		"\u001e\u001f\u0001\u0000\u00d7\u00d8\u0001\u0000\u0003\t\u0002\u0000\u0003"+
		"\u0003\u0006\u0006\u0004\u000044\u0088\u0088\u008e\u008e\u00bb\u00bb\u0002"+
		"\u0000\u0089\u0089\u008f\u008f\u0002\u0000\u008a\u008a\u0090\u0090\u0002"+
		"\u0000//ZZ\u0002\u000011\u00b9\u00b9\u0002\u0000\u00d2\u00d2\u00d4\u00d4"+
		"\u0003\u0000ii\u00ae\u00ae\u00b3\u00b3\u0003\u000066||\u00c3\u00c3\u0002"+
		"\u0000||\u00c3\u00c3\u0001\u0000\u00c6\u00c7\b\u0000JJWWkk\u0091\u0093"+
		"\u00ad\u00ad\u00b5\u00b5\u00cf\u00cf\u00d5\u00d5\u0002\u0000kk\u0091\u0091"+
		"\u0002\u0000HH\u00be\u00be\u0006\u0000*egpr|~\u00a2\u00a4\u00af\u00b1"+
		"\u00d6\u0005\u0000ffqq}}\u00a3\u00a3\u00b0\u00b0\u08e4\u0000\u01a6\u0001"+
		"\u0000\u0000\u0000\u0002\u01aa\u0001\u0000\u0000\u0000\u0004\u01ac\u0001"+
		"\u0000\u0000\u0000\u0006\u01ae\u0001\u0000\u0000\u0000\b\u01b2\u0001\u0000"+
		"\u0000\u0000\n\u01ba\u0001\u0000\u0000\u0000\f\u01c3\u0001\u0000\u0000"+
		"\u0000\u000e\u01cc\u0001\u0000\u0000\u0000\u0010\u01d0\u0001\u0000\u0000"+
		"\u0000\u0012\u01dd\u0001\u0000\u0000\u0000\u0014\u01e8\u0001\u0000\u0000"+
		"\u0000\u0016\u01f1\u0001\u0000\u0000\u0000\u0018\u01fc\u0001\u0000\u0000"+
		"\u0000\u001a\u0212\u0001\u0000\u0000\u0000\u001c\u021a\u0001\u0000\u0000"+
		"\u0000\u001e\u021c\u0001\u0000\u0000\u0000 \u0225\u0001\u0000\u0000\u0000"+
		"\"\u0236\u0001\u0000\u0000\u0000$\u023e\u0001\u0000\u0000\u0000&\u0246"+
		"\u0001\u0000\u0000\u0000(\u024e\u0001\u0000\u0000\u0000*\u0255\u0001\u0000"+
		"\u0000\u0000,\u0273\u0001\u0000\u0000\u0000.\u0280\u0001\u0000\u0000\u0000"+
		"0\u028e\u0001\u0000\u0000\u00002\u0290\u0001\u0000\u0000\u00004\u02b5"+
		"\u0001\u0000\u0000\u00006\u02b7\u0001\u0000\u0000\u00008\u02c0\u0001\u0000"+
		"\u0000\u0000:\u02d3\u0001\u0000\u0000\u0000<\u02d5\u0001\u0000\u0000\u0000"+
		">\u02e0\u0001\u0000\u0000\u0000@\u02e2\u0001\u0000\u0000\u0000B\u02e8"+
		"\u0001\u0000\u0000\u0000D\u02f0\u0001\u0000\u0000\u0000F\u0302\u0001\u0000"+
		"\u0000\u0000H\u0311\u0001\u0000\u0000\u0000J\u0313\u0001\u0000\u0000\u0000"+
		"L\u0316\u0001\u0000\u0000\u0000N\u031c\u0001\u0000\u0000\u0000P\u0324"+
		"\u0001\u0000\u0000\u0000R\u032c\u0001\u0000\u0000\u0000T\u032e\u0001\u0000"+
		"\u0000\u0000V\u0333\u0001\u0000\u0000\u0000X\u033c\u0001\u0000\u0000\u0000"+
		"Z\u033e\u0001\u0000\u0000\u0000\\\u0346\u0001\u0000\u0000\u0000^\u034c"+
		"\u0001\u0000\u0000\u0000`\u034e\u0001\u0000\u0000\u0000b\u0353\u0001\u0000"+
		"\u0000\u0000d\u035a\u0001\u0000\u0000\u0000f\u0362\u0001\u0000\u0000\u0000"+
		"h\u0364\u0001\u0000\u0000\u0000j\u036d\u0001\u0000\u0000\u0000l\u036f"+
		"\u0001\u0000\u0000\u0000n\u0373\u0001\u0000\u0000\u0000p\u037a\u0001\u0000"+
		"\u0000\u0000r\u0383\u0001\u0000\u0000\u0000t\u038a\u0001\u0000\u0000\u0000"+
		"v\u0391\u0001\u0000\u0000\u0000x\u039e\u0001\u0000\u0000\u0000z\u03a0"+
		"\u0001\u0000\u0000\u0000|\u03a3\u0001\u0000\u0000\u0000~\u03ad\u0001\u0000"+
		"\u0000\u0000\u0080\u03b5\u0001\u0000\u0000\u0000\u0082\u03bc\u0001\u0000"+
		"\u0000\u0000\u0084\u03c2\u0001\u0000\u0000\u0000\u0086\u03c4\u0001\u0000"+
		"\u0000\u0000\u0088\u03c6\u0001\u0000\u0000\u0000\u008a\u03cd\u0001\u0000"+
		"\u0000\u0000\u008c\u03cf\u0001\u0000\u0000\u0000\u008e\u03d2\u0001\u0000"+
		"\u0000\u0000\u0090\u03d7\u0001\u0000\u0000\u0000\u0092\u03e4\u0001\u0000"+
		"\u0000\u0000\u0094\u03e8\u0001\u0000\u0000\u0000\u0096\u03ef\u0001\u0000"+
		"\u0000\u0000\u0098\u03f1\u0001\u0000\u0000\u0000\u009a\u0450\u0001\u0000"+
		"\u0000\u0000\u009c\u045d\u0001\u0000\u0000\u0000\u009e\u0475\u0001\u0000"+
		"\u0000\u0000\u00a0\u0477\u0001\u0000\u0000\u0000\u00a2\u0497\u0001\u0000"+
		"\u0000\u0000\u00a4\u04bc\u0001\u0000\u0000\u0000\u00a6\u04c0\u0001\u0000"+
		"\u0000\u0000\u00a8\u04c4\u0001\u0000\u0000\u0000\u00aa\u04c6\u0001\u0000"+
		"\u0000\u0000\u00ac\u04c8\u0001\u0000\u0000\u0000\u00ae\u04ca\u0001\u0000"+
		"\u0000\u0000\u00b0\u04cc\u0001\u0000\u0000\u0000\u00b2\u04ce\u0001\u0000"+
		"\u0000\u0000\u00b4\u04d0\u0001\u0000\u0000\u0000\u00b6\u04d2\u0001\u0000"+
		"\u0000\u0000\u00b8\u04d4\u0001\u0000\u0000\u0000\u00ba\u04dc\u0001\u0000"+
		"\u0000\u0000\u00bc\u04e3\u0001\u0000\u0000\u0000\u00be\u04e8\u0001\u0000"+
		"\u0000\u0000\u00c0\u04ef\u0001\u0000\u0000\u0000\u00c2\u04f6\u0001\u0000"+
		"\u0000\u0000\u00c4\u04f8\u0001\u0000\u0000\u0000\u00c6\u0504\u0001\u0000"+
		"\u0000\u0000\u00c8\u0509\u0001\u0000\u0000\u0000\u00ca\u050c\u0001\u0000"+
		"\u0000\u0000\u00cc\u0517\u0001\u0000\u0000\u0000\u00ce\u0524\u0001\u0000"+
		"\u0000\u0000\u00d0\u0526\u0001\u0000\u0000\u0000\u00d2\u0528\u0001\u0000"+
		"\u0000\u0000\u00d4\u0535\u0001\u0000\u0000\u0000\u00d6\u053d\u0001\u0000"+
		"\u0000\u0000\u00d8\u0542\u0001\u0000\u0000\u0000\u00da\u054d\u0001\u0000"+
		"\u0000\u0000\u00dc\u0558\u0001\u0000\u0000\u0000\u00de\u0563\u0001\u0000"+
		"\u0000\u0000\u00e0\u056e\u0001\u0000\u0000\u0000\u00e2\u0579\u0001\u0000"+
		"\u0000\u0000\u00e4\u057e\u0001\u0000\u0000\u0000\u00e6\u0580\u0001\u0000"+
		"\u0000\u0000\u00e8\u0583\u0001\u0000\u0000\u0000\u00ea\u0587\u0001\u0000"+
		"\u0000\u0000\u00ec\u058b\u0001\u0000\u0000\u0000\u00ee\u058f\u0001\u0000"+
		"\u0000\u0000\u00f0\u0595\u0001\u0000\u0000\u0000\u00f2\u059c\u0001\u0000"+
		"\u0000\u0000\u00f4\u05a2\u0001\u0000\u0000\u0000\u00f6\u05a7\u0001\u0000"+
		"\u0000\u0000\u00f8\u05a9\u0001\u0000\u0000\u0000\u00fa\u05ab\u0001\u0000"+
		"\u0000\u0000\u00fc\u05ad\u0001\u0000\u0000\u0000\u00fe\u05af\u0001\u0000"+
		"\u0000\u0000\u0100\u05b1\u0001\u0000\u0000\u0000\u0102\u05b9\u0001\u0000"+
		"\u0000\u0000\u0104\u05bb\u0001\u0000\u0000\u0000\u0106\u05c2\u0001\u0000"+
		"\u0000\u0000\u0108\u05c9\u0001\u0000\u0000\u0000\u010a\u05d0\u0001\u0000"+
		"\u0000\u0000\u010c\u05d2\u0001\u0000\u0000\u0000\u010e\u05d8\u0001\u0000"+
		"\u0000\u0000\u0110\u05da\u0001\u0000\u0000\u0000\u0112\u05e2\u0001\u0000"+
		"\u0000\u0000\u0114\u05ec\u0001\u0000\u0000\u0000\u0116\u05ee\u0001\u0000"+
		"\u0000\u0000\u0118\u05fd\u0001\u0000\u0000\u0000\u011a\u05ff\u0001\u0000"+
		"\u0000\u0000\u011c\u060a\u0001\u0000\u0000\u0000\u011e\u0620\u0001\u0000"+
		"\u0000\u0000\u0120\u0626\u0001\u0000\u0000\u0000\u0122\u0630\u0001\u0000"+
		"\u0000\u0000\u0124\u064f\u0001\u0000\u0000\u0000\u0126\u065b\u0001\u0000"+
		"\u0000\u0000\u0128\u0660\u0001\u0000\u0000\u0000\u012a\u0677\u0001\u0000"+
		"\u0000\u0000\u012c\u068e\u0001\u0000\u0000\u0000\u012e\u0690\u0001\u0000"+
		"\u0000\u0000\u0130\u0692\u0001\u0000\u0000\u0000\u0132\u0694\u0001\u0000"+
		"\u0000\u0000\u0134\u06a9\u0001\u0000\u0000\u0000\u0136\u06b4\u0001\u0000"+
		"\u0000\u0000\u0138\u06ba\u0001\u0000\u0000\u0000\u013a\u06c3\u0001\u0000"+
		"\u0000\u0000\u013c\u06c9\u0001\u0000\u0000\u0000\u013e\u06cb\u0001\u0000"+
		"\u0000\u0000\u0140\u06d8\u0001\u0000\u0000\u0000\u0142\u06ef\u0001\u0000"+
		"\u0000\u0000\u0144\u06fb\u0001\u0000\u0000\u0000\u0146\u0707\u0001\u0000"+
		"\u0000\u0000\u0148\u0713\u0001\u0000\u0000\u0000\u014a\u0729\u0001\u0000"+
		"\u0000\u0000\u014c\u072b\u0001\u0000\u0000\u0000\u014e\u0732\u0001\u0000"+
		"\u0000\u0000\u0150\u073c\u0001\u0000\u0000\u0000\u0152\u075e\u0001\u0000"+
		"\u0000\u0000\u0154\u0760\u0001\u0000\u0000\u0000\u0156\u0762\u0001\u0000"+
		"\u0000\u0000\u0158\u0764\u0001\u0000\u0000\u0000\u015a\u0772\u0001\u0000"+
		"\u0000\u0000\u015c\u0776\u0001\u0000\u0000\u0000\u015e\u0778\u0001\u0000"+
		"\u0000\u0000\u0160\u0783\u0001\u0000\u0000\u0000\u0162\u0785\u0001\u0000"+
		"\u0000\u0000\u0164\u0787\u0001\u0000\u0000\u0000\u0166\u0789\u0001\u0000"+
		"\u0000\u0000\u0168\u0796\u0001\u0000\u0000\u0000\u016a\u0798\u0001\u0000"+
		"\u0000\u0000\u016c\u079a\u0001\u0000\u0000\u0000\u016e\u079c\u0001\u0000"+
		"\u0000\u0000\u0170\u07a5\u0001\u0000\u0000\u0000\u0172\u07ae\u0001\u0000"+
		"\u0000\u0000\u0174\u07b7\u0001\u0000\u0000\u0000\u0176\u07bf\u0001\u0000"+
		"\u0000\u0000\u0178\u07c8\u0001\u0000\u0000\u0000\u017a\u07d1\u0001\u0000"+
		"\u0000\u0000\u017c\u07da\u0001\u0000\u0000\u0000\u017e\u07e3\u0001\u0000"+
		"\u0000\u0000\u0180\u07e5\u0001\u0000\u0000\u0000\u0182\u07ec\u0001\u0000"+
		"\u0000\u0000\u0184\u07fa\u0001\u0000\u0000\u0000\u0186\u07fc\u0001\u0000"+
		"\u0000\u0000\u0188\u080d\u0001\u0000\u0000\u0000\u018a\u080f\u0001\u0000"+
		"\u0000\u0000\u018c\u081a\u0001\u0000\u0000\u0000\u018e\u0822\u0001\u0000"+
		"\u0000\u0000\u0190\u082a\u0001\u0000\u0000\u0000\u0192\u082c\u0001\u0000"+
		"\u0000\u0000\u0194\u082e\u0001\u0000\u0000\u0000\u0196\u0835\u0001\u0000"+
		"\u0000\u0000\u0198\u0837\u0001\u0000\u0000\u0000\u019a\u0839\u0001\u0000"+
		"\u0000\u0000\u019c\u0845\u0001\u0000\u0000\u0000\u019e\u0855\u0001\u0000"+
		"\u0000\u0000\u01a0\u085a\u0001\u0000\u0000\u0000\u01a2\u01a7\u0003\u0002"+
		"\u0001\u0000\u01a3\u01a7\u0003\n\u0005\u0000\u01a4\u01a7\u0003\b\u0004"+
		"\u0000\u01a5\u01a7\u0003\u0010\b\u0000\u01a6\u01a2\u0001\u0000\u0000\u0000"+
		"\u01a6\u01a3\u0001\u0000\u0000\u0000\u01a6\u01a4\u0001\u0000\u0000\u0000"+
		"\u01a6\u01a5\u0001\u0000\u0000\u0000\u01a7\u01a8\u0001\u0000\u0000\u0000"+
		"\u01a8\u01a9\u0005\u0000\u0000\u0001\u01a9\u0001\u0001\u0000\u0000\u0000"+
		"\u01aa\u01ab\u0003,\u0016\u0000\u01ab\u0003\u0001\u0000\u0000\u0000\u01ac"+
		"\u01ad\u0003,\u0016\u0000\u01ad\u0005\u0001\u0000\u0000\u0000\u01ae\u01b0"+
		"\u0003<\u001e\u0000\u01af\u01b1\u0003>\u001f\u0000\u01b0\u01af\u0001\u0000"+
		"\u0000\u0000\u01b0\u01b1\u0001\u0000\u0000\u0000\u01b1\u0007\u0001\u0000"+
		"\u0000\u0000\u01b2\u01b4\u0005L\u0000\u0000\u01b3\u01b5\u0005e\u0000\u0000"+
		"\u01b4\u01b3\u0001\u0000\u0000\u0000\u01b4\u01b5\u0001\u0000\u0000\u0000"+
		"\u01b5\u01b6\u0001\u0000\u0000\u0000\u01b6\u01b8\u00038\u001c\u0000\u01b7"+
		"\u01b9\u0003\u0098L\u0000\u01b8\u01b7\u0001\u0000\u0000\u0000\u01b8\u01b9"+
		"\u0001\u0000\u0000\u0000\u01b9\t\u0001\u0000\u0000\u0000\u01ba\u01bc\u0005"+
		"\u00cb\u0000\u0000\u01bb\u01bd\u0005,\u0000\u0000\u01bc\u01bb\u0001\u0000"+
		"\u0000\u0000\u01bc\u01bd\u0001\u0000\u0000\u0000\u01bd\u01be\u0001\u0000"+
		"\u0000\u0000\u01be\u01bf\u00038\u001c\u0000\u01bf\u01c1\u0003\f\u0006"+
		"\u0000\u01c0\u01c2\u0003\u0098L\u0000\u01c1\u01c0\u0001\u0000\u0000\u0000"+
		"\u01c1\u01c2\u0001\u0000\u0000\u0000\u01c2\u000b\u0001\u0000\u0000\u0000"+
		"\u01c3\u01c4\u0005\u00b7\u0000\u0000\u01c4\u01c9\u0003\u000e\u0007\u0000"+
		"\u01c5\u01c6\u0005\u0016\u0000\u0000\u01c6\u01c8\u0003\u000e\u0007\u0000"+
		"\u01c7\u01c5\u0001\u0000\u0000\u0000\u01c8\u01cb\u0001\u0000\u0000\u0000"+
		"\u01c9\u01c7\u0001\u0000\u0000\u0000\u01c9\u01ca\u0001\u0000\u0000\u0000"+
		"\u01ca\r\u0001\u0000\u0000\u0000\u01cb\u01c9\u0001\u0000\u0000\u0000\u01cc"+
		"\u01cd\u0003b1\u0000\u01cd\u01ce\u0005\u0010\u0000\u0000\u01ce\u01cf\u0003"+
		"\u00a6S\u0000\u01cf\u000f\u0001\u0000\u0000\u0000\u01d0\u01d2\u0005r\u0000"+
		"\u0000\u01d1\u01d3\u0005u\u0000\u0000\u01d2\u01d1\u0001\u0000\u0000\u0000"+
		"\u01d2\u01d3\u0001\u0000\u0000\u0000\u01d3\u01d4\u0001\u0000\u0000\u0000"+
		"\u01d4\u01d5\u0003\u0006\u0003\u0000\u01d5\u01d8\u0003\u0012\t\u0000\u01d6"+
		"\u01d9\u0003,\u0016\u0000\u01d7\u01d9\u0003\u0014\n\u0000\u01d8\u01d6"+
		"\u0001\u0000\u0000\u0000\u01d8\u01d7\u0001\u0000\u0000\u0000\u01d9\u01db"+
		"\u0001\u0000\u0000\u0000\u01da\u01dc\u0003\u0018\f\u0000\u01db\u01da\u0001"+
		"\u0000\u0000\u0000\u01db\u01dc\u0001\u0000\u0000\u0000\u01dc\u0011\u0001"+
		"\u0000\u0000\u0000\u01dd\u01de\u0005\u0018\u0000\u0000\u01de\u01e3\u0003"+
		"b1\u0000\u01df\u01e0\u0005\u0016\u0000\u0000\u01e0\u01e2\u0003b1\u0000"+
		"\u01e1\u01df\u0001\u0000\u0000\u0000\u01e2\u01e5\u0001\u0000\u0000\u0000"+
		"\u01e3\u01e1\u0001\u0000\u0000\u0000\u01e3\u01e4\u0001\u0000\u0000\u0000"+
		"\u01e4\u01e6\u0001\u0000\u0000\u0000\u01e5\u01e3\u0001\u0000\u0000\u0000"+
		"\u01e6\u01e7\u0005\u0019\u0000\u0000\u01e7\u0013\u0001\u0000\u0000\u0000"+
		"\u01e8\u01e9\u0005\u00ce\u0000\u0000\u01e9\u01ee\u0003\u0016\u000b\u0000"+
		"\u01ea\u01eb\u0005\u0016\u0000\u0000\u01eb\u01ed\u0003\u0016\u000b\u0000"+
		"\u01ec\u01ea\u0001\u0000\u0000\u0000\u01ed\u01f0\u0001\u0000\u0000\u0000"+
		"\u01ee\u01ec\u0001\u0000\u0000\u0000\u01ee\u01ef\u0001\u0000\u0000\u0000"+
		"\u01ef\u0015\u0001\u0000\u0000\u0000\u01f0\u01ee\u0001\u0000\u0000\u0000"+
		"\u01f1\u01f2\u0005\u0018\u0000\u0000\u01f2\u01f7\u0003\u00a6S\u0000\u01f3"+
		"\u01f4\u0005\u0016\u0000\u0000\u01f4\u01f6\u0003\u00a6S\u0000\u01f5\u01f3"+
		"\u0001\u0000\u0000\u0000\u01f6\u01f9\u0001\u0000\u0000\u0000\u01f7\u01f5"+
		"\u0001\u0000\u0000\u0000\u01f7\u01f8\u0001\u0000\u0000\u0000\u01f8\u01fa"+
		"\u0001\u0000\u0000\u0000\u01f9\u01f7\u0001\u0000\u0000\u0000\u01fa\u01fb"+
		"\u0005\u0019\u0000\u0000\u01fb\u0017\u0001\u0000\u0000\u0000\u01fc\u01fd"+
		"\u0005\u009e\u0000\u0000\u01fd\u01ff\u0005=\u0000\u0000\u01fe\u0200\u0003"+
		"\u001a\r\u0000\u01ff\u01fe\u0001\u0000\u0000\u0000\u01ff\u0200\u0001\u0000"+
		"\u0000\u0000\u0200\u0201\u0001\u0000\u0000\u0000\u0201\u0202\u0005P\u0000"+
		"\u0000\u0202\u0203\u0003\u001c\u000e\u0000\u0203\u0019\u0001\u0000\u0000"+
		"\u0000\u0204\u0205\u0005\u009e\u0000\u0000\u0205\u0206\u0005>\u0000\u0000"+
		"\u0206\u0213\u0003\u01a0\u00d0\u0000\u0207\u0208\u0005\u0018\u0000\u0000"+
		"\u0208\u020d\u0003b1\u0000\u0209\u020a\u0005\u0016\u0000\u0000\u020a\u020c"+
		"\u0003b1\u0000\u020b\u0209\u0001\u0000\u0000\u0000\u020c\u020f\u0001\u0000"+
		"\u0000\u0000\u020d\u020b\u0001\u0000\u0000\u0000\u020d\u020e\u0001\u0000"+
		"\u0000\u0000\u020e\u0210\u0001\u0000\u0000\u0000\u020f\u020d\u0001\u0000"+
		"\u0000\u0000\u0210\u0211\u0005\u0019\u0000\u0000\u0211\u0213\u0001\u0000"+
		"\u0000\u0000\u0212\u0204\u0001\u0000\u0000\u0000\u0212\u0207\u0001\u0000"+
		"\u0000\u0000\u0213\u001b\u0001\u0000\u0000\u0000\u0214\u021b\u0005\u0098"+
		"\u0000\u0000\u0215\u0216\u0005\u00cb\u0000\u0000\u0216\u0218\u0003\f\u0006"+
		"\u0000\u0217\u0219\u0003\u0098L\u0000\u0218\u0217\u0001\u0000\u0000\u0000"+
		"\u0218\u0219\u0001\u0000\u0000\u0000\u0219\u021b\u0001\u0000\u0000\u0000"+
		"\u021a\u0214\u0001\u0000\u0000\u0000\u021a\u0215\u0001\u0000\u0000\u0000"+
		"\u021b\u001d\u0001\u0000\u0000\u0000\u021c\u021d\u0005\u00d2\u0000\u0000"+
		"\u021d\u0222\u0003 \u0010\u0000\u021e\u021f\u0005\u0016\u0000\u0000\u021f"+
		"\u0221\u0003 \u0010\u0000\u0220\u021e\u0001\u0000\u0000\u0000\u0221\u0224"+
		"\u0001\u0000\u0000\u0000\u0222\u0220\u0001\u0000\u0000\u0000\u0222\u0223"+
		"\u0001\u0000\u0000\u0000\u0223\u001f\u0001\u0000\u0000\u0000\u0224\u0222"+
		"\u0001\u0000\u0000\u0000\u0225\u0226\u0003\u01a0\u00d0\u0000\u0226\u022b"+
		"\u00052\u0000\u0000\u0227\u0229\u0005\u0097\u0000\u0000\u0228\u0227\u0001"+
		"\u0000\u0000\u0000\u0228\u0229\u0001\u0000\u0000\u0000\u0229\u022a\u0001"+
		"\u0000\u0000\u0000\u022a\u022c\u0005\u0087\u0000\u0000\u022b\u0228\u0001"+
		"\u0000\u0000\u0000\u022b\u022c\u0001\u0000\u0000\u0000\u022c\u022d\u0001"+
		"\u0000\u0000\u0000\u022d\u022e\u0005\u0018\u0000\u0000\u022e\u022f\u0003"+
		",\u0016\u0000\u022f\u0231\u0005\u0019\u0000\u0000\u0230\u0232\u0003$\u0012"+
		"\u0000\u0231\u0230\u0001\u0000\u0000\u0000\u0231\u0232\u0001\u0000\u0000"+
		"\u0000\u0232\u0234\u0001\u0000\u0000\u0000\u0233\u0235\u0003*\u0015\u0000"+
		"\u0234\u0233\u0001\u0000\u0000\u0000\u0234\u0235\u0001\u0000\u0000\u0000"+
		"\u0235!\u0001\u0000\u0000\u0000\u0236\u023b\u0003\u01a0\u00d0\u0000\u0237"+
		"\u0238\u0005\u0016\u0000\u0000\u0238\u023a\u0003\u01a0\u00d0\u0000\u0239"+
		"\u0237\u0001\u0000\u0000\u0000\u023a\u023d\u0001\u0000\u0000\u0000\u023b"+
		"\u0239\u0001\u0000\u0000\u0000\u023b\u023c\u0001\u0000\u0000\u0000\u023c"+
		"#\u0001\u0000\u0000\u0000\u023d\u023b\u0001\u0000\u0000\u0000\u023e\u023f"+
		"\u0005\u00b4\u0000\u0000\u023f\u0240\u0007\u0000\u0000\u0000\u0240\u0241"+
		"\u0005a\u0000\u0000\u0241\u0242\u00058\u0000\u0000\u0242\u0243\u0003&"+
		"\u0013\u0000\u0243\u0244\u0005\u00b7\u0000\u0000\u0244\u0245\u0003\u01a0"+
		"\u00d0\u0000\u0245%\u0001\u0000\u0000\u0000\u0246\u024b\u0003(\u0014\u0000"+
		"\u0247\u0248\u0005\u0016\u0000\u0000\u0248\u024a\u0003(\u0014\u0000\u0249"+
		"\u0247\u0001\u0000\u0000\u0000\u024a\u024d\u0001\u0000\u0000\u0000\u024b"+
		"\u0249\u0001\u0000\u0000\u0000\u024b\u024c\u0001\u0000\u0000\u0000\u024c"+
		"\'\u0001\u0000\u0000\u0000\u024d\u024b\u0001\u0000\u0000\u0000\u024e\u0250"+
		"\u0003\u01a0\u00d0\u0000\u024f\u0251\u0003\u0086C\u0000\u0250\u024f\u0001"+
		"\u0000\u0000\u0000\u0250\u0251\u0001\u0000\u0000\u0000\u0251\u0253\u0001"+
		"\u0000\u0000\u0000\u0252\u0254\u0003\u0082A\u0000\u0253\u0252\u0001\u0000"+
		"\u0000\u0000\u0253\u0254\u0001\u0000\u0000\u0000\u0254)\u0001\u0000\u0000"+
		"\u0000\u0255\u0256\u0005G\u0000\u0000\u0256\u0257\u0003\"\u0011\u0000"+
		"\u0257\u0258\u0005\u00b7\u0000\u0000\u0258\u025e\u0003\u01a0\u00d0\u0000"+
		"\u0259\u025a\u0005\u00c2\u0000\u0000\u025a\u025b\u0003\u00ceg\u0000\u025b"+
		"\u025c\u0005K\u0000\u0000\u025c\u025d\u0003\u00ceg\u0000\u025d\u025f\u0001"+
		"\u0000\u0000\u0000\u025e\u0259\u0001\u0000\u0000\u0000\u025e\u025f\u0001"+
		"\u0000\u0000\u0000\u025f\u0262\u0001\u0000\u0000\u0000\u0260\u0261\u0005"+
		"\u00cc\u0000\u0000\u0261\u0263\u0003\u01a0\u00d0\u0000\u0262\u0260\u0001"+
		"\u0000\u0000\u0000\u0262\u0263\u0001\u0000\u0000\u0000\u0263+\u0001\u0000"+
		"\u0000\u0000\u0264\u0266\u0003\u001e\u000f\u0000\u0265\u0264\u0001\u0000"+
		"\u0000\u0000\u0265\u0266\u0001\u0000\u0000\u0000\u0266\u0267\u0001\u0000"+
		"\u0000\u0000\u0267\u0274\u0003.\u0017\u0000\u0268\u026a\u0003\u001e\u000f"+
		"\u0000\u0269\u0268\u0001\u0000\u0000\u0000\u0269\u026a\u0001\u0000\u0000"+
		"\u0000\u026a\u026b\u0001\u0000\u0000\u0000\u026b\u026f\u0003.\u0017\u0000"+
		"\u026c\u026d\u00030\u0018\u0000\u026d\u026e\u0003.\u0017\u0000\u026e\u0270"+
		"\u0001\u0000\u0000\u0000\u026f\u026c\u0001\u0000\u0000\u0000\u0270\u0271"+
		"\u0001\u0000\u0000\u0000\u0271\u026f\u0001\u0000\u0000\u0000\u0271\u0272"+
		"\u0001\u0000\u0000\u0000\u0272\u0274\u0001\u0000\u0000\u0000\u0273\u0265"+
		"\u0001\u0000\u0000\u0000\u0273\u0269\u0001\u0000\u0000\u0000\u0274-\u0001"+
		"\u0000\u0000\u0000\u0275\u0277\u00034\u001a\u0000\u0276\u0278\u00032\u0019"+
		"\u0000\u0277\u0276\u0001\u0000\u0000\u0000\u0277\u0278\u0001\u0000\u0000"+
		"\u0000\u0278\u0281\u0001\u0000\u0000\u0000\u0279\u027a\u0005\u0018\u0000"+
		"\u0000\u027a\u027b\u0003,\u0016\u0000\u027b\u027d\u0005\u0019\u0000\u0000"+
		"\u027c\u027e\u00032\u0019\u0000\u027d\u027c\u0001\u0000\u0000\u0000\u027d"+
		"\u027e\u0001\u0000\u0000\u0000\u027e\u0281\u0001\u0000\u0000\u0000\u027f"+
		"\u0281\u00032\u0019\u0000\u0280\u0275\u0001\u0000\u0000\u0000\u0280\u0279"+
		"\u0001\u0000\u0000\u0000\u0280\u027f\u0001\u0000\u0000\u0000\u0281/\u0001"+
		"\u0000\u0000\u0000\u0282\u0284\u0005\u00ca\u0000\u0000\u0283\u0285\u0005"+
		"/\u0000\u0000\u0284\u0283\u0001\u0000\u0000\u0000\u0284\u0285\u0001\u0000"+
		"\u0000\u0000\u0285\u028f\u0001\u0000\u0000\u0000\u0286\u0288\u0005t\u0000"+
		"\u0000\u0287\u0289\u0005/\u0000\u0000\u0288\u0287\u0001\u0000\u0000\u0000"+
		"\u0288\u0289\u0001\u0000\u0000\u0000\u0289\u028f\u0001\u0000\u0000\u0000"+
		"\u028a\u028c\u0005[\u0000\u0000\u028b\u028d\u0005/\u0000\u0000\u028c\u028b"+
		"\u0001\u0000\u0000\u0000\u028c\u028d\u0001\u0000\u0000\u0000\u028d\u028f"+
		"\u0001\u0000\u0000\u0000\u028e\u0282\u0001\u0000\u0000\u0000\u028e\u0286"+
		"\u0001\u0000\u0000\u0000\u028e\u028a\u0001\u0000\u0000\u0000\u028f1\u0001"+
		"\u0000\u0000\u0000\u0290\u0292\u0003|>\u0000\u0291\u0293\u0003\u008cF"+
		"\u0000\u0292\u0291\u0001\u0000\u0000\u0000\u0292\u0293\u0001\u0000\u0000"+
		"\u0000\u0293\u0295\u0001\u0000\u0000\u0000\u0294\u0296\u0003\u008eG\u0000"+
		"\u0295\u0294\u0001\u0000\u0000\u0000\u0295\u0296\u0001\u0000\u0000\u0000"+
		"\u0296\u0298\u0001\u0000\u0000\u0000\u0297\u0299\u0003\u0090H\u0000\u0298"+
		"\u0297\u0001\u0000\u0000\u0000\u0298\u0299\u0001\u0000\u0000\u0000\u0299"+
		"3\u0001\u0000\u0000\u0000\u029a\u029c\u0003L&\u0000\u029b\u029d\u0003"+
		"6\u001b\u0000\u029c\u029b\u0001\u0000\u0000\u0000\u029c\u029d\u0001\u0000"+
		"\u0000\u0000\u029d\u029f\u0001\u0000\u0000\u0000\u029e\u02a0\u0003\u0098"+
		"L\u0000\u029f\u029e\u0001\u0000\u0000\u0000\u029f\u02a0\u0001\u0000\u0000"+
		"\u0000\u02a0\u02a5\u0001\u0000\u0000\u0000\u02a1\u02a3\u0003v;\u0000\u02a2"+
		"\u02a4\u0003z=\u0000\u02a3\u02a2\u0001\u0000\u0000\u0000\u02a3\u02a4\u0001"+
		"\u0000\u0000\u0000\u02a4\u02a6\u0001\u0000\u0000\u0000\u02a5\u02a1\u0001"+
		"\u0000\u0000\u0000\u02a5\u02a6\u0001\u0000\u0000\u0000\u02a6\u02b6\u0001"+
		"\u0000\u0000\u0000\u02a7\u02a9\u00036\u001b\u0000\u02a8\u02aa\u0003\u0098"+
		"L\u0000\u02a9\u02a8\u0001\u0000\u0000\u0000\u02a9\u02aa\u0001\u0000\u0000"+
		"\u0000\u02aa\u02af\u0001\u0000\u0000\u0000\u02ab\u02ad\u0003v;\u0000\u02ac"+
		"\u02ae\u0003z=\u0000\u02ad\u02ac\u0001\u0000\u0000\u0000\u02ad\u02ae\u0001"+
		"\u0000\u0000\u0000\u02ae\u02b0\u0001\u0000\u0000\u0000\u02af\u02ab\u0001"+
		"\u0000\u0000\u0000\u02af\u02b0\u0001\u0000\u0000\u0000\u02b0\u02b2\u0001"+
		"\u0000\u0000\u0000\u02b1\u02b3\u0003L&\u0000\u02b2\u02b1\u0001\u0000\u0000"+
		"\u0000\u02b2\u02b3\u0001\u0000\u0000\u0000\u02b3\u02b6\u0001\u0000\u0000"+
		"\u0000\u02b4\u02b6\u0003\u0098L\u0000\u02b5\u029a\u0001\u0000\u0000\u0000"+
		"\u02b5\u02a7\u0001\u0000\u0000\u0000\u02b5\u02b4\u0001\u0000\u0000\u0000"+
		"\u02b65\u0001\u0000\u0000\u0000\u02b7\u02b8\u0005e\u0000\u0000\u02b8\u02bd"+
		"\u00038\u001c\u0000\u02b9\u02ba\u0005\u0016\u0000\u0000\u02ba\u02bc\u0003"+
		"8\u001c\u0000\u02bb\u02b9\u0001\u0000\u0000\u0000\u02bc\u02bf\u0001\u0000"+
		"\u0000\u0000\u02bd\u02bb\u0001\u0000\u0000\u0000\u02bd\u02be\u0001\u0000"+
		"\u0000\u0000\u02be7\u0001\u0000\u0000\u0000\u02bf\u02bd\u0001\u0000\u0000"+
		"\u0000\u02c0\u02c6\u0003:\u001d\u0000\u02c1\u02c5\u0003D\"\u0000\u02c2"+
		"\u02c5\u0003@ \u0000\u02c3\u02c5\u0003B!\u0000\u02c4\u02c1\u0001\u0000"+
		"\u0000\u0000\u02c4\u02c2\u0001\u0000\u0000\u0000\u02c4\u02c3\u0001\u0000"+
		"\u0000\u0000\u02c5\u02c8\u0001\u0000\u0000\u0000\u02c6\u02c4\u0001\u0000"+
		"\u0000\u0000\u02c6\u02c7\u0001\u0000\u0000\u0000\u02c79\u0001\u0000\u0000"+
		"\u0000\u02c8\u02c6\u0001\u0000\u0000\u0000\u02c9\u02cb\u0003<\u001e\u0000"+
		"\u02ca\u02cc\u0003>\u001f\u0000\u02cb\u02ca\u0001\u0000\u0000\u0000\u02cb"+
		"\u02cc\u0001\u0000\u0000\u0000\u02cc\u02d4\u0001\u0000\u0000\u0000\u02cd"+
		"\u02ce\u0005\u0018\u0000\u0000\u02ce\u02cf\u0003\u0004\u0002\u0000\u02cf"+
		"\u02d1\u0005\u0019\u0000\u0000\u02d0\u02d2\u0003>\u001f\u0000\u02d1\u02d0"+
		"\u0001\u0000\u0000\u0000\u02d1\u02d2\u0001\u0000\u0000\u0000\u02d2\u02d4"+
		"\u0001\u0000\u0000\u0000\u02d3\u02c9\u0001\u0000\u0000\u0000\u02d3\u02cd"+
		"\u0001\u0000\u0000\u0000\u02d4;\u0001\u0000\u0000\u0000\u02d5\u02da\u0003"+
		"\u01a0\u00d0\u0000\u02d6\u02d7\u0005\u0017\u0000\u0000\u02d7\u02d9\u0003"+
		"\u01a0\u00d0\u0000\u02d8\u02d6\u0001\u0000\u0000\u0000\u02d9\u02dc\u0001"+
		"\u0000\u0000\u0000\u02da\u02d8\u0001\u0000\u0000\u0000\u02da\u02db\u0001"+
		"\u0000\u0000\u0000\u02db=\u0001\u0000\u0000\u0000\u02dc\u02da\u0001\u0000"+
		"\u0000\u0000\u02dd\u02de\u00052\u0000\u0000\u02de\u02e1\u0003\u01a0\u00d0"+
		"\u0000\u02df\u02e1\u0003\u019e\u00cf\u0000\u02e0\u02dd\u0001\u0000\u0000"+
		"\u0000\u02e0\u02df\u0001\u0000\u0000\u0000\u02e1?\u0001\u0000\u0000\u0000"+
		"\u02e2\u02e3\u0005@\u0000\u0000\u02e3\u02e4\u0005w\u0000\u0000\u02e4\u02e6"+
		"\u0003<\u001e\u0000\u02e5\u02e7\u0003>\u001f\u0000\u02e6\u02e5\u0001\u0000"+
		"\u0000\u0000\u02e6\u02e7\u0001\u0000\u0000\u0000\u02e7A\u0001\u0000\u0000"+
		"\u0000\u02e8\u02e9\u0005\u0016\u0000\u0000\u02e9\u02ea\u0005n\u0000\u0000"+
		"\u02ea\u02eb\u0005\u0018\u0000\u0000\u02eb\u02ec\u0003f3\u0000\u02ec\u02ee"+
		"\u0005\u0019\u0000\u0000\u02ed\u02ef\u0003>\u001f\u0000\u02ee\u02ed\u0001"+
		"\u0000\u0000\u0000\u02ee\u02ef\u0001\u0000\u0000\u0000\u02efC\u0001\u0000"+
		"\u0000\u0000\u02f0\u02f1\u0003F#\u0000\u02f1\u02f3\u0005w\u0000\u0000"+
		"\u02f2\u02f4\u0005_\u0000\u0000\u02f3\u02f2\u0001\u0000\u0000\u0000\u02f3"+
		"\u02f4\u0001\u0000\u0000\u0000\u02f4\u02f5\u0001\u0000\u0000\u0000\u02f5"+
		"\u02f7\u0003H$\u0000\u02f6\u02f8\u0003J%\u0000\u02f7\u02f6\u0001\u0000"+
		"\u0000\u0000\u02f7\u02f8\u0001\u0000\u0000\u0000\u02f8E\u0001\u0000\u0000"+
		"\u0000\u02f9\u02fb\u0005q\u0000\u0000\u02fa\u02f9\u0001\u0000\u0000\u0000"+
		"\u02fa\u02fb\u0001\u0000\u0000\u0000\u02fb\u0303\u0001\u0000\u0000\u0000"+
		"\u02fc\u02fe\u0007\u0001\u0000\u0000\u02fd\u02fc\u0001\u0000\u0000\u0000"+
		"\u02fd\u02fe\u0001\u0000\u0000\u0000\u02fe\u0300\u0001\u0000\u0000\u0000"+
		"\u02ff\u0301\u0005\u00a3\u0000\u0000\u0300\u02ff\u0001\u0000\u0000\u0000"+
		"\u0300\u0301\u0001\u0000\u0000\u0000\u0301\u0303\u0001\u0000\u0000\u0000"+
		"\u0302\u02fa\u0001\u0000\u0000\u0000\u0302\u02fd\u0001\u0000\u0000\u0000"+
		"\u0303G\u0001\u0000\u0000\u0000\u0304\u0306\u0003f3\u0000\u0305\u0307"+
		"\u0003>\u001f\u0000\u0306\u0305\u0001\u0000\u0000\u0000\u0306\u0307\u0001"+
		"\u0000\u0000\u0000\u0307\u0312\u0001\u0000\u0000\u0000\u0308\u030a\u0005"+
		"{\u0000\u0000\u0309\u0308\u0001\u0000\u0000\u0000\u0309\u030a\u0001\u0000"+
		"\u0000\u0000\u030a\u030b\u0001\u0000\u0000\u0000\u030b\u030c\u0005\u0018"+
		"\u0000\u0000\u030c\u030d\u0003\u0004\u0002\u0000\u030d\u030f\u0005\u0019"+
		"\u0000\u0000\u030e\u0310\u0003>\u001f\u0000\u030f\u030e\u0001\u0000\u0000"+
		"\u0000\u030f\u0310\u0001\u0000\u0000\u0000\u0310\u0312\u0001\u0000\u0000"+
		"\u0000\u0311\u0304\u0001\u0000\u0000\u0000\u0311\u0309\u0001\u0000\u0000"+
		"\u0000\u0312I\u0001\u0000\u0000\u0000\u0313\u0314\u0007\u0002\u0000\u0000"+
		"\u0314\u0315\u0003\u009aM\u0000\u0315K\u0001\u0000\u0000\u0000\u0316\u0318"+
		"\u0005\u00b6\u0000\u0000\u0317\u0319\u0005O\u0000\u0000\u0318\u0317\u0001"+
		"\u0000\u0000\u0000\u0318\u0319\u0001\u0000\u0000\u0000\u0319\u031a\u0001"+
		"\u0000\u0000\u0000\u031a\u031b\u0003N\'\u0000\u031bM\u0001\u0000\u0000"+
		"\u0000\u031c\u0321\u0003P(\u0000\u031d\u031e\u0005\u0016\u0000\u0000\u031e"+
		"\u0320\u0003P(\u0000\u031f\u031d\u0001\u0000\u0000\u0000\u0320\u0323\u0001"+
		"\u0000\u0000\u0000\u0321\u031f\u0001\u0000\u0000\u0000\u0321\u0322\u0001"+
		"\u0000\u0000\u0000\u0322O\u0001\u0000\u0000\u0000\u0323\u0321\u0001\u0000"+
		"\u0000\u0000\u0324\u0326\u0003R)\u0000\u0325\u0327\u0003>\u001f\u0000"+
		"\u0326\u0325\u0001\u0000\u0000\u0000\u0326\u0327\u0001\u0000\u0000\u0000"+
		"\u0327Q\u0001\u0000\u0000\u0000\u0328\u032d\u0003V+\u0000\u0329\u032d"+
		"\u0003T*\u0000\u032a\u032d\u0003`0\u0000\u032b\u032d\u0003\u00a6S\u0000"+
		"\u032c\u0328\u0001\u0000\u0000\u0000\u032c\u0329\u0001\u0000\u0000\u0000"+
		"\u032c\u032a\u0001\u0000\u0000\u0000\u032c\u032b\u0001\u0000\u0000\u0000"+
		"\u032dS\u0001\u0000\u0000\u0000\u032e\u032f\u0005V\u0000\u0000\u032f\u0330"+
		"\u0005\u0018\u0000\u0000\u0330\u0331\u0003f3\u0000\u0331\u0332\u0005\u0019"+
		"\u0000\u0000\u0332U\u0001\u0000\u0000\u0000\u0333\u0334\u0005\u0094\u0000"+
		"\u0000\u0334\u0335\u0003X,\u0000\u0335\u0336\u0005\u0018\u0000\u0000\u0336"+
		"\u0337\u0003Z-\u0000\u0337\u0338\u0005\u0019\u0000\u0000\u0338W\u0001"+
		"\u0000\u0000\u0000\u0339\u033d\u0005\u0080\u0000\u0000\u033a\u033d\u0005"+
		"\u0086\u0000\u0000\u033b\u033d\u0003b1\u0000\u033c\u0339\u0001\u0000\u0000"+
		"\u0000\u033c\u033a\u0001\u0000\u0000\u0000\u033c\u033b\u0001\u0000\u0000"+
		"\u0000\u033dY\u0001\u0000\u0000\u0000\u033e\u0343\u0003\\.\u0000\u033f"+
		"\u0340\u0005\u0016\u0000\u0000\u0340\u0342\u0003\\.\u0000\u0341\u033f"+
		"\u0001\u0000\u0000\u0000\u0342\u0345\u0001\u0000\u0000\u0000\u0343\u0341"+
		"\u0001\u0000\u0000\u0000\u0343\u0344\u0001\u0000\u0000\u0000\u0344[\u0001"+
		"\u0000\u0000\u0000\u0345\u0343\u0001\u0000\u0000\u0000\u0346\u0348\u0003"+
		"^/\u0000\u0347\u0349\u0003>\u001f\u0000\u0348\u0347\u0001\u0000\u0000"+
		"\u0000\u0348\u0349\u0001\u0000\u0000\u0000\u0349]\u0001\u0000\u0000\u0000"+
		"\u034a\u034d\u0003\u00a6S\u0000\u034b\u034d\u0003V+\u0000\u034c\u034a"+
		"\u0001\u0000\u0000\u0000\u034c\u034b\u0001\u0000\u0000\u0000\u034d_\u0001"+
		"\u0000\u0000\u0000\u034e\u034f\u0005\u009a\u0000\u0000\u034f\u0350\u0005"+
		"\u0018\u0000\u0000\u0350\u0351\u0003\u01a0\u00d0\u0000\u0351\u0352\u0005"+
		"\u0019\u0000\u0000\u0352a\u0001\u0000\u0000\u0000\u0353\u0357\u0003\u01a0"+
		"\u00d0\u0000\u0354\u0356\u0003d2\u0000\u0355\u0354\u0001\u0000\u0000\u0000"+
		"\u0356\u0359\u0001\u0000\u0000\u0000\u0357\u0355\u0001\u0000\u0000\u0000"+
		"\u0357\u0358\u0001\u0000\u0000\u0000\u0358c\u0001\u0000\u0000\u0000\u0359"+
		"\u0357\u0001\u0000\u0000\u0000\u035a\u035b\u0005\u0017\u0000\u0000\u035b"+
		"\u035c\u0003\u01a0\u00d0\u0000\u035ce\u0001\u0000\u0000\u0000\u035d\u035f"+
		"\u0003j5\u0000\u035e\u0360\u0003h4\u0000\u035f\u035e\u0001\u0000\u0000"+
		"\u0000\u035f\u0360\u0001\u0000\u0000\u0000\u0360\u0363\u0001\u0000\u0000"+
		"\u0000\u0361\u0363\u0003l6\u0000\u0362\u035d\u0001\u0000\u0000\u0000\u0362"+
		"\u0361\u0001\u0000\u0000\u0000\u0363g\u0001\u0000\u0000\u0000\u0364\u0365"+
		"\u0005\u0017\u0000\u0000\u0365\u0366\u0003b1\u0000\u0366i\u0001\u0000"+
		"\u0000\u0000\u0367\u036e\u0003p8\u0000\u0368\u036e\u0003r9\u0000\u0369"+
		"\u036e\u0003t:\u0000\u036a\u036b\u0003b1\u0000\u036b\u036c\u0003n7\u0000"+
		"\u036c\u036e\u0001\u0000\u0000\u0000\u036d\u0367\u0001\u0000\u0000\u0000"+
		"\u036d\u0368\u0001\u0000\u0000\u0000\u036d\u0369\u0001\u0000\u0000\u0000"+
		"\u036d\u036a\u0001\u0000\u0000\u0000\u036ek\u0001\u0000\u0000\u0000\u036f"+
		"\u0371\u0003b1\u0000\u0370\u0372\u0003n7\u0000\u0371\u0370\u0001\u0000"+
		"\u0000\u0000\u0371\u0372\u0001\u0000\u0000\u0000\u0372m\u0001\u0000\u0000"+
		"\u0000\u0373\u0374\u0005\u001a\u0000\u0000\u0374\u0375\u0003\u00a2Q\u0000"+
		"\u0375\u0378\u0005\u001b\u0000\u0000\u0376\u0377\u0005\u0017\u0000\u0000"+
		"\u0377\u0379\u0003l6\u0000\u0378\u0376\u0001\u0000\u0000\u0000\u0378\u0379"+
		"\u0001\u0000\u0000\u0000\u0379o\u0001\u0000\u0000\u0000\u037a\u037b\u0005"+
		"\u00c4\u0000\u0000\u037b\u037c\u0005\u0018\u0000\u0000\u037c\u037d\u0003"+
		"f3\u0000\u037d\u037e\u00052\u0000\u0000\u037e\u037f\u0003b1\u0000\u037f"+
		"\u0381\u0005\u0019\u0000\u0000\u0380\u0382\u0003h4\u0000\u0381\u0380\u0001"+
		"\u0000\u0000\u0000\u0381\u0382\u0001\u0000\u0000\u0000\u0382q\u0001\u0000"+
		"\u0000\u0000\u0383\u0384\u0003\u00aaU\u0000\u0384\u0385\u0005\u0018\u0000"+
		"\u0000\u0385\u0386\u0003f3\u0000\u0386\u0388\u0005\u0019\u0000\u0000\u0387"+
		"\u0389\u0003h4\u0000\u0388\u0387\u0001\u0000\u0000\u0000\u0388\u0389\u0001"+
		"\u0000\u0000\u0000\u0389s\u0001\u0000\u0000\u0000\u038a\u038b\u0003\u00ac"+
		"V\u0000\u038b\u038c\u0005\u0018\u0000\u0000\u038c\u038d\u0003f3\u0000"+
		"\u038d\u038f\u0005\u0019\u0000\u0000\u038e\u0390\u0003h4\u0000\u038f\u038e"+
		"\u0001\u0000\u0000\u0000\u038f\u0390\u0001\u0000\u0000\u0000\u0390u\u0001"+
		"\u0000\u0000\u0000\u0391\u0392\u0005h\u0000\u0000\u0392\u0393\u00058\u0000"+
		"\u0000\u0393\u0398\u0003x<\u0000\u0394\u0395\u0005\u0016\u0000\u0000\u0395"+
		"\u0397\u0003x<\u0000\u0396\u0394\u0001\u0000\u0000\u0000\u0397\u039a\u0001"+
		"\u0000\u0000\u0000\u0398\u0396\u0001\u0000\u0000\u0000\u0398\u0399\u0001"+
		"\u0000\u0000\u0000\u0399w\u0001\u0000\u0000\u0000\u039a\u0398\u0001\u0000"+
		"\u0000\u0000\u039b\u039f\u0003\u01a0\u00d0\u0000\u039c\u039f\u0005\u0003"+
		"\u0000\u0000\u039d\u039f\u0003\u00a2Q\u0000\u039e\u039b\u0001\u0000\u0000"+
		"\u0000\u039e\u039c\u0001\u0000\u0000\u0000\u039e\u039d\u0001\u0000\u0000"+
		"\u0000\u039fy\u0001\u0000\u0000\u0000\u03a0\u03a1\u0005j\u0000\u0000\u03a1"+
		"\u03a2\u0003\u009aM\u0000\u03a2{\u0001\u0000\u0000\u0000\u03a3\u03a4\u0005"+
		"\u00a1\u0000\u0000\u03a4\u03a5\u00058\u0000\u0000\u03a5\u03aa\u0003\u0080"+
		"@\u0000\u03a6\u03a7\u0005\u0016\u0000\u0000\u03a7\u03a9\u0003\u0080@\u0000"+
		"\u03a8\u03a6\u0001\u0000\u0000\u0000\u03a9\u03ac\u0001\u0000\u0000\u0000"+
		"\u03aa\u03a8\u0001\u0000\u0000\u0000\u03aa\u03ab\u0001\u0000\u0000\u0000"+
		"\u03ab}\u0001\u0000\u0000\u0000\u03ac\u03aa\u0001\u0000\u0000\u0000\u03ad"+
		"\u03b2\u0003\u0080@\u0000\u03ae\u03af\u0005\u0016\u0000\u0000\u03af\u03b1"+
		"\u0003\u0080@\u0000\u03b0\u03ae\u0001\u0000\u0000\u0000\u03b1\u03b4\u0001"+
		"\u0000\u0000\u0000\u03b2\u03b0\u0001\u0000\u0000\u0000\u03b2\u03b3\u0001"+
		"\u0000\u0000\u0000\u03b3\u007f\u0001\u0000\u0000\u0000\u03b4\u03b2\u0001"+
		"\u0000\u0000\u0000\u03b5\u03b7\u0003\u0084B\u0000\u03b6\u03b8\u0003\u0086"+
		"C\u0000\u03b7\u03b6\u0001\u0000\u0000\u0000\u03b7\u03b8\u0001\u0000\u0000"+
		"\u0000\u03b8\u03ba\u0001\u0000\u0000\u0000\u03b9\u03bb\u0003\u0082A\u0000"+
		"\u03ba\u03b9\u0001\u0000\u0000\u0000\u03ba\u03bb\u0001\u0000\u0000\u0000"+
		"\u03bb\u0081\u0001\u0000\u0000\u0000\u03bc\u03bd\u0005\u0099\u0000\u0000"+
		"\u03bd\u03be\u0007\u0003\u0000\u0000\u03be\u0083\u0001\u0000\u0000\u0000"+
		"\u03bf\u03c3\u0003\u01a0\u00d0\u0000\u03c0\u03c3\u0005\u0003\u0000\u0000"+
		"\u03c1\u03c3\u0003\u00a2Q\u0000\u03c2\u03bf\u0001\u0000\u0000\u0000\u03c2"+
		"\u03c0\u0001\u0000\u0000\u0000\u03c2\u03c1\u0001\u0000\u0000\u0000\u03c3"+
		"\u0085\u0001\u0000\u0000\u0000\u03c4\u03c5\u0007\u0004\u0000\u0000\u03c5"+
		"\u0087\u0001\u0000\u0000\u0000\u03c6\u03c7\u0005;\u0000\u0000\u03c7\u03c8"+
		"\u0005\u0018\u0000\u0000\u03c8\u03c9\u0003\u00a2Q\u0000\u03c9\u03ca\u0005"+
		"2\u0000\u0000\u03ca\u03cb\u0003\u008aE\u0000\u03cb\u03cc\u0005\u0019\u0000"+
		"\u0000\u03cc\u0089\u0001\u0000\u0000\u0000\u03cd\u03ce\u0003b1\u0000\u03ce"+
		"\u008b\u0001\u0000\u0000\u0000\u03cf\u03d0\u0005\u007f\u0000\u0000\u03d0"+
		"\u03d1\u0003\u0094J\u0000\u03d1\u008d\u0001\u0000\u0000\u0000\u03d2\u03d3"+
		"\u0005\u009c\u0000\u0000\u03d3\u03d5\u0003\u0094J\u0000\u03d4\u03d6\u0007"+
		"\u0005\u0000\u0000\u03d5\u03d4\u0001\u0000\u0000\u0000\u03d5\u03d6\u0001"+
		"\u0000\u0000\u0000\u03d6\u008f\u0001\u0000\u0000\u0000\u03d7\u03d8\u0005"+
		"_\u0000\u0000\u03d8\u03d9\u0007\u0006\u0000\u0000\u03d9\u03da\u0003\u0092"+
		"I\u0000\u03da\u03de\u0007\u0005\u0000\u0000\u03db\u03df\u0005\u009f\u0000"+
		"\u0000\u03dc\u03dd\u0005\u00d2\u0000\u0000\u03dd\u03df\u0005\u00bd\u0000"+
		"\u0000\u03de\u03db\u0001\u0000\u0000\u0000\u03de\u03dc\u0001\u0000\u0000"+
		"\u0000\u03df\u0091\u0001\u0000\u0000\u0000\u03e0\u03e5\u0003\u0094J\u0000"+
		"\u03e1\u03e2\u0003\u0096K\u0000\u03e2\u03e3\u0005\u00a9\u0000\u0000\u03e3"+
		"\u03e5\u0001\u0000\u0000\u0000\u03e4\u03e0\u0001\u0000\u0000\u0000\u03e4"+
		"\u03e1\u0001\u0000\u0000\u0000\u03e5\u0093\u0001\u0000\u0000\u0000\u03e6"+
		"\u03e9\u0003\u0112\u0089\u0000\u03e7\u03e9\u0005\u0003\u0000\u0000\u03e8"+
		"\u03e6\u0001\u0000\u0000\u0000\u03e8\u03e7\u0001\u0000\u0000\u0000\u03e9"+
		"\u0095\u0001\u0000\u0000\u0000\u03ea\u03f0\u0003\u0112\u0089\u0000\u03eb"+
		"\u03f0\u0005\u0003\u0000\u0000\u03ec\u03f0\u0005\u0004\u0000\u0000\u03ed"+
		"\u03f0\u0005\u0005\u0000\u0000\u03ee\u03f0\u0005\u0006\u0000\u0000\u03ef"+
		"\u03ea\u0001\u0000\u0000\u0000\u03ef\u03eb\u0001\u0000\u0000\u0000\u03ef"+
		"\u03ec\u0001\u0000\u0000\u0000\u03ef\u03ed\u0001\u0000\u0000\u0000\u03ef"+
		"\u03ee\u0001\u0000\u0000\u0000\u03f0\u0097\u0001\u0000\u0000\u0000\u03f1"+
		"\u03f2\u0005\u00d1\u0000\u0000\u03f2\u03f3\u0003\u009aM\u0000\u03f3\u0099"+
		"\u0001\u0000\u0000\u0000\u03f4\u03f5\u0006M\uffff\uffff\u0000\u03f5\u03f6"+
		"\u0005\u0018\u0000\u0000\u03f6\u03f7\u0003\u009aM\u0000\u03f7\u03f8\u0005"+
		"\u0019\u0000\u0000\u03f8\u0451\u0001\u0000\u0000\u0000\u03f9\u03fa\u0003"+
		"\u00a2Q\u0000\u03fa\u03fc\u0005v\u0000\u0000\u03fb\u03fd\u0005\u0097\u0000"+
		"\u0000\u03fc\u03fb\u0001\u0000\u0000\u0000\u03fc\u03fd\u0001\u0000\u0000"+
		"\u0000\u03fd\u03fe\u0001\u0000\u0000\u0000\u03fe\u03ff\u0005\u00d9\u0000"+
		"\u0000\u03ff\u0451\u0001\u0000\u0000\u0000\u0400\u0401\u0003\u00a2Q\u0000"+
		"\u0401\u0403\u0005v\u0000\u0000\u0402\u0404\u0005\u0097\u0000\u0000\u0403"+
		"\u0402\u0001\u0000\u0000\u0000\u0403\u0404\u0001\u0000\u0000\u0000\u0404"+
		"\u0405\u0001\u0000\u0000\u0000\u0405\u0406\u0005T\u0000\u0000\u0406\u0451"+
		"\u0001\u0000\u0000\u0000\u0407\u0408\u0003\u00a2Q\u0000\u0408\u040a\u0005"+
		"v\u0000\u0000\u0409\u040b\u0005\u0097\u0000\u0000\u040a\u0409\u0001\u0000"+
		"\u0000\u0000\u040a\u040b\u0001\u0000\u0000\u0000\u040b\u040c\u0001\u0000"+
		"\u0000\u0000\u040c\u040d\u0005\u00d7\u0000\u0000\u040d\u0451\u0001\u0000"+
		"\u0000\u0000\u040e\u040f\u0003\u00a2Q\u0000\u040f\u0411\u0005v\u0000\u0000"+
		"\u0410\u0412\u0005\u0097\u0000\u0000\u0411\u0410\u0001\u0000\u0000\u0000"+
		"\u0411\u0412\u0001\u0000\u0000\u0000\u0412\u0413\u0001\u0000\u0000\u0000"+
		"\u0413\u0414\u0005\u00d8\u0000\u0000\u0414\u0451\u0001\u0000\u0000\u0000"+
		"\u0415\u0416\u0003\u00a2Q\u0000\u0416\u0418\u0005v\u0000\u0000\u0417\u0419"+
		"\u0005\u0097\u0000\u0000\u0418\u0417\u0001\u0000\u0000\u0000\u0418\u0419"+
		"\u0001\u0000\u0000\u0000\u0419\u041a\u0001\u0000\u0000\u0000\u041a\u041b"+
		"\u0005O\u0000\u0000\u041b\u041c\u0005e\u0000\u0000\u041c\u041d\u0003\u00a2"+
		"Q\u0000\u041d\u0451\u0001\u0000\u0000\u0000\u041e\u0420\u0003\u00a2Q\u0000"+
		"\u041f\u0421\u0005\u0097\u0000\u0000\u0420\u041f\u0001\u0000\u0000\u0000"+
		"\u0420\u0421\u0001\u0000\u0000\u0000\u0421\u0422\u0001\u0000\u0000\u0000"+
		"\u0422\u0424\u0005\u008b\u0000\u0000\u0423\u0425\u0005\u009b\u0000\u0000"+
		"\u0424\u0423\u0001\u0000\u0000\u0000\u0424\u0425\u0001\u0000\u0000\u0000"+
		"\u0425\u0426\u0001\u0000\u0000\u0000\u0426\u0427\u0003f3\u0000\u0427\u0451"+
		"\u0001\u0000\u0000\u0000\u0428\u042a\u0003\u00a2Q\u0000\u0429\u042b\u0005"+
		"\u0097\u0000\u0000\u042a\u0429\u0001\u0000\u0000\u0000\u042a\u042b\u0001"+
		"\u0000\u0000\u0000\u042b\u042c\u0001\u0000\u0000\u0000\u042c\u042d\u0005"+
		"n\u0000\u0000\u042d\u042e\u0003\u009eO\u0000\u042e\u0451\u0001\u0000\u0000"+
		"\u0000\u042f\u0431\u0003\u00a2Q\u0000\u0430\u0432\u0005\u0097\u0000\u0000"+
		"\u0431\u0430\u0001\u0000\u0000\u0000\u0431\u0432\u0001\u0000\u0000\u0000"+
		"\u0432\u0433\u0001\u0000\u0000\u0000\u0433\u0434\u00055\u0000\u0000\u0434"+
		"\u0435\u0003\u00a2Q\u0000\u0435\u0436\u00050\u0000\u0000\u0436\u0437\u0003"+
		"\u00a2Q\u0000\u0437\u0451\u0001\u0000\u0000\u0000\u0438\u043a\u0003\u00a2"+
		"Q\u0000\u0439\u043b\u0005\u0097\u0000\u0000\u043a\u0439\u0001\u0000\u0000"+
		"\u0000\u043a\u043b\u0001\u0000\u0000\u0000\u043b\u043c\u0001\u0000\u0000"+
		"\u0000\u043c\u043d\u0007\u0007\u0000\u0000\u043d\u043f\u0003\u00a2Q\u0000"+
		"\u043e\u0440\u0003\u00a0P\u0000\u043f\u043e\u0001\u0000\u0000\u0000\u043f"+
		"\u0440\u0001\u0000\u0000\u0000\u0440\u0451\u0001\u0000\u0000\u0000\u0441"+
		"\u0442\u0003\u00a2Q\u0000\u0442\u0443\u0003\u009cN\u0000\u0443\u0444\u0003"+
		"\u00a2Q\u0000\u0444\u0451\u0001\u0000\u0000\u0000\u0445\u0446\u0005]\u0000"+
		"\u0000\u0446\u0447\u0003\u00a8T\u0000\u0447\u0448\u0005\u0018\u0000\u0000"+
		"\u0448\u0449\u0003b1\u0000\u0449\u044a\u0005\u0019\u0000\u0000\u044a\u0451"+
		"\u0001\u0000\u0000\u0000\u044b\u044c\u0005]\u0000\u0000\u044c\u0451\u0003"+
		"\u00a2Q\u0000\u044d\u044e\u0005\u0097\u0000\u0000\u044e\u0451\u0003\u009a"+
		"M\u0004\u044f\u0451\u0003\u00a2Q\u0000\u0450\u03f4\u0001\u0000\u0000\u0000"+
		"\u0450\u03f9\u0001\u0000\u0000\u0000\u0450\u0400\u0001\u0000\u0000\u0000"+
		"\u0450\u0407\u0001\u0000\u0000\u0000\u0450\u040e\u0001\u0000\u0000\u0000"+
		"\u0450\u0415\u0001\u0000\u0000\u0000\u0450\u041e\u0001\u0000\u0000\u0000"+
		"\u0450\u0428\u0001\u0000\u0000\u0000\u0450\u042f\u0001\u0000\u0000\u0000"+
		"\u0450\u0438\u0001\u0000\u0000\u0000\u0450\u0441\u0001\u0000\u0000\u0000"+
		"\u0450\u0445\u0001\u0000\u0000\u0000\u0450\u044b\u0001\u0000\u0000\u0000"+
		"\u0450\u044d\u0001\u0000\u0000\u0000\u0450\u044f\u0001\u0000\u0000\u0000"+
		"\u0451\u045a\u0001\u0000\u0000\u0000\u0452\u0453\n\u0003\u0000\u0000\u0453"+
		"\u0454\u00050\u0000\u0000\u0454\u0459\u0003\u009aM\u0004\u0455\u0456\n"+
		"\u0002\u0000\u0000\u0456\u0457\u0005\u00a0\u0000\u0000\u0457\u0459\u0003"+
		"\u009aM\u0003\u0458\u0452\u0001\u0000\u0000\u0000\u0458\u0455\u0001\u0000"+
		"\u0000\u0000\u0459\u045c\u0001\u0000\u0000\u0000\u045a\u0458\u0001\u0000"+
		"\u0000\u0000\u045a\u045b\u0001\u0000\u0000\u0000\u045b\u009b\u0001\u0000"+
		"\u0000\u0000\u045c\u045a\u0001\u0000\u0000\u0000\u045d\u045e\u0007\b\u0000"+
		"\u0000\u045e\u009d\u0001\u0000\u0000\u0000\u045f\u0460\u0003\u00a8T\u0000"+
		"\u0460\u0461\u0005\u0018\u0000\u0000\u0461\u0462\u0003b1\u0000\u0462\u0463"+
		"\u0005\u0019\u0000\u0000\u0463\u0476\u0001\u0000\u0000\u0000\u0464\u046d"+
		"\u0005\u0018\u0000\u0000\u0465\u046a\u0003\u00a6S\u0000\u0466\u0467\u0005"+
		"\u0016\u0000\u0000\u0467\u0469\u0003\u00a6S\u0000\u0468\u0466\u0001\u0000"+
		"\u0000\u0000\u0469\u046c\u0001\u0000\u0000\u0000\u046a\u0468\u0001\u0000"+
		"\u0000\u0000\u046a\u046b\u0001\u0000\u0000\u0000\u046b\u046e\u0001\u0000"+
		"\u0000\u0000\u046c\u046a\u0001\u0000\u0000\u0000\u046d\u0465\u0001\u0000"+
		"\u0000\u0000\u046d\u046e\u0001\u0000\u0000\u0000\u046e\u046f\u0001\u0000"+
		"\u0000\u0000\u046f\u0476\u0005\u0019\u0000\u0000\u0470\u0471\u0005\u0018"+
		"\u0000\u0000\u0471\u0472\u0003\u0004\u0002\u0000\u0472\u0473\u0005\u0019"+
		"\u0000\u0000\u0473\u0476\u0001\u0000\u0000\u0000\u0474\u0476\u0003\u0112"+
		"\u0089\u0000\u0475\u045f\u0001\u0000\u0000\u0000\u0475\u0464\u0001\u0000"+
		"\u0000\u0000\u0475\u0470\u0001\u0000\u0000\u0000\u0475\u0474\u0001\u0000"+
		"\u0000\u0000\u0476\u009f\u0001\u0000\u0000\u0000\u0477\u047b\u0005Y\u0000"+
		"\u0000\u0478\u047c\u0005\n\u0000\u0000\u0479\u047c\u0005\u000b\u0000\u0000"+
		"\u047a\u047c\u0003\u0112\u0089\u0000\u047b\u0478\u0001\u0000\u0000\u0000"+
		"\u047b\u0479\u0001\u0000\u0000\u0000\u047b\u047a\u0001\u0000\u0000\u0000"+
		"\u047c\u00a1\u0001\u0000\u0000\u0000\u047d\u047e\u0006Q\uffff\uffff\u0000"+
		"\u047e\u047f\u0005\u0018\u0000\u0000\u047f\u0480\u0003\u00a2Q\u0000\u0480"+
		"\u0481\u0005\u0019\u0000\u0000\u0481\u0498\u0001\u0000\u0000\u0000\u0482"+
		"\u0483\u0005\u0018\u0000\u0000\u0483\u0486\u0003\u00a6S\u0000\u0484\u0485"+
		"\u0005\u0016\u0000\u0000\u0485\u0487\u0003\u00a6S\u0000\u0486\u0484\u0001"+
		"\u0000\u0000\u0000\u0487\u0488\u0001\u0000\u0000\u0000\u0488\u0486\u0001"+
		"\u0000\u0000\u0000\u0488\u0489\u0001\u0000\u0000\u0000\u0489\u048a\u0001"+
		"\u0000\u0000\u0000\u048a\u048b\u0005\u0019\u0000\u0000\u048b\u0498\u0001"+
		"\u0000\u0000\u0000\u048c\u048d\u0005\u0018\u0000\u0000\u048d\u048e\u0003"+
		"\u0004\u0002\u0000\u048e\u048f\u0005\u0019\u0000\u0000\u048f\u0498\u0001"+
		"\u0000\u0000\u0000\u0490\u0498\u0003\u00a4R\u0000\u0491\u0492\u0003\u00b6"+
		"[\u0000\u0492\u0493\u0003\u00d2i\u0000\u0493\u0498\u0001\u0000\u0000\u0000"+
		"\u0494\u0495\u0003\u00b6[\u0000\u0495\u0496\u0003\u00a2Q\u0006\u0496\u0498"+
		"\u0001\u0000\u0000\u0000\u0497\u047d\u0001\u0000\u0000\u0000\u0497\u0482"+
		"\u0001\u0000\u0000\u0000\u0497\u048c\u0001\u0000\u0000\u0000\u0497\u0490"+
		"\u0001\u0000\u0000\u0000\u0497\u0491\u0001\u0000\u0000\u0000\u0497\u0494"+
		"\u0001\u0000\u0000\u0000\u0498\u04ab\u0001\u0000\u0000\u0000\u0499\u049a"+
		"\n\u0003\u0000\u0000\u049a\u049b\u0003\u00b2Y\u0000\u049b\u049c\u0003"+
		"\u00a2Q\u0004\u049c\u04aa\u0001\u0000\u0000\u0000\u049d\u049e\n\u0002"+
		"\u0000\u0000\u049e\u049f\u0003\u00b4Z\u0000\u049f\u04a0\u0003\u00a2Q\u0003"+
		"\u04a0\u04aa\u0001\u0000\u0000\u0000\u04a1\u04a2\n\u0001\u0000\u0000\u04a2"+
		"\u04a3\u0005\'\u0000\u0000\u04a3\u04aa\u0003\u00a2Q\u0002\u04a4\u04a5"+
		"\n\u0005\u0000\u0000\u04a5\u04aa\u0003\u018a\u00c5\u0000\u04a6\u04a7\n"+
		"\u0004\u0000\u0000\u04a7\u04a8\u00058\u0000\u0000\u04a8\u04aa\u0003\u018a"+
		"\u00c5\u0000\u04a9\u0499\u0001\u0000\u0000\u0000\u04a9\u049d\u0001\u0000"+
		"\u0000\u0000\u04a9\u04a1\u0001\u0000\u0000\u0000\u04a9\u04a4\u0001\u0000"+
		"\u0000\u0000\u04a9\u04a6\u0001\u0000\u0000\u0000\u04aa\u04ad\u0001\u0000"+
		"\u0000\u0000\u04ab\u04a9\u0001\u0000\u0000\u0000\u04ab\u04ac\u0001\u0000"+
		"\u0000\u0000\u04ac\u00a3\u0001\u0000\u0000\u0000\u04ad\u04ab\u0001\u0000"+
		"\u0000\u0000\u04ae\u04bd\u0003\u00c2a\u0000\u04af\u04bd\u0003\u00ceg\u0000"+
		"\u04b0\u04bd\u0003\u0112\u0089\u0000\u04b1\u04bd\u0003\u00b8\\\u0000\u04b2"+
		"\u04bd\u0003\u00ba]\u0000\u04b3\u04bd\u0003\u00bc^\u0000\u04b4\u04bd\u0003"+
		"\u00be_\u0000\u04b5\u04bd\u0003\u00c0`\u0000\u04b6\u04b8\u0003j5\u0000"+
		"\u04b7\u04b9\u0003h4\u0000\u04b8\u04b7\u0001\u0000\u0000\u0000\u04b8\u04b9"+
		"\u0001\u0000\u0000\u0000\u04b9\u04bd\u0001\u0000\u0000\u0000\u04ba\u04bd"+
		"\u0003\u0114\u008a\u0000\u04bb\u04bd\u0003l6\u0000\u04bc\u04ae\u0001\u0000"+
		"\u0000\u0000\u04bc\u04af\u0001\u0000\u0000\u0000\u04bc\u04b0\u0001\u0000"+
		"\u0000\u0000\u04bc\u04b1\u0001\u0000\u0000\u0000\u04bc\u04b2\u0001\u0000"+
		"\u0000\u0000\u04bc\u04b3\u0001\u0000\u0000\u0000\u04bc\u04b4\u0001\u0000"+
		"\u0000\u0000\u04bc\u04b5\u0001\u0000\u0000\u0000\u04bc\u04b6\u0001\u0000"+
		"\u0000\u0000\u04bc\u04ba\u0001\u0000\u0000\u0000\u04bc\u04bb\u0001\u0000"+
		"\u0000\u0000\u04bd\u00a5\u0001\u0000\u0000\u0000\u04be\u04c1\u0003\u00a2"+
		"Q\u0000\u04bf\u04c1\u0003\u009aM\u0000\u04c0\u04be\u0001\u0000\u0000\u0000"+
		"\u04c0\u04bf\u0001\u0000\u0000\u0000\u04c1\u00a7\u0001\u0000\u0000\u0000"+
		"\u04c2\u04c5\u0003\u00aeW\u0000\u04c3\u04c5\u0003\u00b0X\u0000\u04c4\u04c2"+
		"\u0001\u0000\u0000\u0000\u04c4\u04c3\u0001\u0000\u0000\u0000\u04c5\u00a9"+
		"\u0001\u0000\u0000\u0000\u04c6\u04c7\u0007\t\u0000\u0000\u04c7\u00ab\u0001"+
		"\u0000\u0000\u0000\u04c8\u04c9\u0007\n\u0000\u0000\u04c9\u00ad\u0001\u0000"+
		"\u0000\u0000\u04ca\u04cb\u0007\u000b\u0000\u0000\u04cb\u00af\u0001\u0000"+
		"\u0000\u0000\u04cc\u04cd\u0007\f\u0000\u0000\u04cd\u00b1\u0001\u0000\u0000"+
		"\u0000\u04ce\u04cf\u0007\r\u0000\u0000\u04cf\u00b3\u0001\u0000\u0000\u0000"+
		"\u04d0\u04d1\u0007\u000e\u0000\u0000\u04d1\u00b5\u0001\u0000\u0000\u0000"+
		"\u04d2\u04d3\u0007\u000e\u0000\u0000\u04d3\u00b7\u0001\u0000\u0000\u0000"+
		"\u04d4\u04d5\u0005\u00c8\u0000\u0000\u04d5\u04d8\u0005\u0018\u0000\u0000"+
		"\u04d6\u04d9\u0003f3\u0000\u04d7\u04d9\u0003\u0112\u0089\u0000\u04d8\u04d6"+
		"\u0001\u0000\u0000\u0000\u04d8\u04d7\u0001\u0000\u0000\u0000\u04d9\u04da"+
		"\u0001\u0000\u0000\u0000\u04da\u04db\u0005\u0019\u0000\u0000\u04db\u00b9"+
		"\u0001\u0000\u0000\u0000\u04dc\u04dd\u0005*\u0000\u0000\u04dd\u04de\u0005"+
		"\u0018\u0000\u0000\u04de\u04df\u0003f3\u0000\u04df\u04e1\u0005\u0019\u0000"+
		"\u0000\u04e0\u04e2\u0003h4\u0000\u04e1\u04e0\u0001\u0000\u0000\u0000\u04e1"+
		"\u04e2\u0001\u0000\u0000\u0000\u04e2\u00bb\u0001\u0000\u0000\u0000\u04e3"+
		"\u04e4\u0005+\u0000\u0000\u04e4\u04e5\u0005\u0018\u0000\u0000\u04e5\u04e6"+
		"\u0003f3\u0000\u04e6\u04e7\u0005\u0019\u0000\u0000\u04e7\u00bd\u0001\u0000"+
		"\u0000\u0000\u04e8\u04e9\u0005-\u0000\u0000\u04e9\u04ea\u0005\u0018\u0000"+
		"\u0000\u04ea\u04eb\u0003f3\u0000\u04eb\u04ed\u0005\u0019\u0000\u0000\u04ec"+
		"\u04ee\u0003h4\u0000\u04ed\u04ec\u0001\u0000\u0000\u0000\u04ed\u04ee\u0001"+
		"\u0000\u0000\u0000\u04ee\u00bf\u0001\u0000\u0000\u0000\u04ef\u04f0\u0005"+
		".\u0000\u0000\u04f0\u04f1\u0005\u0018\u0000\u0000\u04f1\u04f2\u0003f3"+
		"\u0000\u04f2\u04f3\u0005\u0019\u0000\u0000\u04f3\u00c1\u0001\u0000\u0000"+
		"\u0000\u04f4\u04f7\u0003\u00c4b\u0000\u04f5\u04f7\u0003\u00cae\u0000\u04f6"+
		"\u04f4\u0001\u0000\u0000\u0000\u04f6\u04f5\u0001\u0000\u0000\u0000\u04f7"+
		"\u00c3\u0001\u0000\u0000\u0000\u04f8\u04f9\u00059\u0000\u0000\u04f9\u04fb"+
		"\u0003\u00a6S\u0000\u04fa\u04fc\u0003\u00c6c\u0000\u04fb\u04fa\u0001\u0000"+
		"\u0000\u0000\u04fc\u04fd\u0001\u0000\u0000\u0000\u04fd\u04fb\u0001\u0000"+
		"\u0000\u0000\u04fd\u04fe\u0001\u0000\u0000\u0000\u04fe\u0500\u0001\u0000"+
		"\u0000\u0000\u04ff\u0501\u0003\u00c8d\u0000\u0500\u04ff\u0001\u0000\u0000"+
		"\u0000\u0500\u0501\u0001\u0000\u0000\u0000\u0501\u0502\u0001\u0000\u0000"+
		"\u0000\u0502\u0503\u0005U\u0000\u0000\u0503\u00c5\u0001\u0000\u0000\u0000"+
		"\u0504\u0505\u0005\u00d0\u0000\u0000\u0505\u0506\u0003\u00a2Q\u0000\u0506"+
		"\u0507\u0005\u00bc\u0000\u0000\u0507\u0508\u0003\u00a6S\u0000\u0508\u00c7"+
		"\u0001\u0000\u0000\u0000\u0509\u050a\u0005S\u0000\u0000\u050a\u050b\u0003"+
		"\u00a6S\u0000\u050b\u00c9\u0001\u0000\u0000\u0000\u050c\u050e\u00059\u0000"+
		"\u0000\u050d\u050f\u0003\u00ccf\u0000\u050e\u050d\u0001\u0000\u0000\u0000"+
		"\u050f\u0510\u0001\u0000\u0000\u0000\u0510\u050e\u0001\u0000\u0000\u0000"+
		"\u0510\u0511\u0001\u0000\u0000\u0000\u0511\u0513\u0001\u0000\u0000\u0000"+
		"\u0512\u0514\u0003\u00c8d\u0000\u0513\u0512\u0001\u0000\u0000\u0000\u0513"+
		"\u0514\u0001\u0000\u0000\u0000\u0514\u0515\u0001\u0000\u0000\u0000\u0515"+
		"\u0516\u0005U\u0000\u0000\u0516\u00cb\u0001\u0000\u0000\u0000\u0517\u0518"+
		"\u0005\u00d0\u0000\u0000\u0518\u0519\u0003\u009aM\u0000\u0519\u051a\u0005"+
		"\u00bc\u0000\u0000\u051a\u051b\u0003\u00a6S\u0000\u051b\u00cd\u0001\u0000"+
		"\u0000\u0000\u051c\u0525\u0005\n\u0000\u0000\u051d\u0525\u0005\u000b\u0000"+
		"\u0000\u051e\u0525\u0005\u00d9\u0000\u0000\u051f\u0525\u0003\u00d0h\u0000"+
		"\u0520\u0525\u0003\u00d2i\u0000\u0521\u0525\u0003\u00d4j\u0000\u0522\u0525"+
		"\u0003\u00d6k\u0000\u0523\u0525\u0003\u010c\u0086\u0000\u0524\u051c\u0001"+
		"\u0000\u0000\u0000\u0524\u051d\u0001\u0000\u0000\u0000\u0524\u051e\u0001"+
		"\u0000\u0000\u0000\u0524\u051f\u0001\u0000\u0000\u0000\u0524\u0520\u0001"+
		"\u0000\u0000\u0000\u0524\u0521\u0001\u0000\u0000\u0000\u0524\u0522\u0001"+
		"\u0000\u0000\u0000\u0524\u0523\u0001\u0000\u0000\u0000\u0525\u00cf\u0001"+
		"\u0000\u0000\u0000\u0526\u0527\u0007\u000f\u0000\u0000\u0527\u00d1\u0001"+
		"\u0000\u0000\u0000\u0528\u0529\u0007\u0010\u0000\u0000\u0529\u00d3\u0001"+
		"\u0000\u0000\u0000\u052a\u0536\u0005\f\u0000\u0000\u052b\u052c\u0005\u001c"+
		"\u0000\u0000\u052c\u0531\u0005\t\u0000\u0000\u052d\u052e\u0005\u0016\u0000"+
		"\u0000\u052e\u0530\u0005\t\u0000\u0000\u052f\u052d\u0001\u0000\u0000\u0000"+
		"\u0530\u0533\u0001\u0000\u0000\u0000\u0531\u052f\u0001\u0000\u0000\u0000"+
		"\u0531\u0532\u0001\u0000\u0000\u0000\u0532\u0534\u0001\u0000\u0000\u0000"+
		"\u0533\u0531\u0001\u0000\u0000\u0000\u0534\u0536\u0005\u001d\u0000\u0000"+
		"\u0535\u052a\u0001\u0000\u0000\u0000\u0535\u052b\u0001\u0000\u0000\u0000"+
		"\u0536\u00d5\u0001\u0000\u0000\u0000\u0537\u053e\u0003\u00d8l\u0000\u0538"+
		"\u053e\u0003\u00e0p\u0000\u0539\u053e\u0003\u00e2q\u0000\u053a\u053e\u0003"+
		"\u0104\u0082\u0000\u053b\u053e\u0003\u0106\u0083\u0000\u053c\u053e\u0003"+
		"\u0108\u0084\u0000\u053d\u0537\u0001\u0000\u0000\u0000\u053d\u0538\u0001"+
		"\u0000\u0000\u0000\u053d\u0539\u0001\u0000\u0000\u0000\u053d\u053a\u0001"+
		"\u0000\u0000\u0000\u053d\u053b\u0001\u0000\u0000\u0000\u053d\u053c\u0001"+
		"\u0000\u0000\u0000\u053e\u00d7\u0001\u0000\u0000\u0000\u053f\u0543\u0003"+
		"\u00dam\u0000\u0540\u0543\u0003\u00dcn\u0000\u0541\u0543\u0003\u00deo"+
		"\u0000\u0542\u053f\u0001\u0000\u0000\u0000\u0542\u0540\u0001\u0000\u0000"+
		"\u0000\u0542\u0541\u0001\u0000\u0000\u0000\u0543\u00d9\u0001\u0000\u0000"+
		"\u0000\u0544\u0545\u0005\u001c\u0000\u0000\u0545\u0546\u0003\u00e6s\u0000"+
		"\u0546\u0547\u0005\u001d\u0000\u0000\u0547\u054e\u0001\u0000\u0000\u0000"+
		"\u0548\u054a\u0005\u0082\u0000\u0000\u0549\u0548\u0001\u0000\u0000\u0000"+
		"\u0549\u054a\u0001\u0000\u0000\u0000\u054a\u054b\u0001\u0000\u0000\u0000"+
		"\u054b\u054c\u0005I\u0000\u0000\u054c\u054e\u0003\u00e6s\u0000\u054d\u0544"+
		"\u0001\u0000\u0000\u0000\u054d\u0549\u0001\u0000\u0000\u0000\u054e\u00db"+
		"\u0001\u0000\u0000\u0000\u054f\u0550\u0005\u001c\u0000\u0000\u0550\u0551"+
		"\u0003\u00e8t\u0000\u0551\u0552\u0005\u001d\u0000\u0000\u0552\u0559\u0001"+
		"\u0000\u0000\u0000\u0553\u0555\u0005\u00d6\u0000\u0000\u0554\u0553\u0001"+
		"\u0000\u0000\u0000\u0554\u0555\u0001\u0000\u0000\u0000\u0555\u0556\u0001"+
		"\u0000\u0000\u0000\u0556\u0557\u0005I\u0000\u0000\u0557\u0559\u0003\u00e8"+
		"t\u0000\u0558\u054f\u0001\u0000\u0000\u0000\u0558\u0554\u0001\u0000\u0000"+
		"\u0000\u0559\u00dd\u0001\u0000\u0000\u0000\u055a\u055b\u0005\u001c\u0000"+
		"\u0000\u055b\u055c\u0003\u00eau\u0000\u055c\u055d\u0005\u001d\u0000\u0000"+
		"\u055d\u0564\u0001\u0000\u0000\u0000\u055e\u0560\u0005\u009c\u0000\u0000"+
		"\u055f\u055e\u0001\u0000\u0000\u0000\u055f\u0560\u0001\u0000\u0000\u0000"+
		"\u0560\u0561\u0001\u0000\u0000\u0000\u0561\u0562\u0005I\u0000\u0000\u0562"+
		"\u0564\u0003\u00ecv\u0000\u0563\u055a\u0001\u0000\u0000\u0000\u0563\u055f"+
		"\u0001\u0000\u0000\u0000\u0564\u00df\u0001\u0000\u0000\u0000\u0565\u0566"+
		"\u0005\u001c\u0000\u0000\u0566\u0567\u0003\u00eew\u0000\u0567\u0568\u0005"+
		"\u001d\u0000\u0000\u0568\u056f\u0001\u0000\u0000\u0000\u0569\u056b\u0005"+
		"\u0082\u0000\u0000\u056a\u0569\u0001\u0000\u0000\u0000\u056a\u056b\u0001"+
		"\u0000\u0000\u0000\u056b\u056c\u0001\u0000\u0000\u0000\u056c\u056d\u0005"+
		"H\u0000\u0000\u056d\u056f\u0003\u00eew\u0000\u056e\u0565\u0001\u0000\u0000"+
		"\u0000\u056e\u056a\u0001\u0000\u0000\u0000\u056f\u00e1\u0001\u0000\u0000"+
		"\u0000\u0570\u0571\u0005\u001c\u0000\u0000\u0571\u0572\u0003\u00f0x\u0000"+
		"\u0572\u0573\u0005\u001d\u0000\u0000\u0573\u057a\u0001\u0000\u0000\u0000"+
		"\u0574\u0576\u0005\u0082\u0000\u0000\u0575\u0574\u0001\u0000\u0000\u0000"+
		"\u0575\u0576\u0001\u0000\u0000\u0000\u0576\u0577\u0001\u0000\u0000\u0000"+
		"\u0577\u0578\u0005\u00be\u0000\u0000\u0578\u057a\u0003\u00f0x\u0000\u0579"+
		"\u0570\u0001\u0000\u0000\u0000\u0579\u0575\u0001\u0000\u0000\u0000\u057a"+
		"\u00e3\u0001\u0000\u0000\u0000\u057b\u057f\u0003\u00e6s\u0000\u057c\u057f"+
		"\u0003\u00e8t\u0000\u057d\u057f\u0003\u00eau\u0000\u057e\u057b\u0001\u0000"+
		"\u0000\u0000\u057e\u057c\u0001\u0000\u0000\u0000\u057e\u057d\u0001\u0000"+
		"\u0000\u0000\u057f\u00e5\u0001\u0000\u0000\u0000\u0580\u0581\u0003\u00ee"+
		"w\u0000\u0581\u0582\u0003\u00f0x\u0000\u0582\u00e7\u0001\u0000\u0000\u0000"+
		"\u0583\u0584\u0003\u00eew\u0000\u0584\u0585\u0003\u00f0x\u0000\u0585\u0586"+
		"\u0003\u0102\u0081\u0000\u0586\u00e9\u0001\u0000\u0000\u0000\u0587\u0588"+
		"\u0003\u00eew\u0000\u0588\u0589\u0003\u00f0x\u0000\u0589\u058a\u0003\u00f2"+
		"y\u0000\u058a\u00eb\u0001\u0000\u0000\u0000\u058b\u058c\u0003\u00eew\u0000"+
		"\u058c\u058d\u0003\u00f0x\u0000\u058d\u058e\u0003\u00f4z\u0000\u058e\u00ed"+
		"\u0001\u0000\u0000\u0000\u058f\u0590\u0003\u00f6{\u0000\u0590\u0591\u0005"+
		"\u001f\u0000\u0000\u0591\u0592\u0003\u00f8|\u0000\u0592\u0593\u0005\u001f"+
		"\u0000\u0000\u0593\u0594\u0003\u00fa}\u0000\u0594\u00ef\u0001\u0000\u0000"+
		"\u0000\u0595\u0596\u0003\u00fc~\u0000\u0596\u0597\u0005%\u0000\u0000\u0597"+
		"\u059a\u0003\u00fe\u007f\u0000\u0598\u0599\u0005%\u0000\u0000\u0599\u059b"+
		"\u0003\u0100\u0080\u0000\u059a\u0598\u0001\u0000\u0000\u0000\u059a\u059b"+
		"\u0001\u0000\u0000\u0000\u059b\u00f1\u0001\u0000\u0000\u0000\u059c\u059d"+
		"\u0007\u000e\u0000\u0000\u059d\u05a0\u0003\u00fc~\u0000\u059e\u059f\u0005"+
		"%\u0000\u0000\u059f\u05a1\u0003\u00fe\u007f\u0000\u05a0\u059e\u0001\u0000"+
		"\u0000\u0000\u05a0\u05a1\u0001\u0000\u0000\u0000\u05a1\u00f3\u0001\u0000"+
		"\u0000\u0000\u05a2\u05a3\u0007\u000e\u0000\u0000\u05a3\u05a4\u0003\u00fc"+
		"~\u0000\u05a4\u05a5\u0005%\u0000\u0000\u05a5\u05a6\u0003\u00fe\u007f\u0000"+
		"\u05a6\u00f5\u0001\u0000\u0000\u0000\u05a7\u05a8\u0005\u0003\u0000\u0000"+
		"\u05a8\u00f7\u0001\u0000\u0000\u0000\u05a9\u05aa\u0005\u0003\u0000\u0000"+
		"\u05aa\u00f9\u0001\u0000\u0000\u0000\u05ab\u05ac\u0005\u0003\u0000\u0000"+
		"\u05ac\u00fb\u0001\u0000\u0000\u0000\u05ad\u05ae\u0005\u0003\u0000\u0000"+
		"\u05ae\u00fd\u0001\u0000\u0000\u0000\u05af\u05b0\u0005\u0003\u0000\u0000"+
		"\u05b0\u00ff\u0001\u0000\u0000\u0000\u05b1\u05b2\u0007\u0011\u0000\u0000"+
		"\u05b2\u0101\u0001\u0000\u0000\u0000\u05b3\u05b6\u0005\u00da\u0000\u0000"+
		"\u05b4\u05b5\u0005!\u0000\u0000\u05b5\u05b7\u0005\u00da\u0000\u0000\u05b6"+
		"\u05b4\u0001\u0000\u0000\u0000\u05b6\u05b7\u0001\u0000\u0000\u0000\u05b7"+
		"\u05ba\u0001\u0000\u0000\u0000\u05b8\u05ba\u0005\n\u0000\u0000\u05b9\u05b3"+
		"\u0001\u0000\u0000\u0000\u05b9\u05b8\u0001\u0000\u0000\u0000\u05ba\u0103"+
		"\u0001\u0000\u0000\u0000\u05bb\u05be\u0005\r\u0000\u0000\u05bc\u05bf\u0003"+
		"\u00e4r\u0000\u05bd\u05bf\u0003\u010a\u0085\u0000\u05be\u05bc\u0001\u0000"+
		"\u0000\u0000\u05be\u05bd\u0001\u0000\u0000\u0000\u05bf\u05c0\u0001\u0000"+
		"\u0000\u0000\u05c0\u05c1\u0005\u001d\u0000\u0000\u05c1\u0105\u0001\u0000"+
		"\u0000\u0000\u05c2\u05c5\u0005\u000e\u0000\u0000\u05c3\u05c6\u0003\u00ee"+
		"w\u0000\u05c4\u05c6\u0003\u010a\u0085\u0000\u05c5\u05c3\u0001\u0000\u0000"+
		"\u0000\u05c5\u05c4\u0001\u0000\u0000\u0000\u05c6\u05c7\u0001\u0000\u0000"+
		"\u0000\u05c7\u05c8\u0005\u001d\u0000\u0000\u05c8\u0107\u0001\u0000\u0000"+
		"\u0000\u05c9\u05cc\u0005\u000f\u0000\u0000\u05ca\u05cd\u0003\u00f0x\u0000"+
		"\u05cb\u05cd\u0003\u010a\u0085\u0000\u05cc\u05ca\u0001\u0000\u0000\u0000"+
		"\u05cc\u05cb\u0001\u0000\u0000\u0000\u05cd\u05ce\u0001\u0000\u0000\u0000"+
		"\u05ce\u05cf\u0005\u001d\u0000\u0000\u05cf\u0109\u0001\u0000\u0000\u0000"+
		"\u05d0\u05d1\u0005\n\u0000\u0000\u05d1\u010b\u0001\u0000\u0000\u0000\u05d2"+
		"\u05d3\u0005\u001c\u0000\u0000\u05d3\u05d4\u0003\u010e\u0087\u0000\u05d4"+
		"\u05d5\u0005%\u0000\u0000\u05d5\u05d6\u0003\u0110\u0088\u0000\u05d6\u05d7"+
		"\u0005\u001d\u0000\u0000\u05d7\u010d\u0001\u0000\u0000\u0000\u05d8\u05d9"+
		"\u0005\n\u0000\u0000\u05d9\u010f\u0001\u0000\u0000\u0000\u05da\u05db\u0005"+
		"\n\u0000\u0000\u05db\u0111\u0001\u0000\u0000\u0000\u05dc\u05dd\u0005%"+
		"\u0000\u0000\u05dd\u05e3\u0003\u01a0\u00d0\u0000\u05de\u05e0\u0005(\u0000"+
		"\u0000\u05df\u05e1\u0005\u0003\u0000\u0000\u05e0\u05df\u0001\u0000\u0000"+
		"\u0000\u05e0\u05e1\u0001\u0000\u0000\u0000\u05e1\u05e3\u0001\u0000\u0000"+
		"\u0000\u05e2\u05dc\u0001\u0000\u0000\u0000\u05e2\u05de\u0001\u0000\u0000"+
		"\u0000\u05e3\u0113\u0001\u0000\u0000\u0000\u05e4\u05ed\u0003\u014a\u00a5"+
		"\u0000\u05e5\u05ed\u0003\u0128\u0094\u0000\u05e6\u05ed\u0003\u0122\u0091"+
		"\u0000\u05e7\u05ed\u0003\u0124\u0092\u0000\u05e8\u05ed\u0003\u0126\u0093"+
		"\u0000\u05e9\u05ed\u0003\u0116\u008b\u0000\u05ea\u05ed\u0003\u011a\u008d"+
		"\u0000\u05eb\u05ed\u0003\u011c\u008e\u0000\u05ec\u05e4\u0001\u0000\u0000"+
		"\u0000\u05ec\u05e5\u0001\u0000\u0000\u0000\u05ec\u05e6\u0001\u0000\u0000"+
		"\u0000\u05ec\u05e7\u0001\u0000\u0000\u0000\u05ec\u05e8\u0001\u0000\u0000"+
		"\u0000\u05ec\u05e9\u0001\u0000\u0000\u0000\u05ec\u05ea\u0001\u0000\u0000"+
		"\u0000\u05ec\u05eb\u0001\u0000\u0000\u0000\u05ed\u0115\u0001\u0000\u0000"+
		"\u0000\u05ee\u05ef\u0005g\u0000\u0000\u05ef\u05f0\u0005\u0018\u0000\u0000"+
		"\u05f0\u05f3\u0003\u0118\u008c\u0000\u05f1\u05f2\u00052\u0000\u0000\u05f2"+
		"\u05f4\u0003\u014e\u00a7\u0000\u05f3\u05f1\u0001\u0000\u0000\u0000\u05f3"+
		"\u05f4\u0001\u0000\u0000\u0000\u05f4\u05f7\u0001\u0000\u0000\u0000\u05f5"+
		"\u05f6\u0005\u0016\u0000\u0000\u05f6\u05f8\u0003\u0120\u0090\u0000\u05f7"+
		"\u05f5\u0001\u0000\u0000\u0000\u05f7\u05f8\u0001\u0000\u0000\u0000\u05f8"+
		"\u05f9\u0001\u0000\u0000\u0000\u05f9\u05fa\u0005\u0019\u0000\u0000\u05fa"+
		"\u0117\u0001\u0000\u0000\u0000\u05fb\u05fe\u0005\n\u0000\u0000\u05fc\u05fe"+
		"\u0003\u01a0\u00d0\u0000\u05fd\u05fb\u0001\u0000\u0000\u0000\u05fd\u05fc"+
		"\u0001\u0000\u0000\u0000\u05fe\u0119\u0001\u0000\u0000\u0000\u05ff\u0600"+
		"\u0005<\u0000\u0000\u0600\u0601\u0005\u0018\u0000\u0000\u0601\u0602\u0003"+
		"f3\u0000\u0602\u0603\u0005\u0017\u0000\u0000\u0603\u0606\u0003\u0118\u008c"+
		"\u0000\u0604\u0605\u00052\u0000\u0000\u0605\u0607\u0003\u014e\u00a7\u0000"+
		"\u0606\u0604\u0001\u0000\u0000\u0000\u0606\u0607\u0001\u0000\u0000\u0000"+
		"\u0607\u0608\u0001\u0000\u0000\u0000\u0608\u0609\u0005\u0019\u0000\u0000"+
		"\u0609\u011b\u0001\u0000\u0000\u0000\u060a\u060b\u0003\u011e\u008f\u0000"+
		"\u060b\u060e\u0005\u0018\u0000\u0000\u060c\u060f\u0003\u0120\u0090\u0000"+
		"\u060d\u060f\u0005 \u0000\u0000\u060e\u060c\u0001\u0000\u0000\u0000\u060e"+
		"\u060d\u0001\u0000\u0000\u0000\u060e\u060f\u0001\u0000\u0000\u0000\u060f"+
		"\u0610\u0001\u0000\u0000\u0000\u0610\u0612\u0005\u0019\u0000\u0000\u0611"+
		"\u0613\u0003\u013c\u009e\u0000\u0612\u0611\u0001\u0000\u0000\u0000\u0612"+
		"\u0613\u0001\u0000\u0000\u0000\u0613\u0615\u0001\u0000\u0000\u0000\u0614"+
		"\u0616\u0003\u013a\u009d\u0000\u0615\u0614\u0001\u0000\u0000\u0000\u0615"+
		"\u0616\u0001\u0000\u0000\u0000\u0616\u0618\u0001\u0000\u0000\u0000\u0617"+
		"\u0619\u0003\u0136\u009b\u0000\u0618\u0617\u0001\u0000\u0000\u0000\u0618"+
		"\u0619\u0001\u0000\u0000\u0000\u0619\u061b\u0001\u0000\u0000\u0000\u061a"+
		"\u061c\u0003\u0138\u009c\u0000\u061b\u061a\u0001\u0000\u0000\u0000\u061b"+
		"\u061c\u0001\u0000\u0000\u0000\u061c\u061e\u0001\u0000\u0000\u0000\u061d"+
		"\u061f\u0003\u013e\u009f\u0000\u061e\u061d\u0001\u0000\u0000\u0000\u061e"+
		"\u061f\u0001\u0000\u0000\u0000\u061f\u011d\u0001\u0000\u0000\u0000\u0620"+
		"\u0621\u0003b1\u0000\u0621\u011f\u0001\u0000\u0000\u0000\u0622\u0627\u0005"+
		"O\u0000\u0000\u0623\u0624\u0003\u018a\u00c5\u0000\u0624\u0625\u0005\u0016"+
		"\u0000\u0000\u0625\u0627\u0001\u0000\u0000\u0000\u0626\u0622\u0001\u0000"+
		"\u0000\u0000\u0626\u0623\u0001\u0000\u0000\u0000\u0626\u0627\u0001\u0000"+
		"\u0000\u0000\u0627\u0628\u0001\u0000\u0000\u0000\u0628\u062d\u0003\u00a6"+
		"S\u0000\u0629\u062a\u0005\u0016\u0000\u0000\u062a\u062c\u0003\u00a6S\u0000"+
		"\u062b\u0629\u0001\u0000\u0000\u0000\u062c\u062f\u0001\u0000\u0000\u0000"+
		"\u062d\u062b\u0001\u0000\u0000\u0000\u062d\u062e\u0001\u0000\u0000\u0000"+
		"\u062e\u0121\u0001\u0000\u0000\u0000\u062f\u062d\u0001\u0000\u0000\u0000"+
		"\u0630\u0631\u0005\u00b8\u0000\u0000\u0631\u0632\u0005\u0018\u0000\u0000"+
		"\u0632\u0633\u0003f3\u0000\u0633\u0634\u0005\u0019\u0000\u0000\u0634\u0123"+
		"\u0001\u0000\u0000\u0000\u0635\u0636\u0007\u0012\u0000\u0000\u0636\u0637"+
		"\u0005\u0018\u0000\u0000\u0637\u0638\u0003\u00aeW\u0000\u0638\u0639\u0005"+
		"\u0018\u0000\u0000\u0639\u063a\u0003f3\u0000\u063a\u063b\u0005\u0019\u0000"+
		"\u0000\u063b\u063c\u0005\u0019\u0000\u0000\u063c\u0650\u0001\u0000\u0000"+
		"\u0000\u063d\u063e\u0007\u0012\u0000\u0000\u063e\u063f\u0005\u0018\u0000"+
		"\u0000\u063f\u0640\u0003\u00b0X\u0000\u0640\u0641\u0005\u0018\u0000\u0000"+
		"\u0641\u0642\u0003f3\u0000\u0642\u0643\u0005\u0019\u0000\u0000\u0643\u0644"+
		"\u0005\u0019\u0000\u0000\u0644\u0650\u0001\u0000\u0000\u0000\u0645\u0646"+
		"\u0007\u0013\u0000\u0000\u0646\u0647\u0005\u0018\u0000\u0000\u0647\u0648"+
		"\u0003f3\u0000\u0648\u0649\u0005\u0019\u0000\u0000\u0649\u0650\u0001\u0000"+
		"\u0000\u0000\u064a\u064b\u0007\u0014\u0000\u0000\u064b\u064c\u0005\u0018"+
		"\u0000\u0000\u064c\u064d\u0003f3\u0000\u064d\u064e\u0005\u0019\u0000\u0000"+
		"\u064e\u0650\u0001\u0000\u0000\u0000\u064f\u0635\u0001\u0000\u0000\u0000"+
		"\u064f\u063d\u0001\u0000\u0000\u0000\u064f\u0645\u0001\u0000\u0000\u0000"+
		"\u064f\u064a\u0001\u0000\u0000\u0000\u0650\u0125\u0001\u0000\u0000\u0000"+
		"\u0651\u0652\u0003\u00aeW\u0000\u0652\u0653\u0005\u0018\u0000\u0000\u0653"+
		"\u0654\u0003f3\u0000\u0654\u0655\u0005\u0019\u0000\u0000\u0655\u065c\u0001"+
		"\u0000\u0000\u0000\u0656\u0657\u0003\u00b0X\u0000\u0657\u0658\u0005\u0018"+
		"\u0000\u0000\u0658\u0659\u0003f3\u0000\u0659\u065a\u0005\u0019\u0000\u0000"+
		"\u065a\u065c\u0001\u0000\u0000\u0000\u065b\u0651\u0001\u0000\u0000\u0000"+
		"\u065b\u0656\u0001\u0000\u0000\u0000\u065c\u0127\u0001\u0000\u0000\u0000"+
		"\u065d\u0661\u0003\u012a\u0095\u0000\u065e\u0661\u0003\u012c\u0096\u0000"+
		"\u065f\u0661\u0003\u0132\u0099\u0000\u0660\u065d\u0001\u0000\u0000\u0000"+
		"\u0660\u065e\u0001\u0000\u0000\u0000\u0660\u065f\u0001\u0000\u0000\u0000"+
		"\u0661\u0129\u0001\u0000\u0000\u0000\u0662\u0663\u0003\u012e\u0097\u0000"+
		"\u0663\u0664\u0005\u0018\u0000\u0000\u0664\u0665\u0003\u009aM\u0000\u0665"+
		"\u0667\u0005\u0019\u0000\u0000\u0666\u0668\u0003\u0138\u009c\u0000\u0667"+
		"\u0666\u0001\u0000\u0000\u0000\u0667\u0668\u0001\u0000\u0000\u0000\u0668"+
		"\u066a\u0001\u0000\u0000\u0000\u0669\u066b\u0003\u013e\u009f\u0000\u066a"+
		"\u0669\u0001\u0000\u0000\u0000\u066a\u066b\u0001\u0000\u0000\u0000\u066b"+
		"\u0678\u0001\u0000\u0000\u0000\u066c\u066d\u0003\u012e\u0097\u0000\u066d"+
		"\u066e\u0005\u0018\u0000\u0000\u066e\u066f\u0003\u0004\u0002\u0000\u066f"+
		"\u0670\u0005\u0019\u0000\u0000\u0670\u0678\u0001\u0000\u0000\u0000\u0671"+
		"\u0672\u0003\u012e\u0097\u0000\u0672\u0673\u0003\u00a8T\u0000\u0673\u0674"+
		"\u0005\u0018\u0000\u0000\u0674\u0675\u0003b1\u0000\u0675\u0676\u0005\u0019"+
		"\u0000\u0000\u0676\u0678\u0001\u0000\u0000\u0000\u0677\u0662\u0001\u0000"+
		"\u0000\u0000\u0677\u066c\u0001\u0000\u0000\u0000\u0677\u0671\u0001\u0000"+
		"\u0000\u0000\u0678\u012b\u0001\u0000\u0000\u0000\u0679\u067a\u0003\u0130"+
		"\u0098\u0000\u067a\u067b\u0005\u0018\u0000\u0000\u067b\u067c\u0003\u009a"+
		"M\u0000\u067c\u067e\u0005\u0019\u0000\u0000\u067d\u067f\u0003\u0138\u009c"+
		"\u0000\u067e\u067d\u0001\u0000\u0000\u0000\u067e\u067f\u0001\u0000\u0000"+
		"\u0000\u067f\u0681\u0001\u0000\u0000\u0000\u0680\u0682\u0003\u013e\u009f"+
		"\u0000\u0681\u0680\u0001\u0000\u0000\u0000\u0681\u0682\u0001\u0000\u0000"+
		"\u0000\u0682\u068f\u0001\u0000\u0000\u0000\u0683\u0684\u0003\u0130\u0098"+
		"\u0000\u0684\u0685\u0005\u0018\u0000\u0000\u0685\u0686\u0003\u0004\u0002"+
		"\u0000\u0686\u0687\u0005\u0019\u0000\u0000\u0687\u068f\u0001\u0000\u0000"+
		"\u0000\u0688\u0689\u0003\u0130\u0098\u0000\u0689\u068a\u0003\u00a8T\u0000"+
		"\u068a\u068b\u0005\u0018\u0000\u0000\u068b\u068c\u0003b1\u0000\u068c\u068d"+
		"\u0005\u0019\u0000\u0000\u068d\u068f\u0001\u0000\u0000\u0000\u068e\u0679"+
		"\u0001\u0000\u0000\u0000\u068e\u0683\u0001\u0000\u0000\u0000\u068e\u0688"+
		"\u0001\u0000\u0000\u0000\u068f\u012d\u0001\u0000\u0000\u0000\u0690\u0691"+
		"\u0007\u0015\u0000\u0000\u0691\u012f\u0001\u0000\u0000\u0000\u0692\u0693"+
		"\u0007\u0016\u0000\u0000\u0693\u0131\u0001\u0000\u0000\u0000\u0694\u0695"+
		"\u0005\u0081\u0000\u0000\u0695\u0697\u0005\u0018\u0000\u0000\u0696\u0698"+
		"\u0005O\u0000\u0000\u0697\u0696\u0001\u0000\u0000\u0000\u0697\u0698\u0001"+
		"\u0000\u0000\u0000\u0698\u0699\u0001\u0000\u0000\u0000\u0699\u069a\u0003"+
		"\u00a6S\u0000\u069a\u069b\u0005\u0016\u0000\u0000\u069b\u069d\u0003\u00a6"+
		"S\u0000\u069c\u069e\u0003\u0134\u009a\u0000\u069d\u069c\u0001\u0000\u0000"+
		"\u0000\u069d\u069e\u0001\u0000\u0000\u0000\u069e\u069f\u0001\u0000\u0000"+
		"\u0000\u069f\u06a1\u0005\u0019\u0000\u0000\u06a0\u06a2\u0003\u0136\u009b"+
		"\u0000\u06a1\u06a0\u0001\u0000\u0000\u0000\u06a1\u06a2\u0001\u0000\u0000"+
		"\u0000\u06a2\u06a4\u0001\u0000\u0000\u0000\u06a3\u06a5\u0003\u0138\u009c"+
		"\u0000\u06a4\u06a3\u0001\u0000\u0000\u0000\u06a4\u06a5\u0001\u0000\u0000"+
		"\u0000\u06a5\u06a7\u0001\u0000\u0000\u0000\u06a6\u06a8\u0003\u013e\u009f"+
		"\u0000\u06a7\u06a6\u0001\u0000\u0000\u0000\u06a7\u06a8\u0001\u0000\u0000"+
		"\u0000\u06a8\u0133\u0001\u0000\u0000\u0000\u06a9\u06aa\u0005\u009e\u0000"+
		"\u0000\u06aa\u06b2\u0005\u00a5\u0000\u0000\u06ab\u06b3\u0005X\u0000\u0000"+
		"\u06ac\u06ae\u0005\u00c7\u0000\u0000\u06ad\u06af\u0003\u00a2Q\u0000\u06ae"+
		"\u06ad\u0001\u0000\u0000\u0000\u06ae\u06af\u0001\u0000\u0000\u0000\u06af"+
		"\u06b0\u0001\u0000\u0000\u0000\u06b0\u06b1\u0007\u0017\u0000\u0000\u06b1"+
		"\u06b3\u0005?\u0000\u0000\u06b2\u06ab\u0001\u0000\u0000\u0000\u06b2\u06ac"+
		"\u0001\u0000\u0000\u0000\u06b3\u0135\u0001\u0000\u0000\u0000\u06b4\u06b5"+
		"\u0005\u00d3\u0000\u0000\u06b5\u06b6\u0005h\u0000\u0000\u06b6\u06b7\u0005"+
		"\u0018\u0000\u0000\u06b7\u06b8\u0003|>\u0000\u06b8\u06b9\u0005\u0019\u0000"+
		"\u0000\u06b9\u0137\u0001\u0000\u0000\u0000\u06ba\u06bb\u0005`\u0000\u0000"+
		"\u06bb\u06bc\u0005\u0018\u0000\u0000\u06bc\u06bd\u0003\u0098L\u0000\u06bd"+
		"\u06be\u0005\u0019\u0000\u0000\u06be\u0139\u0001\u0000\u0000\u0000\u06bf"+
		"\u06c0\u0005\u00af\u0000\u0000\u06c0\u06c4\u0005\u0099\u0000\u0000\u06c1"+
		"\u06c2\u0005l\u0000\u0000\u06c2\u06c4\u0005\u0099\u0000\u0000\u06c3\u06bf"+
		"\u0001\u0000\u0000\u0000\u06c3\u06c1\u0001\u0000\u0000\u0000\u06c4\u013b"+
		"\u0001\u0000\u0000\u0000\u06c5\u06c6\u0005e\u0000\u0000\u06c6\u06ca\u0005"+
		"a\u0000\u0000\u06c7\u06c8\u0005e\u0000\u0000\u06c8\u06ca\u0005z\u0000"+
		"\u0000\u06c9\u06c5\u0001\u0000\u0000\u0000\u06c9\u06c7\u0001\u0000\u0000"+
		"\u0000\u06ca\u013d\u0001\u0000\u0000\u0000\u06cb\u06cc\u0005\u00a4\u0000"+
		"\u0000\u06cc\u06ce\u0005\u0018\u0000\u0000\u06cd\u06cf\u0003\u0140\u00a0"+
		"\u0000\u06ce\u06cd\u0001\u0000\u0000\u0000\u06ce\u06cf\u0001\u0000\u0000"+
		"\u0000\u06cf\u06d1\u0001\u0000\u0000\u0000\u06d0\u06d2\u0003|>\u0000\u06d1"+
		"\u06d0\u0001\u0000\u0000\u0000\u06d1\u06d2\u0001\u0000\u0000\u0000\u06d2"+
		"\u06d4\u0001\u0000\u0000\u0000\u06d3\u06d5\u0003\u0142\u00a1\u0000\u06d4"+
		"\u06d3\u0001\u0000\u0000\u0000\u06d4\u06d5\u0001\u0000\u0000\u0000\u06d5"+
		"\u06d6\u0001\u0000\u0000\u0000\u06d6\u06d7\u0005\u0019\u0000\u0000\u06d7"+
		"\u013f\u0001\u0000\u0000\u0000\u06d8\u06d9\u0005\u00a8\u0000\u0000\u06d9"+
		"\u06da\u00058\u0000\u0000\u06da\u06df\u0003\u00a2Q\u0000\u06db\u06dc\u0005"+
		"\u0016\u0000\u0000\u06dc\u06de\u0003\u00a2Q\u0000\u06dd\u06db\u0001\u0000"+
		"\u0000\u0000\u06de\u06e1\u0001\u0000\u0000\u0000\u06df\u06dd\u0001\u0000"+
		"\u0000\u0000\u06df\u06e0\u0001\u0000\u0000\u0000\u06e0\u0141\u0001\u0000"+
		"\u0000\u0000\u06e1\u06df\u0001\u0000\u0000\u0000\u06e2\u06e3\u0007\u0018"+
		"\u0000\u0000\u06e3\u06e5\u0003\u0144\u00a2\u0000\u06e4\u06e6\u0003\u0148"+
		"\u00a4\u0000\u06e5\u06e4\u0001\u0000\u0000\u0000\u06e5\u06e6\u0001\u0000"+
		"\u0000\u0000\u06e6\u06f0\u0001\u0000\u0000\u0000\u06e7\u06e8\u0007\u0018"+
		"\u0000\u0000\u06e8\u06e9\u00055\u0000\u0000\u06e9\u06ea\u0003\u0144\u00a2"+
		"\u0000\u06ea\u06eb\u00050\u0000\u0000\u06eb\u06ed\u0003\u0146\u00a3\u0000"+
		"\u06ec\u06ee\u0003\u0148\u00a4\u0000\u06ed\u06ec\u0001\u0000\u0000\u0000"+
		"\u06ed\u06ee\u0001\u0000\u0000\u0000\u06ee\u06f0\u0001\u0000\u0000\u0000"+
		"\u06ef\u06e2\u0001\u0000\u0000\u0000\u06ef\u06e7\u0001\u0000\u0000\u0000"+
		"\u06f0\u0143\u0001\u0000\u0000\u0000\u06f1\u06f2\u0005B\u0000\u0000\u06f2"+
		"\u06fc\u0005\u00b2\u0000\u0000\u06f3\u06f4\u0005\u00c9\u0000\u0000\u06f4"+
		"\u06fc\u0005\u00ac\u0000\u0000\u06f5\u06f6\u0003\u00a2Q\u0000\u06f6\u06f7"+
		"\u0005\u00ac\u0000\u0000\u06f7\u06fc\u0001\u0000\u0000\u0000\u06f8\u06f9"+
		"\u0003\u00a2Q\u0000\u06f9\u06fa\u0005b\u0000\u0000\u06fa\u06fc\u0001\u0000"+
		"\u0000\u0000\u06fb\u06f1\u0001\u0000\u0000\u0000\u06fb\u06f3\u0001\u0000"+
		"\u0000\u0000\u06fb\u06f5\u0001\u0000\u0000\u0000\u06fb\u06f8\u0001\u0000"+
		"\u0000\u0000\u06fc\u0145\u0001\u0000\u0000\u0000\u06fd\u06fe\u0005B\u0000"+
		"\u0000\u06fe\u0708\u0005\u00b2\u0000\u0000\u06ff\u0700\u0005\u00c9\u0000"+
		"\u0000\u0700\u0708\u0005b\u0000\u0000\u0701\u0702\u0003\u00a2Q\u0000\u0702"+
		"\u0703\u0005\u00ac\u0000\u0000\u0703\u0708\u0001\u0000\u0000\u0000\u0704"+
		"\u0705\u0003\u00a2Q\u0000\u0705\u0706\u0005b\u0000\u0000\u0706\u0708\u0001"+
		"\u0000\u0000\u0000\u0707\u06fd\u0001\u0000\u0000\u0000\u0707\u06ff\u0001"+
		"\u0000\u0000\u0000\u0707\u0701\u0001\u0000\u0000\u0000\u0707\u0704\u0001"+
		"\u0000\u0000\u0000\u0708\u0147\u0001\u0000\u0000\u0000\u0709\u070a\u0005"+
		"\\\u0000\u0000\u070a\u070b\u0005B\u0000\u0000\u070b\u0714\u0005\u00b2"+
		"\u0000\u0000\u070c\u070d\u0005\\\u0000\u0000\u070d\u0714\u0005h\u0000"+
		"\u0000\u070e\u070f\u0005\\\u0000\u0000\u070f\u0714\u0005\u00bd\u0000\u0000"+
		"\u0710\u0711\u0005\\\u0000\u0000\u0711\u0712\u0005\u0096\u0000\u0000\u0712"+
		"\u0714\u0005\u00a2\u0000\u0000\u0713\u0709\u0001\u0000\u0000\u0000\u0713"+
		"\u070c\u0001\u0000\u0000\u0000\u0713\u070e\u0001\u0000\u0000\u0000\u0713"+
		"\u0710\u0001\u0000\u0000\u0000\u0714\u0149\u0001\u0000\u0000\u0000\u0715"+
		"\u072a\u0003\u014c\u00a6\u0000\u0716\u072a\u0003\u0184\u00c2\u0000\u0717"+
		"\u072a\u0003\u0186\u00c3\u0000\u0718\u072a\u0003\u0180\u00c0\u0000\u0719"+
		"\u072a\u0003\u0088D\u0000\u071a\u072a\u0003\u0152\u00a9\u0000\u071b\u072a"+
		"\u0003\u0166\u00b3\u0000\u071c\u072a\u0003\u0158\u00ac\u0000\u071d\u072a"+
		"\u0003\u015e\u00af\u0000\u071e\u072a\u0003\u0194\u00ca\u0000\u071f\u072a"+
		"\u0003\u0170\u00b8\u0000\u0720\u072a\u0003\u0172\u00b9\u0000\u0721\u072a"+
		"\u0003\u0174\u00ba\u0000\u0722\u072a\u0003\u0176\u00bb\u0000\u0723\u072a"+
		"\u0003\u017c\u00be\u0000\u0724\u072a\u0003\u017e\u00bf\u0000\u0725\u072a"+
		"\u0003\u0178\u00bc\u0000\u0726\u072a\u0003\u017a\u00bd\u0000\u0727\u072a"+
		"\u0003\u019a\u00cd\u0000\u0728\u072a\u0003\u019c\u00ce\u0000\u0729\u0715"+
		"\u0001\u0000\u0000\u0000\u0729\u0716\u0001\u0000\u0000\u0000\u0729\u0717"+
		"\u0001\u0000\u0000\u0000\u0729\u0718\u0001\u0000\u0000\u0000\u0729\u0719"+
		"\u0001\u0000\u0000\u0000\u0729\u071a\u0001\u0000\u0000\u0000\u0729\u071b"+
		"\u0001\u0000\u0000\u0000\u0729\u071c\u0001\u0000\u0000\u0000\u0729\u071d"+
		"\u0001\u0000\u0000\u0000\u0729\u071e\u0001\u0000\u0000\u0000\u0729\u071f"+
		"\u0001\u0000\u0000\u0000\u0729\u0720\u0001\u0000\u0000\u0000\u0729\u0721"+
		"\u0001\u0000\u0000\u0000\u0729\u0722\u0001\u0000\u0000\u0000\u0729\u0723"+
		"\u0001\u0000\u0000\u0000\u0729\u0724\u0001\u0000\u0000\u0000\u0729\u0725"+
		"\u0001\u0000\u0000\u0000\u0729\u0726\u0001\u0000\u0000\u0000\u0729\u0727"+
		"\u0001\u0000\u0000\u0000\u0729\u0728\u0001\u0000\u0000\u0000\u072a\u014b"+
		"\u0001\u0000\u0000\u0000\u072b\u072c\u0005:\u0000\u0000\u072c\u072d\u0005"+
		"\u0018\u0000\u0000\u072d\u072e\u0003\u00a2Q\u0000\u072e\u072f\u00052\u0000"+
		"\u0000\u072f\u0730\u0003\u014e\u00a7\u0000\u0730\u0731\u0005\u0019\u0000"+
		"\u0000\u0731\u014d\u0001\u0000\u0000\u0000\u0732\u073a\u0003\u0150\u00a8"+
		"\u0000\u0733\u0734\u0005\u0018\u0000\u0000\u0734\u0737\u0005\u0003\u0000"+
		"\u0000\u0735\u0736\u0005\u0016\u0000\u0000\u0736\u0738\u0005\u0003\u0000"+
		"\u0000\u0737\u0735\u0001\u0000\u0000\u0000\u0737\u0738\u0001\u0000\u0000"+
		"\u0000\u0738\u0739\u0001\u0000\u0000\u0000\u0739\u073b\u0005\u0019\u0000"+
		"\u0000\u073a\u0733\u0001\u0000\u0000\u0000\u073a\u073b\u0001\u0000\u0000"+
		"\u0000\u073b\u014f\u0001\u0000\u0000\u0000\u073c\u073d\u0003\u01a0\u00d0"+
		"\u0000\u073d\u073e\u0006\u00a8\uffff\uffff\u0000\u073e\u0745\u0001\u0000"+
		"\u0000\u0000\u073f\u0740\u0005\u0017\u0000\u0000\u0740\u0741\u0003\u01a0"+
		"\u00d0\u0000\u0741\u0742\u0006\u00a8\uffff\uffff\u0000\u0742\u0744\u0001"+
		"\u0000\u0000\u0000\u0743\u073f\u0001\u0000\u0000\u0000\u0744\u0747\u0001"+
		"\u0000\u0000\u0000\u0745\u0743\u0001\u0000\u0000\u0000\u0745\u0746\u0001"+
		"\u0000\u0000\u0000\u0746\u0151\u0001\u0000\u0000\u0000\u0747\u0745\u0001"+
		"\u0000\u0000\u0000\u0748\u0749\u0005\u00ba\u0000\u0000\u0749\u074a\u0005"+
		"\u0018\u0000\u0000\u074a\u074b\u0003\u00a2Q\u0000\u074b\u074c\u0005\u0016"+
		"\u0000\u0000\u074c\u074f\u0003\u0154\u00aa\u0000\u074d\u074e\u0005\u0016"+
		"\u0000\u0000\u074e\u0750\u0003\u0156\u00ab\u0000\u074f\u074d\u0001\u0000"+
		"\u0000\u0000\u074f\u0750\u0001\u0000\u0000\u0000\u0750\u0751\u0001\u0000"+
		"\u0000\u0000\u0751\u0752\u0005\u0019\u0000\u0000\u0752\u075f\u0001\u0000"+
		"\u0000\u0000\u0753\u0754\u0005\u00ba\u0000\u0000\u0754\u0755\u0005\u0018"+
		"\u0000\u0000\u0755\u0756\u0003\u00a2Q\u0000\u0756\u0757\u0005e\u0000\u0000"+
		"\u0757\u075a\u0003\u0154\u00aa\u0000\u0758\u0759\u0005c\u0000\u0000\u0759"+
		"\u075b\u0003\u0156\u00ab\u0000\u075a\u0758\u0001\u0000\u0000\u0000\u075a"+
		"\u075b\u0001\u0000\u0000\u0000\u075b\u075c\u0001\u0000\u0000\u0000\u075c"+
		"\u075d\u0005\u0019\u0000\u0000\u075d\u075f\u0001\u0000\u0000\u0000\u075e"+
		"\u0748\u0001\u0000\u0000\u0000\u075e\u0753\u0001\u0000\u0000\u0000\u075f"+
		"\u0153\u0001\u0000\u0000\u0000\u0760\u0761\u0003\u00a2Q\u0000\u0761\u0155"+
		"\u0001\u0000\u0000\u0000\u0762\u0763\u0003\u00a2Q\u0000\u0763\u0157\u0001"+
		"\u0000\u0000\u0000\u0764\u0765\u0005\u00c5\u0000\u0000\u0765\u0767\u0005"+
		"\u0018\u0000\u0000\u0766\u0768\u0003\u015a\u00ad\u0000\u0767\u0766\u0001"+
		"\u0000\u0000\u0000\u0767\u0768\u0001\u0000\u0000\u0000\u0768\u076a\u0001"+
		"\u0000\u0000\u0000\u0769\u076b\u0003\u015c\u00ae\u0000\u076a\u0769\u0001"+
		"\u0000\u0000\u0000\u076a\u076b\u0001\u0000\u0000\u0000\u076b\u076d\u0001"+
		"\u0000\u0000\u0000\u076c\u076e\u0005e\u0000\u0000\u076d\u076c\u0001\u0000"+
		"\u0000\u0000\u076d\u076e\u0001\u0000\u0000\u0000\u076e\u076f\u0001\u0000"+
		"\u0000\u0000\u076f\u0770\u0003\u00a2Q\u0000\u0770\u0771\u0005\u0019\u0000"+
		"\u0000\u0771\u0159\u0001\u0000\u0000\u0000\u0772\u0773\u0007\u0019\u0000"+
		"\u0000\u0773\u015b\u0001\u0000\u0000\u0000\u0774\u0777\u0005\n\u0000\u0000"+
		"\u0775\u0777\u0003\u0112\u0089\u0000\u0776\u0774\u0001\u0000\u0000\u0000"+
		"\u0776\u0775\u0001\u0000\u0000\u0000\u0777\u015d\u0001\u0000\u0000\u0000"+
		"\u0778\u0779\u0005\u00a7\u0000\u0000\u0779\u077a\u0005\u0018\u0000\u0000"+
		"\u077a\u077b\u0003\u00a2Q\u0000\u077b\u077c\u0005\u00d2\u0000\u0000\u077c"+
		"\u077d\u0003\u0164\u00b2\u0000\u077d\u077f\u0003\u0160\u00b0\u0000\u077e"+
		"\u0780\u0003\u0162\u00b1\u0000\u077f\u077e\u0001\u0000\u0000\u0000\u077f"+
		"\u0780\u0001\u0000\u0000\u0000\u0780\u0781\u0001\u0000\u0000\u0000\u0781"+
		"\u0782\u0005\u0019\u0000\u0000\u0782\u015f\u0001\u0000\u0000\u0000\u0783"+
		"\u0784\u0007\u001a\u0000\u0000\u0784\u0161\u0001\u0000\u0000\u0000\u0785"+
		"\u0786\u0005\n\u0000\u0000\u0786\u0163\u0001\u0000\u0000\u0000\u0787\u0788"+
		"\u0003\u00a2Q\u0000\u0788\u0165\u0001\u0000\u0000\u0000\u0789\u078a\u0005"+
		"\u00a6\u0000\u0000\u078a\u078b\u0005\u0018\u0000\u0000\u078b\u078c\u0003"+
		"\u0168\u00b4\u0000\u078c\u078d\u0005\u00aa\u0000\u0000\u078d\u078e\u0003"+
		"\u016a\u00b5\u0000\u078e\u078f\u0005e\u0000\u0000\u078f\u0792\u0003\u016c"+
		"\u00b6\u0000\u0790\u0791\u0005c\u0000\u0000\u0791\u0793\u0003\u016e\u00b7"+
		"\u0000\u0792\u0790\u0001\u0000\u0000\u0000\u0792\u0793\u0001\u0000\u0000"+
		"\u0000\u0793\u0794\u0001\u0000\u0000\u0000\u0794\u0795\u0005\u0019\u0000"+
		"\u0000\u0795\u0167\u0001\u0000\u0000\u0000\u0796\u0797\u0003\u00a2Q\u0000"+
		"\u0797\u0169\u0001\u0000\u0000\u0000\u0798\u0799\u0003\u00a2Q\u0000\u0799"+
		"\u016b\u0001\u0000\u0000\u0000\u079a\u079b\u0003\u00a2Q\u0000\u079b\u016d"+
		"\u0001\u0000\u0000\u0000\u079c\u079d\u0003\u00a2Q\u0000\u079d\u016f\u0001"+
		"\u0000\u0000\u0000\u079e\u07a1\u0005C\u0000\u0000\u079f\u07a0\u0005\u0018"+
		"\u0000\u0000\u07a0\u07a2\u0005\u0019\u0000\u0000\u07a1\u079f\u0001\u0000"+
		"\u0000\u0000\u07a1\u07a2\u0001\u0000\u0000\u0000\u07a2\u07a6\u0001\u0000"+
		"\u0000\u0000\u07a3\u07a4\u0005B\u0000\u0000\u07a4\u07a6\u0005H\u0000\u0000"+
		"\u07a5\u079e\u0001\u0000\u0000\u0000\u07a5\u07a3\u0001\u0000\u0000\u0000"+
		"\u07a6\u0171\u0001\u0000\u0000\u0000\u07a7\u07aa\u0005E\u0000\u0000\u07a8"+
		"\u07a9\u0005\u0018\u0000\u0000\u07a9\u07ab\u0005\u0019\u0000\u0000\u07aa"+
		"\u07a8\u0001\u0000\u0000\u0000\u07aa\u07ab\u0001\u0000\u0000\u0000\u07ab"+
		"\u07af\u0001\u0000\u0000\u0000\u07ac\u07ad\u0005B\u0000\u0000\u07ad\u07af"+
		"\u0005\u00be\u0000\u0000\u07ae\u07a7\u0001\u0000\u0000\u0000\u07ae\u07ac"+
		"\u0001\u0000\u0000\u0000\u07af\u0173\u0001\u0000\u0000\u0000\u07b0\u07b3"+
		"\u0005F\u0000\u0000\u07b1\u07b2\u0005\u0018\u0000\u0000\u07b2\u07b4\u0005"+
		"\u0019\u0000\u0000\u07b3\u07b1\u0001\u0000\u0000\u0000\u07b3\u07b4\u0001"+
		"\u0000\u0000\u0000\u07b4\u07b8\u0001\u0000\u0000\u0000\u07b5\u07b6\u0005"+
		"B\u0000\u0000\u07b6\u07b8\u0005\u00bf\u0000\u0000\u07b7\u07b0\u0001\u0000"+
		"\u0000\u0000\u07b7\u07b5\u0001\u0000\u0000\u0000\u07b8\u0175\u0001\u0000"+
		"\u0000\u0000\u07b9\u07bc\u0005D\u0000\u0000\u07ba\u07bb\u0005\u0018\u0000"+
		"\u0000\u07bb\u07bd\u0005\u0019\u0000\u0000\u07bc\u07ba\u0001\u0000\u0000"+
		"\u0000\u07bc\u07bd\u0001\u0000\u0000\u0000\u07bd\u07c0\u0001\u0000\u0000"+
		"\u0000\u07be\u07c0\u0005s\u0000\u0000\u07bf\u07b9\u0001\u0000\u0000\u0000"+
		"\u07bf\u07be\u0001\u0000\u0000\u0000\u07c0\u0177\u0001\u0000\u0000\u0000"+
		"\u07c1\u07c4\u0005\u0084\u0000\u0000\u07c2\u07c3\u0005\u0018\u0000\u0000"+
		"\u07c3\u07c5\u0005\u0019\u0000\u0000\u07c4\u07c2\u0001\u0000\u0000\u0000"+
		"\u07c4\u07c5\u0001\u0000\u0000\u0000\u07c5\u07c9\u0001\u0000\u0000\u0000"+
		"\u07c6\u07c7\u0005\u0082\u0000\u0000\u07c7\u07c9\u0005I\u0000\u0000\u07c8"+
		"\u07c1\u0001\u0000\u0000\u0000\u07c8\u07c6\u0001\u0000\u0000\u0000\u07c9"+
		"\u0179\u0001\u0000\u0000\u0000\u07ca\u07cd\u0005\u009d\u0000\u0000\u07cb"+
		"\u07cc\u0005\u0018\u0000\u0000\u07cc\u07ce\u0005\u0019\u0000\u0000\u07cd"+
		"\u07cb\u0001\u0000\u0000\u0000\u07cd\u07ce\u0001\u0000\u0000\u0000\u07ce"+
		"\u07d2\u0001\u0000\u0000\u0000\u07cf\u07d0\u0005\u009c\u0000\u0000\u07d0"+
		"\u07d2\u0005I\u0000\u0000\u07d1\u07ca\u0001\u0000\u0000\u0000\u07d1\u07cf"+
		"\u0001\u0000\u0000\u0000\u07d2\u017b\u0001\u0000\u0000\u0000\u07d3\u07d6"+
		"\u0005\u0083\u0000\u0000\u07d4\u07d5\u0005\u0018\u0000\u0000\u07d5\u07d7"+
		"\u0005\u0019\u0000\u0000\u07d6\u07d4\u0001\u0000\u0000\u0000\u07d6\u07d7"+
		"\u0001\u0000\u0000\u0000\u07d7\u07db\u0001\u0000\u0000\u0000\u07d8\u07d9"+
		"\u0005\u0082\u0000\u0000\u07d9\u07db\u0005H\u0000\u0000\u07da\u07d3\u0001"+
		"\u0000\u0000\u0000\u07da\u07d8\u0001\u0000\u0000\u0000\u07db\u017d\u0001"+
		"\u0000\u0000\u0000\u07dc\u07df\u0005\u0085\u0000\u0000\u07dd\u07de\u0005"+
		"\u0018\u0000\u0000\u07de\u07e0\u0005\u0019\u0000\u0000\u07df\u07dd\u0001"+
		"\u0000\u0000\u0000\u07df\u07e0\u0001\u0000\u0000\u0000\u07e0\u07e4\u0001"+
		"\u0000\u0000\u0000\u07e1\u07e2\u0005\u0082\u0000\u0000\u07e2\u07e4\u0005"+
		"\u00be\u0000\u0000\u07e3\u07dc\u0001\u0000\u0000\u0000\u07e3\u07e1\u0001"+
		"\u0000\u0000\u0000\u07e4\u017f\u0001\u0000\u0000\u0000\u07e5\u07e6\u0005"+
		"d\u0000\u0000\u07e6\u07e7\u0005\u0018\u0000\u0000\u07e7\u07e8\u0003\u00a2"+
		"Q\u0000\u07e8\u07e9\u00052\u0000\u0000\u07e9\u07ea\u0003\u0182\u00c1\u0000"+
		"\u07ea\u07eb\u0005\u0019\u0000\u0000\u07eb\u0181\u0001\u0000\u0000\u0000"+
		"\u07ec\u07ed\u0005\n\u0000\u0000\u07ed\u0183\u0001\u0000\u0000\u0000\u07ee"+
		"\u07ef\u0005^\u0000\u0000\u07ef\u07f0\u0005\u0018\u0000\u0000\u07f0\u07f1"+
		"\u0003\u0188\u00c4\u0000\u07f1\u07f2\u0005e\u0000\u0000\u07f2\u07f3\u0003"+
		"\u00a2Q\u0000\u07f3\u07f4\u0005\u0019\u0000\u0000\u07f4\u07fb\u0001\u0000"+
		"\u0000\u0000\u07f5\u07f6\u0003\u018a\u00c5\u0000\u07f6\u07f7\u0005\u0018"+
		"\u0000\u0000\u07f7\u07f8\u0003\u00a2Q\u0000\u07f8\u07f9\u0005\u0019\u0000"+
		"\u0000\u07f9\u07fb\u0001\u0000\u0000\u0000\u07fa\u07ee\u0001\u0000\u0000"+
		"\u0000\u07fa\u07f5\u0001\u0000\u0000\u0000\u07fb\u0185\u0001\u0000\u0000"+
		"\u0000\u07fc\u07fd\u0007\u001b\u0000\u0000\u07fd\u07fe\u0005\u0018\u0000"+
		"\u0000\u07fe\u0804\u0003\u00a2Q\u0000\u07ff\u0802\u0005\u0016\u0000\u0000"+
		"\u0800\u0803\u0003\u018a\u00c5\u0000\u0801\u0803\u0003\u00a2Q\u0000\u0802"+
		"\u0800\u0001\u0000\u0000\u0000\u0802\u0801\u0001\u0000\u0000\u0000\u0803"+
		"\u0805\u0001\u0000\u0000\u0000\u0804\u07ff\u0001\u0000\u0000\u0000\u0804"+
		"\u0805\u0001\u0000\u0000\u0000\u0805\u0806\u0001\u0000\u0000\u0000\u0806"+
		"\u0807\u0005\u0019\u0000\u0000\u0807\u0187\u0001\u0000\u0000\u0000\u0808"+
		"\u080e\u0003\u018a\u00c5\u0000\u0809\u080e\u0003\u018c\u00c6\u0000\u080a"+
		"\u080e\u0003\u018e\u00c7\u0000\u080b\u080e\u0003\u0190\u00c8\u0000\u080c"+
		"\u080e\u0003\u0192\u00c9\u0000\u080d\u0808\u0001\u0000\u0000\u0000\u080d"+
		"\u0809\u0001\u0000\u0000\u0000\u080d\u080a\u0001\u0000\u0000\u0000\u080d"+
		"\u080b\u0001\u0000\u0000\u0000\u080d\u080c\u0001\u0000\u0000\u0000\u080e"+
		"\u0189\u0001\u0000\u0000\u0000\u080f\u0810\u0007\u001c\u0000\u0000\u0810"+
		"\u018b\u0001\u0000\u0000\u0000\u0811\u0812\u0005J\u0000\u0000\u0812\u0813"+
		"\u0005\u009b\u0000\u0000\u0813\u081b\u0005\u0092\u0000\u0000\u0814\u0815"+
		"\u0005J\u0000\u0000\u0815\u0816\u0005\u009b\u0000\u0000\u0816\u081b\u0005"+
		"\u00cf\u0000\u0000\u0817\u0818\u0005J\u0000\u0000\u0818\u0819\u0005\u009b"+
		"\u0000\u0000\u0819\u081b\u0005\u00d5\u0000\u0000\u081a\u0811\u0001\u0000"+
		"\u0000\u0000\u081a\u0814\u0001\u0000\u0000\u0000\u081a\u0817\u0001\u0000"+
		"\u0000\u0000\u081b\u018d\u0001\u0000\u0000\u0000\u081c\u081d\u0005\u00cf"+
		"\u0000\u0000\u081d\u081e\u0005\u009b\u0000\u0000\u081e\u0823\u0005\u0092"+
		"\u0000\u0000\u081f\u0820\u0005\u00cf\u0000\u0000\u0820\u0821\u0005\u009b"+
		"\u0000\u0000\u0821\u0823\u0005\u00d5\u0000\u0000\u0822\u081c\u0001\u0000"+
		"\u0000\u0000\u0822\u081f\u0001\u0000\u0000\u0000\u0823\u018f\u0001\u0000"+
		"\u0000\u0000\u0824\u0826\u0005\u009c\u0000\u0000\u0825\u0827\u0007\u001d"+
		"\u0000\u0000\u0826\u0825\u0001\u0000\u0000\u0000\u0826\u0827\u0001\u0000"+
		"\u0000\u0000\u0827\u082b\u0001\u0000\u0000\u0000\u0828\u082b\u0005\u00c0"+
		"\u0000\u0000\u0829\u082b\u0005\u00c1\u0000\u0000\u082a\u0824\u0001\u0000"+
		"\u0000\u0000\u082a\u0828\u0001\u0000\u0000\u0000\u082a\u0829\u0001\u0000"+
		"\u0000\u0000\u082b\u0191\u0001\u0000\u0000\u0000\u082c\u082d\u0007\u001e"+
		"\u0000\u0000\u082d\u0193\u0001\u0000\u0000\u0000\u082e\u082f\u0005\u00ab"+
		"\u0000\u0000\u082f\u0830\u0005\u0018\u0000\u0000\u0830\u0831\u0003\u0196"+
		"\u00cb\u0000\u0831\u0832\u0005n\u0000\u0000\u0832\u0833\u0003\u0198\u00cc"+
		"\u0000\u0833\u0834\u0005\u0019\u0000\u0000\u0834\u0195\u0001\u0000\u0000"+
		"\u0000\u0835\u0836\u0003\u00a2Q\u0000\u0836\u0197\u0001\u0000\u0000\u0000"+
		"\u0837\u0838\u0003\u00a2Q\u0000\u0838\u0199\u0001\u0000\u0000\u0000\u0839"+
		"\u083a\u0005A\u0000\u0000\u083a\u083b\u0005\u0018\u0000\u0000\u083b\u0840"+
		"\u0003\u00a6S\u0000\u083c\u083d\u0005\u0016\u0000\u0000\u083d\u083f\u0003"+
		"\u00a6S\u0000\u083e\u083c\u0001\u0000\u0000\u0000\u083f\u0842\u0001\u0000"+
		"\u0000\u0000\u0840\u083e\u0001\u0000\u0000\u0000\u0840\u0841\u0001\u0000"+
		"\u0000\u0000\u0841\u0843\u0001\u0000\u0000\u0000\u0842\u0840\u0001\u0000"+
		"\u0000\u0000\u0843\u0844\u0005\u0019\u0000\u0000\u0844\u019b\u0001\u0000"+
		"\u0000\u0000\u0845\u0846\u0005\u00b1\u0000\u0000\u0846\u0847\u0005\u0018"+
		"\u0000\u0000\u0847\u084c\u0003\u00a6S\u0000\u0848\u0849\u0005\u0016\u0000"+
		"\u0000\u0849\u084b\u0003\u00a6S\u0000\u084a\u0848\u0001\u0000\u0000\u0000"+
		"\u084b\u084e\u0001\u0000\u0000\u0000\u084c\u084a\u0001\u0000\u0000\u0000"+
		"\u084c\u084d\u0001\u0000\u0000\u0000\u084d\u084f\u0001\u0000\u0000\u0000"+
		"\u084e\u084c\u0001\u0000\u0000\u0000\u084f\u0850\u0005\u0019\u0000\u0000"+
		"\u0850\u019d\u0001\u0000\u0000\u0000\u0851\u0856\u0005\u00da\u0000\u0000"+
		"\u0852\u0856\u0005\u00db\u0000\u0000\u0853\u0854\u0007\u001f\u0000\u0000"+
		"\u0854\u0856\u0006\u00cf\uffff\uffff\u0000\u0855\u0851\u0001\u0000\u0000"+
		"\u0000\u0855\u0852\u0001\u0000\u0000\u0000\u0855\u0853\u0001\u0000\u0000"+
		"\u0000\u0856\u019f\u0001\u0000\u0000\u0000\u0857\u085b\u0003\u019e\u00cf"+
		"\u0000\u0858\u0859\u0007 \u0000\u0000\u0859\u085b\u0006\u00d0\uffff\uffff"+
		"\u0000\u085a\u0857\u0001\u0000\u0000\u0000\u085a\u0858\u0001\u0000\u0000"+
		"\u0000\u085b\u01a1\u0001\u0000\u0000\u0000\u00f2\u01a6\u01b0\u01b4\u01b8"+
		"\u01bc\u01c1\u01c9\u01d2\u01d8\u01db\u01e3\u01ee\u01f7\u01ff\u020d\u0212"+
		"\u0218\u021a\u0222\u0228\u022b\u0231\u0234\u023b\u024b\u0250\u0253\u025e"+
		"\u0262\u0265\u0269\u0271\u0273\u0277\u027d\u0280\u0284\u0288\u028c\u028e"+
		"\u0292\u0295\u0298\u029c\u029f\u02a3\u02a5\u02a9\u02ad\u02af\u02b2\u02b5"+
		"\u02bd\u02c4\u02c6\u02cb\u02d1\u02d3\u02da\u02e0\u02e6\u02ee\u02f3\u02f7"+
		"\u02fa\u02fd\u0300\u0302\u0306\u0309\u030f\u0311\u0318\u0321\u0326\u032c"+
		"\u033c\u0343\u0348\u034c\u0357\u035f\u0362\u036d\u0371\u0378\u0381\u0388"+
		"\u038f\u0398\u039e\u03aa\u03b2\u03b7\u03ba\u03c2\u03d5\u03de\u03e4\u03e8"+
		"\u03ef\u03fc\u0403\u040a\u0411\u0418\u0420\u0424\u042a\u0431\u043a\u043f"+
		"\u0450\u0458\u045a\u046a\u046d\u0475\u047b\u0488\u0497\u04a9\u04ab\u04b8"+
		"\u04bc\u04c0\u04c4\u04d8\u04e1\u04ed\u04f6\u04fd\u0500\u0510\u0513\u0524"+
		"\u0531\u0535\u053d\u0542\u0549\u054d\u0554\u0558\u055f\u0563\u056a\u056e"+
		"\u0575\u0579\u057e\u059a\u05a0\u05b6\u05b9\u05be\u05c5\u05cc\u05e0\u05e2"+
		"\u05ec\u05f3\u05f7\u05fd\u0606\u060e\u0612\u0615\u0618\u061b\u061e\u0626"+
		"\u062d\u064f\u065b\u0660\u0667\u066a\u0677\u067e\u0681\u068e\u0697\u069d"+
		"\u06a1\u06a4\u06a7\u06ae\u06b2\u06c3\u06c9\u06ce\u06d1\u06d4\u06df\u06e5"+
		"\u06ed\u06ef\u06fb\u0707\u0713\u0729\u0737\u073a\u0745\u074f\u075a\u075e"+
		"\u0767\u076a\u076d\u0776\u077f\u0792\u07a1\u07a5\u07aa\u07ae\u07b3\u07b7"+
		"\u07bc\u07bf\u07c4\u07c8\u07cd\u07d1\u07d6\u07da\u07df\u07e3\u07fa\u0802"+
		"\u0804\u080d\u081a\u0822\u0826\u082a\u0840\u084c\u0855\u085a";
	public static final ATN _ATN =
		new ATNDeserializer().deserialize(_serializedATN.toCharArray());
	static {
		_decisionToDFA = new DFA[_ATN.getNumberOfDecisions()];
		for (int i = 0; i < _ATN.getNumberOfDecisions(); i++) {
			_decisionToDFA[i] = new DFA(_ATN.getDecisionState(i), i);
		}
	}
}
