
package org.hibernate.boot.jaxb.mapping;

import java.io.Serializable;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 *                 See @EmbeddableInstantiatorRegistration
 *             
 * 
 * <p>Java class for embeddable-instantiator-registration complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="embeddable-instantiator-registration">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="embeddableClass" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="instantiator" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "embeddable-instantiator-registration", namespace = "http://www.hibernate.org/xsd/orm/mapping")
public class JaxbEmbeddableInstantiatorRegistration
    implements Serializable
{

    @XmlAttribute(name = "embeddableClass", required = true)
    protected String embeddableClass;
    @XmlAttribute(name = "instantiator", required = true)
    protected String instantiator;

    /**
     * Gets the value of the embeddableClass property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getEmbeddableClass() {
        return embeddableClass;
    }

    /**
     * Sets the value of the embeddableClass property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setEmbeddableClass(String value) {
        this.embeddableClass = value;
    }

    /**
     * Gets the value of the instantiator property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getInstantiator() {
        return instantiator;
    }

    /**
     * Sets the value of the instantiator property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setInstantiator(String value) {
        this.instantiator = value;
    }

}
