
package org.hibernate.boot.jaxb.hbm.spi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 *                 Declares the id type, column and generation algorithm for an entity class.
 *                 If a name attribute is given, the id is exposed to the application through the
 *                 named property of the class. If not, the id is only exposed to the application
 *                 via Session.getIdentifier()
 *             
 * 
 * <p>Java class for SimpleIdType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="SimpleIdType">
 *   <complexContent>
 *     <extension base="{http://www.hibernate.org/xsd/orm/hbm}ToolingHintContainer">
 *       <sequence>
 *         <element name="column" type="{http://www.hibernate.org/xsd/orm/hbm}ColumnType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="type" type="{http://www.hibernate.org/xsd/orm/hbm}TypeSpecificationType" minOccurs="0"/>
 *         <element name="generator" type="{http://www.hibernate.org/xsd/orm/hbm}GeneratorSpecificationType" minOccurs="0"/>
 *       </sequence>
 *       <attribute name="access" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="column" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="length" type="{http://www.w3.org/2001/XMLSchema}int" />
 *       <attribute name="name" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="node" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="type" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="unsaved-value" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SimpleIdType", namespace = "http://www.hibernate.org/xsd/orm/hbm", propOrder = {
    "column",
    "type",
    "generator"
})
public class JaxbHbmSimpleIdType
    extends JaxbHbmToolingHintContainer
    implements Serializable, SingularAttributeInfo, ToolingHintContainer, TypeContainer
{

    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/hbm")
    protected List<JaxbHbmColumnType> column;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/hbm")
    protected JaxbHbmTypeSpecificationType type;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/hbm")
    protected JaxbHbmGeneratorSpecificationType generator;
    @XmlAttribute(name = "access")
    protected String access;
    @XmlAttribute(name = "column")
    protected String columnAttribute;
    @XmlAttribute(name = "length")
    protected Integer length;
    @XmlAttribute(name = "name")
    protected String name;
    @XmlAttribute(name = "node")
    protected String node;
    @XmlAttribute(name = "type")
    protected String typeAttribute;
    @XmlAttribute(name = "unsaved-value")
    protected String unsavedValue;

    /**
     * Gets the value of the column property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the column property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getColumn().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbHbmColumnType }
     * 
     * 
     * @return
     *     The value of the column property.
     */
    public List<JaxbHbmColumnType> getColumn() {
        if (column == null) {
            column = new ArrayList<>();
        }
        return this.column;
    }

    /**
     * Gets the value of the type property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbHbmTypeSpecificationType }
     *     
     */
    public JaxbHbmTypeSpecificationType getType() {
        return type;
    }

    /**
     * Sets the value of the type property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbHbmTypeSpecificationType }
     *     
     */
    public void setType(JaxbHbmTypeSpecificationType value) {
        this.type = value;
    }

    /**
     * Gets the value of the generator property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbHbmGeneratorSpecificationType }
     *     
     */
    public JaxbHbmGeneratorSpecificationType getGenerator() {
        return generator;
    }

    /**
     * Sets the value of the generator property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbHbmGeneratorSpecificationType }
     *     
     */
    public void setGenerator(JaxbHbmGeneratorSpecificationType value) {
        this.generator = value;
    }

    /**
     * Gets the value of the access property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAccess() {
        return access;
    }

    /**
     * Sets the value of the access property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAccess(String value) {
        this.access = value;
    }

    /**
     * Gets the value of the columnAttribute property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getColumnAttribute() {
        return columnAttribute;
    }

    /**
     * Sets the value of the columnAttribute property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setColumnAttribute(String value) {
        this.columnAttribute = value;
    }

    /**
     * Gets the value of the length property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public Integer getLength() {
        return length;
    }

    /**
     * Sets the value of the length property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setLength(Integer value) {
        this.length = value;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setName(String value) {
        this.name = value;
    }

    /**
     * Gets the value of the node property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getNode() {
        return node;
    }

    /**
     * Sets the value of the node property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setNode(String value) {
        this.node = value;
    }

    /**
     * Gets the value of the typeAttribute property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTypeAttribute() {
        return typeAttribute;
    }

    /**
     * Sets the value of the typeAttribute property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTypeAttribute(String value) {
        this.typeAttribute = value;
    }

    /**
     * Gets the value of the unsavedValue property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getUnsavedValue() {
        return unsavedValue;
    }

    /**
     * Sets the value of the unsavedValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setUnsavedValue(String value) {
        this.unsavedValue = value;
    }

}
