/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;
import java.util.function.Consumer;
import org.hibernate.MappingException;
import org.hibernate.SharedSessionContract;
import org.hibernate.bytecode.spi.ReflectionOptimizer;
import org.hibernate.cache.MutableCacheKeyBuilder;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.IndexedConsumer;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.UnsupportedMappingException;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.AttributeMappingsList;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectableMappings;
import org.hibernate.metamodel.mapping.SelectablePath;
import org.hibernate.metamodel.mapping.internal.AbstractSingularAttributeMapping;
import org.hibernate.metamodel.mapping.internal.BasicAttributeMapping;
import org.hibernate.metamodel.mapping.internal.DiscriminatedAssociationAttributeMapping;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationHelper;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.mapping.internal.MutableAttributeMappingList;
import org.hibernate.metamodel.mapping.internal.SelectableMappingsImpl;
import org.hibernate.metamodel.mapping.internal.SimpleAttributeMetadata;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.spi.EmbeddableRepresentationStrategy;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.property.access.internal.PropertyAccessStrategyBackRefImpl;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.type.AnyType;
import org.hibernate.type.BasicType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.spi.TypeConfiguration;

public abstract class AbstractEmbeddableMapping
implements EmbeddableMappingType {
    protected final MutableAttributeMappingList attributeMappings;
    protected SelectableMappings selectableMappings;

    public AbstractEmbeddableMapping(MutableAttributeMappingList attributeMappings) {
        this.attributeMappings = attributeMappings;
    }

    @Override
    public JavaType<?> getMappedJavaType() {
        return this.getRepresentationStrategy().getMappedJavaType();
    }

    @Override
    public Object[] getValues(Object compositeInstance) {
        if (compositeInstance == PropertyAccessStrategyBackRefImpl.UNKNOWN) {
            return new Object[this.getNumberOfAttributeMappings()];
        }
        ReflectionOptimizer optimizer = this.getRepresentationStrategy().getReflectionOptimizer();
        if (optimizer != null && optimizer.getAccessOptimizer() != null) {
            return optimizer.getAccessOptimizer().getPropertyValues(compositeInstance);
        }
        Object[] results = new Object[this.getNumberOfAttributeMappings()];
        for (int i = 0; i < results.length; ++i) {
            Getter getter = this.getAttributeMapping(i).getAttributeMetadata().getPropertyAccess().getGetter();
            results[i] = getter.get(compositeInstance);
        }
        return results;
    }

    @Override
    public void setValues(Object component, Object[] values) {
        ReflectionOptimizer optimizer = this.getRepresentationStrategy().getReflectionOptimizer();
        if (optimizer != null && optimizer.getAccessOptimizer() != null) {
            optimizer.getAccessOptimizer().setPropertyValues(component, values);
        } else {
            for (int i = 0; i < values.length; ++i) {
                this.getAttributeMapping(i).getPropertyAccess().getSetter().set(component, values[i]);
            }
        }
    }

    protected boolean inverseInitializeCallback(TableGroupProducer declaringTableGroupProducer, SelectableMappings selectableMappings, EmbeddableMappingType inverseMappingType, MappingModelCreationProcess creationProcess, ManagedMappingType declaringType, MutableAttributeMappingList mappings) {
        int size = inverseMappingType.getNumberOfAttributeMappings();
        if (size == 0) {
            return false;
        }
        mappings.clear();
        int currentIndex = 0;
        for (int j = 0; j < size; ++j) {
            AbstractSingularAttributeMapping original;
            AttributeMapping attributeMapping = inverseMappingType.getAttributeMapping(j);
            if (attributeMapping instanceof BasicAttributeMapping) {
                original = (BasicAttributeMapping)attributeMapping;
                SelectableMapping selectableMapping = selectableMappings.getSelectable(currentIndex);
                attributeMapping = BasicAttributeMapping.withSelectableMapping(declaringType, (BasicValuedModelPart)((Object)original), original.getPropertyAccess(), selectableMapping.isInsertable(), selectableMapping.isUpdateable(), selectableMapping);
                ++currentIndex;
            } else if (attributeMapping instanceof ToOneAttributeMapping) {
                original = (ToOneAttributeMapping)attributeMapping;
                ForeignKeyDescriptor foreignKeyDescriptor = ((ToOneAttributeMapping)original).getForeignKeyDescriptor();
                if (foreignKeyDescriptor == null) {
                    throw new IllegalStateException("Not yet ready: " + (ToOneAttributeMapping)original);
                }
                ToOneAttributeMapping toOne = ((ToOneAttributeMapping)original).copy(declaringType, declaringTableGroupProducer);
                int offset = currentIndex;
                toOne.setIdentifyingColumnsTableExpression(selectableMappings.getSelectable(offset).getContainingTableExpression());
                toOne.setForeignKeyDescriptor(foreignKeyDescriptor.withKeySelectionMapping(declaringType, declaringTableGroupProducer, index -> selectableMappings.getSelectable(offset + index), creationProcess));
                attributeMapping = toOne;
                currentIndex += attributeMapping.getJdbcTypeCount();
            } else if (attributeMapping instanceof EmbeddableValuedModelPart) {
                SelectableMapping[] subMappings = new SelectableMapping[attributeMapping.getJdbcTypeCount()];
                for (int i = 0; i < subMappings.length; ++i) {
                    subMappings[i] = selectableMappings.getSelectable(currentIndex++);
                }
                attributeMapping = MappingModelCreationHelper.createInverseModelPart((EmbeddableValuedModelPart)((Object)attributeMapping), declaringType, declaringTableGroupProducer, new SelectableMappingsImpl(subMappings), creationProcess);
            } else {
                throw new UnsupportedMappingException("Only basic and to-one attributes are supported in composite fks");
            }
            mappings.add(attributeMapping);
        }
        return true;
    }

    protected boolean finishInitialization(NavigableRole navigableRole, Component bootDescriptor, CompositeType compositeType, String rootTableExpression, String[] rootTableKeyColumnNames, EmbeddableMappingType declarer, EmbeddableRepresentationStrategy representationStrategy, AttributeTypeValidator attributeTypeValidator, ConcreteTableResolver concreteTableResolver, Consumer<AttributeMapping> attributeConsumer, SuccessfulCompletionCallback completionCallback, MappingModelCreationProcess creationProcess) {
        TypeConfiguration typeConfiguration = creationProcess.getCreationContext().getTypeConfiguration();
        JdbcServices jdbcServices = creationProcess.getCreationContext().getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        Dialect dialect = jdbcEnvironment.getDialect();
        Type[] subtypes = compositeType.getSubtypes();
        int attributeIndex = 0;
        int columnPosition = 0;
        for (Property bootPropertyDescriptor : bootDescriptor.getProperties()) {
            AttributeMapping attributeMapping;
            Type subtype = subtypes[attributeIndex];
            attributeTypeValidator.check(bootPropertyDescriptor.getName(), subtype);
            PropertyAccess propertyAccess = representationStrategy.resolvePropertyAccess(bootPropertyDescriptor);
            Value value = bootPropertyDescriptor.getValue();
            if (subtype instanceof BasicType) {
                SelectablePath selectablePath;
                boolean isLob;
                boolean nullable;
                Integer temporalPrecision;
                Integer scale;
                Integer precision;
                Long length;
                String columnDefinition;
                String containingTableExpression;
                String columnExpression;
                BasicValue basicValue = (BasicValue)value;
                Selectable selectable = basicValue.getColumn();
                if (rootTableKeyColumnNames == null) {
                    columnExpression = selectable.isFormula() ? selectable.getTemplate(dialect, creationProcess.getCreationContext().getTypeConfiguration(), creationProcess.getSqmFunctionRegistry()) : selectable.getText(dialect);
                    containingTableExpression = selectable instanceof Column ? concreteTableResolver.resolve((Column)selectable, jdbcEnvironment) : rootTableExpression;
                } else {
                    containingTableExpression = rootTableExpression;
                    columnExpression = rootTableKeyColumnNames[columnPosition];
                }
                if (selectable instanceof Column) {
                    Column column = (Column)selectable;
                    columnDefinition = column.getSqlType();
                    length = column.getLength();
                    precision = column.getPrecision();
                    scale = column.getScale();
                    temporalPrecision = column.getTemporalPrecision();
                    nullable = column.isNullable();
                    isLob = column.isSqlTypeLob(creationProcess.getCreationContext().getMetadata());
                    selectablePath = basicValue.createSelectablePath(column.getQuotedName(dialect));
                } else {
                    columnDefinition = null;
                    length = null;
                    precision = null;
                    scale = null;
                    temporalPrecision = null;
                    nullable = true;
                    isLob = false;
                    selectablePath = new SelectablePath(this.determineEmbeddablePrefix() + bootPropertyDescriptor.getName());
                }
                attributeMapping = MappingModelCreationHelper.buildBasicAttributeMapping(bootPropertyDescriptor.getName(), navigableRole.append(bootPropertyDescriptor.getName()), attributeIndex, attributeIndex, bootPropertyDescriptor, declarer, (BasicType)subtype, containingTableExpression, columnExpression, selectablePath, selectable.isFormula(), selectable.getCustomReadExpression(), selectable.getWriteExpr(((BasicType)subtype).getJdbcMapping(), dialect), columnDefinition, length, precision, scale, temporalPrecision, isLob, nullable, value.isColumnInsertable(0), value.isColumnUpdateable(0), propertyAccess, compositeType.getCascadeStyle(attributeIndex), creationProcess);
                ++columnPosition;
            } else if (subtype instanceof AnyType) {
                Any bootValueMapping = (Any)value;
                AnyType anyType = (AnyType)subtype;
                boolean nullable = bootValueMapping.isNullable();
                boolean insertable = value.isColumnInsertable(0);
                boolean updateable = value.isColumnUpdateable(0);
                boolean includeInOptimisticLocking = bootPropertyDescriptor.isOptimisticLocked();
                CascadeStyle cascadeStyle = compositeType.getCascadeStyle(attributeIndex);
                SimpleAttributeMetadata attributeMetadataAccess = new SimpleAttributeMetadata(propertyAccess, AbstractEmbeddableMapping.getMutabilityPlan(updateable), nullable, insertable, updateable, includeInOptimisticLocking, true, cascadeStyle);
                attributeMapping = new DiscriminatedAssociationAttributeMapping(navigableRole.append(bootPropertyDescriptor.getName()), typeConfiguration.getJavaTypeRegistry().getDescriptor((java.lang.reflect.Type)((Object)Object.class)), declarer, attributeIndex, attributeIndex, attributeMetadataAccess, bootPropertyDescriptor.isLazy() ? FetchTiming.DELAYED : FetchTiming.IMMEDIATE, propertyAccess, bootPropertyDescriptor, anyType, bootValueMapping, creationProcess);
            } else if (subtype instanceof CompositeType) {
                String[] subRootTableKeyColumnNames;
                String subTableExpression;
                CompositeType subCompositeType = (CompositeType)subtype;
                int columnSpan = subCompositeType.getColumnSpan(creationProcess.getCreationContext().getMetadata());
                if (rootTableKeyColumnNames == null) {
                    subTableExpression = rootTableExpression;
                    subRootTableKeyColumnNames = null;
                } else {
                    subTableExpression = rootTableExpression;
                    subRootTableKeyColumnNames = new String[columnSpan];
                    System.arraycopy(rootTableKeyColumnNames, columnPosition, subRootTableKeyColumnNames, 0, columnSpan);
                }
                attributeMapping = MappingModelCreationHelper.buildEmbeddedAttributeMapping(bootPropertyDescriptor.getName(), attributeIndex, attributeIndex, bootPropertyDescriptor, declarer, subCompositeType, subTableExpression, subRootTableKeyColumnNames, propertyAccess, compositeType.getCascadeStyle(attributeIndex), creationProcess);
                columnPosition += columnSpan;
            } else if (subtype instanceof CollectionType) {
                attributeMapping = MappingModelCreationHelper.buildPluralAttributeMapping(bootPropertyDescriptor.getName(), attributeIndex, attributeIndex, bootPropertyDescriptor, this, propertyAccess, compositeType.getCascadeStyle(attributeIndex), compositeType.getFetchMode(attributeIndex), creationProcess);
            } else if (subtype instanceof EntityType) {
                EntityPersister entityPersister = creationProcess.getEntityPersister(bootDescriptor.getOwner().getEntityName());
                attributeMapping = MappingModelCreationHelper.buildSingularAssociationAttributeMapping(bootPropertyDescriptor.getName(), navigableRole.append(bootPropertyDescriptor.getName()), attributeIndex, attributeIndex, bootPropertyDescriptor, this, entityPersister, (EntityType)subtype, representationStrategy.resolvePropertyAccess(bootPropertyDescriptor), compositeType.getCascadeStyle(attributeIndex), creationProcess);
                columnPosition += bootPropertyDescriptor.getColumnSpan();
            } else {
                throw new MappingException(String.format(Locale.ROOT, "Unable to determine attribute nature : %s#%s", bootDescriptor.getOwner().getEntityName(), bootPropertyDescriptor.getName()));
            }
            attributeConsumer.accept(attributeMapping);
            ++attributeIndex;
        }
        completionCallback.success();
        return true;
    }

    protected String determineEmbeddablePrefix() {
        NavigableRole root = this.getNavigableRole().getParent();
        while (!root.isRoot()) {
            root = root.getParent();
        }
        return this.getNavigableRole().getFullPath().substring(root.getFullPath().length() + 1) + ".";
    }

    @Override
    public int getNumberOfFetchables() {
        return this.getAttributeMappings().size();
    }

    @Override
    public Fetchable getFetchable(int position) {
        return this.getAttributeMappings().get(position);
    }

    @Override
    public void visitFetchables(Consumer<? super Fetchable> consumer, EntityMappingType treatTargetType) {
        this.forEachAttributeMapping(consumer);
    }

    @Override
    public void visitFetchables(IndexedConsumer<? super Fetchable> indexedConsumer, EntityMappingType treatTargetType) {
        this.getAttributeMappings().indexedForEach(indexedConsumer);
    }

    @Override
    public int getNumberOfAttributeMappings() {
        return this.getAttributeMappings().size();
    }

    @Override
    public AttributeMapping getAttributeMapping(int position) {
        return this.getAttributeMappings().get(position);
    }

    @Override
    public AttributeMapping findAttributeMapping(String name) {
        AttributeMappingsList attributes = this.getAttributeMappings();
        for (int i = 0; i < attributes.size(); ++i) {
            AttributeMapping attr = attributes.get(i);
            if (!name.equals(attr.getAttributeName())) continue;
            return attr;
        }
        return null;
    }

    @Override
    public AttributeMappingsList getAttributeMappings() {
        this.checkIsReady();
        return this.attributeMappings;
    }

    private void checkIsReady() {
        if (this.selectableMappings == null) {
            throw new IllegalStateException("Not yet ready");
        }
    }

    @Override
    public SelectableMapping getSelectable(int columnIndex) {
        return this.getSelectableMappings().getSelectable(columnIndex);
    }

    @Override
    public int forEachSelectable(SelectableConsumer consumer) {
        return this.getSelectableMappings().forEachSelectable(0, consumer);
    }

    @Override
    public int forEachSelectable(int offset, SelectableConsumer consumer) {
        return this.getSelectableMappings().forEachSelectable(offset, consumer);
    }

    @Override
    public int getJdbcTypeCount() {
        return this.getSelectableMappings().getJdbcTypeCount();
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        return this.getSelectableMappings().forEachSelectable(offset, (index, selectable) -> action.accept(index, selectable.getJdbcMapping()));
    }

    @Override
    public JdbcMapping getJdbcMapping(int index) {
        return this.getSelectable(index).getJdbcMapping();
    }

    @Override
    public void forEachAttributeMapping(IndexedConsumer<? super AttributeMapping> consumer) {
        this.getAttributeMappings().indexedForEach(consumer);
    }

    @Override
    public void forEachAttributeMapping(Consumer<? super AttributeMapping> action) {
        this.getAttributeMappings().forEach(action);
    }

    @Override
    public ModelPart findSubPart(String name, EntityMappingType treatTargetType) {
        return this.findAttributeMapping(name);
    }

    @Override
    public void forEachSubPart(IndexedConsumer<ModelPart> consumer, EntityMappingType treatTarget) {
        AttributeMappingsList attributes = this.getAttributeMappings();
        for (int i = 0; i < attributes.size(); ++i) {
            consumer.accept(i, attributes.get(i));
        }
    }

    @Override
    public void visitSubParts(Consumer<ModelPart> consumer, EntityMappingType treatTargetType) {
        this.forEachAttributeMapping(consumer);
    }

    @Override
    public <X, Y> int breakDownJdbcValues(Object domainValue, int offset, X x, Y y, ModelPart.JdbcValueBiConsumer<X, Y> valueConsumer, SharedSessionContractImplementor session) {
        int span = 0;
        if (domainValue == null) {
            for (int i = 0; i < this.attributeMappings.size(); ++i) {
                AttributeMapping attribute = this.attributeMappings.get(i);
                span += attribute.breakDownJdbcValues(null, offset + span, x, y, valueConsumer, session);
            }
        } else {
            for (int i = 0; i < this.attributeMappings.size(); ++i) {
                AttributeMapping attribute = this.attributeMappings.get(i);
                Object attributeValue = attribute.getValue(domainValue);
                span += attribute.breakDownJdbcValues(attributeValue, offset + span, x, y, valueConsumer, session);
            }
        }
        return span;
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        int size = this.attributeMappings.size();
        Object[] result = new Object[size];
        for (int i = 0; i < size; ++i) {
            AttributeMapping attributeMapping = this.attributeMappings.get(i);
            Object o = attributeMapping.getValue(value);
            result[i] = attributeMapping.disassemble(o, session);
        }
        return result;
    }

    @Override
    public void addToCacheKey(MutableCacheKeyBuilder cacheKey, Object value, SharedSessionContractImplementor session) {
        int size = this.attributeMappings.size();
        if (value == null) {
            for (int i = 0; i < size; ++i) {
                this.attributeMappings.get(i).addToCacheKey(cacheKey, null, session);
            }
        } else {
            for (int i = 0; i < size; ++i) {
                AttributeMapping attributeMapping = this.attributeMappings.get(i);
                attributeMapping.addToCacheKey(cacheKey, attributeMapping.getValue(value), session);
            }
        }
    }

    @Override
    public <X, Y> int forEachDisassembledJdbcValue(Object value, int offset, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> valuesConsumer, SharedSessionContractImplementor session) {
        int span = 0;
        if (value == null) {
            for (int i = 0; i < this.attributeMappings.size(); ++i) {
                AttributeMapping mapping = this.attributeMappings.get(i);
                span += mapping.forEachDisassembledJdbcValue(null, span + offset, x, y, valuesConsumer, session);
            }
        } else {
            Object[] values = (Object[])value;
            for (int i = 0; i < this.attributeMappings.size(); ++i) {
                AttributeMapping mapping = this.attributeMappings.get(i);
                span += mapping.forEachDisassembledJdbcValue(values[i], span + offset, x, y, valuesConsumer, session);
            }
        }
        return span;
    }

    @Override
    public <X, Y> int forEachJdbcValue(Object value, int offset, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> valuesConsumer, SharedSessionContractImplementor session) {
        int span = 0;
        if (value == null) {
            for (int i = 0; i < this.attributeMappings.size(); ++i) {
                AttributeMapping attributeMapping = this.attributeMappings.get(i);
                if (attributeMapping instanceof PluralAttributeMapping) continue;
                span += attributeMapping.forEachJdbcValue(null, span + offset, x, y, valuesConsumer, session);
            }
        } else {
            for (int i = 0; i < this.attributeMappings.size(); ++i) {
                AttributeMapping attributeMapping = this.attributeMappings.get(i);
                if (attributeMapping instanceof PluralAttributeMapping) continue;
                Object o = attributeMapping.getPropertyAccess().getGetter().get(value);
                span += attributeMapping.forEachJdbcValue(o, span + offset, x, y, valuesConsumer, session);
            }
        }
        return span;
    }

    protected void addAttribute(AttributeMapping attributeMapping) {
        for (int i = 0; i < this.attributeMappings.size(); ++i) {
            AttributeMapping previous = this.attributeMappings.get(i);
            if (!attributeMapping.getAttributeName().equals(previous.getAttributeName())) continue;
            this.attributeMappings.setAttributeMapping(i, attributeMapping);
            return;
        }
        this.attributeMappings.add(attributeMapping);
    }

    protected SelectableMappings getSelectableMappings() {
        this.checkIsReady();
        return this.selectableMappings;
    }

    protected boolean initColumnMappings() {
        int propertySpan = this.attributeMappings.size();
        ArrayList<SelectableMapping> selectableMappings = CollectionHelper.arrayList(propertySpan);
        this.attributeMappings.indexedForEach((index, attributeMapping) -> attributeMapping.forEachSelectable((columnIndex, selection) -> selectableMappings.add(selection)));
        this.selectableMappings = new SelectableMappingsImpl(selectableMappings.toArray(new SelectableMapping[0]));
        return true;
    }

    private static MutabilityPlan<?> getMutabilityPlan(boolean updateable) {
        if (updateable) {
            return new MutabilityPlan<Object>(){

                @Override
                public boolean isMutable() {
                    return true;
                }

                @Override
                public Object deepCopy(Object value) {
                    return value;
                }

                @Override
                public Serializable disassemble(Object value, SharedSessionContract session) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Object assemble(Serializable cached, SharedSessionContract session) {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return ImmutableMutabilityPlan.INSTANCE;
    }

    @FunctionalInterface
    protected static interface AttributeTypeValidator {
        public void check(String var1, Type var2) throws IllegalAttributeType;
    }

    protected static class IllegalAttributeType
    extends RuntimeException {
        public IllegalAttributeType(String message) {
            super(message);
        }
    }

    @FunctionalInterface
    protected static interface SuccessfulCompletionCallback {
        public void success();
    }

    @FunctionalInterface
    protected static interface ConcreteTableResolver {
        public String resolve(Column var1, JdbcEnvironment var2);
    }
}

