/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import jakarta.persistence.TemporalType;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.hibernate.PessimisticLockException;
import org.hibernate.QueryTimeoutException;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DmlTargetColumnQualifierSupport;
import org.hibernate.dialect.FunctionalDependencyAnalysisSupport;
import org.hibernate.dialect.FunctionalDependencyAnalysisSupportImpl;
import org.hibernate.dialect.H2DurationIntervalSecondJdbcType;
import org.hibernate.dialect.H2JsonJdbcType;
import org.hibernate.dialect.H2SqlAstTranslator;
import org.hibernate.dialect.NullOrdering;
import org.hibernate.dialect.Replacer;
import org.hibernate.dialect.SelectItemReferenceStrategy;
import org.hibernate.dialect.TimeZoneSupport;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.hint.IndexQueryHintHandler;
import org.hibernate.dialect.identity.H2FinalTableIdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.OffsetFetchLimitHandler;
import org.hibernate.dialect.sequence.H2V1SequenceSupport;
import org.hibernate.dialect.sequence.H2V2SequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.dialect.temptable.TemporaryTableKind;
import org.hibernate.dialect.unique.CreateTableUniqueDelegate;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtractor;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.mutation.EntityMutationTarget;
import org.hibernate.query.sqm.FetchClauseType;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.query.sqm.mutation.internal.temptable.GlobalTemporaryTableInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.temptable.GlobalTemporaryTableMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.ParameterMarkerStrategy;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.internal.OptionalTableUpdate;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorLegacyImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.jdbc.EnumJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.OrdinalEnumJdbcType;
import org.hibernate.type.descriptor.jdbc.TimeUtcAsOffsetTimeJdbcType;
import org.hibernate.type.descriptor.jdbc.TimestampUtcAsInstantJdbcType;
import org.hibernate.type.descriptor.jdbc.UUIDJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.internal.DdlTypeImpl;
import org.hibernate.type.descriptor.sql.internal.NativeEnumDdlTypeImpl;
import org.hibernate.type.descriptor.sql.internal.NativeOrdinalEnumDdlTypeImpl;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class H2Dialect
extends Dialect {
    private static final DatabaseVersion MINIMUM_VERSION = DatabaseVersion.make(2, 1, 214);
    private final boolean ansiSequence;
    private final boolean cascadeConstraints;
    private final boolean useLocalTime;
    private final SequenceInformationExtractor sequenceInformationExtractor;
    private final String querySequenceString;
    private final UniqueDelegate uniqueDelegate = new CreateTableUniqueDelegate(this);
    private final OptionalTableUpdateStrategy optionalTableUpdateStrategy;
    private static final ViolatedConstraintNameExtractor EXTRACTOR = new TemplatedViolatedConstraintNameExtractor(sqle -> {
        String message;
        int i;
        if (sqle.getSQLState().startsWith("23") && (i = (message = sqle.getMessage()).indexOf("violation: ")) > 0) {
            int j;
            String constraintDescription = message.substring(i + "violation: ".length()).replace("\"", "");
            if (sqle.getSQLState().equals("23506")) {
                constraintDescription = constraintDescription.substring(1, constraintDescription.indexOf(58));
            }
            return (j = constraintDescription.indexOf(" ON ")) > 0 ? constraintDescription.substring(0, j) : constraintDescription;
        }
        return null;
    });

    public H2Dialect(DialectResolutionInfo info) {
        this(H2Dialect.parseVersion(info));
        this.registerKeywords(info);
    }

    public H2Dialect() {
        this(MINIMUM_VERSION);
    }

    public H2Dialect(DatabaseVersion version) {
        super(version);
        this.ansiSequence = true;
        this.cascadeConstraints = true;
        this.useLocalTime = true;
        this.sequenceInformationExtractor = SequenceInformationExtractorLegacyImpl.INSTANCE;
        this.querySequenceString = "select * from INFORMATION_SCHEMA.SEQUENCES";
        this.optionalTableUpdateStrategy = H2Dialect::usingMerge;
    }

    private static DatabaseVersion parseVersion(DialectResolutionInfo info) {
        DatabaseVersion version = info.makeCopyOrDefault(MINIMUM_VERSION);
        if (info.getDatabaseVersion() != null) {
            version = DatabaseVersion.make(version.getMajor(), version.getMinor(), H2Dialect.parseBuildId(info));
        }
        return version;
    }

    private static int parseBuildId(DialectResolutionInfo info) {
        String databaseVersion = info.getDatabaseVersion();
        if (databaseVersion == null) {
            return 0;
        }
        String[] bits = databaseVersion.split("[. \\-]");
        return bits.length > 2 ? Integer.parseInt(bits[2]) : 0;
    }

    @Override
    protected DatabaseVersion getMinimumSupportedVersion() {
        return MINIMUM_VERSION;
    }

    @Override
    public boolean getDefaultNonContextualLobCreation() {
        return true;
    }

    @Override
    public boolean supportsStandardArrays() {
        return true;
    }

    @Override
    public boolean useArrayForMultiValuedParameters() {
        return false;
    }

    @Override
    protected String columnType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case -15: {
                return this.columnType(1);
            }
            case -9: {
                return this.columnType(12);
            }
        }
        return super.columnType(sqlTypeCode);
    }

    @Override
    protected String castType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case -15: 
            case 1: {
                return "char";
            }
            case -9: 
            case 12: 
            case 4001: 
            case 4002: {
                return "varchar";
            }
            case -3: 
            case -2: 
            case 4003: {
                return "varbinary";
            }
        }
        return super.castType(sqlTypeCode);
    }

    @Override
    protected void registerColumnTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.registerColumnTypes(typeContributions, serviceRegistry);
        DdlTypeRegistry ddlTypeRegistry = typeContributions.getTypeConfiguration().getDdlTypeRegistry();
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3000, "uuid", this));
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3200, "geometry", this));
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3100, "interval second($p,$s)", this));
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3001, "json", this));
        ddlTypeRegistry.addDescriptor(new NativeEnumDdlTypeImpl(this));
        ddlTypeRegistry.addDescriptor(new NativeOrdinalEnumDdlTypeImpl(this));
    }

    @Override
    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        JdbcTypeRegistry jdbcTypeRegistry = typeContributions.getTypeConfiguration().getJdbcTypeRegistry();
        jdbcTypeRegistry.addDescriptor(TimeUtcAsOffsetTimeJdbcType.INSTANCE);
        jdbcTypeRegistry.addDescriptor(TimestampUtcAsInstantJdbcType.INSTANCE);
        jdbcTypeRegistry.addDescriptorIfAbsent(UUIDJdbcType.INSTANCE);
        jdbcTypeRegistry.addDescriptorIfAbsent(H2DurationIntervalSecondJdbcType.INSTANCE);
        jdbcTypeRegistry.addDescriptorIfAbsent(H2JsonJdbcType.INSTANCE);
        jdbcTypeRegistry.addDescriptor(EnumJdbcType.INSTANCE);
        jdbcTypeRegistry.addDescriptor(OrdinalEnumJdbcType.INSTANCE);
    }

    @Override
    public int getDefaultStatementBatchSize() {
        return 15;
    }

    public boolean hasOddDstBehavior() {
        return true;
    }

    @Override
    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.aggregates(this, SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER);
        functionFactory.avg_castingNonDoubleArguments(this, SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER);
        functionFactory.pi();
        functionFactory.cot();
        functionFactory.radians();
        functionFactory.degrees();
        functionFactory.log10();
        functionFactory.mod_operator();
        functionFactory.rand();
        functionFactory.soundex();
        functionFactory.translate();
        functionFactory.bitand();
        functionFactory.bitor();
        functionFactory.bitxor();
        functionFactory.bitnot();
        functionFactory.bitAndOr();
        functionFactory.yearMonthDay();
        functionFactory.hourMinuteSecond();
        functionFactory.dayOfWeekMonthYear();
        functionFactory.weekQuarter();
        functionFactory.daynameMonthname();
        if (this.useLocalTime) {
            functionFactory.localtimeLocaltimestamp();
        }
        functionFactory.trunc_dateTrunc();
        functionFactory.dateTrunc();
        functionFactory.bitLength();
        functionFactory.octetLength();
        functionFactory.ascii();
        functionFactory.octetLength();
        functionFactory.space();
        functionFactory.repeat();
        functionFactory.chr_char();
        functionFactory.instr();
        functionFactory.substr();
        functionFactory.position();
        functionFactory.trim1();
        functionFactory.concat_pipeOperator();
        functionFactory.nowCurdateCurtime();
        functionFactory.sysdate();
        functionFactory.insert();
        functionFactory.everyAny_boolAndOr();
        functionFactory.median();
        functionFactory.stddevPopSamp();
        functionFactory.varPopSamp();
        functionFactory.format_formatdatetime();
        functionFactory.rownum();
        functionFactory.windowFunctions();
        functionFactory.listagg(null);
        functionFactory.inverseDistributionOrderedSetAggregates();
        functionFactory.hypotheticalOrderedSetAggregates();
        functionFactory.array();
        functionFactory.arrayAggregate();
        functionFactory.arrayPosition_h2(this.getMaximumArraySize());
        functionFactory.arrayPositions_h2(this.getMaximumArraySize());
        functionFactory.arrayLength_cardinality();
        functionFactory.arrayConcat_operator();
        functionFactory.arrayPrepend_operator();
        functionFactory.arrayAppend_operator();
        functionFactory.arrayContains_h2(this.getMaximumArraySize());
        functionFactory.arrayIntersects_h2(this.getMaximumArraySize());
        functionFactory.arrayGet_h2();
        functionFactory.arraySet_h2(this.getMaximumArraySize());
        functionFactory.arrayRemove_h2(this.getMaximumArraySize());
        functionFactory.arrayRemoveIndex_h2(this.getMaximumArraySize());
        functionFactory.arraySlice();
        functionFactory.arrayReplace_h2(this.getMaximumArraySize());
        functionFactory.arrayTrim_trim_array();
        functionFactory.arrayFill_h2();
        functionFactory.arrayToString_h2(this.getMaximumArraySize());
    }

    protected int getMaximumArraySize() {
        return 1000;
    }

    @Override
    public void augmentPhysicalTableTypes(List<String> tableTypesList) {
        tableTypesList.add("BASE TABLE");
    }

    @Override
    protected Integer resolveSqlTypeCode(String columnTypeName, TypeConfiguration typeConfiguration) {
        switch (columnTypeName) {
            case "FLOAT(24)": {
                return 7;
            }
        }
        return super.resolveSqlTypeCode(columnTypeName, typeConfiguration);
    }

    @Override
    public JdbcType resolveSqlTypeDescriptor(String columnTypeName, int jdbcTypeCode, int precision, int scale, JdbcTypeRegistry jdbcTypeRegistry) {
        switch (jdbcTypeCode) {
            case 6: {
                if (!"DOUBLE PRECISION".equals(columnTypeName)) break;
                return jdbcTypeRegistry.getDescriptor(8);
            }
            case 1111: {
                if ("GEOMETRY".equals(columnTypeName)) {
                    return jdbcTypeRegistry.getDescriptor(3200);
                }
                if (!"JSON".equals(columnTypeName)) break;
                return jdbcTypeRegistry.getDescriptor(3001);
            }
        }
        return super.resolveSqlTypeDescriptor(columnTypeName, jdbcTypeCode, precision, scale, jdbcTypeRegistry);
    }

    @Override
    protected Integer resolveSqlTypeCode(String typeName, String baseTypeName, TypeConfiguration typeConfiguration) {
        switch (baseTypeName) {
            case "CHARACTER VARYING": {
                return 12;
            }
        }
        return super.resolveSqlTypeCode(typeName, baseTypeName, typeConfiguration);
    }

    @Override
    public int getMaxVarcharLength() {
        return 0x100000;
    }

    @Override
    public String currentTime() {
        return this.useLocalTime ? "localtime" : super.currentTime();
    }

    @Override
    public String currentTimestamp() {
        return this.useLocalTime ? "localtimestamp" : super.currentTimestamp();
    }

    @Override
    public String currentTimestampWithTimeZone() {
        return "current_timestamp";
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new H2SqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    @Override
    public String extractPattern(TemporalUnit unit) {
        return unit == TemporalUnit.SECOND ? "(" + super.extractPattern(unit) + "+extract(nanosecond from ?2)/1e9)" : super.extractPattern(unit);
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        if (intervalType != null) {
            return "(?2+?3)";
        }
        return unit == TemporalUnit.SECOND ? "dateadd(nanosecond,?2*1e9,?3)" : "dateadd(?1,?2,?3)";
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        if (unit == null) {
            return "(?3-?2)";
        }
        return "datediff(?1,?2,?3)";
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, TemporalAccessor temporalAccessor, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate(appender, temporalAccessor);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                if (this.supportsTimeLiteralOffset() && temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS)) {
                    appender.appendSql("time with time zone '");
                    DateTimeUtils.appendAsTime(appender, temporalAccessor, this.supportsTemporalLiteralOffset(), jdbcTimeZone);
                } else {
                    appender.appendSql("time '");
                    DateTimeUtils.appendAsLocalTime(appender, temporalAccessor);
                }
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                if (this.supportsTemporalLiteralOffset() && temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS)) {
                    appender.appendSql("timestamp with time zone '");
                    DateTimeUtils.appendAsTimestampWithNanos(appender, temporalAccessor, true, jdbcTimeZone);
                    appender.appendSql('\'');
                    break;
                }
                appender.appendSql("timestamp '");
                DateTimeUtils.appendAsTimestampWithNanos(appender, temporalAccessor, false, jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, Date date, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate(appender, date);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                if (this.supportsTimeLiteralOffset()) {
                    appender.appendSql("time with time zone '");
                    DateTimeUtils.appendAsTime(appender, date, jdbcTimeZone);
                } else {
                    appender.appendSql("time '");
                    DateTimeUtils.appendAsLocalTime(appender, date);
                }
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp with time zone '");
                DateTimeUtils.appendAsTimestampWithNanos(appender, date, jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, Calendar calendar, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate(appender, calendar);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                if (this.supportsTimeLiteralOffset()) {
                    appender.appendSql("time with time zone '");
                    DateTimeUtils.appendAsTime(appender, calendar, jdbcTimeZone);
                } else {
                    appender.appendSql("time '");
                    DateTimeUtils.appendAsLocalTime(appender, calendar);
                }
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp with time zone '");
                DateTimeUtils.appendAsTimestampWithMillis(appender, calendar, jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public boolean supportsTimeLiteralOffset() {
        return true;
    }

    @Override
    public boolean supportsTemporalLiteralOffset() {
        return true;
    }

    @Override
    public TimeZoneSupport getTimeZoneSupport() {
        return TimeZoneSupport.NATIVE;
    }

    @Override
    public boolean supportsIsTrue() {
        return true;
    }

    @Override
    public void appendBooleanValueString(SqlAppender appender, boolean bool) {
        appender.appendSql(bool);
    }

    @Override
    public LimitHandler getLimitHandler() {
        return OffsetFetchLimitHandler.INSTANCE;
    }

    @Override
    public boolean supportsDistinctFromPredicate() {
        return true;
    }

    @Override
    public boolean supportsIfExistsAfterTableName() {
        return !this.supportsIfExistsBeforeTableName();
    }

    @Override
    public boolean supportsIfExistsBeforeTableName() {
        return this.cascadeConstraints;
    }

    @Override
    public boolean supportsIfExistsAfterAlterTable() {
        return this.cascadeConstraints;
    }

    @Override
    public boolean supportsIfExistsBeforeConstraintName() {
        return true;
    }

    @Override
    public String getCascadeConstraintsString() {
        return this.cascadeConstraints ? " cascade " : super.getCascadeConstraintsString();
    }

    @Override
    public boolean supportsAlterColumnType() {
        return true;
    }

    @Override
    public String getAlterColumnTypeString(String columnName, String columnType, String columnDefinition) {
        return "alter column " + columnName + " set data type " + columnType;
    }

    @Override
    public boolean supportsCommentOn() {
        return true;
    }

    @Override
    public boolean dropConstraints() {
        return false;
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return this.ansiSequence ? H2V2SequenceSupport.INSTANCE : H2V1SequenceSupport.INSTANCE;
    }

    @Override
    public String getQuerySequencesString() {
        return this.querySequenceString;
    }

    @Override
    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return this.sequenceInformationExtractor;
    }

    @Override
    public NullOrdering getNullOrdering() {
        return NullOrdering.SMALLEST;
    }

    @Override
    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType entityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new GlobalTemporaryTableMutationStrategy(TemporaryTable.createIdTable(entityDescriptor, basename -> "HT_" + basename, this, runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    @Override
    public SqmMultiTableInsertStrategy getFallbackSqmInsertStrategy(EntityMappingType entityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new GlobalTemporaryTableInsertStrategy(TemporaryTable.createEntityTable(entityDescriptor, name -> "HTE_" + name, this, runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    @Override
    public String getTemporaryTableCreateOptions() {
        return "TRANSACTIONAL";
    }

    @Override
    public TemporaryTableKind getSupportedTemporaryTableKind() {
        return TemporaryTableKind.GLOBAL;
    }

    @Override
    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return EXTRACTOR;
    }

    @Override
    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (sqlException, message, sql) -> {
            int errorCode = JdbcExceptionHelper.extractErrorCode(sqlException);
            switch (errorCode) {
                case 23505: {
                    String constraintName = this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException);
                    return new ConstraintViolationException(message, sqlException, sql, ConstraintViolationException.ConstraintKind.UNIQUE, constraintName);
                }
                case 40001: {
                    return new LockAcquisitionException(message, sqlException, sql);
                }
                case 50200: {
                    return new PessimisticLockException(message, sqlException, sql);
                }
                case 90006: {
                    String constraintName = this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException);
                    return new ConstraintViolationException(message, sqlException, sql, constraintName);
                }
                case 57014: {
                    return new QueryTimeoutException(message, sqlException, sql);
                }
            }
            return null;
        };
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "call current_timestamp()";
    }

    @Override
    public boolean supportsLobValueChangePropagation() {
        return false;
    }

    @Override
    public boolean supportsTupleCounts() {
        return true;
    }

    @Override
    public boolean requiresParensForTupleDistinctCounts() {
        return true;
    }

    @Override
    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return true;
    }

    @Override
    public SelectItemReferenceStrategy getGroupBySelectItemReferenceStrategy() {
        return SelectItemReferenceStrategy.ALIAS;
    }

    @Override
    public boolean supportsOffsetInSubquery() {
        return true;
    }

    @Override
    public boolean supportsWindowFunctions() {
        return true;
    }

    @Override
    public boolean supportsRecursiveCTE() {
        return true;
    }

    @Override
    public boolean supportsFetchClause(FetchClauseType type) {
        return true;
    }

    @Override
    public FunctionalDependencyAnalysisSupport getFunctionalDependencyAnalysisSupport() {
        return FunctionalDependencyAnalysisSupportImpl.TABLE_GROUP_AND_CONSTANTS;
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return H2FinalTableIdentityColumnSupport.INSTANCE;
    }

    @Override
    public boolean supportsInsertReturning() {
        return true;
    }

    @Override
    public boolean supportsInsertReturningRowId() {
        return false;
    }

    @Override
    public boolean supportsInsertReturningGeneratedKeys() {
        return true;
    }

    @Override
    public boolean unquoteGetGeneratedKeys() {
        return true;
    }

    @Override
    public int registerResultSetOutParameter(CallableStatement statement, int position) throws SQLException {
        return position;
    }

    @Override
    public String getQueryHintString(String query, String hints) {
        return IndexQueryHintHandler.INSTANCE.addQueryHints(query, hints);
    }

    @Override
    public void appendDatetimeFormat(SqlAppender appender, String format) {
        appender.appendSql(new Replacer(format, "'", "''").replace("e", "u").replace("xxx", "XXX").replace("xx", "XX").replace("x", "X").result());
    }

    @Override
    public String translateExtractField(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_MONTH: {
                return "day";
            }
            case WEEK: {
                return "iso_week";
            }
        }
        return unit.toString();
    }

    @Override
    public String generatedAs(String generatedAs) {
        return " generated always as (" + generatedAs + ")";
    }

    @Override
    public boolean canDisableConstraints() {
        return true;
    }

    @Override
    public String getEnableConstraintsStatement() {
        return "set referential_integrity true";
    }

    @Override
    public String getEnumTypeDeclaration(String name, String[] values) {
        StringBuilder type = new StringBuilder();
        type.append("enum (");
        String separator = "";
        for (String value : values) {
            type.append(separator).append('\'').append(value).append('\'');
            separator = ",";
        }
        return type.append(')').toString();
    }

    @Override
    public String getDisableConstraintsStatement() {
        return "set referential_integrity false";
    }

    @Override
    public UniqueDelegate getUniqueDelegate() {
        return this.uniqueDelegate;
    }

    @Override
    public String rowId(String rowId) {
        return "_rowid_";
    }

    @Override
    public int rowIdSqlType() {
        return -5;
    }

    @Override
    public MutationOperation createOptionalTableUpdateOperation(EntityMutationTarget mutationTarget, OptionalTableUpdate optionalTableUpdate, SessionFactoryImplementor factory) {
        return this.optionalTableUpdateStrategy.buildMutationOperation(mutationTarget, optionalTableUpdate, factory);
    }

    private static MutationOperation usingMerge(EntityMutationTarget mutationTarget, OptionalTableUpdate optionalTableUpdate, SessionFactoryImplementor factory) {
        H2SqlAstTranslator translator = new H2SqlAstTranslator(factory, optionalTableUpdate);
        return translator.createMergeOperation(optionalTableUpdate);
    }

    @Override
    public ParameterMarkerStrategy getNativeParameterMarkerStrategy() {
        return OrdinalParameterMarkerStrategy.INSTANCE;
    }

    @Override
    public DmlTargetColumnQualifierSupport getDmlTargetColumnQualifierSupport() {
        return DmlTargetColumnQualifierSupport.TABLE_ALIAS;
    }

    @Override
    public String getCaseInsensitiveLike() {
        return "ilike";
    }

    @Override
    public boolean supportsCaseInsensitiveLike() {
        return true;
    }

    @FunctionalInterface
    private static interface OptionalTableUpdateStrategy {
        public MutationOperation buildMutationOperation(EntityMutationTarget var1, OptionalTableUpdate var2, SessionFactoryImplementor var3);
    }

    public static class OrdinalParameterMarkerStrategy
    implements ParameterMarkerStrategy {
        public static final OrdinalParameterMarkerStrategy INSTANCE = new OrdinalParameterMarkerStrategy();

        @Override
        public String createMarker(int position, JdbcType jdbcType) {
            return "?" + position;
        }
    }
}

