/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.Incubating;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.EventType;
import org.hibernate.generator.Generator;
import org.hibernate.generator.values.GeneratedValues;
import org.hibernate.internal.util.NullnessUtil;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.internal.NoCallbackExecutionContext;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.sql.results.internal.RowTransformerArrayImpl;
import org.hibernate.sql.results.spi.ListResultsConsumer;

@Incubating
public class GeneratedValuesProcessor {
    private final SelectStatement selectStatement;
    private final JdbcOperationQuerySelect jdbcSelect;
    private final List<AttributeMapping> generatedValuesToSelect;
    private final JdbcParametersList jdbcParameters;
    private final EntityPersister entityDescriptor;

    public GeneratedValuesProcessor(EntityPersister entityDescriptor, List<AttributeMapping> generatedAttributes, EventType timing, SessionFactoryImplementor sessionFactory) {
        this.entityDescriptor = entityDescriptor;
        this.generatedValuesToSelect = generatedAttributes;
        if (this.generatedValuesToSelect.isEmpty() || !this.needsSubsequentSelect(timing, generatedAttributes)) {
            this.selectStatement = null;
            this.jdbcSelect = null;
            this.jdbcParameters = null;
        } else {
            JdbcParametersList.Builder builder = JdbcParametersList.newBuilder();
            this.selectStatement = LoaderSelectBuilder.createSelect((Loadable)entityDescriptor, this.generatedValuesToSelect, entityDescriptor.getIdentifierMapping(), null, 1, new LoadQueryInfluencers(sessionFactory), LockOptions.READ, builder::add, sessionFactory);
            this.jdbcSelect = sessionFactory.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory().buildSelectTranslator(sessionFactory, this.selectStatement).translate(JdbcParameterBindings.NO_BINDINGS, QueryOptions.NONE);
            this.jdbcParameters = builder.build();
        }
    }

    private boolean needsSubsequentSelect(EventType timing, List<AttributeMapping> generatedAttributes) {
        if (timing == EventType.INSERT) {
            return this.entityDescriptor.getInsertDelegate() == null || !this.entityDescriptor.getInsertDelegate().supportsArbitraryValues() || generatedAttributes.size() > this.numberOfGeneratedNonIdentifierProperties(timing);
        }
        return this.entityDescriptor.getUpdateDelegate() == null;
    }

    private int numberOfGeneratedNonIdentifierProperties(EventType timing) {
        if (timing == EventType.INSERT) {
            return this.entityDescriptor.getInsertGeneratedProperties().size() - (this.entityDescriptor.isIdentifierAssignedByInsert() ? 1 : 0);
        }
        return 0;
    }

    public static List<AttributeMapping> getGeneratedAttributes(EntityMappingType entityDescriptor, EventType timing) {
        Generator[] generators = entityDescriptor.getEntityPersister().getEntityMetamodel().getGenerators();
        ArrayList<AttributeMapping> generatedValuesToSelect = new ArrayList<AttributeMapping>();
        entityDescriptor.forEachAttributeMapping(mapping -> {
            Generator generator = generators[mapping.getStateArrayPosition()];
            if (generator != null && generator.generatedOnExecution() && generator.getEventTypes().contains((Object)timing)) {
                generatedValuesToSelect.add((AttributeMapping)mapping);
            }
        });
        return generatedValuesToSelect;
    }

    public void processGeneratedValues(Object entity, Object id, Object[] state, GeneratedValues generatedValues, SharedSessionContractImplementor session) {
        if (this.hasActualGeneratedValuesToSelect(session, entity)) {
            if (this.selectStatement != null) {
                List<Object[]> results = this.executeSelect(id, session);
                assert (results.size() == 1);
                this.setEntityAttributes(entity, state, results.get(0));
            } else {
                NullnessUtil.castNonNull(generatedValues);
                List<Object> results = generatedValues.getGeneratedValues(this.generatedValuesToSelect);
                this.setEntityAttributes(entity, state, results.toArray(new Object[0]));
            }
        }
    }

    private boolean hasActualGeneratedValuesToSelect(SharedSessionContractImplementor session, Object entity) {
        for (AttributeMapping attributeMapping : this.generatedValuesToSelect) {
            if (!attributeMapping.getGenerator().generatedOnExecution(entity, session)) continue;
            return true;
        }
        return false;
    }

    private List<Object[]> executeSelect(Object id, SharedSessionContractImplementor session) {
        JdbcParameterBindings jdbcParamBindings = this.getJdbcParameterBindings(id, session);
        return session.getFactory().getJdbcServices().getJdbcSelectExecutor().list(this.jdbcSelect, jdbcParamBindings, new NoCallbackExecutionContext(session), RowTransformerArrayImpl.INSTANCE, null, ListResultsConsumer.UniqueSemantic.FILTER, 1);
    }

    private JdbcParameterBindings getJdbcParameterBindings(Object id, SharedSessionContractImplementor session) {
        JdbcParameterBindingsImpl jdbcParamBindings = new JdbcParameterBindingsImpl(this.jdbcParameters.size());
        int offset = jdbcParamBindings.registerParametersForEachJdbcValue(id, this.entityDescriptor.getIdentifierMapping(), this.jdbcParameters, session);
        assert (offset == this.jdbcParameters.size());
        return jdbcParamBindings;
    }

    private void setEntityAttributes(Object entity, Object[] state, Object[] selectionResults) {
        for (int i = 0; i < this.generatedValuesToSelect.size(); ++i) {
            Object generatedValue;
            AttributeMapping attribute = this.generatedValuesToSelect.get(i);
            state[attribute.getStateArrayPosition()] = generatedValue = selectionResults[i];
            attribute.getAttributeMetadata().getPropertyAccess().getSetter().set(entity, generatedValue);
        }
    }

    public SelectStatement getSelectStatement() {
        return this.selectStatement;
    }

    public List<AttributeMapping> getGeneratedValuesToSelect() {
        return this.generatedValuesToSelect;
    }

    public JdbcParametersList getJdbcParameters() {
        return this.jdbcParameters;
    }

    public EntityMappingType getEntityDescriptor() {
        return this.entityDescriptor;
    }

    public JdbcOperationQuerySelect getJdbcSelect() {
        return this.jdbcSelect;
    }
}

