/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.List;
import java.util.stream.Collectors;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.process.instance.timer.TimerInstance;
import org.jbpm.workflow.core.node.EventSubProcessNode;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.instance.NodeInstance;
import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.node.CompositeContextNodeInstance;
import org.jbpm.workflow.instance.node.EndNodeInstance;
import org.jbpm.workflow.instance.node.StartNodeInstance;
import org.kie.api.definition.process.NodeContainer;

public class EventSubProcessNodeInstance
extends CompositeContextNodeInstance {
    private static final long serialVersionUID = 7095736653568661510L;

    @Override
    protected EventSubProcessNode getCompositeNode() {
        return (EventSubProcessNode)this.getNode();
    }

    @Override
    public NodeContainer getNodeContainer() {
        return this.getCompositeNode();
    }

    @Override
    protected String getActivationType() {
        return "RuleFlowStateEventSubProcess-" + this.getProcessInstance().getProcessId() + "-" + this.getCompositeNode().getUniqueId();
    }

    @Override
    public void internalTrigger(org.kie.api.runtime.process.NodeInstance from, String type) {
        super.internalTriggerOnlyParent(from, type);
    }

    @Override
    public void signalEvent(String type, Object event) {
        if ((this.getNodeInstanceContainer().getNodeInstances().contains(this) || type.startsWith("Error-") || type.equals("timerTriggered")) && this.getNodeInstances().isEmpty()) {
            StartNode startNode = this.getCompositeNode().findStartNode();
            if (this.resolveVariables(((EventSubProcessNode)this.getEventBasedNode()).getEvents()).contains(type) || this.containsTimerEvent(type, event)) {
                NodeInstance nodeInstance = this.getNodeInstance(startNode);
                ((StartNodeInstance)nodeInstance).signalEvent(type, event);
            }
        }
        super.signalEvent(type, event);
    }

    private boolean containsTimerEvent(String type, Object event) {
        if (!type.equals("timerTriggered") || !(event instanceof TimerInstance)) {
            return false;
        }
        TimerInstance timerInstance = (TimerInstance)event;
        List<Long> timersRegisteredInNodeInstance = this.getTimerInstances();
        return timersRegisteredInNodeInstance != null && timersRegisteredInNodeInstance.contains(timerInstance.getId());
    }

    @Override
    public void nodeInstanceCompleted(NodeInstance nodeInstance, String outType) {
        if (nodeInstance instanceof EndNodeInstance) {
            if (this.getCompositeNode().isKeepActive()) {
                StartNode startNode = this.getCompositeNode().findStartNode();
                if (startNode.isInterrupting()) {
                    this.getProcessInstance().getMetaData().put("SUB_PROCESS_INTERRUPTION", Boolean.TRUE);
                }
                this.triggerCompleted(true);
                if (startNode.isInterrupting()) {
                    String faultName;
                    String string = faultName = this.getProcessInstance().getOutcome() == null ? "" : this.getProcessInstance().getOutcome();
                    if (startNode.getMetaData("FaultCode") != null) {
                        faultName = (String)startNode.getMetaData("FaultCode");
                    }
                    this.getProcessInstance().getMetaData().remove("SUB_PROCESS_INTERRUPTION");
                    if (this.getNodeInstanceContainer() instanceof ProcessInstance) {
                        Object faultData = this.getProcessInstance().getVariable("event");
                        this.getProcessInstance().setState(3, faultName, faultData);
                    } else {
                        ((NodeInstanceContainer)this.getNodeInstanceContainer()).setState(3);
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Completing a node instance that has no outgoing connection not supported.");
        }
    }

    protected List<String> resolveVariables(List<String> events) {
        return events.stream().map(event -> this.resolveVariable((String)event)).collect(Collectors.toList());
    }
}

